/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMUtils;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IInitializeWithFile;
import org.eclipse.swt.internal.ole.win32.IInitializeWithStream;
import org.eclipse.swt.internal.ole.win32.IPreviewHandler;
import org.eclipse.swt.internal.ole.win32.IStream;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.Registry;
import org.eclipse.swt.internal.win32.OSEx;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Composite;

public class PreviewView
extends Composite {
    private static final Logger LOG = Logger.getLogger(PreviewView.class.getName());
    private static final String REG_SUBPATH = "\\ShellEx\\{8895b1c6-b41f-4c1c-a562-0d564250836f}";
    private static final Registry REGISTRY = new Registry(100);
    private IPreviewHandler previewHandler = null;
    private IUnknown initializeWith = null;
    private IStream stream = null;

    private static final String format(String string, int n) {
        return String.valueOf(string) + ": " + COMUtils.formatMessage(n);
    }

    private static final void info(String string, String string2) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(String.valueOf(string) + (string2 != null ? ". File: " + string2 : ""));
        }
    }

    private static final void warn(String string, int n, String string2) {
        LOG.warning(String.valueOf(PreviewView.format(string, n)) + (string2 != null ? ". File: " + string2 : ""));
    }

    private static final FileSystemException error(String string, int n, String string2) {
        String string3 = PreviewView.format(string, n);
        LOG.warning(String.valueOf(string3) + (string2 != null ? ". File: " + string2 : ""));
        return new FileSystemException(string3);
    }

    public PreviewView(Composite composite) {
        super(composite, 0);
    }

    private void createStream(String string) throws FileSystemException {
        long[] lArray = new long[1];
        int n = OSEx.SHCreateStreamOnFileEx(COMUtils.toNative(string), 0, 0, false, lArray);
        if (n == 0) {
            if (lArray[0] == 0L) {
                throw new FileSystemException("Native returns null address");
            }
        } else {
            throw PreviewView.error("SHCreateStreamOnFileEx failed", n, string);
        }
        long l = lArray[0];
        this.stream = new IStream(l);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposePreview();
    }

    private void disposePreview() {
        if (this.previewHandler != null) {
            this.previewHandler.Unload();
            this.previewHandler.Release();
            this.previewHandler = null;
        }
        if (this.initializeWith != null) {
            this.initializeWith.Release();
            this.initializeWith = null;
        }
        if (this.stream != null) {
            this.stream.Release();
            this.stream = null;
        }
    }

    private void doPreview(Rectangle rectangle, String string) throws FileSystemException {
        RECT rECT = new RECT();
        rECT.top = 10;
        rECT.left = 10;
        rECT.right = rectangle.width - 20;
        rECT.bottom = rectangle.height - 20;
        int n = this.previewHandler.SetWindow(this.handle, rECT);
        if (n == 0) {
            n = this.previewHandler.DoPreview();
            if (n != 0) {
                throw PreviewView.error("IPreviewHandler.DoPreview failed", n, string);
            }
        } else {
            throw PreviewView.error("IPreviewHandler.SetWindow failed", n, string);
        }
        PreviewView.info("doPreview succeeded", string);
    }

    private static final String getClassIDForName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0 || n >= string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n);
        String string3 = REGISTRY.getDefValue(Integer.MIN_VALUE, String.valueOf(string2) + REG_SUBPATH);
        if (string3 == null) {
            String string4 = REGISTRY.getDefValue(Integer.MIN_VALUE, string2);
            if (string4 != null) {
                string3 = REGISTRY.getDefValue(Integer.MIN_VALUE, String.valueOf(string4) + REG_SUBPATH);
            }
            if (string3 == null) {
                string3 = REGISTRY.getDefValue(Integer.MIN_VALUE, "SystemFileAssociations\\" + string2 + REG_SUBPATH);
                if (string3 == null) {
                    String string5 = REGISTRY.getValue(Integer.MIN_VALUE, string2, "PerceivedType");
                    if (string5 != null && !string5.isEmpty()) {
                        string3 = REGISTRY.getDefValue(Integer.MIN_VALUE, "SystemFileAssociations\\" + string5 + REG_SUBPATH);
                    }
                } else {
                    PreviewView.info("Manage to get from SystemFileAssociations", string);
                }
            } else {
                PreviewView.info("Manage to get from class reference", string);
            }
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPreviewItem(File file) throws IOException {
        GUID gUID;
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.disposePreview();
        file = file.getCanonicalFile();
        if (!file.isFile()) {
            throw new FileNotFoundException("Missing or invalid file");
        }
        Rectangle rectangle = this.getBounds();
        if (rectangle.isEmpty()) {
            throw new IOException("Preview component size is empty");
        }
        String string = file.getName();
        String string2 = PreviewView.getClassIDForName(string);
        if (string2 == null) {
            throw new NoSuchFileException("No handler to make a preview");
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Find class ID for " + string + ": " + string2);
        }
        if ((gUID = COMUtils.CLSIDFromString(string2)) == null) throw new FileSystemException("Cannot find GUID for class " + string2);
        String string3 = file.getPath();
        long[] lArray = new long[1];
        int n = COM.CoCreateInstance(gUID, 0L, 3, IPreviewHandler.CLSID, lArray);
        if (n != 0) throw PreviewView.error("CoCreateInstance with IPreviewHandler failed", n, string3);
        this.previewHandler = new IPreviewHandler(lArray[0]);
        long[] lArray2 = new long[1];
        n = this.previewHandler.QueryInterface(IInitializeWithFile.CLSID, lArray2);
        if (n == 0) {
            IInitializeWithFile iInitializeWithFile = new IInitializeWithFile(lArray2[0]);
            this.initializeWith = iInitializeWithFile;
            n = iInitializeWithFile.Initialize(string3, 0);
            if (n != 0) {
                throw PreviewView.error("IInitializeWithFile.Initialize failed", n, string3);
            }
        } else {
            if (LOG.isLoggable(Level.INFO)) {
                PreviewView.info(PreviewView.format("QueryInterface with IInitializeWithFile failed", n), string3);
            }
            this.createStream(string3);
            long[] lArray3 = new long[1];
            n = this.previewHandler.QueryInterface(IInitializeWithStream.CLSID, lArray3);
            if (n != 0) throw PreviewView.error("QueryInterface with IInitializeWithStream failed", n, string3);
            IInitializeWithStream iInitializeWithStream = new IInitializeWithStream(lArray3[0]);
            this.initializeWith = iInitializeWithStream;
            n = iInitializeWithStream.Initialize(this.stream.getAddress(), 0);
            if (n != 0) {
                throw PreviewView.error("IInitializeWithStream.Initialize failed", n, string3);
            }
        }
        this.doPreview(rectangle, string3);
    }

    public static final boolean canPreviewItem(File file) throws NullPointerException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.isFile()) {
            return false;
        }
        String string = file.getName();
        String string2 = PreviewView.getClassIDForName(string);
        return string2 != null;
    }
}

