/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HIGHCONTRAST;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.INPUT;
import org.eclipse.swt.internal.win32.KEYBDINPUT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MOUSEINPUT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    public MSG msg = new MSG();
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    Event[] eventQueue;
    Callback windowCallback;
    long windowProc;
    int threadId;
    TCHAR windowClass;
    TCHAR windowShadowClass;
    TCHAR windowOwnDCClass;
    static int WindowClassCount;
    static final String WindowName = "SWT_Window";
    static final String WindowShadowName = "SWT_WindowShadow";
    static final String WindowOwnDCName = "SWT_WindowOwnDC";
    EventTable eventTable;
    EventTable filterTable;
    boolean useOwnDC;
    int freeSlot;
    int[] indexTable;
    Control lastControl;
    Control lastGetControl;
    long lastHwnd;
    long lastGetHwnd;
    Control[] controlTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final boolean USE_PROPERTY;
    static STARTUPINFO lpStartupInfo;
    long hButtonTheme;
    long hEditTheme;
    long hExplorerBarTheme;
    long hScrollBarTheme;
    long hTabTheme;
    static final char[] BUTTON;
    static final char[] EDIT;
    static final char[] EXPLORER;
    static final char[] EXPLORERBAR;
    static final char[] SCROLLBAR;
    static final char[] LISTVIEW;
    static final char[] TAB;
    static final char[] TREEVIEW;
    int focusEvent;
    Control focusControl;
    boolean fixFocus;
    Menu[] bars;
    Menu[] popups;
    MenuItem[] items;
    static final int ID_START = 108;
    Callback msgFilterCallback;
    long msgFilterProc;
    long filterHook;
    MSG hookMsg = new MSG();
    boolean runDragDrop = true;
    boolean dragCancelled = false;
    Callback foregroundIdleCallback;
    long foregroundIdleProc;
    long idleHook;
    boolean ignoreNextKey;
    Callback getMsgCallback;
    Callback embeddedCallback;
    long getMsgProc;
    long msgHook;
    long embeddedHwnd;
    long embeddedProc;
    static final String AWT_WINDOW_CLASS = "SunAwtWindow";
    static final short[] ACCENTS;
    Synchronizer synchronizer = new Synchronizer(this);
    boolean runMessages = true;
    boolean runMessagesInIdle = false;
    boolean runMessagesInMessageProc = true;
    static final String RUN_MESSAGES_IN_IDLE_KEY = "org.eclipse.swt.internal.win32.runMessagesInIdle";
    static final String RUN_MESSAGES_IN_MESSAGE_PROC_KEY = "org.eclipse.swt.internal.win32.runMessagesInMessageProc";
    static final String USE_OWNDC_KEY = "org.eclipse.swt.internal.win32.useOwnDC";
    static final String ACCEL_KEY_HIT = "org.eclipse.swt.internal.win32.accelKeyHit";
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    int nextTrayId;
    TaskBar taskBar;
    static final String TASKBAR_EVENT = "/SWTINTERNAL_ID";
    static final String LAUNCHER_PREFIX = "--launcher.openFile ";
    long[] timerIds;
    Runnable[] timerList;
    long nextTimerId = 101L;
    static final long SETTINGS_ID = 100L;
    static final int SETTINGS_DELAY = 2000;
    boolean lastHighContrast;
    boolean sendSettings;
    RECT clickRect;
    int clickCount;
    int lastTime;
    int lastButton;
    long lastClickHwnd;
    int scrollRemainder;
    int scrollHRemainder;
    int lastKey;
    int lastMouse;
    int lastAscii;
    boolean lastVirtual;
    boolean lastNull;
    boolean lastDead;
    byte[] keyboard = new byte[256];
    boolean accelKeyHit;
    boolean mnemonicKeyHit;
    boolean lockActiveWindow;
    boolean captureChanged;
    boolean xMouse;
    double magStartDistance;
    double lastDistance;
    double rotationAngle;
    int lastX;
    int lastY;
    TouchSource[] touchSources;
    int nextToolTipId;
    boolean ignoreRestoreFocus;
    Control lastHittestControl;
    int lastHittest;
    Callback messageCallback;
    long hwndMessage;
    long messageProc;
    LOGFONT lfSystemFont;
    Font systemFont;
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningIcon;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    ImageList[] imageList;
    ImageList[] toolImageList;
    ImageList[] toolHotImageList;
    ImageList[] toolDisabledImageList;
    long lpCustColors;
    Image upArrow;
    Image downArrow;
    char[] tableBuffer;
    NMHDR hdr = new NMHDR();
    NMLVDISPINFO plvfi = new NMLVDISPINFO();
    long hwndParent;
    int columnCount;
    boolean[] columnVisible;
    int resizeCount;
    static final int RESIZE_LIMIT = 4;
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    Monitor[] monitors = null;
    int monitorCount = 0;
    Shell[] modalShells;
    Dialog modalDialog;
    static boolean TrimEnabled;
    static final int SWT_GETACCELCOUNT = 32768;
    static final int SWT_GETACCEL = 32769;
    static final int SWT_KEYMSG = 32770;
    static final int SWT_DESTROY = 32771;
    static final int SWT_TRAYICONMSG = 32772;
    static final int SWT_NULL = 32773;
    static final int SWT_RUNASYNC = 32774;
    static int TASKBARCREATED;
    static int TASKBARBUTTONCREATED;
    static int SWT_RESTORECARET;
    static int DI_GETDRAGIMAGE;
    static int SWT_OPENDOC;
    int hitCount;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";

    static {
        USE_PROPERTY = !OS.IsWinCE;
        SWT_OBJECT_INDEX = USE_PROPERTY ? OS.GlobalAddAtom(new TCHAR(0, "SWT_OBJECT_INDEX", true)) : 0;
        if (!OS.IsWinCE) {
            lpStartupInfo = new STARTUPINFO();
            Display.lpStartupInfo.cb = STARTUPINFO.sizeof;
            OS.GetStartupInfo(lpStartupInfo);
        }
        char[] cArray = new char[7];
        cArray[0] = 66;
        cArray[1] = 85;
        cArray[2] = 84;
        cArray[3] = 84;
        cArray[4] = 79;
        cArray[5] = 78;
        BUTTON = cArray;
        char[] cArray2 = new char[5];
        cArray2[0] = 69;
        cArray2[1] = 68;
        cArray2[2] = 73;
        cArray2[3] = 84;
        EDIT = cArray2;
        char[] cArray3 = new char[9];
        cArray3[0] = 69;
        cArray3[1] = 88;
        cArray3[2] = 80;
        cArray3[3] = 76;
        cArray3[4] = 79;
        cArray3[5] = 82;
        cArray3[6] = 69;
        cArray3[7] = 82;
        EXPLORER = cArray3;
        char[] cArray4 = new char[12];
        cArray4[0] = 69;
        cArray4[1] = 88;
        cArray4[2] = 80;
        cArray4[3] = 76;
        cArray4[4] = 79;
        cArray4[5] = 82;
        cArray4[6] = 69;
        cArray4[7] = 82;
        cArray4[8] = 66;
        cArray4[9] = 65;
        cArray4[10] = 82;
        EXPLORERBAR = cArray4;
        char[] cArray5 = new char[10];
        cArray5[0] = 83;
        cArray5[1] = 67;
        cArray5[2] = 82;
        cArray5[3] = 79;
        cArray5[4] = 76;
        cArray5[5] = 76;
        cArray5[6] = 66;
        cArray5[7] = 65;
        cArray5[8] = 82;
        SCROLLBAR = cArray5;
        char[] cArray6 = new char[9];
        cArray6[0] = 76;
        cArray6[1] = 73;
        cArray6[2] = 83;
        cArray6[3] = 84;
        cArray6[4] = 86;
        cArray6[5] = 73;
        cArray6[6] = 69;
        cArray6[7] = 87;
        LISTVIEW = cArray6;
        char[] cArray7 = new char[4];
        cArray7[0] = 84;
        cArray7[1] = 65;
        cArray7[2] = 66;
        TAB = cArray7;
        char[] cArray8 = new char[9];
        cArray8[0] = 84;
        cArray8[1] = 82;
        cArray8[2] = 69;
        cArray8[3] = 69;
        cArray8[4] = 86;
        cArray8[5] = 73;
        cArray8[6] = 69;
        cArray8[7] = 87;
        TREEVIEW = cArray8;
        ACCENTS = new short[]{126, 96, 39, 94, 34};
        KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {38, 0x1000001}, {40, 0x1000002}, {37, 0x1000003}, {39, 0x1000004}, {33, 0x1000005}, {34, 0x1000006}, {36, 0x1000007}, {35, 0x1000008}, {45, 0x1000009}, {8, 8}, {13, 13}, {46, 127}, {27, 27}, {13, 10}, {9, 9}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {124, 0x1000016}, {125, 0x1000017}, {126, 0x1000018}, {127, 0x1000019}, {128, 0x100001A}, {129, 0x100001B}, {130, 0x100001C}, {131, 0x100001D}, {106, 16777258}, {107, 16777259}, {13, 0x1000050}, {109, 16777261}, {110, 16777262}, {111, 16777263}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {19, 0x1000055}, {3, 16777302}, {44, 16777303}};
        Displays = new Display[4];
        TrimEnabled = false;
        DeviceFinder = new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    Control _getFocusControl() {
        return this.findControl(OS.GetFocus());
    }

    void addBar(Menu menu) {
        if (this.bars == null) {
            this.bars = new Menu[4];
        }
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.bars[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.bars[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.bars, 0, menuArray, 0, n);
            this.bars = menuArray;
        }
        this.bars[n2] = menu;
    }

    void addControl(long l, Control control) {
        int n;
        if (l == 0L) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n = this.freeSlot + 1024;
            int[] nArray = new int[n];
            Control[] controlArray = new Control[n];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.controlTable, 0, controlArray, 0, this.freeSlot);
            int n2 = this.freeSlot;
            while (n2 < n - 1) {
                nArray[n2] = n2 + 1;
                ++n2;
            }
            nArray[n - 1] = -1;
            this.indexTable = nArray;
            this.controlTable = controlArray;
        }
        if (USE_PROPERTY) {
            OS.SetProp(l, SWT_OBJECT_INDEX, this.freeSlot + 1);
        } else {
            OS.SetWindowLongPtr(l, -21, this.freeSlot + 1);
        }
        n = this.freeSlot;
        this.freeSlot = this.indexTable[n];
        this.indexTable[n] = -2;
        this.controlTable[n] = control;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    void addMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            this.items = new MenuItem[64];
        }
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] == null) {
                menuItem.id = n + 108;
                this.items[n] = menuItem;
                return;
            }
            ++n;
        }
        menuItem.id = this.items.length + 108;
        MenuItem[] menuItemArray = new MenuItem[this.items.length + 64];
        menuItemArray[this.items.length] = menuItem;
        System.arraycopy(this.items, 0, menuItemArray, 0, this.items.length);
        this.items = menuItemArray;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n = this.popups.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    int asciiKey(int n) {
        if (OS.IsWinCE) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.keyboard.length) {
            this.keyboard[n2] = 0;
            ++n2;
        }
        if (!OS.GetKeyboardState(this.keyboard)) {
            return 0;
        }
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n, n, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n, n, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.MessageBeep(0);
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    @Override
    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread() && this.threadId != OS.GetCurrentThreadId()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] != null) {
                    if (!bl) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[n].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) break;
            if (this.modalShells[n] == null) {
                return;
            }
            ++n;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    int controlKey(int n) {
        int n2 = (int)OS.CharUpper((short)n);
        if (64 <= n2 && n2 <= 95) {
            return n2 & 0xBF;
        }
        return n;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, true);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
    }

    static long create32bitDIB(Image image) {
        byte[] byArray;
        Object object;
        int n = -1;
        int n2 = -1;
        long l = 0L;
        long l2 = 0L;
        byte[] byArray2 = null;
        switch (image.type) {
            case 1: {
                object = new ICONINFO();
                OS.GetIconInfo(image.handle, (ICONINFO)object);
                l2 = ((ICONINFO)object).hbmColor;
                l = ((ICONINFO)object).hbmMask;
                break;
            }
            case 0: {
                ImageData imageData = image.getImageDataAtCurrentZoom();
                l2 = image.handle;
                n2 = imageData.alpha;
                byArray2 = imageData.alphaData;
                n = imageData.transparentPixel;
            }
        }
        object = new BITMAP();
        OS.GetObject(l2, BITMAP.sizeof, (BITMAP)object);
        int n3 = ((BITMAP)object).bmWidth;
        int n4 = ((BITMAP)object).bmHeight;
        long l3 = OS.GetDC(0L);
        long l4 = OS.CreateCompatibleDC(l3);
        long l5 = OS.SelectObject(l4, l2);
        long l6 = OS.CreateCompatibleDC(l3);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n3;
        bITMAPINFOHEADER.biHeight = -n4;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray3 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray3, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        long[] lArray = new long[1];
        long l7 = OS.CreateDIBSection(0L, byArray3, 0, lArray, 0L, 0);
        if (l7 == 0L) {
            SWT.error(2);
        }
        long l8 = OS.SelectObject(l6, l7);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(l7, BITMAP.sizeof, bITMAP);
        int n5 = bITMAP.bmWidthBytes * bITMAP.bmHeight;
        OS.BitBlt(l6, 0, 0, n3, n4, l4, 0, 0, 0xCC0020);
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        if (n != -1) {
            if (((BITMAP)object).bmBitsPixel <= 8) {
                byArray = new byte[4];
                OS.GetDIBColorTable(l4, n, 1, byArray);
                by3 = byArray[0];
                by2 = byArray[1];
                by = byArray[2];
            } else {
                switch (((BITMAP)object).bmBitsPixel) {
                    case 16: {
                        by3 = (byte)((n & 0x1F) << 3);
                        by2 = (byte)((n & 0x3E0) >> 2);
                        by = (byte)((n & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        by3 = (byte)((n & 0xFF0000) >> 16);
                        by2 = (byte)((n & 0xFF00) >> 8);
                        by = (byte)(n & 0xFF);
                        break;
                    }
                    case 32: {
                        by3 = (byte)((n & 0xFF000000) >>> 24);
                        by2 = (byte)((n & 0xFF0000) >> 16);
                        by = (byte)((n & 0xFF00) >> 8);
                    }
                }
            }
        }
        byArray = new byte[n5];
        OS.MoveMemory(byArray, lArray[0], n5);
        if (l != 0L) {
            OS.SelectObject(l4, l);
            int n6 = 0;
            int n7 = 0;
            while (n6 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    if (OS.GetPixel(l4, n8, n6) != 0) {
                        byArray[n7 + 3] = 0;
                        byArray[n7 + 2] = 0;
                        byArray[n7 + 1] = 0;
                        byArray[n7 + 0] = 0;
                    } else {
                        byArray[n7 + 3] = -1;
                    }
                    n7 += 4;
                    ++n8;
                }
                ++n6;
            }
        } else if (n2 != -1) {
            int n9 = 0;
            int n10 = 0;
            while (n9 < n4) {
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = (byArray[n10 + 0] & 0xFF) * n2 + 128;
                    n12 = n12 + (n12 >> 8) >> 8;
                    int n13 = (byArray[n10 + 1] & 0xFF) * n2 + 128;
                    n13 = n13 + (n13 >> 8) >> 8;
                    int n14 = (byArray[n10 + 2] & 0xFF) * n2 + 128;
                    n14 = n14 + (n14 >> 8) >> 8;
                    byArray[n10 + 0] = (byte)n12;
                    byArray[n10 + 1] = (byte)n13;
                    byArray[n10 + 2] = (byte)n14;
                    byArray[n10 + 3] = (byte)n2;
                    n10 += 4;
                    ++n11;
                }
                ++n9;
            }
        } else if (byArray2 != null) {
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            while (n15 < n4) {
                int n18 = 0;
                while (n18 < n3) {
                    int n19 = byArray2[n17++] & 0xFF;
                    int n20 = (byArray[n16 + 0] & 0xFF) * n19 + 128;
                    n20 = n20 + (n20 >> 8) >> 8;
                    int n21 = (byArray[n16 + 1] & 0xFF) * n19 + 128;
                    n21 = n21 + (n21 >> 8) >> 8;
                    int n22 = (byArray[n16 + 2] & 0xFF) * n19 + 128;
                    n22 = n22 + (n22 >> 8) >> 8;
                    byArray[n16 + 0] = (byte)n20;
                    byArray[n16 + 1] = (byte)n21;
                    byArray[n16 + 2] = (byte)n22;
                    byArray[n16 + 3] = (byte)n19;
                    n16 += 4;
                    ++n18;
                }
                ++n15;
            }
        } else if (n != -1) {
            int n23 = 0;
            int n24 = 0;
            while (n23 < n4) {
                int n25 = 0;
                while (n25 < n3) {
                    if (byArray[n24] == by3 && byArray[n24 + 1] == by2 && byArray[n24 + 2] == by) {
                        byArray[n24 + 3] = 0;
                        byArray[n24 + 2] = 0;
                        byArray[n24 + 1] = 0;
                        byArray[n24 + 0] = 0;
                    } else {
                        byArray[n24 + 3] = -1;
                    }
                    n24 += 4;
                    ++n25;
                }
                ++n23;
            }
        } else {
            int n26 = 0;
            int n27 = 0;
            while (n26 < n4) {
                int n28 = 0;
                while (n28 < n3) {
                    byArray[n27 + 3] = -1;
                    n27 += 4;
                    ++n28;
                }
                ++n26;
            }
        }
        OS.MoveMemory(lArray[0], byArray, n5);
        OS.SelectObject(l4, l5);
        OS.SelectObject(l6, l8);
        OS.DeleteObject(l4);
        OS.DeleteObject(l6);
        OS.ReleaseDC(0L, l3);
        if (l2 != image.handle && l2 != 0L) {
            OS.DeleteObject(l2);
        }
        if (l != 0L) {
            OS.DeleteObject(l);
        }
        return l7;
    }

    static long create32bitDIB(long l, int n, byte[] byArray, int n2) {
        byte[] byArray2;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(l, BITMAP.sizeof, bITMAP);
        int n3 = bITMAP.bmWidth;
        int n4 = bITMAP.bmHeight;
        long l2 = OS.GetDC(0L);
        long l3 = OS.CreateCompatibleDC(l2);
        long l4 = OS.SelectObject(l3, l);
        long l5 = OS.CreateCompatibleDC(l2);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n3;
        bITMAPINFOHEADER.biHeight = -n4;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray3 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray3, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        long[] lArray = new long[1];
        long l6 = OS.CreateDIBSection(0L, byArray3, 0, lArray, 0L, 0);
        if (l6 == 0L) {
            SWT.error(2);
        }
        long l7 = OS.SelectObject(l5, l6);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject(l6, BITMAP.sizeof, bITMAP2);
        int n5 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt(l5, 0, 0, n3, n4, l3, 0, 0, 0xCC0020);
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        if (n2 != -1) {
            if (bITMAP.bmBitsPixel <= 8) {
                byArray2 = new byte[4];
                OS.GetDIBColorTable(l3, n2, 1, byArray2);
                by3 = byArray2[0];
                by2 = byArray2[1];
                by = byArray2[2];
            } else {
                switch (bITMAP.bmBitsPixel) {
                    case 16: {
                        by3 = (byte)((n2 & 0x1F) << 3);
                        by2 = (byte)((n2 & 0x3E0) >> 2);
                        by = (byte)((n2 & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        by3 = (byte)((n2 & 0xFF0000) >> 16);
                        by2 = (byte)((n2 & 0xFF00) >> 8);
                        by = (byte)(n2 & 0xFF);
                        break;
                    }
                    case 32: {
                        by3 = (byte)((n2 & 0xFF000000) >>> 24);
                        by2 = (byte)((n2 & 0xFF0000) >> 16);
                        by = (byte)((n2 & 0xFF00) >> 8);
                    }
                }
            }
        }
        OS.SelectObject(l3, l4);
        OS.SelectObject(l5, l7);
        OS.DeleteObject(l3);
        OS.DeleteObject(l5);
        OS.ReleaseDC(0L, l2);
        byArray2 = new byte[n5];
        OS.MoveMemory(byArray2, lArray[0], n5);
        if (n != -1) {
            int n6 = 0;
            int n7 = 0;
            while (n6 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    byArray2[n7 + 3] = (byte)n;
                    n7 += 4;
                    ++n8;
                }
                ++n6;
            }
        } else if (byArray != null) {
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            while (n9 < n4) {
                int n12 = 0;
                while (n12 < n3) {
                    byArray2[n10 + 3] = byArray[n11++];
                    n10 += 4;
                    ++n12;
                }
                ++n9;
            }
        } else if (n2 != -1) {
            int n13 = 0;
            int n14 = 0;
            while (n13 < n4) {
                int n15 = 0;
                while (n15 < n3) {
                    byArray2[n14 + 3] = byArray2[n14] == by3 && byArray2[n14 + 1] == by2 && byArray2[n14 + 2] == by ? 0 : -1;
                    n14 += 4;
                    ++n15;
                }
                ++n13;
            }
        }
        OS.MoveMemory(lArray[0], byArray2, n5);
        return l6;
    }

    static Image createIcon(Image image) {
        long l;
        long l2;
        long l3;
        Device device = image.getDevice();
        ImageData imageData = image.getImageDataAtCurrentZoom();
        if (imageData.alpha == -1 && imageData.alphaData == null) {
            ImageData imageData2 = imageData.getTransparencyMask();
            return new Image(device, imageData, imageData2);
        }
        int n = imageData.width;
        int n2 = imageData.height;
        long l4 = device.internal_new_GC(null);
        long l5 = OS.CreateCompatibleDC(l4);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            l3 = Display.create32bitDIB(image.handle, imageData.alpha, imageData.alphaData, imageData.transparentPixel);
            l2 = OS.CreateBitmap(n, n2, 1, 1, null);
            l = OS.SelectObject(l5, l2);
            OS.PatBlt(l5, 0, 0, n, n2, 66);
        } else {
            l2 = Display.createMaskFromAlpha(imageData, n, n2);
            l3 = OS.CreateCompatibleBitmap(l4, n, n2);
            l = OS.SelectObject(l5, l3);
            long l6 = OS.CreateCompatibleDC(l4);
            long l7 = OS.SelectObject(l6, image.handle);
            OS.PatBlt(l5, 0, 0, n, n2, 66);
            OS.BitBlt(l5, 0, 0, n, n2, l6, 0, 0, 0x660046);
            OS.SelectObject(l6, l2);
            OS.BitBlt(l5, 0, 0, n, n2, l6, 0, 0, 8913094);
            OS.SelectObject(l6, image.handle);
            OS.BitBlt(l5, 0, 0, n, n2, l6, 0, 0, 0x660046);
            OS.SelectObject(l6, l7);
            OS.DeleteDC(l6);
        }
        OS.SelectObject(l5, l);
        OS.DeleteDC(l5);
        device.internal_dispose_GC(l4, null);
        ICONINFO iCONINFO = new ICONINFO();
        iCONINFO.fIcon = true;
        iCONINFO.hbmColor = l3;
        iCONINFO.hbmMask = l2;
        long l8 = OS.CreateIconIndirect(iCONINFO);
        if (l8 == 0L) {
            SWT.error(2);
        }
        OS.DeleteObject(l3);
        OS.DeleteObject(l2);
        return Image.win32_new(device, 1, l8);
    }

    static long createMaskFromAlpha(ImageData imageData, int n, int n2) {
        int n3 = imageData.width;
        int n4 = imageData.height;
        ImageData imageData2 = ImageData.internal_new(n3, n4, 1, new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255)), 2, null, 1, null, null, -1, -1, -1, 0, 0, 0, 0);
        int n5 = 0;
        int n6 = 0;
        while (n6 < imageData2.height) {
            int n7 = 0;
            while (n7 < imageData2.width) {
                imageData2.setPixel(n7, n6, (imageData.alphaData[n5++] & 0xFF) <= 127 ? 1 : 0);
                ++n7;
            }
            ++n6;
        }
        long l = OS.CreateBitmap(n3, n4, 1, 1, imageData2.data);
        if (n3 != n || n4 != n2) {
            long l2 = OS.GetDC(0L);
            long l3 = OS.CreateCompatibleDC(l2);
            OS.SelectObject(l3, l);
            long l4 = OS.CreateCompatibleDC(l2);
            long l5 = OS.CreateBitmap(n, n2, 1, 1, null);
            OS.SelectObject(l4, l5);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(l4, 3);
            }
            OS.StretchBlt(l4, 0, 0, n, n2, l3, 0, 0, n3, n4, 0xCC0020);
            OS.DeleteDC(l3);
            OS.DeleteDC(l4);
            OS.ReleaseDC(0L, l2);
            OS.DeleteObject(l);
            l = l5;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int n = 0;
            while (n < Displays.length) {
                if (display == Displays[n]) {
                    Display.Displays[n] = null;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int n = 0;
        while (n < this.disposeList.length) {
            if (this.disposeList[n] == null) {
                this.disposeList[n] = runnable;
                return;
            }
            ++n;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void drawMenuBars() {
        if (this.bars == null) {
            return;
        }
        int n = 0;
        while (n < this.bars.length) {
            Menu menu = this.bars[n];
            if (menu != null && !menu.isDisposed()) {
                menu.update();
            }
            ++n;
        }
        this.bars = null;
    }

    long embeddedProc(long l, long l2, long l3, long l4) {
        switch ((int)l2) {
            case 32770: {
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, l4, MSG.sizeof);
                OS.TranslateMessage(mSG);
                OS.DispatchMessage(mSG);
                long l5 = OS.GetProcessHeap();
                OS.HeapFree(l5, 0, l4);
                break;
            }
            case 32771: {
                OS.DestroyWindow(l);
                if (this.embeddedCallback != null) {
                    this.embeddedCallback.dispose();
                }
                if (this.getMsgCallback != null) {
                    this.getMsgCallback.dispose();
                }
                this.getMsgCallback = null;
                this.embeddedCallback = null;
                this.getMsgProc = 0L;
                this.embeddedProc = 0L;
            }
        }
        return OS.DefWindowProc(l, (int)l2, l3, l4);
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int n = event.type;
            this.sendPreEvent(n);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(n);
            }
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    boolean filterMessage(MSG mSG) {
        Control control;
        int n = mSG.message;
        if (256 <= n && n <= 264 && (control = this.findControl(mSG.hwnd)) != null && (this.translateAccelerator(mSG, control) || this.translateMnemonic(mSG, control) || this.translateTraversal(mSG, control))) {
            this.lastKey = 0;
            this.lastAscii = 0;
            this.lastDead = false;
            this.lastNull = false;
            this.lastVirtual = false;
            return true;
        }
        return false;
    }

    Control findControl(long l) {
        if (l == 0L) {
            return null;
        }
        long l2 = 0L;
        do {
            Control control;
            if ((control = this.getControl(l)) != null) {
                return control;
            }
            l2 = OS.GetWindow(l, 4);
        } while ((l = OS.GetParent(l)) != 0L && l != l2);
        return null;
    }

    public Widget findWidget(long l) {
        this.checkDevice();
        return this.getControl(l);
    }

    public Widget findWidget(long l, long l2) {
        this.checkDevice();
        Control control = this.getControl(l);
        return control != null ? control.findItem(l2) : null;
    }

    public Widget findWidget(Widget widget, long l) {
        this.checkDevice();
        if (widget instanceof Control) {
            return this.findWidget(((Control)widget).handle, l);
        }
        return null;
    }

    long foregroundIdleProc(long l, long l2, long l3) {
        if (l >= 0L && this.runMessages && this.getMessageCount() != 0) {
            int n;
            MSG mSG;
            this.sendPostExternalEventDispatchEvent();
            if (this.runMessagesInIdle) {
                if (this.runMessagesInMessageProc) {
                    OS.PostMessage(this.hwndMessage, 32774, 0L, 0L);
                } else {
                    this.runAsyncMessages(false);
                }
            }
            if (!OS.PeekMessage(mSG = new MSG(), 0L, 0, 0, n = 458754)) {
                this.wakeThread();
            }
            this.sendPreExternalEventDispatchEvent();
        }
        return OS.CallNextHookEx(this.idleHook, (int)l, l2, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int n = 0;
            while (n < Displays.length) {
                Display display = Displays[n];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    TouchSource findTouchSource(long l, Monitor monitor) {
        if (this.touchSources == null) {
            this.touchSources = new TouchSource[4];
        }
        int n = this.touchSources.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.touchSources[n2] != null && this.touchSources[n2].handle == l) {
                return this.touchSources[n2];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.touchSources[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            TouchSource[] touchSourceArray = new TouchSource[n + 4];
            System.arraycopy(this.touchSources, 0, touchSourceArray, 0, n);
            this.touchSources = touchSourceArray;
        }
        this.touchSources[n2] = new TouchSource(l, true, monitor.getBounds());
        return this.touchSources[n2];
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Control control = this.findControl(OS.GetActiveWindow());
        return control != null ? control.getShell() : null;
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            int n = OS.GetSystemMetrics(0);
            int n2 = OS.GetSystemMetrics(1);
            return new Rectangle(0, 0, n, n2);
        }
        int n = OS.GetSystemMetrics(76);
        int n3 = OS.GetSystemMetrics(77);
        int n4 = OS.GetSystemMetrics(78);
        int n5 = OS.GetSystemMetrics(79);
        return new Rectangle(n, n3, n4, n5);
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getClickCount(int n, int n2, long l, long l2) {
        switch (n) {
            case 3: {
                int n3 = OS.GetDoubleClickTime();
                if (this.clickRect == null) {
                    this.clickRect = new RECT();
                }
                int n4 = Math.abs(this.lastTime - this.getLastEventTime());
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, l2);
                this.clickCount = this.lastClickHwnd == l && this.lastButton == n2 && n4 <= n3 && OS.PtInRect(this.clickRect, pOINT) ? ++this.clickCount : 1;
            }
            case 8: {
                this.lastButton = n2;
                this.lastClickHwnd = l;
                this.lastTime = this.getLastEventTime();
                int n5 = OS.GetSystemMetrics(36) / 2;
                int n6 = OS.GetSystemMetrics(37) / 2;
                int n7 = OS.GET_X_LPARAM(l2);
                int n8 = OS.GET_Y_LPARAM(l2);
                OS.SetRect(this.clickRect, n7 - n5, n8 - n6, n7 + n5, n8 + n6);
            }
            case 4: {
                return this.clickCount;
            }
        }
        return 0;
    }

    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getClientAreaInPixels());
    }

    Rectangle getClientAreaInPixels() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            int n = rECT.right - rECT.left;
            int n2 = rECT.bottom - rECT.top;
            return new Rectangle(rECT.left, rECT.top, n, n2);
        }
        int n = OS.GetSystemMetrics(76);
        int n3 = OS.GetSystemMetrics(77);
        int n4 = OS.GetSystemMetrics(78);
        int n5 = OS.GetSystemMetrics(79);
        return new Rectangle(n, n3, n4, n5);
    }

    Control getControl(long l) {
        Control control;
        if (l == 0L) {
            return null;
        }
        if (this.lastControl != null && this.lastHwnd == l) {
            return this.lastControl;
        }
        if (this.lastGetControl != null && this.lastGetHwnd == l) {
            return this.lastGetControl;
        }
        int n = USE_PROPERTY ? (int)OS.GetProp(l, SWT_OBJECT_INDEX) - 1 : (int)OS.GetWindowLongPtr(l, -21) - 1;
        if (n >= 0 && n < this.controlTable.length && (control = this.controlTable[n]) != null && control.checkHandle(l)) {
            this.lastGetHwnd = l;
            this.lastGetControl = control;
            return control;
        }
        return null;
    }

    public Control getCursorControl() {
        this.checkDevice();
        POINT pOINT = new POINT();
        if (!OS.GetCursorPos(pOINT)) {
            return null;
        }
        return this.findControl(OS.WindowFromPoint(pOINT));
    }

    public Point getCursorLocation() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getCursorLocationInPixels());
    }

    Point getCursorLocationInPixels() {
        POINT pOINT = new POINT();
        OS.GetCursorPos(pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(13), OS.GetSystemMetrics(14))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    @Override
    public boolean isAutoScalable() {
        return true;
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(RUN_MESSAGES_IN_IDLE_KEY)) {
            return new Boolean(this.runMessagesInIdle);
        }
        if (string.equals(RUN_MESSAGES_IN_MESSAGE_PROC_KEY)) {
            return new Boolean(this.runMessagesInMessageProc);
        }
        if (string.equals(USE_OWNDC_KEY)) {
            return new Boolean(this.useOwnDC);
        }
        if (string.equals(ACCEL_KEY_HIT)) {
            return new Boolean(this.accelKeyHit);
        }
        if (this.keys == null) {
            return null;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDoubleClickTime();
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        return this._getFocusControl();
    }

    String getFontName(LOGFONT lOGFONT) {
        char[] cArray;
        if (OS.IsUnicode) {
            cArray = ((LOGFONTW)lOGFONT).lfFaceName;
        } else {
            cArray = new char[32];
            byte[] byArray = ((LOGFONTA)lOGFONT).lfFaceName;
            OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\u0000') break;
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public boolean getHighContrast() {
        this.checkDevice();
        if (OS.IsWinCE) {
            return false;
        }
        HIGHCONTRAST hIGHCONTRAST = new HIGHCONTRAST();
        hIGHCONTRAST.cbSize = HIGHCONTRAST.sizeof;
        OS.SystemParametersInfo(66, 0, hIGHCONTRAST, 0);
        return (hIGHCONTRAST.dwFlags & 1) != 0;
    }

    public int getIconDepth() {
        TCHAR tCHAR;
        this.checkDevice();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1) && this.getDepth() >= 24) {
            return 32;
        }
        TCHAR tCHAR2 = new TCHAR(0, "Control Panel\\Desktop\\WindowMetrics", true);
        long[] lArray = new long[1];
        int n = OS.RegOpenKeyEx(-2147483647L, tCHAR2, 0, 131097, lArray);
        if (n != 0) {
            return 4;
        }
        int n2 = 4;
        TCHAR tCHAR3 = new TCHAR(0, "Shell Icon BPP", true);
        int[] nArray = new int[1];
        n = OS.RegQueryValueEx(lArray[0], tCHAR3, 0L, null, null, nArray);
        if (n == 0 && (n = OS.RegQueryValueEx(lArray[0], tCHAR3, 0L, null, tCHAR = new TCHAR(0, nArray[0] / TCHAR.sizeof), nArray)) == 0) {
            try {
                n2 = Integer.parseInt(tCHAR.toString(0, tCHAR.strlen()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        OS.RegCloseKey(lArray[0]);
        return n2;
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(49), OS.GetSystemMetrics(50)), new Point(OS.GetSystemMetrics(11), OS.GetSystemMetrics(12))};
    }

    ImageList getImageList(int n, int n2, int n3) {
        Object object;
        if (this.imageList == null) {
            this.imageList = new ImageList[4];
        }
        int n4 = 0;
        int n5 = this.imageList.length;
        while (n4 < n5) {
            object = this.imageList[n4];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n2 && point.y == n3 && ((ImageList)object).getStyle() == n) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n4;
        }
        if (n4 == n5) {
            object = new ImageList[n5 + 4];
            System.arraycopy(this.imageList, 0, object, 0, n5);
            this.imageList = object;
        }
        this.imageList[n4] = object = new ImageList(n, n2, n3);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBar(int n, int n2, int n3) {
        Object object;
        if (this.toolImageList == null) {
            this.toolImageList = new ImageList[4];
        }
        int n4 = 0;
        int n5 = this.toolImageList.length;
        while (n4 < n5) {
            object = this.toolImageList[n4];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n2 && point.y == n3 && ((ImageList)object).getStyle() == n) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n4;
        }
        if (n4 == n5) {
            object = new ImageList[n5 + 4];
            System.arraycopy(this.toolImageList, 0, object, 0, n5);
            this.toolImageList = object;
        }
        this.toolImageList[n4] = object = new ImageList(n, n2, n3);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBarDisabled(int n, int n2, int n3) {
        Object object;
        if (this.toolDisabledImageList == null) {
            this.toolDisabledImageList = new ImageList[4];
        }
        int n4 = 0;
        int n5 = this.toolDisabledImageList.length;
        while (n4 < n5) {
            object = this.toolDisabledImageList[n4];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n2 && point.y == n3 && ((ImageList)object).getStyle() == n) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n4;
        }
        if (n4 == n5) {
            object = new ImageList[n5 + 4];
            System.arraycopy(this.toolDisabledImageList, 0, object, 0, n5);
            this.toolDisabledImageList = object;
        }
        this.toolDisabledImageList[n4] = object = new ImageList(n, n2, n3);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBarHot(int n, int n2, int n3) {
        Object object;
        if (this.toolHotImageList == null) {
            this.toolHotImageList = new ImageList[4];
        }
        int n4 = 0;
        int n5 = this.toolHotImageList.length;
        while (n4 < n5) {
            object = this.toolHotImageList[n4];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n2 && point.y == n3 && ((ImageList)object).getStyle() == n) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n4;
        }
        if (n4 == n5) {
            object = new ImageList[n5 + 4];
            System.arraycopy(this.toolHotImageList, 0, object, 0, n5);
            this.toolHotImageList = object;
        }
        this.toolHotImageList[n4] = object = new ImageList(n, n2, n3);
        ((ImageList)object).addRef();
        return object;
    }

    int getLastEventTime() {
        return OS.IsWinCE ? OS.GetTickCount() : OS.GetMessageTime();
    }

    MenuItem getMenuItem(int n) {
        if (this.items == null) {
            return null;
        }
        if ((n -= 108) >= 0 && n < this.items.length) {
            return this.items[n];
        }
        return null;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Shell getModalShell() {
        if (this.modalShells == null) {
            return null;
        }
        int n = this.modalShells.length;
        while (--n >= 0) {
            Shell shell = this.modalShells[n];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return new Monitor[]{this.getPrimaryMonitor()};
        }
        this.monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        long l = callback.getAddress();
        if (l == 0L) {
            this.error(3);
        }
        OS.EnumDisplayMonitors(0L, null, l, 0);
        callback.dispose();
        Monitor[] monitorArray = new Monitor[this.monitorCount];
        System.arraycopy(this.monitors, 0, monitorArray, 0, this.monitorCount);
        this.monitors = null;
        this.monitorCount = 0;
        return monitorArray;
    }

    long getMsgProc(long l, long l2, long l3) {
        if (this.embeddedHwnd == 0L) {
            long l4 = OS.GetModuleHandle(null);
            this.embeddedHwnd = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0L, 0L, l4, null);
            this.embeddedCallback = new Callback(this, "embeddedProc", 4);
            this.embeddedProc = this.embeddedCallback.getAddress();
            if (this.embeddedProc == 0L) {
                this.error(3);
            }
            OS.SetWindowLongPtr(this.embeddedHwnd, -4, this.embeddedProc);
        }
        if (l >= 0L && (l2 & 1L) != 0L) {
            MSG mSG = new MSG();
            OS.MoveMemory(mSG, l3, MSG.sizeof);
            block0 : switch (mSG.message) {
                case 256: 
                case 257: 
                case 260: 
                case 261: {
                    Control control = this.findControl(mSG.hwnd);
                    if (control == null) break;
                    long l5 = OS.GetProcessHeap();
                    long l6 = OS.HeapAlloc(l5, 8, MSG.sizeof);
                    OS.MoveMemory(l6, mSG, MSG.sizeof);
                    OS.PostMessage(this.hwndMessage, 32770, l2, l6);
                    switch ((int)mSG.wParam) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 20: 
                        case 144: 
                        case 145: {
                            break block0;
                        }
                    }
                    mSG.message = 0;
                    OS.MoveMemory(l3, mSG, MSG.sizeof);
                }
            }
        }
        return OS.CallNextHookEx(this.msgHook, (int)l, l2, l3);
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            Monitor monitor = new Monitor();
            int n = OS.GetSystemMetrics(0);
            int n2 = OS.GetSystemMetrics(1);
            Rectangle rectangle = new Rectangle(0, 0, n, n2);
            rectangle = DPIUtil.autoScaleDown(rectangle);
            monitor.setBounds(rectangle);
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            Rectangle rectangle2 = new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
            rectangle2 = DPIUtil.autoScaleDown(rectangle2);
            monitor.setClientArea(rectangle2);
            return monitor;
        }
        this.monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        long l = callback.getAddress();
        if (l == 0L) {
            this.error(3);
        }
        OS.EnumDisplayMonitors(0L, null, l, 0);
        callback.dispose();
        Monitor monitor = null;
        MONITORINFO mONITORINFO = new MONITORINFO();
        mONITORINFO.cbSize = MONITORINFO.sizeof;
        int n = 0;
        while (n < this.monitorCount) {
            Monitor monitor2 = this.monitors[n];
            OS.GetMonitorInfo(this.monitors[n].handle, mONITORINFO);
            if ((mONITORINFO.dwFlags & 1) != 0) {
                monitor = monitor2;
                break;
            }
            ++n;
        }
        this.monitors = null;
        this.monitorCount = 0;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        Shell[] shellArray = new Shell[16];
        int n2 = 0;
        while (n2 < this.controlTable.length) {
            Control control = this.controlTable[n2];
            if (control != null && control instanceof Shell) {
                int n3 = 0;
                while (n3 < n) {
                    if (shellArray[n3] == control) break;
                    ++n3;
                }
                if (n3 == n) {
                    if (n == shellArray.length) {
                        Shell[] shellArray2 = new Shell[n + 16];
                        System.arraycopy(shellArray, 0, shellArray2, 0, n);
                        shellArray = shellArray2;
                    }
                    shellArray[n++] = (Shell)control;
                }
            }
            ++n2;
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray3, 0, n);
        return shellArray3;
    }

    Image getSortImage(int n) {
        switch (n) {
            case 128: {
                if (this.upArrow != null) {
                    return this.upArrow;
                }
                Color color = this.getSystemColor(18);
                Color color2 = this.getSystemColor(20);
                Color color3 = this.getSystemColor(22);
                PaletteData paletteData = new PaletteData(color.getRGB(), color2.getRGB(), color3.getRGB());
                ImageData imageData = new ImageData(8, 8, 4, paletteData);
                imageData.transparentPixel = 2;
                this.upArrow = new Image((Device)this, imageData);
                GC gC = new GC(this.upArrow);
                gC.setBackground(color3);
                gC.fillRectangle(0, 0, 8, 8);
                gC.setForeground(color);
                int[] nArray = new int[14];
                nArray[1] = 6;
                nArray[2] = 1;
                nArray[3] = 6;
                nArray[4] = 1;
                nArray[5] = 4;
                nArray[6] = 2;
                nArray[7] = 4;
                nArray[8] = 2;
                nArray[9] = 2;
                nArray[10] = 3;
                nArray[11] = 2;
                nArray[12] = 3;
                nArray[13] = 1;
                int[] nArray2 = nArray;
                gC.drawPolyline(nArray2);
                gC.setForeground(color2);
                int[] nArray3 = new int[18];
                nArray3[1] = 7;
                nArray3[2] = 7;
                nArray3[3] = 7;
                nArray3[4] = 7;
                nArray3[5] = 6;
                nArray3[6] = 6;
                nArray3[7] = 6;
                nArray3[8] = 6;
                nArray3[9] = 4;
                nArray3[10] = 5;
                nArray3[11] = 4;
                nArray3[12] = 5;
                nArray3[13] = 2;
                nArray3[14] = 4;
                nArray3[15] = 2;
                nArray3[16] = 4;
                nArray3[17] = 1;
                int[] nArray4 = nArray3;
                gC.drawPolyline(nArray4);
                gC.dispose();
                return this.upArrow;
            }
            case 1024: {
                if (this.downArrow != null) {
                    return this.downArrow;
                }
                Color color = this.getSystemColor(18);
                Color color4 = this.getSystemColor(20);
                Color color5 = this.getSystemColor(22);
                PaletteData paletteData = new PaletteData(color.getRGB(), color4.getRGB(), color5.getRGB());
                ImageData imageData = new ImageData(8, 8, 4, paletteData);
                imageData.transparentPixel = 2;
                this.downArrow = new Image((Device)this, imageData);
                GC gC = new GC(this.downArrow);
                gC.setBackground(color5);
                gC.fillRectangle(0, 0, 8, 8);
                gC.setForeground(color);
                int[] nArray = new int[18];
                nArray[0] = 7;
                nArray[5] = 1;
                nArray[6] = 1;
                nArray[7] = 1;
                nArray[8] = 1;
                nArray[9] = 3;
                nArray[10] = 2;
                nArray[11] = 3;
                nArray[12] = 2;
                nArray[13] = 5;
                nArray[14] = 3;
                nArray[15] = 5;
                nArray[16] = 3;
                nArray[17] = 6;
                int[] nArray5 = nArray;
                gC.drawPolyline(nArray5);
                gC.setForeground(color4);
                int[] nArray6 = new int[]{4, 6, 4, 5, 5, 5, 5, 3, 6, 3, 6, 1, 7, 1};
                gC.drawPolyline(nArray6);
                gC.dispose();
                return this.downArrow;
            }
        }
        return null;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    @Override
    public Color getSystemColor(int n) {
        this.checkDevice();
        int n2 = 0;
        switch (n) {
            case 17: {
                n2 = OS.GetSysColor(OS.COLOR_3DDKSHADOW);
                break;
            }
            case 18: {
                n2 = OS.GetSysColor(OS.COLOR_3DSHADOW);
                break;
            }
            case 19: {
                n2 = OS.GetSysColor(OS.COLOR_3DLIGHT);
                break;
            }
            case 20: {
                n2 = OS.GetSysColor(OS.COLOR_3DHIGHLIGHT);
                break;
            }
            case 22: {
                n2 = OS.GetSysColor(OS.COLOR_3DFACE);
                break;
            }
            case 23: {
                n2 = OS.GetSysColor(OS.COLOR_WINDOWFRAME);
                break;
            }
            case 21: 
            case 24: {
                n2 = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
                break;
            }
            case 25: {
                n2 = OS.GetSysColor(OS.COLOR_WINDOW);
                break;
            }
            case 26: {
                n2 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                break;
            }
            case 27: {
                n2 = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                break;
            }
            case 36: {
                n2 = OS.GetSysColor(OS.COLOR_HOTLIGHT);
                break;
            }
            case 28: {
                n2 = OS.GetSysColor(OS.COLOR_INFOTEXT);
                break;
            }
            case 29: {
                n2 = OS.GetSysColor(OS.COLOR_INFOBK);
                break;
            }
            case 30: {
                n2 = OS.GetSysColor(OS.COLOR_CAPTIONTEXT);
                break;
            }
            case 31: {
                n2 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 32: {
                n2 = OS.GetSysColor(OS.COLOR_GRADIENTACTIVECAPTION);
                if (n2 != 0) break;
                n2 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 33: {
                n2 = OS.GetSysColor(OS.COLOR_INACTIVECAPTIONTEXT);
                break;
            }
            case 34: {
                n2 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            case 35: {
                n2 = OS.GetSysColor(OS.COLOR_GRADIENTINACTIVECAPTION);
                if (n2 != 0) break;
                n2 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        return Color.win32_new(this, n2);
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (n < 0 || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    @Override
    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        long l = 0L;
        if (!OS.IsWinCE) {
            NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                LOGFONT lOGFONT = OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont;
                l = OS.CreateFontIndirect(lOGFONT);
                LOGFONT lOGFONT2 = this.lfSystemFont = l != 0L ? lOGFONT : null;
            }
        }
        if (l == 0L) {
            l = OS.GetStockObject(17);
        }
        if (l == 0L) {
            l = OS.GetStockObject(13);
        }
        this.systemFont = Font.win32_new(this, l);
        return this.systemFont;
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        switch (n) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                long l = OS.LoadImage(0L, 32513L, 1, 0, 0, 32768);
                this.errorImage = Image.win32_new(this, 1, l);
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                long l = OS.LoadImage(0L, 32516L, 1, 0, 0, 32768);
                this.infoImage = Image.win32_new(this, 1, l);
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage != null) {
                    return this.questionImage;
                }
                long l = OS.LoadImage(0L, 32514L, 1, 0, 0, 32768);
                this.questionImage = Image.win32_new(this, 1, l);
                return this.questionImage;
            }
            case 8: {
                if (this.warningIcon != null) {
                    return this.warningIcon;
                }
                long l = OS.LoadImage(0L, 32515L, 1, 0, 0, 32768);
                this.warningIcon = Image.win32_new(this, 1, l);
                return this.warningIcon;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        if (this.taskBar != null) {
            return this.taskBar;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1)) {
            this.taskBar = new TaskBar(this, 0);
        }
        return this.taskBar;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        if (!OS.IsWinCE) {
            this.tray = new Tray(this, 0);
        }
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        int n = OS.GetSystemMetrics(94);
        return (n & 0xC0) == 192;
    }

    long hButtonTheme() {
        if (this.hButtonTheme != 0L) {
            return this.hButtonTheme;
        }
        this.hButtonTheme = OS.OpenThemeData(this.hwndMessage, BUTTON);
        return this.hButtonTheme;
    }

    long hEditTheme() {
        if (this.hEditTheme != 0L) {
            return this.hEditTheme;
        }
        this.hEditTheme = OS.OpenThemeData(this.hwndMessage, EDIT);
        return this.hEditTheme;
    }

    long hExplorerBarTheme() {
        if (this.hExplorerBarTheme != 0L) {
            return this.hExplorerBarTheme;
        }
        this.hExplorerBarTheme = OS.OpenThemeData(this.hwndMessage, EXPLORERBAR);
        return this.hExplorerBarTheme;
    }

    long hScrollBarTheme() {
        if (this.hScrollBarTheme != 0L) {
            return this.hScrollBarTheme;
        }
        this.hScrollBarTheme = OS.OpenThemeData(this.hwndMessage, SCROLLBAR);
        return this.hScrollBarTheme;
    }

    long hTabTheme() {
        if (this.hTabTheme != 0L) {
            return this.hTabTheme;
        }
        this.hTabTheme = OS.OpenThemeData(this.hwndMessage, TAB);
        return this.hTabTheme;
    }

    @Override
    public long internal_new_GC(GCData gCData) {
        long l;
        if (this.isDisposed()) {
            this.error(45);
        }
        if ((l = OS.GetDC(0L)) == 0L) {
            this.error(2);
        }
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.font = this.getSystemFont();
        }
        return l;
    }

    @Override
    protected void init() {
        long[] lArray;
        int n;
        String string;
        super.init();
        DPIUtil.setDeviceZoom(this.getDeviceZoom());
        char[] cArray = null;
        if (APP_NAME != null && !"SWT".equalsIgnoreCase(APP_NAME) && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 1)) {
            int n2 = APP_NAME.length();
            cArray = new char[n2 + 1];
            APP_NAME.getChars(0, n2, cArray, 0);
            long[] lArray2 = new long[1];
            if (OS.GetCurrentProcessExplicitAppUserModelID(lArray2) != 0) {
                OS.SetCurrentProcessExplicitAppUserModelID(cArray);
            }
            if (lArray2[0] != 0L) {
                OS.CoTaskMemFree(lArray2[0]);
            }
        }
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0L) {
            this.error(3);
        }
        this.threadId = OS.GetCurrentThreadId();
        this.windowClass = new TCHAR(0, WindowName + WindowClassCount, true);
        this.windowShadowClass = new TCHAR(0, WindowShadowName + WindowClassCount, true);
        this.windowOwnDCClass = new TCHAR(0, WindowOwnDCName + WindowClassCount, true);
        ++WindowClassCount;
        long l = OS.GetProcessHeap();
        long l2 = OS.GetModuleHandle(null);
        WNDCLASS wNDCLASS = new WNDCLASS();
        wNDCLASS.hInstance = l2;
        wNDCLASS.lpfnWndProc = this.windowProc;
        wNDCLASS.style = 8200;
        wNDCLASS.hCursor = OS.LoadCursor(0L, 32512L);
        if (!OS.IsWinCE) {
            TCHAR tCHAR = new TCHAR(0, 260);
            while (OS.GetModuleFileName(0L, tCHAR, tCHAR.length()) == tCHAR.length()) {
                tCHAR = new TCHAR(0, tCHAR.length() + 260);
            }
            if (OS.ExtractIconEx(tCHAR, -1, null, null, 1) != 0 && ((string = tCHAR.toString(0, tCHAR.strlen())).endsWith("java.exe") || string.endsWith("javaw.exe"))) {
                wNDCLASS.hIcon = OS.LoadIcon(0L, 32512L);
            }
        }
        int n3 = this.windowClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(l, 8, n3);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowClass, n3);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(l, 0, wNDCLASS.lpszClassName);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            wNDCLASS.style |= 0x20000;
        }
        n3 = this.windowShadowClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(l, 8, n3);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowShadowClass, n3);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(l, 0, wNDCLASS.lpszClassName);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            wNDCLASS.style |= 0x20;
        }
        n3 = this.windowOwnDCClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(l, 8, n3);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowOwnDCClass, n3);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(l, 0, wNDCLASS.lpszClassName);
        this.hwndMessage = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0L, 0L, l2, null);
        string = "SWT_Window_" + APP_NAME;
        OS.SetWindowText(this.hwndMessage, new TCHAR(0, string, true));
        this.messageCallback = new Callback(this, "messageProc", 4);
        this.messageProc = this.messageCallback.getAddress();
        if (this.messageProc == 0L) {
            this.error(3);
        }
        OS.SetWindowLongPtr(this.hwndMessage, -4, this.messageProc);
        if (!OS.IsWinCE) {
            this.msgFilterCallback = new Callback(this, "msgFilterProc", 3);
            this.msgFilterProc = this.msgFilterCallback.getAddress();
            if (this.msgFilterProc == 0L) {
                this.error(3);
            }
            this.filterHook = OS.SetWindowsHookEx(-1, this.msgFilterProc, 0L, this.threadId);
        }
        if (!OS.IsWinCE) {
            this.foregroundIdleCallback = new Callback(this, "foregroundIdleProc", 3);
            this.foregroundIdleProc = this.foregroundIdleCallback.getAddress();
            if (this.foregroundIdleProc == 0L) {
                this.error(3);
            }
            this.idleHook = OS.SetWindowsHookEx(11, this.foregroundIdleProc, 0L, this.threadId);
        }
        TASKBARCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarCreated", true));
        TASKBARBUTTONCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarButtonCreated", true));
        SWT_RESTORECARET = OS.RegisterWindowMessage(new TCHAR(0, "SWT_RESTORECARET", true));
        DI_GETDRAGIMAGE = OS.RegisterWindowMessage(new TCHAR(0, "ShellGetDragImage", true));
        SWT_OPENDOC = OS.RegisterWindowMessage(new TCHAR(0, "SWT_OPENDOC", true));
        if (!OS.IsWinCE) {
            OS.OleInitialize(0L);
        }
        if (cArray != null && (n = OS.CoCreateInstance(TaskBar.CLSID_DestinationList, 0L, 1, TaskBar.IID_ICustomDestinationList, lArray = new long[1])) == 0) {
            OS.VtblCall(10, lArray[0], cArray);
            OS.VtblCall(2, lArray[0]);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.BufferedPaintInit();
        }
        this.indexTable = new int[1024];
        this.controlTable = new Control[1024];
        int n4 = 0;
        while (n4 < 1023) {
            this.indexTable[n4] = n4 + 1;
            ++n4;
        }
        this.indexTable[1023] = -1;
        this.lastHighContrast = this.getHighContrast();
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        OS.ReleaseDC(0L, l);
    }

    boolean isXMouseActive() {
        boolean bl = false;
        TCHAR tCHAR = new TCHAR(0, "Control Panel\\Desktop", true);
        long[] lArray = new long[1];
        int n = OS.RegOpenKeyEx(-2147483647L, tCHAR, 0, 131097, lArray);
        if (n == 0) {
            TCHAR tCHAR2 = new TCHAR(0, "UserPreferencesMask", true);
            int[] nArray = new int[1];
            int[] nArray2 = new int[]{4};
            n = OS.RegQueryValueEx(lArray[0], tCHAR2, 0L, null, nArray, nArray2);
            if (n == 0) {
                bl = (nArray[0] & 1) != 0;
            }
            OS.RegCloseKey(lArray[0]);
        }
        return bl;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, point));
    }

    Point mapInPixels(Control control, Control control2, Point point) {
        return this.mapInPixels(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        this.checkDevice();
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, n, n2));
    }

    Point mapInPixels(Control control, Control control2, int n, int n2) {
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        if (control == control2) {
            return new Point(n, n2);
        }
        long l = control != null ? control.handle : 0L;
        long l2 = control2 != null ? control2.handle : 0L;
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        OS.MapWindowPoints(l, l2, pOINT, 1);
        return new Point(pOINT.x, pOINT.y);
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(rectangle);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, rectangle));
    }

    Rectangle mapInPixels(Control control, Control control2, Rectangle rectangle) {
        return this.mapInPixels(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        this.checkDevice();
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        n3 = DPIUtil.autoScaleUp(n3);
        n4 = DPIUtil.autoScaleUp(n4);
        return DPIUtil.autoScaleDown(this.mapInPixels(control, control2, n, n2, n3, n4));
    }

    Rectangle mapInPixels(Control control, Control control2, int n, int n2, int n3, int n4) {
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        if (control == control2) {
            return new Rectangle(n, n2, n3, n4);
        }
        long l = control != null ? control.handle : 0L;
        long l2 = control2 != null ? control2.handle : 0L;
        RECT rECT = new RECT();
        rECT.left = n;
        rECT.top = n2;
        rECT.right = n + n3;
        rECT.bottom = n2 + n4;
        OS.MapWindowPoints(l, l2, rECT, 2);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    static char mbcsToWcs(int n) {
        return Display.mbcsToWcs(n, 0);
    }

    static char mbcsToWcs(int n, int n2) {
        char[] cArray;
        byte[] byArray;
        if (OS.IsUnicode) {
            return (char)n;
        }
        int n3 = n & 0xFFFF;
        if (n3 <= 127) {
            return (char)n;
        }
        int n4 = n2 != 0 ? n2 : 0;
        int n5 = OS.MultiByteToWideChar(n4, 1, byArray = n3 <= 255 ? new byte[]{(byte)n3} : new byte[]{(byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF)}, byArray.length, cArray = new char[1], 1);
        if (n5 == 0) {
            return '\u0000';
        }
        return cArray[0];
    }

    long messageProc(long l, long l2, long l3, long l4) {
        switch ((int)l2) {
            case 32774: {
                if (!this.runMessagesInIdle) break;
                this.runAsyncMessages(false);
                break;
            }
            case 32770: {
                boolean bl = false;
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, l4, MSG.sizeof);
                Control control = this.findControl(mSG.hwnd);
                if (control != null) {
                    int n;
                    boolean bl2 = false;
                    block12 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            if (OS.IsWinCE) break;
                            switch ((int)mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block12;
                                }
                            }
                            n = OS.MapVirtualKey((int)mSG.wParam, 2);
                            if (n == 0) break;
                            boolean bl3 = bl2 = (n & (OS.IsWinNT ? Integer.MIN_VALUE : 32768)) != 0;
                            if (bl2) break;
                            int n2 = 0;
                            while (n2 < ACCENTS.length) {
                                short s = OS.VkKeyScan(ACCENTS[n2]);
                                if (s != -1 && (long)(s & 0xFF) == mSG.wParam) {
                                    int n3 = s >> 8;
                                    if (OS.GetKeyState(16) < 0 == ((n3 & 1) != 0) && OS.GetKeyState(17) < 0 == ((n3 & 2) != 0) && OS.GetKeyState(18) < 0 == ((n3 & 4) != 0)) {
                                        if ((n3 & 7) == 0) break block12;
                                        bl2 = true;
                                        break block12;
                                    }
                                }
                                ++n2;
                            }
                            break;
                        }
                    }
                    if (!bl2 && !this.ignoreNextKey) {
                        mSG.hwnd = control.handle;
                        n = 10420227;
                        do {
                            if (bl |= this.filterMessage(mSG)) continue;
                            OS.TranslateMessage(mSG);
                            bl |= OS.DispatchMessage(mSG) == 1L;
                        } while (OS.PeekMessage(mSG, mSG.hwnd, 256, 264, n));
                    }
                    block18 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            switch ((int)mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block18;
                                }
                            }
                            this.ignoreNextKey = bl2;
                        }
                    }
                }
                switch ((int)mSG.wParam) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: 
                    case 144: 
                    case 145: {
                        bl = true;
                    }
                }
                if (bl) {
                    long l5 = OS.GetProcessHeap();
                    OS.HeapFree(l5, 0, l4);
                } else {
                    OS.PostMessage(this.embeddedHwnd, 32770, l3, l4);
                }
                return 0L;
            }
            case 32772: {
                if (this.tray != null) {
                    TrayItem[] trayItemArray = this.tray.items;
                    int n = 0;
                    while (n < trayItemArray.length) {
                        TrayItem trayItem = trayItemArray[n];
                        if (trayItem != null && (long)trayItem.id == l3) {
                            return trayItem.messageProc(l, (int)l2, l3, l4);
                        }
                        ++n;
                    }
                }
                return 0L;
            }
            case 28: {
                long l6;
                Shell shell;
                long l7;
                if (l3 == 0L || this.isXMouseActive() || (l7 = OS.GetActiveWindow()) != 0L && OS.IsWindowEnabled(l7)) break;
                Shell shell2 = shell = this.modalDialog != null ? this.modalDialog.parent : this.getModalShell();
                if (shell == null || shell.isDisposed()) break;
                long l8 = shell.handle;
                if (OS.IsWindowEnabled(l8)) {
                    shell.bringToTop();
                    if (shell.isDisposed()) break;
                }
                if ((l6 = OS.GetLastActivePopup(l8)) == 0L || l6 == shell.handle || this.getControl(l6) != null || !OS.IsWindowEnabled(l6)) break;
                OS.SetActiveWindow(l6);
                break;
            }
            case 22: {
                if (l3 == 0L) break;
                this.dispose();
                break;
            }
            case 17: {
                Event event = new Event();
                this.sendEvent(21, event);
                if (event.doit) break;
                return 0L;
            }
            case 800: {
                this.sendSettings = true;
            }
            case 26: {
                if (this.lastHighContrast != this.getHighContrast()) {
                    this.sendSettings = true;
                    this.lastHighContrast = this.getHighContrast();
                }
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    this.sendSettings = true;
                }
                switch ((int)l3) {
                    case 0: 
                    case 1: 
                    case 67: {
                        this.sendSettings = true;
                        this.lastHighContrast = this.getHighContrast();
                    }
                }
                if (!this.sendSettings) break;
                OS.SetTimer(this.hwndMessage, 100L, 2000, 0L);
                break;
            }
            case 794: {
                if (OS.COMCTL32_MAJOR < 6) break;
                if (this.hButtonTheme != 0L) {
                    OS.CloseThemeData(this.hButtonTheme);
                }
                if (this.hEditTheme != 0L) {
                    OS.CloseThemeData(this.hEditTheme);
                }
                if (this.hExplorerBarTheme != 0L) {
                    OS.CloseThemeData(this.hExplorerBarTheme);
                }
                if (this.hScrollBarTheme != 0L) {
                    OS.CloseThemeData(this.hScrollBarTheme);
                }
                if (this.hTabTheme != 0L) {
                    OS.CloseThemeData(this.hTabTheme);
                }
                this.hTabTheme = 0L;
                this.hScrollBarTheme = 0L;
                this.hExplorerBarTheme = 0L;
                this.hEditTheme = 0L;
                this.hButtonTheme = 0L;
                break;
            }
            case 275: {
                if (l3 == 100L) {
                    this.sendSettings = false;
                    OS.KillTimer(this.hwndMessage, 100L);
                    this.runSettings();
                    break;
                }
                this.runTimer(l3);
                break;
            }
            default: {
                Object object;
                if ((int)l2 == TASKBARCREATED && this.tray != null) {
                    object = this.tray.items;
                    int n = 0;
                    while (n < ((TrayItem[])object).length) {
                        Object object2 = object[n];
                        if (object2 != null) {
                            ((TrayItem)object2).recreate();
                        }
                        ++n;
                    }
                }
                if ((int)l2 != SWT_OPENDOC || (object = this.getSharedData((int)l3, (int)l4)) == null) break;
                if (((String)object).startsWith(TASKBAR_EVENT)) {
                    String string = ((String)object).substring(TASKBAR_EVENT.length());
                    int n = Integer.parseInt(string);
                    MenuItem menuItem = this.getMenuItem(n);
                    if (menuItem != null) {
                        menuItem.sendSelectionEvent(13);
                    }
                } else {
                    Event event = new Event();
                    event.text = object;
                    this.sendEvent(46, event);
                }
                this.wakeThread();
            }
        }
        return OS.DefWindowProc(l, (int)l2, l3, l4);
    }

    String getSharedData(int n, int n2) {
        long l;
        if (OS.IsWinCE) {
            return null;
        }
        long[] lArray = new long[1];
        if (n == OS.GetCurrentProcessId()) {
            lArray[0] = n2;
        } else {
            l = OS.OpenProcess(80, false, n);
            if (l == 0L) {
                return null;
            }
            OS.DuplicateHandle(l, n2, OS.GetCurrentProcess(), lArray, 2, false, 2);
            OS.CloseHandle(l);
        }
        l = OS.MapViewOfFile(lArray[0], 4, 0, 0, 0);
        if (l == 0L) {
            return null;
        }
        int n3 = OS.IsUnicode ? OS.wcslen(l) : OS.strlen(l);
        TCHAR tCHAR = new TCHAR(0, n3);
        int n4 = tCHAR.length() * TCHAR.sizeof;
        OS.MoveMemory(tCHAR, l, n4);
        String string = tCHAR.toString(0, n3);
        OS.UnmapViewOfFile(l);
        if ((long)n2 != lArray[0]) {
            OS.CloseHandle(lArray[0]);
        }
        return string;
    }

    long monitorEnumProc(long l, long l2, long l3, long l4) {
        Monitor[] monitorArray;
        if (this.monitorCount >= this.monitors.length) {
            monitorArray = new Monitor[this.monitors.length + 4];
            System.arraycopy(this.monitors, 0, monitorArray, 0, this.monitors.length);
            this.monitors = monitorArray;
        }
        monitorArray = new MONITORINFO();
        monitorArray.cbSize = MONITORINFO.sizeof;
        OS.GetMonitorInfo(l, (MONITORINFO)monitorArray);
        Monitor monitor = new Monitor();
        monitor.handle = l;
        Rectangle rectangle = new Rectangle(monitorArray.rcMonitor_left, monitorArray.rcMonitor_top, monitorArray.rcMonitor_right - monitorArray.rcMonitor_left, monitorArray.rcMonitor_bottom - monitorArray.rcMonitor_top);
        monitor.setBounds(DPIUtil.autoScaleDown(rectangle));
        Rectangle rectangle2 = new Rectangle(monitorArray.rcWork_left, monitorArray.rcWork_top, monitorArray.rcWork_right - monitorArray.rcWork_left, monitorArray.rcWork_bottom - monitorArray.rcWork_top);
        monitor.setClientArea(DPIUtil.autoScaleDown(rectangle2));
        this.monitors[this.monitorCount++] = monitor;
        return 1L;
    }

    long msgFilterProc(long l, long l2, long l3) {
        switch ((int)l) {
            case 16896: {
                if (this.runDragDrop || this.dragCancelled) break;
                OS.MoveMemory(this.hookMsg, l3, MSG.sizeof);
                if (this.hookMsg.message != 512) break;
                this.dragCancelled = true;
                OS.SendMessage(this.hookMsg.hwnd, 31, 0L, 0L);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                int n;
                MSG mSG;
                if (!this.runMessages) break;
                OS.MoveMemory(this.hookMsg, l3, MSG.sizeof);
                if (this.hookMsg.message != 0 || OS.PeekMessage(mSG = new MSG(), 0L, 0, 0, n = 10420226) || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return OS.CallNextHookEx(this.filterHook, (int)l, l2, l3);
    }

    int numpadKey(int n) {
        switch (n) {
            case 96: {
                return 48;
            }
            case 97: {
                return 49;
            }
            case 98: {
                return 50;
            }
            case 99: {
                return 51;
            }
            case 100: {
                return 52;
            }
            case 101: {
                return 53;
            }
            case 102: {
                return 54;
            }
            case 103: {
                return 55;
            }
            case 104: {
                return 56;
            }
            case 105: {
                return 57;
            }
            case 106: {
                return 42;
            }
            case 107: {
                return 43;
            }
            case 108: {
                return 0;
            }
            case 109: {
                return 45;
            }
            case 110: {
                return 46;
            }
            case 111: {
                return 47;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean post(Event var1_1) {
        var2_2 = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (var1_1 == null) {
                this.error(4);
            }
            var3_3 = var1_1.type;
            switch (var3_3) {
                case 1: 
                case 2: {
                    var4_4 = new KEYBDINPUT();
                    var4_4.wVk = (short)Display.untranslateKey(var1_1.keyCode);
                    if (var4_4.wVk == 0) {
                        var5_6 = var1_1.character;
                        switch (var5_6) {
                            case '\b': {
                                var4_4.wVk = (short)8;
                                break;
                            }
                            case '\r': {
                                var4_4.wVk = (short)13;
                                break;
                            }
                            case '\u007f': {
                                var4_4.wVk = (short)46;
                                break;
                            }
                            case '\u001b': {
                                var4_4.wVk = (short)27;
                                break;
                            }
                            case '\t': {
                                var4_4.wVk = (short)9;
                                break;
                            }
                            case '\n': {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return false;
                            }
                            default: {
                                if (OS.IsWinCE) {
                                    var4_4.wVk = (short)OS.CharUpper((short)var5_6);
                                    break;
                                }
                                var4_4.wVk = OS.VkKeyScan((short)Display.wcsToMbcs(var5_6, 0));
                                if (var4_4.wVk == -1) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return false;
                                }
                                var4_4.wVk = (short)(var4_4.wVk & 255);
                            }
                        }
                    }
                    var4_4.dwFlags = var3_3 == 2 ? 2 : 0;
                    switch (var4_4.wVk) {
                        case 3: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 111: 
                        case 144: {
                            var4_4.dwFlags |= 1;
                            break;
                        }
                    }
                    var5_7 = OS.GetProcessHeap();
                    var7_11 = OS.HeapAlloc(var5_7, 8, INPUT.sizeof);
                    OS.MoveMemory(var7_11, new int[]{1}, 4);
                    OS.MoveMemory(var7_11 + (long)OS.PTR_SIZEOF, var4_4, KEYBDINPUT.sizeof);
                    var9_14 = OS.SendInput(1, var7_11, INPUT.sizeof) != 0;
                    OS.HeapFree(var5_7, 0, var7_11);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return var9_14;
                }
                case 3: 
                case 4: 
                case 5: 
                case 37: {
                    var4_5 = new MOUSEINPUT();
                    if (var3_3 != 5) ** GOTO lbl78
                    var4_5.dwFlags = 32769;
                    var5_8 = 0;
                    var6_17 = 0;
                    var7_12 = 0;
                    var8_18 = 0;
                    if (OS.WIN32_VERSION >= OS.VERSION(5, 0)) {
                        var4_5.dwFlags |= 16384;
                        var5_8 = OS.GetSystemMetrics(76);
                        var6_17 = OS.GetSystemMetrics(77);
                        var7_12 = OS.GetSystemMetrics(78);
                        var8_18 = OS.GetSystemMetrics(79);
                    } else {
                        var7_12 = OS.GetSystemMetrics(0);
                        var8_18 = OS.GetSystemMetrics(1);
                    }
                    var9_15 = var1_1.getLocationInPixels();
                    var4_5.dx = ((var9_15.x - var5_8) * 65535 + var7_12 - 2) / (var7_12 - 1);
                    var4_5.dy = ((var9_15.y - var6_17) * 65535 + var8_18 - 2) / (var8_18 - 1);
                    ** GOTO lbl123
lbl78:
                    // 1 sources

                    if (var3_3 != 37) ** GOTO lbl96
                    if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    var4_5.dwFlags = 2048;
                    switch (var1_1.detail) {
                        case 2: {
                            var4_5.mouseData = var1_1.count * 120;
                            ** GOTO lbl123
                        }
                        case 1: {
                            var5_9 = new int[1];
                            OS.SystemParametersInfo(104, 0, var5_9, 0);
                            var4_5.mouseData = var1_1.count * 120 / var5_9[0];
                            ** GOTO lbl123
                        }
                        default: {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                    }
lbl96:
                    // 1 sources

                    switch (var1_1.button) {
                        case 1: {
                            var4_5.dwFlags = var3_3 == 3 ? 2 : 4;
                            break;
                        }
                        case 2: {
                            var4_5.dwFlags = var3_3 == 3 ? 32 : 64;
                            break;
                        }
                        case 3: {
                            var4_5.dwFlags = var3_3 == 3 ? 8 : 16;
                            break;
                        }
                        case 4: {
                            if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return false;
                            }
                            var4_5.dwFlags = var3_3 == 3 ? 128 : 256;
                            var4_5.mouseData = 1;
                            break;
                        }
                        case 5: {
                            if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return false;
                            }
                            var4_5.dwFlags = var3_3 == 3 ? 128 : 256;
                            var4_5.mouseData = 2;
                            break;
                        }
                        default: {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                    }
lbl123:
                    // 8 sources

                    var5_10 = OS.GetProcessHeap();
                    var7_13 = OS.HeapAlloc(var5_10, 8, INPUT.sizeof);
                    OS.MoveMemory(var7_13, new int[1], 4);
                    OS.MoveMemory(var7_13 + (long)OS.PTR_SIZEOF, var4_5, MOUSEINPUT.sizeof);
                    var9_16 = OS.SendInput(1, var7_13, INPUT.sizeof) != 0;
                    OS.HeapFree(var5_10, 0, var7_13);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return var9_16;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n = 0;
        int n2 = this.eventQueue.length;
        while (n < n2) {
            if (this.eventQueue[n] == null) break;
            ++n;
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        lpStartupInfo = null;
        this.drawMenuBars();
        this.runSkin();
        this.runDeferredLayouts();
        this.runPopups();
        if (OS.PeekMessage(this.msg, 0L, 0, 0, 1)) {
            if (!this.filterMessage(this.msg)) {
                OS.TranslateMessage(this.msg);
                OS.DispatchMessage(this.msg);
            }
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runMessages && this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] == null) {
                    Display.Displays[n] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        if (this.taskBar != null) {
            this.taskBar.dispose();
        }
        this.taskBar = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            n = 0;
            while (n < this.disposeList.length) {
                if (this.disposeList[n] != null) {
                    this.disposeList[n].run();
                }
                ++n;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        if (this.embeddedHwnd != 0L) {
            OS.PostMessage(this.embeddedHwnd, 32771, 0L, 0L);
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.hButtonTheme != 0L) {
                OS.CloseThemeData(this.hButtonTheme);
            }
            if (this.hEditTheme != 0L) {
                OS.CloseThemeData(this.hEditTheme);
            }
            if (this.hExplorerBarTheme != 0L) {
                OS.CloseThemeData(this.hExplorerBarTheme);
            }
            if (this.hScrollBarTheme != 0L) {
                OS.CloseThemeData(this.hScrollBarTheme);
            }
            if (this.hTabTheme != 0L) {
                OS.CloseThemeData(this.hTabTheme);
            }
            this.hTabTheme = 0L;
            this.hScrollBarTheme = 0L;
            this.hExplorerBarTheme = 0L;
            this.hEditTheme = 0L;
            this.hButtonTheme = 0L;
        }
        if (!OS.IsWinCE) {
            if (this.msgHook != 0L) {
                OS.UnhookWindowsHookEx(this.msgHook);
            }
            this.msgHook = 0L;
        }
        if (!OS.IsWinCE) {
            if (this.filterHook != 0L) {
                OS.UnhookWindowsHookEx(this.filterHook);
            }
            this.filterHook = 0L;
            this.msgFilterCallback.dispose();
            this.msgFilterCallback = null;
            this.msgFilterProc = 0L;
        }
        if (!OS.IsWinCE) {
            if (this.idleHook != 0L) {
                OS.UnhookWindowsHookEx(this.idleHook);
            }
            this.idleHook = 0L;
            this.foregroundIdleCallback.dispose();
            this.foregroundIdleCallback = null;
            this.foregroundIdleProc = 0L;
        }
        OS.KillTimer(this.hwndMessage, 100L);
        if (this.hwndMessage != 0L) {
            OS.DestroyWindow(this.hwndMessage);
        }
        this.hwndMessage = 0L;
        this.messageCallback.dispose();
        this.messageCallback = null;
        this.messageProc = 0L;
        long l = OS.GetProcessHeap();
        long l2 = OS.GetModuleHandle(null);
        OS.UnregisterClass(this.windowClass, l2);
        OS.UnregisterClass(this.windowShadowClass, l2);
        OS.UnregisterClass(this.windowOwnDCClass, l2);
        this.windowOwnDCClass = null;
        this.windowShadowClass = null;
        this.windowClass = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.windowProc = 0L;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        this.lfSystemFont = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningIcon != null) {
            this.warningIcon.dispose();
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        if (this.upArrow != null) {
            this.upArrow.dispose();
        }
        if (this.downArrow != null) {
            this.downArrow.dispose();
        }
        this.downArrow = null;
        this.upArrow = null;
        int n = 0;
        while (n < this.cursors.length) {
            if (this.cursors[n] != null) {
                this.cursors[n].dispose();
            }
            ++n;
        }
        this.cursors = null;
        if (this.resources != null) {
            n = 0;
            while (n < this.resources.length) {
                if (this.resources[n] != null) {
                    this.resources[n].dispose();
                }
                ++n;
            }
            this.resources = null;
        }
        if (this.lpCustColors != 0L) {
            OS.HeapFree(l, 0, this.lpCustColors);
        }
        this.lpCustColors = 0L;
        if (!OS.IsWinCE) {
            OS.OleUninitialize();
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.BufferedPaintUnInit();
        }
        this.thread = null;
        this.hookMsg = null;
        this.msg = null;
        this.keyboard = null;
        this.modalDialog = null;
        this.modalShells = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.popups = null;
        this.bars = null;
        this.indexTable = null;
        this.timerIds = null;
        this.controlTable = null;
        this.lastHittestControl = null;
        this.lastGetControl = null;
        this.lastControl = null;
        this.toolDisabledImageList = null;
        this.toolHotImageList = null;
        this.toolImageList = null;
        this.imageList = null;
        this.timerList = null;
        this.tableBuffer = null;
        this.columnVisible = null;
        this.filterTable = null;
        this.eventTable = null;
        this.items = null;
        this.clickRect = null;
        this.hdr = null;
        this.plvfi = null;
        this.monitors = null;
        this.touchSources = null;
        this.threadId = 0;
    }

    void releaseImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.imageList.length;
        while (n < n2) {
            if (this.imageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.imageList, n + 1, this.imageList, n, --n2 - n);
                this.imageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.imageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.imageList = null;
                return;
            }
            ++n;
        }
    }

    void releaseToolImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.toolImageList.length;
        while (n < n2) {
            if (this.toolImageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolImageList, n + 1, this.toolImageList, n, --n2 - n);
                this.toolImageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.toolImageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.toolImageList = null;
                return;
            }
            ++n;
        }
    }

    void releaseToolHotImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.toolHotImageList.length;
        while (n < n2) {
            if (this.toolHotImageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolHotImageList, n + 1, this.toolHotImageList, n, --n2 - n);
                this.toolHotImageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.toolHotImageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.toolHotImageList = null;
                return;
            }
            ++n;
        }
    }

    void releaseToolDisabledImageList(ImageList imageList) {
        int n = 0;
        int n2 = this.toolDisabledImageList.length;
        while (n < n2) {
            if (this.toolDisabledImageList[n] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolDisabledImageList, n + 1, this.toolDisabledImageList, n, --n2 - n);
                this.toolDisabledImageList[n2] = null;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.toolDisabledImageList[n3] != null) {
                        return;
                    }
                    ++n3;
                }
                this.toolDisabledImageList = null;
                return;
            }
            ++n;
        }
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    void removeBar(Menu menu) {
        if (this.bars == null) {
            return;
        }
        int n = 0;
        while (n < this.bars.length) {
            if (this.bars[n] == menu) {
                this.bars[n] = null;
                return;
            }
            ++n;
        }
    }

    Control removeControl(long l) {
        int n;
        if (l == 0L) {
            return null;
        }
        this.lastGetControl = null;
        this.lastControl = null;
        Control control = null;
        if (USE_PROPERTY) {
            n = (int)OS.RemoveProp(l, SWT_OBJECT_INDEX) - 1;
        } else {
            n = (int)OS.GetWindowLongPtr(l, -21) - 1;
            OS.SetWindowLongPtr(l, -21, 0L);
        }
        if (n >= 0 && n < this.controlTable.length) {
            control = this.controlTable[n];
            this.controlTable[n] = null;
            this.indexTable[n] = this.freeSlot;
            this.freeSlot = n;
        }
        return control;
    }

    void removeMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            return;
        }
        this.items[menuItem.id - 108] = null;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int n = 0;
        while (n < this.popups.length) {
            if (this.popups[n] == menu) {
                this.popups[n] = null;
                return;
            }
            ++n;
        }
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        boolean bl = false;
        while (this.eventQueue != null) {
            Widget widget;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl = true;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return bl;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int n2 = 0;
            while (n2 < n) {
                Composite composite = compositeArray[n2];
                if (!composite.isDisposed()) {
                    composite.setLayoutDeferred(false);
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    void runSettings() {
        Font font = this.getSystemFont();
        this.saveResources();
        this.updateImages();
        this.sendEvent(39, null);
        Font font2 = this.getSystemFont();
        boolean bl = font.equals(font2);
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                if (!bl) {
                    shell.updateFont(font, font2);
                }
                shell.layout(true, true);
            }
            ++n;
        }
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int n2 = 0;
                while (n2 < n) {
                    Widget widget = widgetArray[n2];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFFDFFFFF;
                        widgetArray[n2] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    boolean runTimer(long l) {
        if (this.timerList != null && this.timerIds != null) {
            int n = 0;
            while (n < this.timerIds.length) {
                if (this.timerIds[n] == l) {
                    OS.KillTimer(this.hwndMessage, this.timerIds[n]);
                    this.timerIds[n] = 0L;
                    Runnable runnable = this.timerList[n];
                    this.timerList[n] = null;
                    if (runnable != null) {
                        runnable.run();
                    }
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    void saveResources() {
        Object object;
        int n = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            n = this.resources.length;
            object = new Resource[n + 27];
            System.arraycopy(this.resources, 0, object, 0, n);
            this.resources = object;
        }
        if (this.systemFont != null && !OS.IsWinCE) {
            object = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            object.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, (NONCLIENTMETRICS)object, 0)) {
                LOGFONT lOGFONT;
                LOGFONT lOGFONT2 = lOGFONT = OS.IsUnicode ? ((NONCLIENTMETRICSW)object).lfMessageFont : ((NONCLIENTMETRICSA)object).lfMessageFont;
                if (this.lfSystemFont == null || lOGFONT.lfCharSet != this.lfSystemFont.lfCharSet || lOGFONT.lfHeight != this.lfSystemFont.lfHeight || lOGFONT.lfWidth != this.lfSystemFont.lfWidth || lOGFONT.lfEscapement != this.lfSystemFont.lfEscapement || lOGFONT.lfOrientation != this.lfSystemFont.lfOrientation || lOGFONT.lfWeight != this.lfSystemFont.lfWeight || lOGFONT.lfItalic != this.lfSystemFont.lfItalic || lOGFONT.lfUnderline != this.lfSystemFont.lfUnderline || lOGFONT.lfStrikeOut != this.lfSystemFont.lfStrikeOut || lOGFONT.lfCharSet != this.lfSystemFont.lfCharSet || lOGFONT.lfOutPrecision != this.lfSystemFont.lfOutPrecision || lOGFONT.lfClipPrecision != this.lfSystemFont.lfClipPrecision || lOGFONT.lfQuality != this.lfSystemFont.lfQuality || lOGFONT.lfPitchAndFamily != this.lfSystemFont.lfPitchAndFamily || !this.getFontName(lOGFONT).equals(this.getFontName(this.lfSystemFont))) {
                    this.resources[n++] = this.systemFont;
                    this.lfSystemFont = lOGFONT;
                    this.systemFont = null;
                }
            }
        }
        if (this.errorImage != null) {
            this.resources[n++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[n++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[n++] = this.questionImage;
        }
        if (this.warningIcon != null) {
            this.resources[n++] = this.warningIcon;
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        int n2 = 0;
        while (n2 < this.cursors.length) {
            if (this.cursors[n2] != null) {
                this.resources[n++] = this.cursors[n2];
            }
            this.cursors[n2] = null;
            ++n2;
        }
        if (n < 27) {
            Resource[] resourceArray = new Resource[n];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(EventTable eventTable, Event event) {
        int n = event.type;
        this.sendPreEvent(n);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(n);
        }
    }

    void sendPreEvent(int n) {
        if (n != 50 && n != 51 && n != 52 && n != 53 && this.eventTable != null && this.eventTable.hooks(50)) {
            Event event = new Event();
            event.detail = n;
            this.sendEvent(50, event);
        }
    }

    void sendPostEvent(int n) {
        if (n != 50 && n != 51 && n != 52 && n != 53 && this.eventTable != null && this.eventTable.hooks(51)) {
            Event event = new Event();
            event.detail = n;
            this.sendEvent(51, event);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(52)) {
            this.sendEvent(52, null);
        }
    }

    public void sendPostExternalEventDispatchEvent() {
        if (this.eventTable != null && this.eventTable.hooks(53)) {
            this.sendEvent(53, null);
        }
    }

    public void setCursorLocation(int n, int n2) {
        this.checkDevice();
        this.setCursorLocationInPixels(DPIUtil.autoScaleUp(n), DPIUtil.autoScaleUp(n2));
    }

    void setCursorLocationInPixels(int n, int n2) {
        OS.SetCursorPos(n, n2);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(RUN_MESSAGES_IN_IDLE_KEY)) {
            Boolean bl = (Boolean)object;
            this.runMessagesInIdle = bl != null && bl != false;
            return;
        }
        if (string.equals(RUN_MESSAGES_IN_MESSAGE_PROC_KEY)) {
            Boolean bl = (Boolean)object;
            this.runMessagesInMessageProc = bl != null && bl != false;
            return;
        }
        if (string.equals(USE_OWNDC_KEY)) {
            Boolean bl = (Boolean)object;
            this.useOwnDC = bl != null && bl != false;
            return;
        }
        if (string.equals(ACCEL_KEY_HIT)) {
            Boolean bl = (Boolean)object;
            this.accelKeyHit = bl != null && bl != false;
            return;
        }
        if (object == null) {
            if (this.keys == null) {
                return;
            }
            int n = 0;
            while (n < this.keys.length && !this.keys[n].equals(string)) {
                ++n;
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                this.values[n] = object;
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].updateModal();
            ++n;
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
            ++n;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.moveAllEventsTo(synchronizer);
            }
            return;
        }
    }

    int shiftedKey(int n) {
        if (OS.IsWinCE) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.keyboard.length) {
            this.keyboard[n2] = 0;
            ++n2;
        }
        this.keyboard[16] = (byte)(this.keyboard[16] | 0x80);
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n, n, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n, n, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.runMessages && this.getMessageCount() != 0) {
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        if (OS.IsWinCE) {
            OS.MsgWaitForMultipleObjectsEx(0, 0L, -1, 127, 4);
            this.sendPostExternalEventDispatchEvent();
            return true;
        }
        boolean bl = OS.WaitMessage();
        this.sendPostExternalEventDispatchEvent();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public void timerExec(int n, Runnable runnable) {
        long l;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new long[4];
        }
        int n2 = 0;
        while (n2 < this.timerList.length) {
            if (this.timerList[n2] == runnable) break;
            ++n2;
        }
        long l2 = 0L;
        if (n2 != this.timerList.length) {
            l2 = this.timerIds[n2];
            if (n < 0) {
                OS.KillTimer(this.hwndMessage, l2);
                this.timerList[n2] = null;
                this.timerIds[n2] = 0L;
                return;
            }
        } else {
            if (n < 0) {
                return;
            }
            n2 = 0;
            while (n2 < this.timerList.length) {
                if (this.timerList[n2] == null) break;
                ++n2;
            }
            l2 = this.nextTimerId++;
            if (n2 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                long[] lArray = new long[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, lArray, 0, this.timerIds.length);
                this.timerIds = lArray;
            }
        }
        if ((l = OS.SetTimer(this.hwndMessage, l2, n, 0L)) != 0L) {
            this.timerList[n2] = runnable;
            this.timerIds[n2] = l;
        }
    }

    boolean translateAccelerator(MSG mSG, Control control) {
        this.accelKeyHit = true;
        boolean bl = control.translateAccelerator(mSG);
        this.accelKeyHit = false;
        return bl;
    }

    static int translateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][0] == n) {
                return KeyTable[n2][1];
            }
            ++n2;
        }
        return 0;
    }

    boolean translateMnemonic(MSG mSG, Control control) {
        switch (mSG.message) {
            case 258: 
            case 262: {
                return control.translateMnemonic(mSG);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG mSG, Control control) {
        switch (mSG.message) {
            case 256: {
                switch ((int)mSG.wParam) {
                    case 9: 
                    case 13: 
                    case 27: 
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        return control.translateTraversal(mSG);
                    }
                }
                break;
            }
            case 260: {
                switch ((int)mSG.wParam) {
                    case 18: {
                        return control.translateTraversal(mSG);
                    }
                }
            }
        }
        return false;
    }

    static int untranslateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][1] == n) {
                return KeyTable[n2][0];
            }
            ++n2;
        }
        return 0;
    }

    public void update() {
        int n;
        Object object;
        this.checkDevice();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && OS.IsHungAppWindow(this.hwndMessage)) {
            object = new MSG();
            n = 3;
            OS.PeekMessage((MSG)object, this.hwndMessage, 32773, 32773, n);
        }
        object = this.getShells();
        n = 0;
        while (n < ((Shell[])object).length) {
            Shell shell = object[n];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++n;
        }
    }

    void updateImages() {
        if (this.upArrow != null) {
            this.upArrow.dispose();
        }
        if (this.downArrow != null) {
            this.downArrow.dispose();
        }
        this.downArrow = null;
        this.upArrow = null;
        int n = 0;
        while (n < this.controlTable.length) {
            Control control = this.controlTable[n];
            if (control != null) {
                control.updateImages();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        if (OS.IsWinCE) {
            OS.PostMessage(this.hwndMessage, 0, 0L, 0L);
        } else {
            OS.PostThreadMessage(this.threadId, 0, 0L, 0L);
        }
    }

    static int wcsToMbcs(char c, int n) {
        if (OS.IsUnicode) {
            return c;
        }
        if (c <= '\u007f') {
            return c;
        }
        TCHAR tCHAR = new TCHAR(n, c, false);
        return tCHAR.tcharAt(0);
    }

    static int wcsToMbcs(char c) {
        return Display.wcsToMbcs(c, 0);
    }

    long windowProc(long l, long l2, long l3, long l4) {
        Control control;
        if (this.columnVisible != null && l2 == 78L && this.hwndParent == l) {
            OS.MoveMemory(this.hdr, l4, NMHDR.sizeof);
            switch (this.hdr.code) {
                case -177: 
                case -150: {
                    OS.MoveMemory(this.plvfi, l4, NMLVDISPINFO.sizeof);
                    if (this.plvfi.iSubItem < 0 || this.plvfi.iSubItem >= this.columnCount || this.columnVisible[this.plvfi.iSubItem]) break;
                    return 0L;
                }
            }
        }
        if ((int)l2 == TASKBARBUTTONCREATED && this.taskBar != null) {
            TaskItem[] taskItemArray = this.taskBar.items;
            int n = 0;
            while (n < taskItemArray.length) {
                TaskItem taskItem = taskItemArray[n];
                if (taskItem != null && taskItem.shell != null && taskItem.shell.handle == l) {
                    taskItem.recreate();
                    break;
                }
                ++n;
            }
        }
        if ((int)l2 == 132) {
            if (this.hitCount++ >= 1024) {
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable throwable) {}
            }
        } else {
            this.hitCount = 0;
        }
        if (this.lastControl != null && this.lastHwnd == l) {
            return this.lastControl.windowProc(l, (int)l2, l3, l4);
        }
        int n = USE_PROPERTY ? (int)OS.GetProp(l, SWT_OBJECT_INDEX) - 1 : (int)OS.GetWindowLongPtr(l, -21) - 1;
        if (n >= 0 && n < this.controlTable.length && (control = this.controlTable[n]) != null) {
            this.lastHwnd = l;
            this.lastControl = control;
            return control.windowProc(l, (int)l2, l3, l4);
        }
        return OS.DefWindowProc(l, (int)l2, l3, l4);
    }

    int textWidth(String string, long l) {
        long l2 = 0L;
        RECT rECT = new RECT();
        long l3 = OS.GetDC(l);
        long l4 = OS.SendMessage(l, 49, 0L, 0L);
        if (l4 != 0L) {
            l2 = OS.SelectObject(l3, l4);
        }
        int n = 3104;
        TCHAR tCHAR = new TCHAR(0, string, false);
        OS.DrawText(l3, tCHAR, tCHAR.length(), rECT, n);
        if (l4 != 0L) {
            OS.SelectObject(l3, l2);
        }
        OS.ReleaseDC(l, l3);
        return rECT.right - rECT.left;
    }

    String wrapText(String string, long l, int n) {
        String string2 = "\r\n";
        string = Display.withCrLf(string);
        int n2 = string.length();
        if (n <= 0 || n2 == 0 || n2 == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            boolean bl;
            n4 = string.indexOf(string2, n3);
            boolean bl2 = bl = n4 == -1;
            if (bl) {
                n4 = n2;
            }
            int n5 = n4 + string2.length();
            while (n4 > n3 + 1 && Character.isWhitespace(string.charAt(n4 - 1))) {
                --n4;
            }
            int n6 = n3;
            int n7 = n3;
            int n8 = n3;
            while (n8 < n4) {
                int n9 = n6;
                int n10 = n7;
                n6 = n8;
                while (n8 < n4 && !Character.isWhitespace(string.charAt(n8))) {
                    ++n8;
                }
                n7 = n8 - 1;
                String string3 = string.substring(n3, n7 + 1);
                int n11 = this.textWidth(string3, l);
                while (n8 < n4 && Character.isWhitespace(string.charAt(n8))) {
                    ++n8;
                }
                if (n11 <= n) continue;
                if (n9 == n6) {
                    while (n6 < n7) {
                        string3 = string.substring(n3, n6 + 1);
                        n11 = this.textWidth(string3, l);
                        if (n11 >= n) break;
                        ++n6;
                    }
                    if (n6 == n9) {
                        ++n6;
                    }
                    n10 = n6 - 1;
                }
                string3 = string.substring(n3, n10 + 1);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                n8 = n6;
                n3 = n6;
                n7 = n6;
            }
            if (n3 < n4) {
                stringBuffer.append(string.substring(n3, n4));
            }
            if (!bl) {
                stringBuffer.append(string2);
            }
            n3 = n5;
        }
        return stringBuffer.toString();
    }

    static String withCrLf(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(10, 0);
        if (n2 == -1) {
            return string;
        }
        if (n2 > 0 && string.charAt(n2 - 1) == '\r') {
            return string;
        }
        ++n2;
        int n3 = 1;
        while (n2 < n) {
            if ((n2 = string.indexOf(10, n2)) == -1) break;
            ++n3;
            ++n2;
        }
        n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n3 += n);
        while (n2 < n) {
            int n4 = string.indexOf(10, n2);
            if (n4 == -1) {
                n4 = n;
            }
            stringBuffer.append(string.substring(n2, n4));
            n2 = n4;
            if (n2 >= n) continue;
            stringBuffer.append("\r\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    static char[] withCrLf(char[] cArray) {
        int n = cArray.length;
        if (n == 0) {
            return cArray;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] == '\n' && ++n2 == 1 && n3 > 0 && cArray[n3 - 1] == '\r') {
                return cArray;
            }
            ++n3;
        }
        if (n2 == 0) {
            return cArray;
        }
        char[] cArray2 = new char[n2 += n];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n && n5 < n2) {
            if (cArray[n4] == '\n') {
                cArray2[n5++] = 13;
            }
            cArray2[n5++] = cArray[n4];
            ++n4;
        }
        return cArray2;
    }
}

