/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.CHOOSECOLOR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    static final int CUSTOM_COLOR_COUNT = 16;
    Display display;
    int width;
    int height;
    RGB rgb;
    RGB[] rgbs;
    int[] colors = new int[16];

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    long CCHookProc(long l, long l2, long l3, long l4) {
        switch ((int)l2) {
            case 272: {
                RECT rECT = new RECT();
                OS.GetWindowRect(l, rECT);
                this.width = rECT.right - rECT.left;
                this.height = rECT.bottom - rECT.top;
                if (this.title == null || this.title.length() == 0) break;
                TCHAR tCHAR = new TCHAR(0, this.title, true);
                OS.SetWindowText(l, tCHAR);
                break;
            }
            case 2: {
                RECT rECT = new RECT();
                OS.GetWindowRect(l, rECT);
                int n = rECT.right - rECT.left;
                int n2 = rECT.bottom - rECT.top;
                if (n >= this.width && n2 >= this.height && n > this.width) break;
            }
        }
        return 0L;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Callback callback;
        long l;
        int n6;
        int n7;
        long l2 = this.parent.handle;
        long l3 = this.parent.handle;
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (n7 = this.style & 0x6000000) != (n6 = this.parent.style & 0x6000000)) {
            int n8 = 0x100000;
            if (n7 == 0x4000000) {
                n8 |= 0x400000;
            }
            l2 = OS.CreateWindowEx(n8, Shell.DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, l3, 0L, OS.GetModuleHandle(null), null);
            bl = OS.IsWindowEnabled(l3);
            if (bl) {
                OS.EnableWindow(l3, false);
            }
        }
        if ((l = (callback = new Callback(this, "CCHookProc", 4)).getAddress()) == 0L) {
            this.error(3);
        }
        this.display = this.parent.display;
        if (this.display.lpCustColors == 0L) {
            long l4 = OS.GetProcessHeap();
            this.display.lpCustColors = OS.HeapAlloc(l4, 8, 64);
            int n9 = 0;
            while (n9 < 16) {
                this.colors[n9] = 0xFFFFFF;
                ++n9;
            }
            OS.MoveMemory(this.display.lpCustColors, this.colors, 64);
        }
        if (this.rgbs != null) {
            int n10 = this.rgbs.length > 16 ? 16 : this.rgbs.length;
            n5 = 0;
            while (n5 < n10) {
                RGB rGB = this.rgbs[n5];
                n4 = rGB.red & 0xFF;
                n3 = rGB.green << 8 & 0xFF00;
                n2 = rGB.blue << 16 & 0xFF0000;
                this.colors[n5] = n4 | n3 | n2;
                ++n5;
            }
            n5 = n10;
            while (n5 < 16) {
                this.colors[n5] = 0xFFFFFF;
                ++n5;
            }
            OS.MoveMemory(this.display.lpCustColors, this.colors, 64);
        }
        CHOOSECOLOR cHOOSECOLOR = new CHOOSECOLOR();
        cHOOSECOLOR.lStructSize = CHOOSECOLOR.sizeof;
        cHOOSECOLOR.Flags = 272;
        cHOOSECOLOR.lpfnHook = l;
        cHOOSECOLOR.hwndOwner = l2;
        cHOOSECOLOR.lpCustColors = this.display.lpCustColors;
        if (this.rgb != null) {
            cHOOSECOLOR.Flags |= 1;
            n5 = this.rgb.red & 0xFF;
            int n11 = this.rgb.green << 8 & 0xFF00;
            n4 = this.rgb.blue << 16 & 0xFF0000;
            cHOOSECOLOR.rgbResult = n5 | n11 | n4;
        }
        Dialog dialog = null;
        if ((this.style & 0x30000) != 0) {
            dialog = this.display.getModalDialog();
            this.display.setModalDialog(this);
        }
        this.display.sendPreExternalEventDispatchEvent();
        boolean bl2 = OS.ChooseColor(cHOOSECOLOR);
        this.display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x30000) != 0) {
            this.display.setModalDialog(dialog);
        }
        n4 = 0;
        OS.MoveMemory(this.colors, this.display.lpCustColors, this.colors.length * 4);
        n3 = 0;
        while (n3 < this.colors.length) {
            if (this.colors[n3] != 0xFFFFFF) {
                n4 = 1;
                break;
            }
            ++n3;
        }
        if (n4 != 0) {
            this.rgbs = new RGB[16];
            n3 = 0;
            while (n3 < this.colors.length) {
                n2 = this.colors[n3];
                n = n2 & 0xFF;
                int n12 = n2 >> 8 & 0xFF;
                int n13 = n2 >> 16 & 0xFF;
                this.rgbs[n3] = new RGB(n, n12, n13);
                ++n3;
            }
        }
        if (bl2) {
            n3 = cHOOSECOLOR.rgbResult & 0xFF;
            n2 = cHOOSECOLOR.rgbResult >> 8 & 0xFF;
            n = cHOOSECOLOR.rgbResult >> 16 & 0xFF;
            this.rgb = new RGB(n3, n2, n);
        }
        callback.dispose();
        if (l3 != l2) {
            if (bl) {
                OS.EnableWindow(l3, true);
            }
            OS.SetActiveWindow(l3);
            OS.DestroyWindow(l2);
        }
        this.display = null;
        if (!bl2) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        if (rGBArray != null) {
            int n = 0;
            while (n < rGBArray.length) {
                if (rGBArray[n] == null) {
                    this.error(5);
                }
                ++n;
            }
        }
        this.rgbs = rGBArray;
    }
}

