/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class GridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public GridLayout() {
    }

    public GridLayout(int n, boolean bl) {
        this.numColumns = n;
        this.makeColumnsEqualWidth = bl;
    }

    @Override
    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Point point = this.layout(composite, false, 0, 0, n, n2, bl);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((GridData)object).flushCache();
        }
        return true;
    }

    GridData getData(Control[][] controlArray, int n, int n2, int n3, int n4, boolean bl) {
        Control control = controlArray[n][n2];
        if (control != null) {
            int n5;
            GridData gridData = (GridData)control.getLayoutData();
            int n6 = Math.max(1, Math.min(gridData.horizontalSpan, n4));
            int n7 = Math.max(1, gridData.verticalSpan);
            int n8 = bl ? n + n7 - 1 : n - n7 + 1;
            int n9 = n5 = bl ? n2 + n6 - 1 : n2 - n6 + 1;
            if (n8 >= 0 && n8 < n3 && n5 >= 0 && n5 < n4 && control == controlArray[n8][n5]) {
                return gridData;
            }
        }
        return null;
    }

    @Override
    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        this.layout(composite, true, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    Point layout(Composite composite, boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        Object object;
        Control[][] controlArray;
        int n22;
        GridData gridData;
        Control control;
        if (this.numColumns < 1) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        Control[] controlArray2 = composite.getChildren();
        int n23 = 0;
        int n24 = 0;
        while (n24 < controlArray2.length) {
            control = controlArray2[n24];
            gridData = (GridData)control.getLayoutData();
            if (gridData == null || !gridData.exclude) {
                controlArray2[n23++] = controlArray2[n24];
            }
            ++n24;
        }
        if (n23 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        n24 = 0;
        while (n24 < n23) {
            control = controlArray2[n24];
            gridData = (GridData)control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData();
                control.setLayoutData(gridData);
            }
            if (bl2) {
                gridData.flushCache();
            }
            gridData.computeSize(control, gridData.widthHint, gridData.heightHint, bl2);
            if (gridData.grabExcessHorizontalSpace && gridData.minimumWidth > 0 && gridData.cacheWidth < gridData.minimumWidth) {
                n22 = 0;
                if (control instanceof Scrollable) {
                    controlArray = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                    n22 = controlArray.width;
                } else {
                    n22 = control.getBorderWidth() * 2;
                }
                gridData.cacheHeight = -1;
                gridData.cacheWidth = -1;
                gridData.computeSize(control, Math.max(0, gridData.minimumWidth - n22), gridData.heightHint, false);
            }
            if (gridData.grabExcessVerticalSpace && gridData.minimumHeight > 0) {
                gridData.cacheHeight = Math.max(gridData.cacheHeight, gridData.minimumHeight);
            }
            ++n24;
        }
        n24 = 0;
        int n25 = 0;
        int n26 = 0;
        n22 = this.numColumns;
        controlArray = new Control[4][n22];
        int n27 = 0;
        while (n27 < n23) {
            Control control2 = controlArray2[n27];
            object = (GridData)control2.getLayoutData();
            int n28 = Math.max(1, Math.min(((GridData)object).horizontalSpan, n22));
            int n29 = Math.max(1, ((GridData)object).verticalSpan);
            while (true) {
                if ((n21 = n24 + n29) >= controlArray.length) {
                    Control[][] controlArray3 = new Control[n21 + 4][n22];
                    System.arraycopy(controlArray, 0, controlArray3, 0, controlArray.length);
                    controlArray = controlArray3;
                }
                if (controlArray[n24] == null) {
                    controlArray[n24] = new Control[n22];
                }
                while (n25 < n22 && controlArray[n24][n25] != null) {
                    ++n25;
                }
                n20 = n25 + n28;
                if (n20 <= n22) {
                    int n30 = n25;
                    while (n30 < n20 && controlArray[n24][n30] == null) {
                        ++n30;
                    }
                    if (n30 == n20) break;
                    n25 = n30;
                }
                if (n25 + n28 < n22) continue;
                n25 = 0;
                ++n24;
            }
            n21 = 0;
            while (n21 < n29) {
                if (controlArray[n24 + n21] == null) {
                    controlArray[n24 + n21] = new Control[n22];
                }
                n20 = 0;
                while (n20 < n28) {
                    controlArray[n24 + n21][n25 + n20] = control2;
                    ++n20;
                }
                ++n21;
            }
            n26 = Math.max(n26, n24 + n29);
            n25 += n28;
            ++n27;
        }
        n27 = n3 - this.horizontalSpacing * (n22 - 1) - (this.marginLeft + this.marginWidth * 2 + this.marginRight);
        int n31 = 0;
        object = new int[n22];
        int[] nArray = new int[n22];
        boolean[] blArray = new boolean[n22];
        n21 = 0;
        while (n21 < n22) {
            n20 = 0;
            while (n20 < n26) {
                GridData gridData2 = this.getData(controlArray, n20, n21, n26, n22, true);
                if (gridData2 != null && (n19 = Math.max(1, Math.min(gridData2.horizontalSpan, n22))) == 1) {
                    n18 = gridData2.cacheWidth + gridData2.horizontalIndent;
                    object[n21] = Math.max((int)object[n21], n18);
                    if (gridData2.grabExcessHorizontalSpace) {
                        if (!blArray[n21]) {
                            ++n31;
                        }
                        blArray[n21] = true;
                    }
                    if (!gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth != 0) {
                        n18 = !gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth == -1 ? gridData2.cacheWidth : gridData2.minimumWidth;
                        nArray[n21] = Math.max(nArray[n21], n18 += gridData2.horizontalIndent);
                    }
                }
                ++n20;
            }
            n20 = 0;
            while (n20 < n26) {
                GridData gridData3 = this.getData(controlArray, n20, n21, n26, n22, false);
                if (gridData3 != null && (n19 = Math.max(1, Math.min(gridData3.horizontalSpan, n22))) > 1) {
                    n18 = 0;
                    n17 = 0;
                    n16 = 0;
                    int n32 = 0;
                    while (n32 < n19) {
                        n18 += object[n21 - n32];
                        n17 += nArray[n21 - n32];
                        if (blArray[n21 - n32]) {
                            ++n16;
                        }
                        ++n32;
                    }
                    if (gridData3.grabExcessHorizontalSpace && n16 == 0) {
                        ++n31;
                        blArray[n21] = true;
                    }
                    if ((n32 = gridData3.cacheWidth + gridData3.horizontalIndent - n18 - (n19 - 1) * this.horizontalSpacing) > 0) {
                        if (this.makeColumnsEqualWidth) {
                            n15 = (n32 + n18) / n19;
                            n14 = (n32 + n18) % n19;
                            n13 = -1;
                            n12 = 0;
                            while (n12 < n19) {
                                n13 = n21 - n12;
                                object[n13] = Math.max(n15, (int)object[n21 - n12]);
                                ++n12;
                            }
                            if (n13 > -1) {
                                Object object2 = object;
                                int n33 = n13;
                                object2[n33] = object2[n33] + n14;
                            }
                        } else if (n16 == 0) {
                            Object object3 = object;
                            int n34 = n21;
                            object3[n34] = object3[n34] + n32;
                        } else {
                            n15 = n32 / n16;
                            n14 = n32 % n16;
                            n13 = -1;
                            n12 = 0;
                            while (n12 < n19) {
                                if (blArray[n21 - n12]) {
                                    Object object4 = object;
                                    n13 = n21 - n12;
                                    object4[n13] = object4[n13] + n15;
                                }
                                ++n12;
                            }
                            if (n13 > -1) {
                                Object object5 = object;
                                int n35 = n13;
                                object5[n35] = object5[n35] + n14;
                            }
                        }
                    }
                    if (!gridData3.grabExcessHorizontalSpace || gridData3.minimumWidth != 0) {
                        int n36 = n32 = !gridData3.grabExcessHorizontalSpace || gridData3.minimumWidth == -1 ? gridData3.cacheWidth : gridData3.minimumWidth;
                        if ((n32 += gridData3.horizontalIndent - n17 - (n19 - 1) * this.horizontalSpacing) > 0) {
                            if (n16 == 0) {
                                int n37 = n21;
                                nArray[n37] = nArray[n37] + n32;
                            } else {
                                n15 = n32 / n16;
                                n14 = n32 % n16;
                                n13 = -1;
                                n12 = 0;
                                while (n12 < n19) {
                                    if (blArray[n21 - n12]) {
                                        n13 = n21 - n12;
                                        nArray[n13] = nArray[n13] + n15;
                                    }
                                    ++n12;
                                }
                                if (n13 > -1) {
                                    int n38 = n13;
                                    nArray[n38] = nArray[n38] + n14;
                                }
                            }
                        }
                    }
                }
                ++n20;
            }
            ++n21;
        }
        if (this.makeColumnsEqualWidth) {
            n21 = 0;
            n20 = 0;
            int n39 = 0;
            while (n39 < n22) {
                n21 = Math.max(n21, nArray[n39]);
                n20 = Math.max(n20, (int)object[n39]);
                ++n39;
            }
            n20 = n3 == -1 || n31 == 0 ? n20 : Math.max(n21, n27 / n22);
            n39 = 0;
            while (n39 < n22) {
                blArray[n39] = n31 > 0;
                object[n39] = n20;
                ++n39;
            }
        } else if (n3 != -1 && n31 > 0) {
            n21 = 0;
            n20 = 0;
            while (n20 < n22) {
                n21 += object[n20];
                ++n20;
            }
            n20 = n31;
            int n40 = (n27 - n21) / n20;
            n19 = (n27 - n21) % n20;
            n18 = -1;
            while (n21 != n27) {
                n17 = 0;
                while (n17 < n22) {
                    if (blArray[n17]) {
                        if (object[n17] + n40 > nArray[n17]) {
                            n18 = n17;
                            object[n18] = object[n17] + n40;
                        } else {
                            object[n17] = nArray[n17];
                            blArray[n17] = false;
                            --n20;
                        }
                    }
                    ++n17;
                }
                if (n18 > -1) {
                    Object object6 = object;
                    int n41 = n18;
                    object6[n41] = object6[n41] + n19;
                }
                n17 = 0;
                while (n17 < n22) {
                    n16 = 0;
                    while (n16 < n26) {
                        GridData gridData4 = this.getData(controlArray, n16, n17, n26, n22, false);
                        if (!(gridData4 == null || (n15 = Math.max(1, Math.min(gridData4.horizontalSpan, n22))) <= 1 || gridData4.grabExcessHorizontalSpace && gridData4.minimumWidth == 0)) {
                            n14 = 0;
                            n13 = 0;
                            n12 = 0;
                            while (n12 < n15) {
                                n14 += object[n17 - n12];
                                if (blArray[n17 - n12]) {
                                    ++n13;
                                }
                                ++n12;
                            }
                            int n42 = n12 = !gridData4.grabExcessHorizontalSpace || gridData4.minimumWidth == -1 ? gridData4.cacheWidth : gridData4.minimumWidth;
                            if ((n12 += gridData4.horizontalIndent - n14 - (n15 - 1) * this.horizontalSpacing) > 0) {
                                if (n13 == 0) {
                                    Object object7 = object;
                                    int n43 = n17;
                                    object7[n43] = object7[n43] + n12;
                                } else {
                                    n11 = n12 / n13;
                                    n10 = n12 % n13;
                                    n9 = -1;
                                    n8 = 0;
                                    while (n8 < n15) {
                                        if (blArray[n17 - n8]) {
                                            Object object8 = object;
                                            n9 = n17 - n8;
                                            object8[n9] = object8[n9] + n11;
                                        }
                                        ++n8;
                                    }
                                    if (n9 > -1) {
                                        Object object9 = object;
                                        int n44 = n9;
                                        object9[n44] = object9[n44] + n10;
                                    }
                                }
                            }
                        }
                        ++n16;
                    }
                    ++n17;
                }
                if (n20 != 0) {
                    n21 = 0;
                    n17 = 0;
                    while (n17 < n22) {
                        n21 += object[n17];
                        ++n17;
                    }
                    n40 = (n27 - n21) / n20;
                    n19 = (n27 - n21) % n20;
                    n18 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] gridDataArray = null;
        n20 = 0;
        if (n3 != -1) {
            int n45 = 0;
            while (n45 < n22) {
                n19 = 0;
                while (n19 < n26) {
                    GridData gridData5 = this.getData(controlArray, n19, n45, n26, n22, false);
                    if (gridData5 != null && gridData5.heightHint == -1) {
                        Control control3 = controlArray[n19][n45];
                        n16 = Math.max(1, Math.min(gridData5.horizontalSpan, n22));
                        int n46 = 0;
                        n15 = 0;
                        while (n15 < n16) {
                            n46 += object[n45 - n15];
                            ++n15;
                        }
                        if ((n46 += (n16 - 1) * this.horizontalSpacing - gridData5.horizontalIndent) != gridData5.cacheWidth && gridData5.horizontalAlignment == 4 || gridData5.cacheWidth > n46) {
                            n15 = 0;
                            if (control3 instanceof Scrollable) {
                                Rectangle rectangle = ((Scrollable)control3).computeTrim(0, 0, 0, 0);
                                n15 = rectangle.width;
                            } else {
                                n15 = control3.getBorderWidth() * 2;
                            }
                            gridData5.cacheHeight = -1;
                            gridData5.cacheWidth = -1;
                            gridData5.computeSize(control3, Math.max(0, n46 - n15), gridData5.heightHint, false);
                            if (gridData5.grabExcessVerticalSpace && gridData5.minimumHeight > 0) {
                                gridData5.cacheHeight = Math.max(gridData5.cacheHeight, gridData5.minimumHeight);
                            }
                            if (gridDataArray == null) {
                                gridDataArray = new GridData[n23];
                            }
                            gridDataArray[n20++] = gridData5;
                        }
                    }
                    ++n19;
                }
                ++n45;
            }
        }
        int n47 = n4 - this.verticalSpacing * (n26 - 1) - (this.marginTop + this.marginHeight * 2 + this.marginBottom);
        n31 = 0;
        int[] nArray2 = new int[n26];
        int[] nArray3 = new int[n26];
        boolean[] blArray2 = new boolean[n26];
        n16 = 0;
        while (n16 < n26) {
            int n48 = 0;
            while (n48 < n22) {
                int n49;
                GridData gridData6 = this.getData(controlArray, n16, n48, n26, n22, true);
                if (gridData6 != null && (n49 = Math.max(1, Math.min(gridData6.verticalSpan, n26))) == 1) {
                    n13 = gridData6.cacheHeight + gridData6.verticalIndent;
                    nArray2[n16] = Math.max(nArray2[n16], n13);
                    if (gridData6.grabExcessVerticalSpace) {
                        if (!blArray2[n16]) {
                            ++n31;
                        }
                        blArray2[n16] = true;
                    }
                    if (!gridData6.grabExcessVerticalSpace || gridData6.minimumHeight != 0) {
                        n13 = !gridData6.grabExcessVerticalSpace || gridData6.minimumHeight == -1 ? gridData6.cacheHeight : gridData6.minimumHeight;
                        nArray3[n16] = Math.max(nArray3[n16], n13 += gridData6.verticalIndent);
                    }
                }
                ++n48;
            }
            n48 = 0;
            while (n48 < n22) {
                int n50;
                GridData gridData7 = this.getData(controlArray, n16, n48, n26, n22, false);
                if (gridData7 != null && (n50 = Math.max(1, Math.min(gridData7.verticalSpan, n26))) > 1) {
                    n13 = 0;
                    n12 = 0;
                    n11 = 0;
                    n10 = 0;
                    while (n10 < n50) {
                        n13 += nArray2[n16 - n10];
                        n12 += nArray3[n16 - n10];
                        if (blArray2[n16 - n10]) {
                            ++n11;
                        }
                        ++n10;
                    }
                    if (gridData7.grabExcessVerticalSpace && n11 == 0) {
                        ++n31;
                        blArray2[n16] = true;
                    }
                    if ((n10 = gridData7.cacheHeight + gridData7.verticalIndent - n13 - (n50 - 1) * this.verticalSpacing) > 0) {
                        if (n11 == 0) {
                            int n51 = n16;
                            nArray2[n51] = nArray2[n51] + n10;
                        } else {
                            n9 = n10 / n11;
                            n8 = n10 % n11;
                            n7 = -1;
                            n6 = 0;
                            while (n6 < n50) {
                                if (blArray2[n16 - n6]) {
                                    n7 = n16 - n6;
                                    nArray2[n7] = nArray2[n7] + n9;
                                }
                                ++n6;
                            }
                            if (n7 > -1) {
                                int n52 = n7;
                                nArray2[n52] = nArray2[n52] + n8;
                            }
                        }
                    }
                    if (!gridData7.grabExcessVerticalSpace || gridData7.minimumHeight != 0) {
                        int n53 = n10 = !gridData7.grabExcessVerticalSpace || gridData7.minimumHeight == -1 ? gridData7.cacheHeight : gridData7.minimumHeight;
                        if ((n10 += gridData7.verticalIndent - n12 - (n50 - 1) * this.verticalSpacing) > 0) {
                            if (n11 == 0) {
                                int n54 = n16;
                                nArray3[n54] = nArray3[n54] + n10;
                            } else {
                                n9 = n10 / n11;
                                n8 = n10 % n11;
                                n7 = -1;
                                n6 = 0;
                                while (n6 < n50) {
                                    if (blArray2[n16 - n6]) {
                                        n7 = n16 - n6;
                                        nArray3[n7] = nArray3[n7] + n9;
                                    }
                                    ++n6;
                                }
                                if (n7 > -1) {
                                    int n55 = n7;
                                    nArray3[n55] = nArray3[n55] + n8;
                                }
                            }
                        }
                    }
                }
                ++n48;
            }
            ++n16;
        }
        if (n4 != -1 && n31 > 0) {
            n16 = 0;
            int n56 = 0;
            while (n56 < n26) {
                n16 += nArray2[n56];
                ++n56;
            }
            n56 = n31;
            int n57 = (n47 - n16) / n56;
            int n58 = (n47 - n16) % n56;
            n13 = -1;
            while (n16 != n47) {
                n12 = 0;
                while (n12 < n26) {
                    if (blArray2[n12]) {
                        if (nArray2[n12] + n57 > nArray3[n12]) {
                            n13 = n12;
                            nArray2[n13] = nArray2[n12] + n57;
                        } else {
                            nArray2[n12] = nArray3[n12];
                            blArray2[n12] = false;
                            --n56;
                        }
                    }
                    ++n12;
                }
                if (n13 > -1) {
                    int n59 = n13;
                    nArray2[n59] = nArray2[n59] + n58;
                }
                n12 = 0;
                while (n12 < n26) {
                    n11 = 0;
                    while (n11 < n22) {
                        GridData gridData8 = this.getData(controlArray, n12, n11, n26, n22, false);
                        if (!(gridData8 == null || (n9 = Math.max(1, Math.min(gridData8.verticalSpan, n26))) <= 1 || gridData8.grabExcessVerticalSpace && gridData8.minimumHeight == 0)) {
                            n8 = 0;
                            n7 = 0;
                            n6 = 0;
                            while (n6 < n9) {
                                n8 += nArray2[n12 - n6];
                                if (blArray2[n12 - n6]) {
                                    ++n7;
                                }
                                ++n6;
                            }
                            int n60 = n6 = !gridData8.grabExcessVerticalSpace || gridData8.minimumHeight == -1 ? gridData8.cacheHeight : gridData8.minimumHeight;
                            if ((n6 += gridData8.verticalIndent - n8 - (n9 - 1) * this.verticalSpacing) > 0) {
                                if (n7 == 0) {
                                    int n61 = n12;
                                    nArray2[n61] = nArray2[n61] + n6;
                                } else {
                                    n5 = n6 / n7;
                                    int n62 = n6 % n7;
                                    int n63 = -1;
                                    int n64 = 0;
                                    while (n64 < n9) {
                                        if (blArray2[n12 - n64]) {
                                            n63 = n12 - n64;
                                            nArray2[n63] = nArray2[n63] + n5;
                                        }
                                        ++n64;
                                    }
                                    if (n63 > -1) {
                                        int n65 = n63;
                                        nArray2[n65] = nArray2[n65] + n62;
                                    }
                                }
                            }
                        }
                        ++n11;
                    }
                    ++n12;
                }
                if (n56 == 0) break;
                n16 = 0;
                n12 = 0;
                while (n12 < n26) {
                    n16 += nArray2[n12];
                    ++n12;
                }
                n57 = (n47 - n16) / n56;
                n58 = (n47 - n16) % n56;
                n13 = -1;
            }
        }
        if (bl) {
            n16 = n2 + this.marginTop + this.marginHeight;
            int n66 = 0;
            while (n66 < n26) {
                int n67 = n + this.marginLeft + this.marginWidth;
                int n68 = 0;
                while (n68 < n22) {
                    GridData gridData9 = this.getData(controlArray, n66, n68, n26, n22, true);
                    if (gridData9 != null) {
                        n12 = Math.max(1, Math.min(gridData9.horizontalSpan, n22));
                        n11 = Math.max(1, gridData9.verticalSpan);
                        int n69 = 0;
                        n9 = 0;
                        n8 = 0;
                        while (n8 < n12) {
                            n69 += object[n68 + n8];
                            ++n8;
                        }
                        n8 = 0;
                        while (n8 < n11) {
                            n9 += nArray2[n66 + n8];
                            ++n8;
                        }
                        n8 = n67 + gridData9.horizontalIndent;
                        n7 = Math.min(gridData9.cacheWidth, n69 += this.horizontalSpacing * (n12 - 1));
                        switch (gridData9.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n8 += Math.max(0, (n69 - gridData9.horizontalIndent - n7) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                n8 += Math.max(0, n69 - gridData9.horizontalIndent - n7);
                                break;
                            }
                            case 4: {
                                n7 = n69 - gridData9.horizontalIndent;
                            }
                        }
                        n6 = n16 + gridData9.verticalIndent;
                        n5 = Math.min(gridData9.cacheHeight, n9 += this.verticalSpacing * (n11 - 1));
                        switch (gridData9.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n6 += Math.max(0, (n9 - gridData9.verticalIndent - n5) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                n6 += Math.max(0, n9 - gridData9.verticalIndent - n5);
                                break;
                            }
                            case 4: {
                                n5 = n9 - gridData9.verticalIndent;
                            }
                        }
                        Control control4 = controlArray[n66][n68];
                        if (control4 != null) {
                            control4.setBounds(n8, n6, n7, n5);
                        }
                    }
                    n67 += object[n68] + this.horizontalSpacing;
                    ++n68;
                }
                n16 += nArray2[n66] + this.verticalSpacing;
                ++n66;
            }
        }
        n16 = 0;
        while (n16 < n20) {
            gridDataArray[n16].cacheHeight = -1;
            gridDataArray[n16].cacheWidth = -1;
            ++n16;
        }
        n16 = 0;
        int n70 = 0;
        int n71 = 0;
        while (n71 < n22) {
            n16 += object[n71];
            ++n71;
        }
        n71 = 0;
        while (n71 < n26) {
            n70 += nArray2[n71];
            ++n71;
        }
        return new Point(n16 += this.horizontalSpacing * (n22 - 1) + this.marginLeft + this.marginWidth * 2 + this.marginRight, n70 += this.verticalSpacing * (n26 - 1) + this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public String toString() {
        String string = String.valueOf(this.getName()) + " {";
        if (this.numColumns != 1) {
            string = String.valueOf(string) + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            string = String.valueOf(string) + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = String.valueOf(string) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string = String.valueOf(string) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string = String.valueOf(string) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string = String.valueOf(string) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            string = String.valueOf(string) + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            string = String.valueOf(string) + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

