/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.TabFolderDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class TabItemDrawData
extends DrawData {
    public TabFolderDrawData parent;
    public int position;
    static final int TABITEM_INSET = 2;
    static final int TABITEM_INSET2 = 6;

    public TabItemDrawData() {
        this.state = new int[1];
    }

    @Override
    Rectangle computeTrim(Theme theme, GC gC) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            int n = this.clientArea.x;
            int n2 = this.clientArea.y;
            int n3 = this.clientArea.width;
            int n4 = this.clientArea.height;
            if ((this.style & 0x4000) != 0) {
                n -= 2;
                n3 += 2;
            }
            RECT rECT = new RECT();
            rECT.left = n;
            rECT.right = n + n3;
            rECT.top = n2 -= 2;
            rECT.bottom = n2 + (n4 += 2);
            RECT rECT2 = new RECT();
            int[] nArray = this.getPartId(0);
            OS.GetThemeBackgroundExtent(l, gC.handle, nArray[0], nArray[1], rECT, rECT2);
            rECT2.left -= 6;
            rECT2.top -= 6;
            rECT2.right += 6;
            OS.CloseThemeData(l);
            return new Rectangle(rECT2.left, rECT2.top, rECT2.right - rECT2.left, rECT2.bottom - rECT2.top);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n = this.state[0];
            long l = OS.OpenThemeData(0L, this.getClassId());
            int n2 = rectangle.x;
            int n3 = rectangle.y;
            int n4 = rectangle.width;
            int n5 = rectangle.height;
            if ((this.position & 0x4000) != 0) {
                n2 += 2;
                n4 -= 2;
            }
            n3 += 2;
            n5 -= 2;
            if ((n & 2) != 0) {
                n2 -= 2;
                n3 -= 2;
                n4 += 4;
                n5 += 4;
            }
            RECT rECT = new RECT();
            rECT.left = n2;
            rECT.right = n2 + n4;
            rECT.top = n3;
            rECT.bottom = n3 + n5;
            int[] nArray = this.getPartId(0);
            OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            OS.CloseThemeData(l);
            Rectangle rectangle2 = this.clientArea;
            if (rectangle2 != null) {
                RECT rECT2 = new RECT();
                OS.GetThemeBackgroundContentRect(l, gC.handle, nArray[0], nArray[1], rECT, rECT2);
                rectangle2.x = rECT2.left;
                rectangle2.y = rECT2.top;
                rectangle2.width = rECT2.right - rECT2.left;
                rectangle2.height = rECT2.bottom - rECT2.top;
            }
        }
    }

    @Override
    char[] getClassId() {
        return TAB;
    }

    @Override
    int[] getPartId(int n) {
        int n2 = this.state[n];
        int n3 = 1;
        int n4 = 1;
        if ((this.style & 0x4000) != 0 && (this.style & 0x20000) != 0) {
            n3 = 2;
        } else if ((this.style & 0x4000) != 0) {
            n3 = 2;
        }
        if ((n2 & 0x40) != 0) {
            n4 = 2;
        }
        if ((n2 & 4) != 0) {
            n4 = 5;
        }
        if ((n2 & 2) != 0) {
            n4 = 3;
        }
        if ((n2 & 0x20) != 0) {
            n4 = 4;
        }
        return new int[]{n3, n4};
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        Rectangle rectangle2;
        if (!rectangle.contains(point)) {
            return -1;
        }
        int n = this.style;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if ((n & 0x4000) != 0) {
            n2 += 2;
            n4 -= 2;
        }
        if (!(rectangle2 = new Rectangle(n2, n3 += 2, n4, n5 -= 2)).contains(point)) {
            return -1;
        }
        return 0;
    }
}

