/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;

public class ScrollBarDrawData
extends RangeDrawData {
    public int thumb;
    public int increment;
    public int pageIncrement;

    public ScrollBarDrawData() {
        this.state = new int[6];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            RECT rECT = new RECT();
            if ((this.style & 0x200) != 0) {
                int n = OS.GetThemeSysSize(l, 2);
                rECT.left = rectangle.x;
                rECT.right = rECT.left + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + n;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.bottom = rectangle.y + rectangle.height;
                rECT.top = rECT.bottom - n;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                int n2 = rectangle.height - 2 * n;
                int n3 = Math.max(n / 2, n2 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n4 = rectangle.y + n + Math.max(0, n2 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.top = rectangle.y + n;
                rECT.bottom = n4;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rECT.top + n3;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(l, gC.handle, 9, nArray[1], rECT, null);
                rECT.top = rECT.bottom;
                rECT.bottom = rectangle.y + rectangle.height - n;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            } else {
                int n = OS.GetThemeSysSize(l, 2);
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + rectangle.height;
                rECT.left = rectangle.x;
                rECT.right = rECT.left + n;
                int[] nArray = this.getPartId(1);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.right = rectangle.x + rectangle.width;
                rECT.left = rECT.right - n;
                nArray = this.getPartId(2);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                int n5 = rectangle.width - 2 * n;
                int n6 = Math.max(n / 2, n5 * this.thumb / (this.maximum - this.minimum));
                int n7 = rectangle.x + n + Math.max(0, n5 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.left = rectangle.x + n;
                rECT.right = n7;
                nArray = this.getPartId(3);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rECT.left + n6;
                nArray = this.getPartId(5);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
                OS.DrawThemeBackground(l, gC.handle, 8, nArray[1], rECT, null);
                rECT.left = rECT.right;
                rECT.right = rectangle.x + rectangle.width - n;
                nArray = this.getPartId(4);
                OS.DrawThemeBackground(l, gC.handle, nArray[0], nArray[1], rECT, null);
            }
            OS.CloseThemeData(l);
        }
    }

    @Override
    char[] getClassId() {
        return SCROLLBAR;
    }

    @Override
    int[] getPartId(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.state[n];
        switch (n) {
            case 1: {
                n2 = 1;
                if ((this.style & 0x200) != 0) {
                    n3 = 1;
                    if ((n4 & 0x40) != 0) {
                        n3 = 2;
                    }
                    if ((n4 & 8) != 0) {
                        n3 = 3;
                    }
                    if ((n4 & 0x20) == 0) break;
                    n3 = 4;
                    break;
                }
                n3 = 9;
                if ((n4 & 0x40) != 0) {
                    n3 = 10;
                }
                if ((n4 & 8) != 0) {
                    n3 = 11;
                }
                if ((n4 & 0x20) == 0) break;
                n3 = 12;
                break;
            }
            case 2: {
                n2 = 1;
                if ((this.style & 0x200) != 0) {
                    n3 = 5;
                    if ((n4 & 0x40) != 0) {
                        n3 = 6;
                    }
                    if ((n4 & 8) != 0) {
                        n3 = 7;
                    }
                    if ((n4 & 0x20) == 0) break;
                    n3 = 8;
                    break;
                }
                n3 = 13;
                if ((n4 & 0x40) != 0) {
                    n3 = 14;
                }
                if ((n4 & 8) != 0) {
                    n3 = 15;
                }
                if ((n4 & 0x20) == 0) break;
                n3 = 16;
                break;
            }
            case 0: 
            case 5: {
                if ((this.style & 0x200) != 0) {
                    n2 = 3;
                    break;
                }
                n2 = 2;
                break;
            }
            case 3: {
                if ((this.style & 0x200) != 0) {
                    n2 = 7;
                    break;
                }
                n2 = 5;
                break;
            }
            case 4: {
                n2 = (this.style & 0x200) != 0 ? 6 : 4;
            }
        }
        if (n != 2 && n != 1) {
            n3 = 1;
            if ((n4 & 0x40) != 0) {
                n3 = 2;
            }
            if ((n4 & 8) != 0) {
                n3 = 3;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 4;
            }
        }
        return new int[]{n2, n3};
    }

    @Override
    Rectangle getBounds(int n, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n2 = OS.GetThemeSysSize(l, 2);
                int n3 = rectangle.height - 2 * n2;
                int n4 = Math.max(n2 / 2, n3 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n5 = rectangle.y + n2 + Math.max(0, n3 * this.selection / Math.max(1, this.maximum - this.minimum));
                switch (n) {
                    case 2: {
                        return new Rectangle(rectangle.x, rectangle.y + rectangle.height - n2, rectangle.width, n2);
                    }
                    case 1: {
                        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, n2);
                    }
                    case 3: {
                        return new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, n5 - rectangle.y - n2);
                    }
                    case 5: {
                        return new Rectangle(rectangle.x, n5, rectangle.width, n4);
                    }
                    case 4: {
                        return new Rectangle(rectangle.x, n5 + n4, rectangle.width, rectangle.y + rectangle.height - n2 - n5 - n4);
                    }
                }
            }
            OS.CloseThemeData(l);
        }
        return super.getBounds(n, rectangle);
    }

    @Override
    int getSelection(Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l = OS.OpenThemeData(0L, this.getClassId());
            if ((this.style & 0x200) != 0) {
                int n = OS.GetThemeSysSize(l, 2);
                int n2 = rectangle.height - 2 * n;
                int n3 = rectangle.y + n + Math.max(0, n2 * this.selection / Math.max(1, this.maximum - this.minimum));
                int n4 = ((n3 += point.y) - rectangle.y - n) * (this.maximum - this.minimum) / n2;
                return Math.max(0, Math.min(n4, this.maximum - this.thumb));
            }
            OS.CloseThemeData(l);
        }
        return 0;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            return -1;
        }
        long l = OS.OpenThemeData(0L, this.getClassId());
        int n = 0;
        RECT rECT = new RECT();
        POINT pOINT = new POINT();
        pOINT.x = point.x;
        pOINT.y = point.y;
        short[] sArray = new short[1];
        try {
            if ((this.style & 0x200) != 0) {
                int n2 = OS.GetThemeSysSize(l, 2);
                rECT.left = rectangle.x;
                rECT.right = rECT.left + rectangle.width;
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + n2;
                int[] nArray = this.getPartId(1);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 1;
                }
                rECT.bottom = rectangle.y + rectangle.height;
                rECT.top = rECT.bottom - n2;
                nArray = this.getPartId(2);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 2;
                }
                int n3 = rectangle.height - 2 * n2;
                int n4 = Math.max(n2 / 2, n3 * this.thumb / Math.max(1, this.maximum - this.minimum));
                int n5 = rectangle.y + n2 + Math.max(0, n3 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.top = rectangle.y + n2;
                rECT.bottom = n5;
                nArray = this.getPartId(5);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 3;
                }
                rECT.top = rECT.bottom;
                rECT.bottom = rECT.top + n4;
                nArray = this.getPartId(3);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 5;
                }
                rECT.top = rECT.bottom;
                rECT.bottom = rectangle.y + rectangle.height - n2;
                nArray = this.getPartId(4);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 4;
                }
            } else {
                int n6 = OS.GetThemeSysSize(l, 2);
                rECT.top = rectangle.y;
                rECT.bottom = rECT.top + rectangle.height;
                rECT.left = rectangle.x;
                rECT.right = rECT.left + n6;
                int[] nArray = this.getPartId(1);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 1;
                }
                rECT.right = rectangle.x + rectangle.width;
                rECT.left = rECT.right - n6;
                nArray = this.getPartId(2);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 2;
                }
                int n7 = rectangle.width - 2 * n6;
                int n8 = Math.max(n6 / 2, n7 * this.thumb / (this.maximum - this.minimum));
                int n9 = rectangle.x + n6 + Math.max(0, n7 * this.selection / Math.max(1, this.maximum - this.minimum));
                rECT.left = rectangle.x + n6;
                rECT.right = n9;
                nArray = this.getPartId(3);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 3;
                }
                rECT.left = rECT.right;
                rECT.right = rECT.left + n8;
                nArray = this.getPartId(5);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 5;
                }
                rECT.left = rECT.right;
                rECT.right = rectangle.x + rectangle.width - n6;
                nArray = this.getPartId(4);
                OS.HitTestThemeBackground(l, n, nArray[0], nArray[1], 0, rECT, 0L, pOINT, sArray);
                if (sArray[0] != 0) {
                    return 4;
                }
            }
        }
        finally {
            OS.CloseThemeData(l);
        }
        return -1;
    }
}

