/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;

public class ScaleDrawData
extends RangeDrawData {
    public int increment;
    public int pageIncrement;
    static final int TICS_MARGIN = 10;

    public ScaleDrawData() {
        this.state = new int[4];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n = this.style;
            int n2 = this.minimum;
            int n3 = this.maximum;
            int n4 = this.selection;
            int n5 = this.pageIncrement;
            long l = OS.OpenThemeData(0L, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rECT.left + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rECT.top + rectangle.height;
            SIZE sIZE = new SIZE();
            if ((n & 0x200) != 0) {
                int n6;
                OS.GetThemePartSize(l, gC.handle, 2, 0, null, 1, sIZE);
                int n7 = sIZE.cx - 1;
                OS.GetThemePartSize(l, gC.handle, 6, 0, null, 1, sIZE);
                int n8 = sIZE.cx;
                int n9 = sIZE.cy;
                OS.GetThemePartSize(l, gC.handle, 9, 0, rECT, 1, sIZE);
                int n10 = sIZE.cx;
                int n11 = n6 = (n8 - n7) / 2;
                rECT.left += (n6 += 10);
                rECT.top += n11;
                rECT.right = rECT.left + n7;
                rECT.bottom -= n11;
                int n12 = rECT.bottom - rECT.top;
                OS.DrawThemeBackground(l, gC.handle, 2, 0, rECT, null);
                rECT.top += (n12 - n9) * (n4 - n2) / Math.max(1, n3 - n2);
                rECT.left -= (n8 - n7) / 2;
                rECT.right = rECT.left + n8;
                rECT.bottom = rECT.top + n9;
                OS.DrawThemeBackground(l, gC.handle, 6, 0, rECT, null);
                rECT.top = rectangle.y + n11 + n9 / 2;
                rECT.bottom = rECT.top + 1;
                int n13 = n2;
                while (n13 <= n3) {
                    rECT.left = rectangle.x + 5;
                    rECT.right = rECT.left + n10;
                    if (n13 != n2 && n13 != n3) {
                        ++rECT.left;
                    }
                    rECT.top = rectangle.y + n11 + n9 / 2;
                    rECT.top += (n12 - n9) * (n13 - n2) / Math.max(1, n3 - n2);
                    rECT.bottom = rECT.top + 1;
                    OS.DrawThemeBackground(l, gC.handle, 10, 1, rECT, null);
                    gC.drawLine(DPIUtil.autoScaleDown(rECT.left), DPIUtil.autoScaleDown(rECT.top), DPIUtil.autoScaleDown(rECT.right), DPIUtil.autoScaleDown(rECT.top));
                    rECT.left = rectangle.x + 10 + n8 + 1;
                    rECT.right = rECT.left + n10;
                    if (n13 != n2 && n13 != n3) {
                        --rECT.right;
                    }
                    OS.DrawThemeBackground(l, gC.handle, 10, 1, rECT, null);
                    gC.drawLine(DPIUtil.autoScaleDown(rECT.left), DPIUtil.autoScaleDown(rECT.top), DPIUtil.autoScaleDown(rECT.right), DPIUtil.autoScaleDown(rECT.top));
                    n13 += n5;
                }
            }
            OS.CloseThemeData(l);
        }
    }

    @Override
    char[] getClassId() {
        return TRACKBAR;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

