/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.ole.win32;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.internal.ole.win32.COMUtils;
import org.eclipse.swt.internal.ole.win32.RegKey;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public final class Registry {
    private static final Logger LOG = Logger.getLogger(Registry.class.getName());
    private final LinkedHashMap<RegKey, String> map;
    private final int cacheMaxSize;

    public Registry(int n) {
        this.cacheMaxSize = n >= 2 ? n : 100;
        this.map = new LinkedHashMap(Math.min(2, this.cacheMaxSize / 5));
    }

    public String getDefValue(int n, String string) {
        RegKey regKey = new RegKey(n, string, null);
        return this.getValue(regKey);
    }

    public String getValue(int n, String string, String string2) {
        RegKey regKey = new RegKey(n, string, string2);
        return this.getValue(regKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getValue(RegKey regKey) {
        Object object = this.map;
        synchronized (object) {
            if (this.map.containsKey(regKey)) {
                String string = (String)this.map.remove(regKey);
                this.map.put(regKey, string);
                return string;
            }
        }
        object = this.readRegQueryValue(regKey);
        LinkedHashMap<RegKey, String> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            int n = this.map.size();
            if (n >= this.cacheMaxSize) {
                Iterator<Map.Entry<RegKey, String>> iterator = this.map.entrySet().iterator();
                while (n >= this.cacheMaxSize && iterator.hasNext()) {
                    iterator.remove();
                    --n;
                }
            }
            this.map.put(regKey, (String)object);
        }
        return object;
    }

    private final String readRegQueryValue(RegKey regKey) throws NullPointerException {
        if (regKey == null) {
            throw new NullPointerException("regKey");
        }
        TCHAR tCHAR = new TCHAR(0, regKey.strKey, true);
        long[] lArray = new long[1];
        int n = OS.RegOpenKeyEx(regKey.hKeyRoot, tCHAR, 0, 131097, lArray);
        if (n != 0) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("RegOpenKeyEx failed for key " + regKey + " with error: " + COMUtils.formatMessage(n));
            }
            return null;
        }
        TCHAR tCHAR2 = regKey.strValueName != null ? new TCHAR(0, regKey.strValueName, true) : null;
        String string = null;
        int[] nArray = new int[1];
        n = OS.RegQueryValueEx(lArray[0], tCHAR2, 0L, null, null, nArray);
        if (n == 0) {
            int n2 = nArray[0] / TCHAR.sizeof;
            if (n2 == 0) {
                string = "";
            } else {
                TCHAR tCHAR3 = new TCHAR(0, n2);
                n = OS.RegQueryValueEx(lArray[0], tCHAR2, 0L, null, tCHAR3, nArray);
                if (n == 0) {
                    string = COMUtils.toJava(tCHAR3);
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Read registry key " + regKey + "=" + string);
                    }
                } else {
                    LOG.warning("RegQueryValueEx failed for key " + regKey + " with error: " + COMUtils.formatMessage(n));
                }
            }
        } else {
            LOG.warning("RegOpenKeyEx for size failed for key " + regKey + " with error: " + COMUtils.formatMessage(n));
        }
        if (lArray[0] != 0L) {
            OS.RegCloseKey(lArray[0]);
        }
        return string;
    }
}

