/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.ole.win32;

final class RegKey {
    final int hKeyRoot;
    final String strKey;
    final String strValueName;
    private final String fullPath;

    RegKey(int n, String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("null strKey");
        }
        this.fullPath = String.valueOf(RegKey.rootKeyToStr(n)) + '\\' + string + (string2 != null ? " " + string2 : "");
        this.hKeyRoot = n;
        this.strKey = string.trim();
        if (this.strKey.length() <= 0) {
            throw new IllegalArgumentException("Empty strKey: " + string);
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        this.strValueName = string2;
    }

    public String toString() {
        return this.fullPath;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegKey regKey = (RegKey)object;
        if (this.hKeyRoot != regKey.hKeyRoot) {
            return false;
        }
        if (!this.strKey.equals(regKey.strKey)) {
            return false;
        }
        return !(this.strValueName != null ? !this.strValueName.equals(regKey.strValueName) : regKey.strValueName != null);
    }

    public final int hashCode() {
        int n = this.hKeyRoot;
        n = 31 * n + this.strKey.hashCode();
        n = 31 * n + (this.strValueName != null ? this.strValueName.hashCode() : 0);
        return n;
    }

    private static final String rootKeyToStr(int n) {
        String string;
        switch (n) {
            case -2147483648: {
                string = "HKEY_CLASSES_ROOT";
                break;
            }
            case -2147483647: {
                string = "HKEY_CURRENT_USER";
                break;
            }
            case -2147483646: {
                string = "HKEY_LOCAL_MACHINE";
                break;
            }
            default: {
                throw new IllegalArgumentException("Root key: " + n);
            }
        }
        return string;
    }
}

