/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.ole.win32;

import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public final class COMUtils {
    public static final GUID CLSIDFromString(String string) {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("name: " + string);
        }
        return COMObject.IIDFromString(string);
    }

    public static final String formatMessage(int n) {
        if (n == 0) {
            return "Success";
        }
        int n2 = 4864;
        long[] lArray = new long[1];
        int n3 = OS.FormatMessage(n2, 0L, n, 1024, lArray, 0, 0L);
        if (n3 == 0) {
            return " [Error=0x" + Integer.toHexString(n) + "]";
        }
        TCHAR tCHAR = new TCHAR(0, n3);
        OS.MoveMemory(tCHAR, lArray[0], n3 * TCHAR.sizeof);
        if (lArray[0] != 0L) {
            OS.LocalFree(lArray[0]);
        }
        String string = tCHAR.toString(0, n3);
        string = string.trim();
        return string;
    }

    public static final String toJava(TCHAR tCHAR) {
        if (tCHAR == null) {
            return null;
        }
        int n = Math.max(0, tCHAR.length() - 1);
        String string = tCHAR.toString(0, n);
        return string;
    }

    public static final char[] toNative(String string) {
        if (string == null) {
            throw new NullPointerException("str");
        }
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        return cArray;
    }
}

