/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.mozilla;

import java.util.HashMap;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.nsID;

public abstract class IIDStore {
    static HashMap<Class<?>, nsID[]> IIDs = new HashMap();

    public static nsID GetIID(Class<?> clazz) {
        return IIDStore.GetIID(clazz, MozillaVersion.GetCurrentVersion());
    }

    public static nsID GetIID(Class<?> clazz, int n) {
        return IIDStore.GetIID(clazz, n, false);
    }

    public static nsID GetIID(Class<?> clazz, int n, boolean bl) {
        if (n <= MozillaVersion.GetLatestVersion()) {
            nsID[] nsIDArray = IIDs.get(clazz);
            if (nsIDArray == null) {
                try {
                    Class<Number> clazz2 = C.PTR_SIZEOF == 4 ? Integer.TYPE : Long.TYPE;
                    clazz.getConstructor(clazz2).newInstance(0);
                    nsIDArray = IIDs.get(clazz);
                }
                catch (Exception exception) {}
            }
            if (nsIDArray != null) {
                if (bl) {
                    return nsIDArray[n];
                }
                int n2 = MozillaVersion.GetLatestVersion() + 1;
                if (n == MozillaVersion.GetCurrentVersion() && nsIDArray[n2] != null) {
                    return nsIDArray[n2];
                }
                int n3 = n;
                while (n3 >= 0) {
                    if (nsIDArray[n3] != null) {
                        if (n == MozillaVersion.GetCurrentVersion()) {
                            nsIDArray[n2] = nsIDArray[n3];
                        }
                        return nsIDArray[n3];
                    }
                    --n3;
                }
            }
        }
        return null;
    }

    protected static void RegisterIID(Class<?> clazz, int n, nsID nsID2) {
        if (n <= MozillaVersion.GetLatestVersion()) {
            nsID[] nsIDArray = IIDs.get(clazz);
            if (nsIDArray == null) {
                nsIDArray = new nsID[MozillaVersion.GetLatestVersion() + 2];
                IIDs.put(clazz, nsIDArray);
            }
            nsIDArray[n] = nsID2;
        }
    }
}

