/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;

public final class WinBMPFileFormat
extends FileFormat {
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 40;
    int importantColors;
    Point pelsPerMeter = new Point(0, 0);

    int compress(int n, byte[] byArray, int n2, int n3, byte[] byArray2, boolean bl) {
        if (n == 1) {
            return this.compressRLE8Data(byArray, n2, n3, byArray2, bl);
        }
        if (n == 2) {
            return this.compressRLE4Data(byArray, n2, n3, byArray2, bl);
        }
        SWT.error(40);
        return 0;
    }

    int compressRLE4Data(byte[] byArray, int n, int n2, byte[] byArray2, boolean bl) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        int n6 = 0;
        while (n3 < n4) {
            int n7 = n4 - n3 - 1;
            if (n7 > 127) {
                n7 = 127;
            }
            int n8 = 0;
            while (n8 < n7) {
                if (byArray[n3 + n8] == byArray[n3 + n8 + 1]) break;
                ++n8;
            }
            if (n8 < 127 && n8 == n7) {
                ++n8;
            }
            switch (n8) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[n5] = 2;
                    byArray2[++n5] = byArray[n3];
                    ++n5;
                    ++n3;
                    n6 += 2;
                    break;
                }
                default: {
                    byArray2[n5] = 0;
                    byArray2[++n5] = (byte)(n8 + n8);
                    ++n5;
                    int n9 = n8;
                    while (n9 > 0) {
                        byArray2[n5] = byArray[n3];
                        ++n5;
                        ++n3;
                        --n9;
                    }
                    n6 += 2 + n8;
                    if ((n8 & 1) == 0) break;
                    byArray2[n5] = 0;
                    ++n5;
                    ++n6;
                }
            }
            n7 = n4 - n3;
            if (n7 <= 0) continue;
            if (n7 > 127) {
                n7 = 127;
            }
            byte by = byArray[n3];
            n8 = 1;
            while (n8 < n7) {
                if (byArray[n3 + n8] != by) break;
                ++n8;
            }
            byArray2[n5] = (byte)(n8 + n8);
            byArray2[++n5] = by;
            ++n5;
            n3 += n8;
            n6 += 2;
        }
        byArray2[n5] = 0;
        ++n5;
        if (bl) {
            byArray2[n5] = 1;
            ++n5;
        } else {
            byArray2[n5] = 0;
            ++n5;
        }
        return n6 += 2;
    }

    int compressRLE8Data(byte[] byArray, int n, int n2, byte[] byArray2, boolean bl) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        int n6 = 0;
        while (n3 < n4) {
            int n7 = n4 - n3 - 1;
            if (n7 > 254) {
                n7 = 254;
            }
            int n8 = 0;
            while (n8 < n7) {
                if (byArray[n3 + n8] == byArray[n3 + n8 + 1]) break;
                ++n8;
            }
            if (n8 == n7) {
                ++n8;
            }
            switch (n8) {
                case 0: {
                    break;
                }
                case 2: {
                    byArray2[n5] = 1;
                    byArray2[++n5] = byArray[n3];
                    ++n5;
                    ++n3;
                    n6 += 2;
                }
                case 1: {
                    byArray2[n5] = 1;
                    byArray2[++n5] = byArray[n3];
                    ++n5;
                    ++n3;
                    n6 += 2;
                    break;
                }
                default: {
                    byArray2[n5] = 0;
                    byArray2[++n5] = (byte)n8;
                    ++n5;
                    int n9 = n8;
                    while (n9 > 0) {
                        byArray2[n5] = byArray[n3];
                        ++n5;
                        ++n3;
                        --n9;
                    }
                    n6 += 2 + n8;
                    if ((n8 & 1) == 0) break;
                    byArray2[n5] = 0;
                    ++n5;
                    ++n6;
                }
            }
            n7 = n4 - n3;
            if (n7 <= 0) continue;
            if (n7 > 255) {
                n7 = 255;
            }
            byte by = byArray[n3];
            n8 = 1;
            while (n8 < n7) {
                if (byArray[n3 + n8] != by) break;
                ++n8;
            }
            byArray2[n5] = (byte)n8;
            byArray2[++n5] = by;
            ++n5;
            n3 += n8;
            n6 += 2;
        }
        byArray2[n5] = 0;
        ++n5;
        if (bl) {
            byArray2[n5] = 1;
            ++n5;
        } else {
            byArray2[n5] = 0;
            ++n5;
        }
        return n6 += 2;
    }

    void convertPixelsToBGR(ImageData imageData, byte[] byArray) {
        byte[] byArray2 = imageData.data;
        PaletteData paletteData = imageData.palette;
        int n = 0;
        while (n < imageData.height) {
            int n2 = 0;
            int n3 = n;
            int n4 = imageData.depth / 8;
            int n5 = n * imageData.bytesPerLine;
            int n6 = 0;
            while (n6 < imageData.width) {
                int n7;
                int n8;
                int n9;
                int n10 = 0;
                switch (imageData.depth) {
                    case 32: {
                        n10 = (byArray2[n5] & 0xFF) << 24 | (byArray2[n5 + 1] & 0xFF) << 16 | (byArray2[n5 + 2] & 0xFF) << 8 | byArray2[n5 + 3] & 0xFF;
                        break;
                    }
                    case 24: {
                        n10 = (byArray2[n5] & 0xFF) << 16 | (byArray2[n5 + 1] & 0xFF) << 8 | byArray2[n5 + 2] & 0xFF;
                        break;
                    }
                    case 16: {
                        n10 = (byArray2[n5 + 1] & 0xFF) << 8 | byArray2[n5] & 0xFF;
                        break;
                    }
                    default: {
                        SWT.error(38);
                    }
                }
                if (imageData.depth == 16) {
                    n9 = n10 & paletteData.redMask;
                    n9 = paletteData.redShift < 0 ? n9 >>> -paletteData.redShift : n9 << paletteData.redShift;
                    n8 = n10 & paletteData.greenMask;
                    n8 = paletteData.greenShift < 0 ? n8 >>> -paletteData.greenShift : n8 << paletteData.greenShift;
                    n7 = n10 & paletteData.blueMask;
                    n7 = paletteData.blueShift < 0 ? n7 >>> -paletteData.blueShift : n7 << paletteData.blueShift;
                    int n11 = n9 << 7 | (n8 &= 0xF8) << 2 | n7 >> 3;
                    byArray[n5] = (byte)(n11 & 0xFF);
                    byArray[n5 + 1] = (byte)(n11 >> 8 & 0xFF);
                } else {
                    n9 = n10 & paletteData.blueMask;
                    byArray[n5] = (byte)(paletteData.blueShift < 0 ? n9 >>> -paletteData.blueShift : n9 << paletteData.blueShift);
                    n8 = n10 & paletteData.greenMask;
                    byArray[n5 + 1] = (byte)(paletteData.greenShift < 0 ? n8 >>> -paletteData.greenShift : n8 << paletteData.greenShift);
                    n7 = n10 & paletteData.redMask;
                    byArray[n5 + 2] = (byte)(paletteData.redShift < 0 ? n7 >>> -paletteData.redShift : n7 << paletteData.redShift);
                    if (n4 == 4) {
                        byArray[n5 + 3] = 0;
                    }
                }
                if (++n2 >= imageData.width) {
                    n5 = ++n3 * imageData.bytesPerLine;
                    n2 = 0;
                } else {
                    n5 += n4;
                }
                ++n6;
            }
            ++n;
        }
    }

    void decompressData(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (n2 == 1) {
            if (this.decompressRLE8Data(byArray, byArray.length, n, byArray2, byArray2.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        if (n2 == 2) {
            if (this.decompressRLE4Data(byArray, byArray.length, n, byArray2, byArray2.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        SWT.error(40);
    }

    int decompressRLE4Data(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        int n5 = n;
        int n6 = 0;
        int n7 = n3;
        int n8 = 0;
        int n9 = 0;
        block5: while (n4 < n5) {
            int n10;
            int n11 = byArray[n4] & 0xFF;
            ++n4;
            if (n11 == 0) {
                n11 = byArray[n4] & 0xFF;
                ++n4;
                switch (n11) {
                    case 0: {
                        n8 = 0;
                        n6 = ++n9 * n2;
                        if (n6 <= n7) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        n8 += byArray[n4] & 0xFF;
                        n9 += byArray[++n4] & 0xFF;
                        ++n4;
                        n6 = n9 * n2 + n8 / 2;
                        if (n6 <= n7) continue block5;
                        return -1;
                    }
                    default: {
                        if ((n11 & 1) != 0) {
                            return -1;
                        }
                        n8 += n11;
                        if ((n11 /= 2) > n5 - n4) {
                            return -1;
                        }
                        if (n11 > n7 - n6) {
                            return -1;
                        }
                        n10 = 0;
                        while (n10 < n11) {
                            byArray2[n6] = byArray[n4];
                            ++n6;
                            ++n4;
                            ++n10;
                        }
                        if ((n4 & 1) == 0) continue block5;
                        ++n4;
                        break;
                    }
                }
                continue;
            }
            if ((n11 & 1) != 0) {
                return -1;
            }
            n8 += n11;
            n10 = byArray[n4];
            ++n4;
            if ((n11 /= 2) > n7 - n6) {
                return -1;
            }
            int n12 = 0;
            while (n12 < n11) {
                byArray2[n6] = n10;
                ++n6;
                ++n12;
            }
        }
        return 1;
    }

    int decompressRLE8Data(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        int n5 = n;
        int n6 = 0;
        int n7 = n3;
        int n8 = 0;
        int n9 = 0;
        block5: while (n4 < n5) {
            int n10;
            int n11 = byArray[n4] & 0xFF;
            ++n4;
            if (n11 == 0) {
                n11 = byArray[n4] & 0xFF;
                ++n4;
                switch (n11) {
                    case 0: {
                        n8 = 0;
                        n6 = ++n9 * n2;
                        if (n6 <= n7) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        n8 += byArray[n4] & 0xFF;
                        n9 += byArray[++n4] & 0xFF;
                        ++n4;
                        n6 = n9 * n2 + n8;
                        if (n6 <= n7) continue block5;
                        return -1;
                    }
                    default: {
                        if (n11 > n5 - n4) {
                            return -1;
                        }
                        if (n11 > n7 - n6) {
                            return -1;
                        }
                        n10 = 0;
                        while (n10 < n11) {
                            byArray2[n6] = byArray[n4];
                            ++n6;
                            ++n4;
                            ++n10;
                        }
                        if ((n4 & 1) != 0) {
                            ++n4;
                        }
                        n8 += n11;
                        break;
                    }
                }
                continue;
            }
            n10 = byArray[n4];
            ++n4;
            if (n11 > n7 - n6) {
                return -1;
            }
            int n12 = 0;
            while (n12 < n11) {
                byArray2[n6] = n10;
                ++n6;
                ++n12;
            }
            n8 += n11;
        }
        return 1;
    }

    @Override
    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[18];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            int n = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8 | (byArray[16] & 0xFF) << 16 | (byArray[17] & 0xFF) << 24;
            return byArray[0] == 66 && byArray[1] == 77 && n >= 40;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isPaletteBMP(PaletteData paletteData, int n) {
        switch (n) {
            case 32: {
                return paletteData.redMask == 65280 && paletteData.greenMask == 0xFF0000 && paletteData.blueMask == -16777216;
            }
            case 24: {
                return paletteData.redMask == 255 && paletteData.greenMask == 65280 && paletteData.blueMask == 0xFF0000;
            }
            case 16: {
                return paletteData.redMask == 31744 && paletteData.greenMask == 992 && paletteData.blueMask == 31;
            }
        }
        return true;
    }

    byte[] loadData(byte[] byArray) {
        int n = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n2 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        int n3 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        int n4 = (n * n3 + 7) / 8;
        n4 = (n4 + 3) / 4 * 4;
        byte[] byArray2 = this.loadData(byArray, n4);
        this.flipScanLines(byArray2, n4, n2);
        return byArray2;
    }

    byte[] loadData(byte[] byArray, int n) {
        int n2 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n2 * n;
        byte[] byArray2 = new byte[n3];
        int n4 = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 24;
        if (n4 == 0 || n4 == 3) {
            try {
                if (this.inputStream.read(byArray2) != n3) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        } else {
            int n5 = byArray[20] & 0xFF | (byArray[21] & 0xFF) << 8 | (byArray[22] & 0xFF) << 16 | (byArray[23] & 0xFF) << 24;
            byte[] byArray3 = new byte[n5];
            try {
                if (this.inputStream.read(byArray3) != n5) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            this.decompressData(byArray3, byArray2, n, n4);
        }
        return byArray2;
    }

    int[] loadFileHeader() {
        int[] nArray = new int[5];
        try {
            nArray[0] = this.inputStream.readShort();
            nArray[1] = this.inputStream.readInt();
            nArray[2] = this.inputStream.readShort();
            nArray[3] = this.inputStream.readShort();
            nArray[4] = this.inputStream.readInt();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 19778) {
            SWT.error(40);
        }
        return nArray;
    }

    @Override
    ImageData[] loadFromByteStream() {
        int[] nArray = this.loadFileHeader();
        byte[] byArray = new byte[40];
        try {
            this.inputStream.read(byArray);
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
        int n = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n2 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        this.compression = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 24;
        PaletteData paletteData = this.loadPalette(byArray);
        if (this.inputStream.getPosition() < nArray[4]) {
            try {
                this.inputStream.skip(nArray[4] - this.inputStream.getPosition());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        byte[] byArray2 = this.loadData(byArray);
        this.importantColors = byArray[36] & 0xFF | (byArray[37] & 0xFF) << 8 | (byArray[38] & 0xFF) << 16 | (byArray[39] & 0xFF) << 24;
        int n4 = byArray[24] & 0xFF | (byArray[25] & 0xFF) << 8 | (byArray[26] & 0xFF) << 16 | (byArray[27] & 0xFF) << 24;
        int n5 = byArray[28] & 0xFF | (byArray[29] & 0xFF) << 8 | (byArray[30] & 0xFF) << 16 | (byArray[31] & 0xFF) << 24;
        this.pelsPerMeter = new Point(n4, n5);
        int n6 = this.compression == 1 || this.compression == 2 ? 1 : 0;
        return new ImageData[]{ImageData.internal_new(n, n2, n3, paletteData, 4, byArray2, 0, null, null, -1, -1, n6, 0, 0, 0, 0)};
    }

    PaletteData loadPalette(byte[] byArray) {
        int n = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        if (n <= 8) {
            int n2 = byArray[32] & 0xFF | (byArray[33] & 0xFF) << 8 | (byArray[34] & 0xFF) << 16 | (byArray[35] & 0xFF) << 24;
            if (n2 == 0) {
                n2 = 1 << n;
            } else if (n2 > 256) {
                n2 = 256;
            }
            byte[] byArray2 = new byte[n2 * 4];
            try {
                if (this.inputStream.read(byArray2) != byArray2.length) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            return this.paletteFromBytes(byArray2, n2);
        }
        if (n == 16) {
            if (this.compression == 3) {
                try {
                    return new PaletteData(this.inputStream.readInt(), this.inputStream.readInt(), this.inputStream.readInt());
                }
                catch (IOException iOException) {
                    SWT.error(39, iOException);
                }
            }
            return new PaletteData(31744, 992, 31);
        }
        if (n == 24) {
            return new PaletteData(255, 65280, 0xFF0000);
        }
        if (this.compression == 3) {
            try {
                return new PaletteData(this.inputStream.readInt(), this.inputStream.readInt(), this.inputStream.readInt());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        return new PaletteData(65280, 0xFF0000, -16777216);
    }

    PaletteData paletteFromBytes(byte[] byArray, int n) {
        int n2 = 0;
        RGB[] rGBArray = new RGB[n];
        int n3 = 0;
        while (n3 < n) {
            rGBArray[n3] = new RGB(byArray[n2 + 2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2] & 0xFF);
            n2 += 4;
            ++n3;
        }
        return new PaletteData(rGBArray);
    }

    static byte[] paletteToBytes(PaletteData paletteData) {
        int n = paletteData.colors == null ? 0 : (paletteData.colors.length < 256 ? paletteData.colors.length : 256);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            RGB rGB = paletteData.colors[n3];
            byArray[n2] = (byte)rGB.blue;
            byArray[n2 + 1] = (byte)rGB.green;
            byArray[n2 + 2] = (byte)rGB.red;
            n2 += 4;
            ++n3;
        }
        return byArray;
    }

    int unloadData(ImageData imageData, byte[] byArray, OutputStream outputStream, int n) {
        int n2 = 0;
        try {
            if (n == 0) {
                return this.unloadDataNoCompression(imageData, byArray, outputStream);
            }
            int n3 = (imageData.width * imageData.depth + 7) / 8;
            int n4 = (n3 + 3) / 4 * 4;
            int n5 = imageData.bytesPerLine;
            byte[] byArray2 = new byte[n4 * 2];
            int n6 = n5 * (imageData.height - 1);
            if (byArray == null) {
                byArray = imageData.data;
            }
            n2 = 0;
            byte[] byArray3 = new byte[32768];
            int n7 = 0;
            int n8 = imageData.height - 1;
            while (n8 >= 0) {
                int n9 = this.compress(n, byArray, n6, n3, byArray2, n8 == 0);
                if (n7 + n9 > byArray3.length) {
                    outputStream.write(byArray3, 0, n7);
                    n7 = 0;
                }
                System.arraycopy(byArray2, 0, byArray3, n7, n9);
                n7 += n9;
                n2 += n9;
                n6 -= n5;
                --n8;
            }
            if (n7 > 0) {
                outputStream.write(byArray3, 0, n7);
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return n2;
    }

    int unloadDataNoCompression(ImageData imageData, byte[] byArray, OutputStream outputStream) {
        int n = 0;
        try {
            int n2 = (imageData.width * imageData.depth + 7) / 8;
            n = (n2 + 3) / 4 * 4;
            int n3 = 32678 / n;
            byte[] byArray2 = new byte[n3 * n];
            if (byArray == null) {
                byArray = imageData.data;
            }
            int n4 = imageData.bytesPerLine;
            int n5 = n4 * (imageData.height - 1);
            if (imageData.depth == 16) {
                int n6 = 0;
                while (n6 < imageData.height) {
                    int n7 = imageData.height - n6;
                    if (n3 < n7) {
                        n7 = n3;
                    }
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < n7) {
                        int n10 = 0;
                        while (n10 < n2) {
                            byArray2[n8 + n10 + 1] = byArray[n5 + n10 + 1];
                            byArray2[n8 + n10] = byArray[n5 + n10];
                            n10 += 2;
                        }
                        n8 += n;
                        n5 -= n4;
                        ++n9;
                    }
                    outputStream.write(byArray2, 0, n8);
                    n6 += n3;
                }
            } else {
                int n11 = 0;
                while (n11 < imageData.height) {
                    int n12 = imageData.height - n11;
                    int n13 = n12 < n3 ? n12 : n3;
                    int n14 = 0;
                    int n15 = 0;
                    while (n15 < n13) {
                        System.arraycopy(byArray, n5, byArray2, n14, n2);
                        n14 += n;
                        n5 -= n4;
                        ++n15;
                    }
                    outputStream.write(byArray2, 0, n14);
                    n11 += n3;
                }
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return n * imageData.height;
    }

    @Override
    void unloadIntoByteStream(ImageLoader imageLoader) {
        byte[] byArray;
        int n;
        int n2;
        ImageData imageData = imageLoader.data[0];
        if (imageData.depth != 1 && imageData.depth != 4 && imageData.depth != 8 && imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32) {
            SWT.error(38);
        }
        if (!((n2 = this.compression) == 0 || n2 == 1 && imageData.depth == 8 || n2 == 2 && imageData.depth == 4)) {
            SWT.error(40);
        }
        PaletteData paletteData = imageData.palette;
        if (imageData.depth == 16 || imageData.depth == 24 || imageData.depth == 32) {
            if (!paletteData.isDirect) {
                SWT.error(40);
            }
            n = 0;
            byArray = null;
        } else {
            if (paletteData.isDirect) {
                SWT.error(40);
            }
            n = paletteData.colors.length;
            byArray = WinBMPFileFormat.paletteToBytes(paletteData);
        }
        int n3 = 54;
        int[] nArray = new int[]{19778, 0, 0, 0, n3};
        if (byArray != null) {
            nArray[4] = nArray[4] + byArray.length;
        }
        byte[] byArray2 = null;
        if (paletteData.isDirect && !this.isPaletteBMP(paletteData, imageData.depth)) {
            byArray2 = new byte[imageData.data.length];
            this.convertPixelsToBGR(imageData, byArray2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.unloadData(imageData, byArray2, byteArrayOutputStream, n2);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        nArray[1] = nArray[4] + byArray3.length;
        try {
            this.outputStream.writeShort(nArray[0]);
            this.outputStream.writeInt(nArray[1]);
            this.outputStream.writeShort(nArray[2]);
            this.outputStream.writeShort(nArray[3]);
            this.outputStream.writeInt(nArray[4]);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        try {
            this.outputStream.writeInt(40);
            this.outputStream.writeInt(imageData.width);
            this.outputStream.writeInt(imageData.height);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort((short)imageData.depth);
            this.outputStream.writeInt(n2);
            this.outputStream.writeInt(byArray3.length);
            this.outputStream.writeInt(this.pelsPerMeter.x);
            this.outputStream.writeInt(this.pelsPerMeter.y);
            this.outputStream.writeInt(n);
            this.outputStream.writeInt(this.importantColors);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (n > 0) {
            try {
                this.outputStream.write(byArray);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        try {
            this.outputStream.write(byArray3);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void flipScanLines(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = (n2 - 1) * n;
        int n5 = 0;
        while (n5 < n2 / 2) {
            int n6 = 0;
            while (n6 < n) {
                byte by = byArray[n6 + n3];
                byArray[n6 + n3] = byArray[n6 + n4];
                byArray[n6 + n4] = by;
                ++n6;
            }
            n3 += n;
            n4 -= n;
            ++n5;
        }
    }
}

