/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngChunkReader;
import org.eclipse.swt.internal.image.PngDecodingDataStream;
import org.eclipse.swt.internal.image.PngEncoder;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngIhdrChunk;
import org.eclipse.swt.internal.image.PngInputStream;
import org.eclipse.swt.internal.image.PngPlteChunk;
import org.eclipse.swt.internal.image.PngTrnsChunk;

public final class PNGFileFormat
extends FileFormat {
    static final int SIGNATURE_LENGTH = 8;
    static final int PRIME = 65521;
    PngIhdrChunk headerChunk;
    PngPlteChunk paletteChunk;
    ImageData imageData;
    byte[] data;
    byte[] alphaPalette;
    byte headerByte1;
    byte headerByte2;
    int adler;

    void readSignature() throws IOException {
        byte[] byArray = new byte[8];
        this.inputStream.read(byArray);
    }

    @Override
    ImageData[] loadFromByteStream() {
        try {
            this.readSignature();
            PngChunkReader pngChunkReader = new PngChunkReader(this.inputStream);
            this.headerChunk = pngChunkReader.getIhdrChunk();
            int n = this.headerChunk.getWidth();
            int n2 = this.headerChunk.getHeight();
            if (n <= 0 || n2 <= 0) {
                SWT.error(40);
            }
            int n3 = this.getAlignedBytesPerRow() * n2;
            this.data = new byte[n3];
            this.imageData = ImageData.internal_new(n, n2, this.headerChunk.getSwtBitsPerPixel(), new PaletteData(0, 0, 0), 4, this.data, 0, null, null, -1, -1, 5, 0, 0, 0, 0);
            if (this.headerChunk.usesDirectColor()) {
                this.imageData.palette = this.headerChunk.getPaletteData();
            }
            while (pngChunkReader.hasMoreChunks()) {
                this.readNextChunk(pngChunkReader);
            }
            return new ImageData[]{this.imageData};
        }
        catch (IOException iOException) {
            SWT.error(40);
            return null;
        }
    }

    void readNextChunk(PngChunkReader pngChunkReader) throws IOException {
        PngChunk pngChunk = pngChunkReader.readNextChunk();
        switch (pngChunk.getChunkType()) {
            case 3: {
                break;
            }
            case 1: {
                if (this.headerChunk.usesDirectColor()) break;
                this.paletteChunk = (PngPlteChunk)pngChunk;
                this.imageData.palette = this.paletteChunk.getPaletteData();
                break;
            }
            case 5: {
                PngTrnsChunk pngTrnsChunk = (PngTrnsChunk)pngChunk;
                if (pngTrnsChunk.getTransparencyType(this.headerChunk) == 0) {
                    this.imageData.transparentPixel = pngTrnsChunk.getSwtTransparentPixel(this.headerChunk);
                    break;
                }
                this.alphaPalette = pngTrnsChunk.getAlphaValues(this.headerChunk, this.paletteChunk);
                int n = 0;
                int n2 = -1;
                int n3 = 0;
                while (n3 < this.alphaPalette.length) {
                    if ((this.alphaPalette[n3] & 0xFF) != 255) {
                        ++n;
                        n2 = n3;
                    }
                    ++n3;
                }
                if (n == 0) {
                    this.alphaPalette = null;
                    break;
                }
                if (n != true || this.alphaPalette[n2] != 0) break;
                this.alphaPalette = null;
                this.imageData.transparentPixel = n2;
                break;
            }
            case 2: {
                if (pngChunkReader.readPixelData()) {
                    SWT.error(40);
                    break;
                }
                PngIdatChunk pngIdatChunk = (PngIdatChunk)pngChunk;
                this.readPixelData(pngIdatChunk, pngChunkReader);
                break;
            }
            default: {
                if (!pngChunk.isCritical()) break;
                SWT.error(20);
            }
        }
    }

    @Override
    void unloadIntoByteStream(ImageLoader imageLoader) {
        PngEncoder pngEncoder = new PngEncoder(imageLoader);
        pngEncoder.encode(this.outputStream);
    }

    @Override
    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        byte[] byArray;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        byArray = new byte[8];
                                        lEDataInputStream.read(byArray);
                                        lEDataInputStream.unread(byArray);
                                        if ((byArray[0] & 0xFF) == 137) break block9;
                                        return false;
                                    }
                                    catch (Exception exception) {
                                        return false;
                                    }
                                }
                                if ((byArray[1] & 0xFF) == 80) break block10;
                                return false;
                            }
                            if ((byArray[2] & 0xFF) == 78) break block11;
                            return false;
                        }
                        if ((byArray[3] & 0xFF) == 71) break block12;
                        return false;
                    }
                    if ((byArray[4] & 0xFF) == 13) break block13;
                    return false;
                }
                if ((byArray[5] & 0xFF) == 10) break block14;
                return false;
            }
            if ((byArray[6] & 0xFF) == 26) break block15;
            return false;
        }
        return (byArray[7] & 0xFF) == 10;
    }

    byte[] validateBitDepth(byte[] byArray) {
        if (this.headerChunk.getBitDepth() > 8) {
            byte[] byArray2 = new byte[byArray.length / 2];
            PNGFileFormat.compress16BitDepthTo8BitDepth(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    void setPixelData(byte[] byArray, ImageData imageData) {
        switch (this.headerChunk.getColorType()) {
            case 4: {
                int n = imageData.width;
                int n2 = imageData.height;
                int n3 = imageData.bytesPerLine;
                int n4 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n4 /= 2;
                }
                byte[] byArray2 = new byte[n3 * n2];
                byte[] byArray3 = new byte[n * n2];
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = n4 * n5;
                    int n7 = n3 * n5;
                    int n8 = n * n5;
                    int n9 = 0;
                    while (n9 < n) {
                        byte by = byArray[n6];
                        byte by2 = byArray[n6 + 1];
                        byArray2[n7 + 0] = by;
                        byArray2[n7 + 1] = by;
                        byArray2[n7 + 2] = by;
                        byArray3[n8] = by2;
                        n6 += 2;
                        n7 += 3;
                        ++n8;
                        ++n9;
                    }
                    ++n5;
                }
                imageData.data = byArray2;
                imageData.alphaData = byArray3;
                break;
            }
            case 6: {
                int n = imageData.width;
                int n10 = imageData.height;
                int n11 = imageData.bytesPerLine;
                int n12 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n12 /= 2;
                }
                byte[] byArray4 = new byte[n11 * n10];
                byte[] byArray5 = new byte[n * n10];
                int n13 = 0;
                while (n13 < n10) {
                    int n14 = n12 * n13;
                    int n15 = n11 * n13;
                    int n16 = n * n13;
                    int n17 = 0;
                    while (n17 < n) {
                        byArray4[n15 + 0] = byArray[n14 + 0];
                        byArray4[n15 + 1] = byArray[n14 + 1];
                        byArray4[n15 + 2] = byArray[n14 + 2];
                        byArray5[n16] = byArray[n14 + 3];
                        n14 += 4;
                        n15 += 3;
                        ++n16;
                        ++n17;
                    }
                    ++n13;
                }
                imageData.data = byArray4;
                imageData.alphaData = byArray5;
                break;
            }
            case 3: {
                imageData.data = byArray;
                if (this.alphaPalette == null) break;
                int n = imageData.width * imageData.height;
                byte[] byArray6 = new byte[n];
                byte[] byArray7 = new byte[n];
                imageData.getPixels(0, 0, n, byArray7, 0);
                int n18 = 0;
                while (n18 < byArray7.length) {
                    byArray6[n18] = this.alphaPalette[byArray7[n18] & 0xFF];
                    ++n18;
                }
                imageData.alphaData = byArray6;
                break;
            }
            default: {
                int n = imageData.height;
                int n19 = imageData.bytesPerLine;
                int n20 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n20 /= 2;
                }
                if (n19 != n20) {
                    int n21 = 0;
                    while (n21 < n) {
                        System.arraycopy(byArray, n21 * n20, imageData.data, n21 * n19, n20);
                        ++n21;
                    }
                    break;
                }
                imageData.data = byArray;
            }
        }
    }

    void setImageDataValues(byte[] byArray, ImageData imageData) {
        byte[] byArray2 = this.validateBitDepth(byArray);
        this.setPixelData(byArray2, imageData);
    }

    void readPixelData(PngIdatChunk pngIdatChunk, PngChunkReader pngChunkReader) throws IOException {
        InputStream inputStream = new PngInputStream(pngIdatChunk, pngChunkReader);
        boolean bl = System.getProperty("org.eclipse.swt.internal.image.PNGFileFormat_3.2") != null;
        BufferedInputStream bufferedInputStream = bl ? null : new BufferedInputStream(new InflaterInputStream(inputStream));
        inputStream = bufferedInputStream != null ? bufferedInputStream : new PngDecodingDataStream(inputStream);
        byte by = this.headerChunk.getInterlaceMethod();
        if (by == 0) {
            this.readNonInterlacedImage(inputStream);
        } else {
            this.readInterlacedImage(inputStream);
        }
        while (inputStream.available() > 0) {
            inputStream.read();
        }
        inputStream.close();
    }

    int getAlignedBytesPerRow() {
        return (this.getBytesPerRow(this.headerChunk.getWidth()) + 3) / 4 * 4;
    }

    int getBytesPerRow() {
        return this.getBytesPerRow(this.headerChunk.getWidth());
    }

    int getBytesPerPixel() {
        int n = this.headerChunk.getBitsPerPixel();
        return (n + 7) / 8;
    }

    int getBytesPerRow(int n) {
        int n2 = this.headerChunk.getBitsPerPixel();
        int n3 = n2 * n;
        int n4 = 8;
        return (n3 + (n4 - 1)) / n4;
    }

    void readInterlaceFrame(InputStream inputStream, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6 = this.headerChunk.getWidth();
        int n7 = this.getAlignedBytesPerRow();
        int n8 = this.headerChunk.getHeight();
        if (n3 >= n8 || n4 >= n6) {
            return;
        }
        int n9 = (n6 - n4 + n2 - 1) / n2;
        int n10 = this.getBytesPerRow(n9);
        byte[] byArray = new byte[n10];
        byte[] byArray2 = new byte[n10];
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n11 = n3;
        while (n11 < n8) {
            int n12;
            int n13;
            int n14;
            int n15;
            byte by = (byte)inputStream.read();
            int n16 = 0;
            while (n16 != n10) {
                n16 += inputStream.read(byArray3, n16, n10 - n16);
            }
            this.filterRow(byArray3, byArray4, by);
            if (this.headerChunk.getBitDepth() >= 8) {
                n15 = this.getBytesPerPixel();
                n14 = n11 * n7 + n4 * n15;
                n13 = 0;
                while (n13 < byArray3.length) {
                    n12 = 0;
                    while (n12 < n15) {
                        this.data[n14 + n12] = byArray3[n13 + n12];
                        ++n12;
                    }
                    n14 += n2 * n15;
                    n13 += n15;
                }
            } else {
                n15 = this.headerChunk.getBitDepth();
                n14 = 8 / n15;
                n13 = n4;
                n12 = n11 * n7;
                int n17 = 0;
                int n18 = 0;
                while (n18 < n15) {
                    n17 <<= 1;
                    n17 |= 1;
                    ++n18;
                }
                n18 = 8 - n15;
                int n19 = 0;
                while (n19 < byArray3.length) {
                    int n20 = n18;
                    while (n20 >= 0) {
                        if (n13 < n6) {
                            int n21 = n12 + n13 * n15 / 8;
                            int n22 = byArray3[n19] >> n20 & n17;
                            int n23 = n18 - n15 * (n13 % n14);
                            int n24 = n21;
                            this.data[n24] = (byte)(this.data[n24] | n22 << n23);
                        }
                        n13 += n2;
                        n20 -= n15;
                    }
                    ++n19;
                }
            }
            byArray3 = byArray3 == byArray ? byArray2 : byArray;
            byArray4 = byArray4 == byArray ? byArray2 : byArray;
            n11 += n;
        }
        this.setImageDataValues(this.data, this.imageData);
        this.fireInterlacedFrameEvent(n5);
    }

    void readInterlacedImage(InputStream inputStream) throws IOException {
        this.readInterlaceFrame(inputStream, 8, 8, 0, 0, 0);
        this.readInterlaceFrame(inputStream, 8, 8, 0, 4, 1);
        this.readInterlaceFrame(inputStream, 8, 4, 4, 0, 2);
        this.readInterlaceFrame(inputStream, 4, 4, 0, 2, 3);
        this.readInterlaceFrame(inputStream, 4, 2, 2, 0, 4);
        this.readInterlaceFrame(inputStream, 2, 2, 0, 1, 5);
        this.readInterlaceFrame(inputStream, 2, 1, 1, 0, 6);
    }

    void fireInterlacedFrameEvent(int n) {
        if (this.loader.hasListeners()) {
            ImageData imageData = (ImageData)this.imageData.clone();
            boolean bl = n == 6;
            this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n, bl));
        }
    }

    void readNonInterlacedImage(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = this.getAlignedBytesPerRow();
        int n3 = this.getBytesPerRow();
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n4 = this.headerChunk.getHeight();
        int n5 = 0;
        while (n5 < n4) {
            byte by = (byte)inputStream.read();
            int n6 = 0;
            while (n6 != n3) {
                n6 += inputStream.read(byArray3, n6, n3 - n6);
            }
            this.filterRow(byArray3, byArray4, by);
            System.arraycopy(byArray3, 0, this.data, n, n3);
            n += n2;
            byArray3 = byArray3 == byArray ? byArray2 : byArray;
            byArray4 = byArray4 == byArray ? byArray2 : byArray;
            ++n5;
        }
        this.setImageDataValues(this.data, this.imageData);
    }

    static void compress16BitDepthTo8BitDepth(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byte by;
            int n5 = n + 2 * n4;
            int n6 = n2 + n4;
            byArray2[n6] = by = byArray[n5];
            ++n4;
        }
    }

    static int compress16BitDepthTo8BitDepth(int n) {
        return n >> 8;
    }

    void filterRow(byte[] byArray, byte[] byArray2, int n) {
        int n2 = this.headerChunk.getFilterByteOffset();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                int n3 = n2;
                while (n3 < byArray.length) {
                    int n4 = byArray[n3] & 0xFF;
                    int n5 = byArray[n3 - n2] & 0xFF;
                    byArray[n3] = (byte)(n4 + n5 & 0xFF);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n6 = 0;
                while (n6 < byArray.length) {
                    int n7 = byArray[n6] & 0xFF;
                    int n8 = byArray2[n6] & 0xFF;
                    byArray[n6] = (byte)(n7 + n8 & 0xFF);
                    ++n6;
                }
                break;
            }
            case 3: {
                int n9 = 0;
                while (n9 < byArray.length) {
                    int n10 = n9 < n2 ? 0 : byArray[n9 - n2] & 0xFF;
                    int n11 = byArray2[n9] & 0xFF;
                    int n12 = byArray[n9] & 0xFF;
                    byArray[n9] = (byte)(n12 + (n10 + n11) / 2 & 0xFF);
                    ++n9;
                }
                break;
            }
            case 4: {
                int n13 = 0;
                while (n13 < byArray.length) {
                    int n14 = n13 < n2 ? 0 : byArray[n13 - n2] & 0xFF;
                    int n15 = n13 < n2 ? 0 : byArray2[n13 - n2] & 0xFF;
                    int n16 = byArray2[n13] & 0xFF;
                    int n17 = Math.abs(n16 - n15);
                    int n18 = Math.abs(n14 - n15);
                    int n19 = Math.abs(n14 - n15 + n16 - n15);
                    int n20 = 0;
                    n20 = n17 <= n18 && n17 <= n19 ? n14 : (n18 <= n19 ? n16 : n15);
                    int n21 = byArray[n13] & 0xFF;
                    byArray[n13] = (byte)(n21 + n20 & 0xFF);
                    ++n13;
                }
                break;
            }
        }
    }
}

