/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;

public class ImageList {
    long handle;
    int style;
    int refCount;
    Image[] images;

    public ImageList(int n) {
        this(n, 32, 32);
    }

    public ImageList(int n, int n2, int n3) {
        this.style = n;
        int n4 = 1;
        if (OS.IsWinCE) {
            n4 |= 0;
        } else if (OS.COMCTL32_MAJOR >= 6) {
            n4 |= 0x20;
        } else {
            long l = OS.GetDC(0L);
            int n5 = OS.GetDeviceCaps(l, 12);
            int n6 = OS.GetDeviceCaps(l, 14);
            OS.ReleaseDC(0L, l);
            int n7 = n5 * n6;
            switch (n7) {
                case 4: {
                    n4 |= 4;
                    break;
                }
                case 8: {
                    n4 |= 8;
                    break;
                }
                case 16: {
                    n4 |= 0x10;
                    break;
                }
                case 24: {
                    n4 |= 0x18;
                    break;
                }
                case 32: {
                    n4 |= 0x20;
                    break;
                }
                default: {
                    n4 |= 0;
                }
            }
        }
        if ((n & 0x4000000) != 0) {
            n4 |= 0x2000;
        }
        this.handle = OS.ImageList_Create(n2, n3, n4, 16, 16);
        this.images = new Image[4];
    }

    public int add(Image image) {
        Image[] imageArray;
        int n = OS.ImageList_GetImageCount(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.images[n2] != null && this.images[n2].isDisposed()) {
                this.images[n2] = null;
            }
            if (this.images[n2] == null) break;
            ++n2;
        }
        if (n == 0) {
            imageArray = image.getBoundsInPixels();
            OS.ImageList_SetIconSize(this.handle, imageArray.width, imageArray.height);
        }
        this.set(n2, image, n);
        if (n2 == this.images.length) {
            imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
        this.images[n2] = image;
        return n2;
    }

    public int addRef() {
        return ++this.refCount;
    }

    long copyBitmap(long l, int n, int n2) {
        long l2;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(l, BITMAP.sizeof, bITMAP);
        long l3 = OS.GetDC(0L);
        long l4 = OS.CreateCompatibleDC(l3);
        OS.SelectObject(l4, l);
        long l5 = OS.CreateCompatibleDC(l3);
        if (bITMAP.bmBitsPixel == 32 && OS.COMCTL32_MAJOR >= 6) {
            BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
            bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER.biWidth = n;
            bITMAPINFOHEADER.biHeight = -n2;
            bITMAPINFOHEADER.biPlanes = 1;
            bITMAPINFOHEADER.biBitCount = (short)24;
            bITMAPINFOHEADER.biCompression = OS.IsWinCE ? 3 : 0;
            byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + (OS.IsWinCE ? 12 : 0)];
            OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
            if (OS.IsWinCE) {
                int n3 = 65280;
                int n4 = 0xFF0000;
                int n5 = -16777216;
                int n6 = BITMAPINFOHEADER.sizeof;
                byArray[n6] = (byte)((n3 & 0xFF000000) >> 24);
                byArray[n6 + 1] = (byte)((n3 & 0xFF0000) >> 16);
                byArray[n6 + 2] = (byte)((n3 & 0xFF00) >> 8);
                byArray[n6 + 3] = (byte)((n3 & 0xFF) >> 0);
                byArray[n6 + 4] = (byte)((n4 & 0xFF000000) >> 24);
                byArray[n6 + 5] = (byte)((n4 & 0xFF0000) >> 16);
                byArray[n6 + 6] = (byte)((n4 & 0xFF00) >> 8);
                byArray[n6 + 7] = (byte)((n4 & 0xFF) >> 0);
                byArray[n6 + 8] = (byte)((n5 & 0xFF000000) >> 24);
                byArray[n6 + 9] = (byte)((n5 & 0xFF0000) >> 16);
                byArray[n6 + 10] = (byte)((n5 & 0xFF00) >> 8);
                byArray[n6 + 11] = (byte)((n5 & 0xFF) >> 0);
            }
            long[] lArray = new long[1];
            l2 = OS.CreateDIBSection(0L, byArray, 0, lArray, 0L, 0);
        } else {
            l2 = OS.CreateCompatibleBitmap(l3, n, n2);
        }
        OS.SelectObject(l5, l2);
        if (n != bITMAP.bmWidth || n2 != bITMAP.bmHeight) {
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(l5, 3);
            }
            OS.StretchBlt(l5, 0, 0, n, n2, l4, 0, 0, bITMAP.bmWidth, bITMAP.bmHeight, 0xCC0020);
        } else {
            OS.BitBlt(l5, 0, 0, n, n2, l4, 0, 0, 0xCC0020);
        }
        OS.DeleteDC(l4);
        OS.DeleteDC(l5);
        OS.ReleaseDC(0L, l3);
        return l2;
    }

    long copyIcon(long l, int n, int n2) {
        long l2;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        return (l2 = OS.CopyImage(l, 1, n, n2, 0)) != 0L ? l2 : l;
    }

    long copyWithAlpha(long l, int n, byte[] byArray, int n2, int n3) {
        int n4;
        byte by;
        byte by2;
        int n5;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(l, BITMAP.sizeof, bITMAP);
        int n6 = bITMAP.bmWidth;
        int n7 = bITMAP.bmHeight;
        long l2 = OS.GetDC(0L);
        long l3 = OS.CreateCompatibleDC(l2);
        long l4 = OS.SelectObject(l3, l);
        long l5 = OS.CreateCompatibleDC(l2);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n6;
        bITMAPINFOHEADER.biHeight = -n7;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray2 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray2, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        long[] lArray = new long[1];
        long l6 = OS.CreateDIBSection(0L, byArray2, 0, lArray, 0L, 0);
        if (l6 == 0L) {
            SWT.error(2);
        }
        long l7 = OS.SelectObject(l5, l6);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject(l6, BITMAP.sizeof, bITMAP2);
        int n8 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt(l5, 0, 0, n6, n7, l3, 0, 0, 0xCC0020);
        byte[] byArray3 = new byte[n8];
        OS.MoveMemory(byArray3, bITMAP2.bmBits, n8);
        if (byArray != null) {
            n5 = bITMAP2.bmWidthBytes - n6 * 4;
            by2 = 0;
            by = 3;
            n4 = 0;
            while (n4 < n7) {
                int n9 = 0;
                while (n9 < n6) {
                    byte by3 = by2;
                    by2 = (byte)(by2 + 1);
                    byArray3[by] = byArray[by3];
                    by += 4;
                    ++n9;
                }
                by += n5;
                ++n4;
            }
        } else {
            n5 = n & 0xFF;
            by2 = (byte)(n >> 8 & 0xFF);
            by = (byte)(n >> 16 & 0xFF);
            n4 = bITMAP2.bmWidthBytes - n6 * 4;
            int n10 = 3;
            int n11 = 0;
            while (n11 < n7) {
                int n12 = 0;
                while (n12 < n6) {
                    byArray3[n10] = byArray3[n10 - 1] == n5 && byArray3[n10 - 2] == by2 && byArray3[n10 - 3] == by ? 0 : -1;
                    n10 += 4;
                    ++n12;
                }
                n10 += n4;
                ++n11;
            }
        }
        OS.MoveMemory(bITMAP2.bmBits, byArray3, n8);
        if (n6 != n2 || n7 != n3) {
            BITMAPINFOHEADER bITMAPINFOHEADER2 = new BITMAPINFOHEADER();
            bITMAPINFOHEADER2.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER2.biWidth = n2;
            bITMAPINFOHEADER2.biHeight = -n3;
            bITMAPINFOHEADER2.biPlanes = 1;
            bITMAPINFOHEADER2.biBitCount = (short)32;
            bITMAPINFOHEADER2.biCompression = 0;
            byte[] byArray4 = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(byArray4, bITMAPINFOHEADER2, BITMAPINFOHEADER.sizeof);
            long[] lArray2 = new long[1];
            long l8 = OS.CreateDIBSection(0L, byArray4, 0, lArray2, 0L, 0);
            long l9 = OS.CreateCompatibleDC(l2);
            long l10 = OS.SelectObject(l9, l8);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(l9, 3);
            }
            OS.StretchBlt(l9, 0, 0, n2, n3, l5, 0, 0, n6, n7, 0xCC0020);
            OS.SelectObject(l9, l10);
            OS.DeleteDC(l9);
            OS.SelectObject(l5, l7);
            OS.DeleteDC(l5);
            OS.DeleteObject(l6);
            l6 = l8;
        } else {
            OS.SelectObject(l5, l7);
            OS.DeleteDC(l5);
        }
        OS.SelectObject(l3, l4);
        OS.DeleteDC(l3);
        OS.ReleaseDC(0L, l2);
        return l6;
    }

    long createMaskFromAlpha(ImageData imageData, int n, int n2) {
        int n3 = imageData.width;
        int n4 = imageData.height;
        ImageData imageData2 = ImageData.internal_new(n3, n4, 1, new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255)), 2, null, 1, null, null, -1, -1, -1, 0, 0, 0, 0);
        int n5 = 0;
        int n6 = 0;
        while (n6 < imageData2.height) {
            int n7 = 0;
            while (n7 < imageData2.width) {
                imageData2.setPixel(n7, n6, (imageData.alphaData[n5++] & 0xFF) <= 127 ? 1 : 0);
                ++n7;
            }
            ++n6;
        }
        long l = OS.CreateBitmap(n3, n4, 1, 1, imageData2.data);
        if (n3 != n || n4 != n2) {
            long l2 = OS.GetDC(0L);
            long l3 = OS.CreateCompatibleDC(l2);
            OS.SelectObject(l3, l);
            long l4 = OS.CreateCompatibleDC(l2);
            long l5 = OS.CreateBitmap(n, n2, 1, 1, null);
            OS.SelectObject(l4, l5);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(l4, 3);
            }
            OS.StretchBlt(l4, 0, 0, n, n2, l3, 0, 0, n3, n4, 0xCC0020);
            OS.DeleteDC(l3);
            OS.DeleteDC(l4);
            OS.ReleaseDC(0L, l2);
            OS.DeleteObject(l);
            l = l5;
        }
        return l;
    }

    long createMask(long l, int n, int n2, int n3, int n4) {
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(l, BITMAP.sizeof, bITMAP);
        int n5 = bITMAP.bmWidth;
        int n6 = bITMAP.bmHeight;
        long l2 = OS.CreateBitmap(n, n2, 1, 1, null);
        long l3 = OS.GetDC(0L);
        long l4 = OS.CreateCompatibleDC(l3);
        if (n3 != -1) {
            OS.SelectObject(l4, l);
            boolean bl = bITMAP.bmBits != 0L;
            byte[] byArray = null;
            if (!OS.IsWinCE && n4 != -1 && bl && bITMAP.bmBitsPixel <= 8) {
                int n7 = 1 << bITMAP.bmBitsPixel;
                byte[] byArray2 = new byte[n7 * 4];
                OS.GetDIBColorTable(l4, 0, n7, byArray2);
                int n8 = n4 * 4;
                byte[] byArray3 = new byte[byArray2.length];
                byArray3[n8] = -1;
                byArray3[n8 + 1] = -1;
                byArray3[n8 + 2] = -1;
                OS.SetDIBColorTable(l4, 0, n7, byArray3);
                byArray = byArray2;
                OS.SetBkColor(l4, 0xFFFFFF);
            } else {
                OS.SetBkColor(l4, n3);
            }
            long l5 = OS.CreateCompatibleDC(l3);
            OS.SelectObject(l5, l2);
            if (n != n5 || n2 != n6) {
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(l5, 3);
                }
                OS.StretchBlt(l5, 0, 0, n, n2, l4, 0, 0, n5, n6, 0xCC0020);
            } else {
                OS.BitBlt(l5, 0, 0, n, n2, l4, 0, 0, 0xCC0020);
            }
            OS.DeleteDC(l5);
            if (byArray != null) {
                OS.SetDIBColorTable(l4, 0, 1 << bITMAP.bmBitsPixel, byArray);
            }
        } else {
            long l6 = OS.SelectObject(l4, l2);
            OS.PatBlt(l4, 0, 0, n, n2, 66);
            OS.SelectObject(l4, l6);
        }
        OS.ReleaseDC(0L, l3);
        OS.DeleteDC(l4);
        return l2;
    }

    public void dispose() {
        if (this.handle != 0L) {
            OS.ImageList_Destroy(this.handle);
        }
        this.handle = 0L;
        this.images = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    public int getStyle() {
        return this.style;
    }

    public long getHandle() {
        return this.handle;
    }

    public Point getImageSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public int indexOf(Image image) {
        int n = OS.ImageList_GetImageCount(this.handle);
        int n2 = 0;
        while (n2 < n) {
            if (this.images[n2] != null) {
                if (this.images[n2].isDisposed()) {
                    this.images[n2] = null;
                }
                if (this.images[n2] != null && this.images[n2].equals(image)) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    public void put(int n, Image image) {
        int n2 = OS.ImageList_GetImageCount(this.handle);
        if (n < 0 || n >= n2) {
            return;
        }
        if (image != null) {
            this.set(n, image, n2);
        }
        this.images[n] = image;
    }

    public void remove(int n) {
        int n2 = OS.ImageList_GetImageCount(this.handle);
        if (n < 0 || n >= n2) {
            return;
        }
        OS.ImageList_Remove(this.handle, n);
        System.arraycopy(this.images, n + 1, this.images, n, --n2 - n);
        this.images[n] = null;
    }

    public int removeRef() {
        return --this.refCount;
    }

    void set(int n, Image image, int n2) {
        long l = image.handle;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(this.handle, nArray, nArray2);
        switch (image.type) {
            case 0: {
                long l2 = 0L;
                long l3 = 0L;
                ImageData imageData = image.getImageDataAtCurrentZoom();
                switch (imageData.getTransparencyType()) {
                    case 1: {
                        boolean bl = true;
                        if (imageData.alphaData == null) {
                            bl = false;
                        } else {
                            byte[] byArray = imageData.alphaData;
                            int n3 = imageData.alphaData.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                byte by = byArray[n4];
                                if (by != 0) {
                                    bl = false;
                                    break;
                                }
                                ++n4;
                            }
                        }
                        if (OS.COMCTL32_MAJOR >= 6 && !bl) {
                            l2 = this.copyWithAlpha(l, -1, imageData.alphaData, nArray[0], nArray2[0]);
                            break;
                        }
                        l2 = this.copyBitmap(l, nArray[0], nArray2[0]);
                        l3 = this.createMaskFromAlpha(imageData, nArray[0], nArray2[0]);
                        break;
                    }
                    case 4: {
                        int n5 = -1;
                        Color color = image.getBackground();
                        if (color != null) {
                            n5 = color.handle;
                        }
                        l2 = this.copyBitmap(l, nArray[0], nArray2[0]);
                        l3 = this.createMask(l, nArray[0], nArray2[0], n5, imageData.transparentPixel);
                        break;
                    }
                    default: {
                        l2 = this.copyBitmap(l, nArray[0], nArray2[0]);
                        if (n == n2) break;
                        l3 = this.createMask(l, nArray[0], nArray2[0], -1, -1);
                    }
                }
                if (n == n2) {
                    OS.ImageList_Add(this.handle, l2, l3);
                } else {
                    OS.ImageList_Replace(this.handle, n, l2, l3);
                }
                if (l3 != 0L) {
                    OS.DeleteObject(l3);
                }
                if (l2 == l) break;
                OS.DeleteObject(l2);
                break;
            }
            case 1: {
                if (OS.IsWinCE) {
                    OS.ImageList_ReplaceIcon(this.handle, n == n2 ? -1 : n, l);
                    break;
                }
                long l4 = this.copyIcon(l, nArray[0], nArray2[0]);
                OS.ImageList_ReplaceIcon(this.handle, n == n2 ? -1 : n, l4);
                OS.DestroyIcon(l4);
            }
        }
    }

    public int size() {
        int n = 0;
        int n2 = OS.ImageList_GetImageCount(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            if (this.images[n3] != null) {
                if (this.images[n3].isDisposed()) {
                    this.images[n3] = null;
                }
                if (this.images[n3] != null) {
                    ++n;
                }
            }
            ++n3;
        }
        return n;
    }
}

