/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;

public class BidiUtil {
    public static final int KEYBOARD_NON_BIDI = 0;
    public static final int KEYBOARD_BIDI = 1;
    static int isBidiPlatform = -1;
    public static final int CLASSIN = 1;
    public static final int LINKBEFORE = 2;
    public static final int LINKAFTER = 4;
    static Map<LONG, Runnable> languageMap = new HashMap<LONG, Runnable>();
    static Map<LONG, LONG> oldProcMap = new HashMap<LONG, LONG>();
    static final String CLASS_NAME = "org.eclipse.swt.internal.BidiUtil";
    static Callback callback;
    static final int GCP_REORDER = 2;
    static final int GCP_GLYPHSHAPE = 16;
    static final int GCP_LIGATE = 32;
    static final int GCP_CLASSIN = 524288;
    static final byte GCPCLASS_ARABIC = 2;
    static final byte GCPCLASS_HEBREW = 2;
    static final byte GCPCLASS_LOCALNUMBER = 4;
    static final byte GCPCLASS_LATINNUMBER = 5;
    static final int GCPGLYPH_LINKBEFORE = 32768;
    static final int GCPGLYPH_LINKAFTER = 16384;
    static final int ETO_CLIPPED = 4;
    static final int ETO_GLYPH_INDEX = 16;
    static final int LANG_ARABIC = 1;
    static final int LANG_HEBREW = 13;
    static final int LANG_FARSI = 41;
    static final String CD_PG_HEBREW = "1255";
    static final String CD_PG_ARABIC = "1256";
    static final int HKL_NEXT = 1;
    static final int HKL_PREV = 0;
    public static final int CLASS_HEBREW = 2;
    public static final int CLASS_ARABIC = 2;
    public static final int CLASS_LOCALNUMBER = 4;
    public static final int CLASS_LATINNUMBER = 5;
    public static final int REORDER = 2;
    public static final int LIGATE = 32;
    public static final int GLYPHSHAPE = 16;

    static {
        try {
            callback = new Callback(Class.forName(CLASS_NAME), "windowProc", 4);
            if (callback.getAddress() == 0L) {
                SWT.error(3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public static void addLanguageListener(long l, Runnable runnable) {
        languageMap.put(new LONG(l), runnable);
        BidiUtil.subclass(l);
    }

    public static void addLanguageListener(Control control, Runnable runnable) {
        BidiUtil.addLanguageListener(control.handle, runnable);
    }

    static long EnumSystemLanguageGroupsProc(long l, long l2, long l3, long l4, long l5) {
        if ((int)l == 12) {
            isBidiPlatform = 1;
            return 0L;
        }
        if ((int)l == 13) {
            isBidiPlatform = 1;
            return 0L;
        }
        return 1L;
    }

    public static void drawGlyphs(GC gC, char[] cArray, int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && OS.GetLayout(gC.handle) != 0) {
            BidiUtil.reverse(nArray);
            int n4 = n3 - 1;
            nArray[n4] = nArray[n4] - 1;
            BidiUtil.reverse(cArray);
        }
        int n5 = OS.SetBkMode(gC.handle, 1);
        OS.ExtTextOutW(gC.handle, n, n2, 16, null, cArray, cArray.length, nArray);
        OS.SetBkMode(gC.handle, n5);
    }

    public static char[] getRenderInfo(GC gC, String string, int[] nArray, byte[] byArray, int[] nArray2, int n, int[] nArray3) {
        int n2 = OS.GetFontLanguageInfo(gC.handle);
        long l = OS.GetProcessHeap();
        int[] nArray4 = new int[8];
        int n3 = OS.GetTextCharset(gC.handle);
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl = OS.GetLayout(gC.handle) != 0;
        }
        OS.TranslateCharsetInfo(n3, nArray4, 1);
        TCHAR tCHAR = new TCHAR(nArray4[1], string, false);
        int n4 = tCHAR.length();
        boolean bl2 = (n & 2) == 2;
        boolean bl3 = (n & 4) == 4;
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n4;
        long l2 = gCP_RESULTS.lpOrder = OS.HeapAlloc(l, 8, n4 * 4);
        long l3 = gCP_RESULTS.lpDx = OS.HeapAlloc(l, 8, n4 * 4);
        long l4 = gCP_RESULTS.lpClass = OS.HeapAlloc(l, 8, n4);
        long l5 = gCP_RESULTS.lpGlyphs = OS.HeapAlloc(l, 8, n4 * 2);
        int n5 = 0;
        int n6 = 0;
        n5 |= 2;
        if ((n2 & 0x20) == 32) {
            n5 |= 0x20;
            n6 |= 0;
        }
        if ((n2 & 0x10) == 16) {
            n5 |= 0x10;
            if (bl2) {
                n6 |= 0x8000;
            }
            if (bl3) {
                n6 |= 0x4000;
            }
        }
        byte[] byArray2 = bl2 || bl3 ? new byte[]{(byte)n6, (byte)(n6 >> 8)} : new byte[]{(byte)n6};
        OS.MoveMemory(gCP_RESULTS.lpGlyphs, byArray2, byArray2.length);
        if ((n & 1) == 1) {
            n5 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        char[] cArray = new char[gCP_RESULTS.nGlyphs];
        int n7 = 0;
        int n8 = 0;
        while (n8 < nArray3.length - 1) {
            Object[] objectArray;
            int n9;
            int n10 = nArray3[n8];
            gCP_RESULTS.nGlyphs = n9 = nArray3[n8 + 1] - nArray3[n8];
            TCHAR tCHAR2 = new TCHAR(nArray4[1], string.substring(n10, n10 + n9), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n5);
            if (nArray2 != null) {
                objectArray = new int[gCP_RESULTS.nGlyphs];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpDx, objectArray.length * 4);
                if (bl) {
                    BidiUtil.reverse(objectArray);
                }
                System.arraycopy(objectArray, 0, nArray2, n7, objectArray.length);
            }
            if (nArray != null) {
                objectArray = new int[n9];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n7, bl);
                System.arraycopy(objectArray, 0, nArray, n10, n9);
            }
            if (byArray != null) {
                objectArray = new byte[n9];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n10, n9);
            }
            objectArray = new char[gCP_RESULTS.nGlyphs];
            OS.MoveMemory((char[])objectArray, gCP_RESULTS.lpGlyphs, objectArray.length * 2);
            if (bl) {
                BidiUtil.reverse((char[])objectArray);
            }
            System.arraycopy(objectArray, 0, cArray, n7, objectArray.length);
            n7 += objectArray.length;
            gCP_RESULTS.lpOrder += (long)(n9 * 4);
            gCP_RESULTS.lpDx += (long)(n9 * 4);
            gCP_RESULTS.lpClass += (long)n9;
            gCP_RESULTS.lpGlyphs += (long)(objectArray.length * 2);
            ++n8;
        }
        OS.HeapFree(l, 0, l5);
        OS.HeapFree(l, 0, l4);
        OS.HeapFree(l, 0, l3);
        OS.HeapFree(l, 0, l2);
        return cArray;
    }

    public static void getOrderInfo(GC gC, String string, int[] nArray, byte[] byArray, int n, int[] nArray2) {
        int n2 = OS.GetFontLanguageInfo(gC.handle);
        long l = OS.GetProcessHeap();
        int[] nArray3 = new int[8];
        int n3 = OS.GetTextCharset(gC.handle);
        OS.TranslateCharsetInfo(n3, nArray3, 1);
        TCHAR tCHAR = new TCHAR(nArray3[1], string, false);
        int n4 = tCHAR.length();
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl = OS.GetLayout(gC.handle) != 0;
        }
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n4;
        long l2 = gCP_RESULTS.lpOrder = OS.HeapAlloc(l, 8, n4 * 4);
        long l3 = gCP_RESULTS.lpClass = OS.HeapAlloc(l, 8, n4);
        int n5 = 0;
        n5 |= 2;
        if ((n2 & 0x20) == 32) {
            n5 |= 0x20;
        }
        if ((n2 & 0x10) == 16) {
            n5 |= 0x10;
        }
        if ((n & 1) == 1) {
            n5 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < nArray2.length - 1) {
            Object[] objectArray;
            int n8;
            int n9 = nArray2[n7];
            gCP_RESULTS.nGlyphs = n8 = nArray2[n7 + 1] - nArray2[n7];
            TCHAR tCHAR2 = new TCHAR(nArray3[1], string.substring(n9, n9 + n8), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n5);
            if (nArray != null) {
                objectArray = new int[n8];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n6, bl);
                System.arraycopy(objectArray, 0, nArray, n9, n8);
            }
            if (byArray != null) {
                objectArray = new byte[n8];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n9, n8);
            }
            n6 += gCP_RESULTS.nGlyphs;
            gCP_RESULTS.lpOrder += (long)(n8 * 4);
            gCP_RESULTS.lpClass += (long)n8;
            ++n7;
        }
        OS.HeapFree(l, 0, l3);
        OS.HeapFree(l, 0, l2);
    }

    public static int getFontBidiAttributes(GC gC) {
        int n = 0;
        int n2 = OS.GetFontLanguageInfo(gC.handle);
        if ((n2 & 2) != 0) {
            n |= 2;
        }
        if ((n2 & 0x20) != 0) {
            n |= 0x20;
        }
        if ((n2 & 0x10) != 0) {
            n |= 0x10;
        }
        return n;
    }

    public static int getKeyboardLanguage() {
        long l = OS.GetKeyboardLayout(0);
        return BidiUtil.isBidiLang(l) ? 1 : 0;
    }

    static long[] getKeyboardLanguageList() {
        int n = 10;
        long[] lArray = new long[n];
        int n2 = OS.GetKeyboardLayoutList(n, lArray);
        long[] lArray2 = new long[n2];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }

    static boolean isBidiLang(long l) {
        short s = OS.PRIMARYLANGID(OS.LOWORD(l));
        return s == 1 || s == 13 || s == 41;
    }

    public static boolean isBidiPlatform() {
        if (OS.IsWinCE) {
            return false;
        }
        if (isBidiPlatform != -1) {
            return isBidiPlatform == 1;
        }
        isBidiPlatform = 0;
        if (!BidiUtil.isKeyboardBidi()) {
            return false;
        }
        Callback callback = null;
        try {
            callback = new Callback(Class.forName(CLASS_NAME), "EnumSystemLanguageGroupsProc", 5);
            long l = callback.getAddress();
            if (l == 0L) {
                SWT.error(3);
            }
            OS.EnumSystemLanguageGroups(l, 1, 0L);
            callback.dispose();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (isBidiPlatform == 1) {
            return true;
        }
        String string = String.valueOf(OS.GetACP());
        if (CD_PG_ARABIC.equals(string) || CD_PG_HEBREW.equals(string)) {
            isBidiPlatform = 1;
        }
        return isBidiPlatform == 1;
    }

    public static boolean isKeyboardBidi() {
        long[] lArray = BidiUtil.getKeyboardLanguageList();
        int n = 0;
        while (n < lArray.length) {
            if (BidiUtil.isBidiLang(lArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void removeLanguageListener(long l) {
        languageMap.remove(new LONG(l));
        BidiUtil.unsubclass(l);
    }

    public static void removeLanguageListener(Control control) {
        BidiUtil.removeLanguageListener(control.handle);
    }

    public static int resolveTextDirection(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char[] cArray = new char[]{' ', ' ', '1'};
        char[] cArray2 = new char[]{'\u202b', 'a', ' '};
        char[] cArray3 = new char[]{'\u05d0', ' ', ' '};
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        int n2 = gCP_RESULTS.nGlyphs = cArray2.length;
        long l = OS.GetProcessHeap();
        long l2 = gCP_RESULTS.lpOrder = OS.HeapAlloc(l, 8, n2 * 4);
        long l3 = OS.GetDC(0L);
        int[] nArray = new int[1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c;
            cArray[0] = c = string.charAt(n4);
            OS.GetCharacterPlacementW(l3, cArray, cArray.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder, 4);
            if (nArray[0] == 2) {
                n3 = 0x4000000;
                break;
            }
            cArray2[2] = c;
            OS.GetCharacterPlacementW(l3, cArray2, cArray2.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder + 4L, 4);
            if (nArray[0] == 1) {
                cArray3[2] = c;
                OS.GetCharacterPlacementW(l3, cArray3, cArray3.length, 0, gCP_RESULTS, 2);
                OS.MoveMemory(nArray, gCP_RESULTS.lpOrder, 4);
                if (nArray[0] == 0) {
                    n3 = 0x2000000;
                    break;
                }
            }
            ++n4;
        }
        OS.ReleaseDC(0L, l3);
        OS.HeapFree(l, 0, l2);
        return n3;
    }

    public static void setKeyboardLanguage(int n) {
        if (n == BidiUtil.getKeyboardLanguage()) {
            return;
        }
        boolean bl = n == 1;
        long[] lArray = BidiUtil.getKeyboardLanguageList();
        int n2 = 0;
        while (n2 < lArray.length) {
            if (bl == BidiUtil.isBidiLang(lArray[n2])) {
                OS.ActivateKeyboardLayout(lArray[n2], 0);
                return;
            }
            ++n2;
        }
    }

    public static boolean setOrientation(long l, int n) {
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return false;
        }
        int n2 = OS.GetWindowLong(l, -20);
        n2 = (n & 0x4000000) != 0 ? (n2 |= 0x400000) : (n2 &= 0xFFBFFFFF);
        OS.SetWindowLong(l, -20, n2);
        return true;
    }

    public static boolean setOrientation(Control control, int n) {
        return BidiUtil.setOrientation(control.handle, n);
    }

    static void subclass(long l) {
        LONG lONG = new LONG(l);
        if (oldProcMap.get(lONG) == null) {
            long l2 = OS.GetWindowLongPtr(l, -4);
            oldProcMap.put(lONG, new LONG(l2));
            OS.SetWindowLongPtr(l, -4, callback.getAddress());
        }
    }

    static void reverse(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 <= (n - 1) / 2) {
            char c = cArray[n2];
            cArray[n2] = cArray[n - 1 - n2];
            cArray[n - 1 - n2] = c;
            ++n2;
        }
    }

    static void reverse(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 <= (n - 1) / 2) {
            int n3 = nArray[n2];
            nArray[n2] = nArray[n - 1 - n2];
            nArray[n - 1 - n2] = n3;
            ++n2;
        }
    }

    static void translateOrder(int[] nArray, int n, boolean bl) {
        int n2;
        int n3 = 0;
        int n4 = nArray.length;
        if (bl) {
            n2 = 0;
            while (n2 < n4) {
                n3 = Math.max(n3, nArray[n2]);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n4) {
            if (bl) {
                nArray[n2] = n3 - nArray[n2];
            }
            int n5 = n2++;
            nArray[n5] = nArray[n5] + n;
        }
    }

    static void unsubclass(long l) {
        LONG lONG = new LONG(l);
        if (languageMap.get(lONG) == null) {
            LONG lONG2 = oldProcMap.remove(lONG);
            if (lONG2 == null) {
                return;
            }
            OS.SetWindowLongPtr(l, -4, lONG2.value);
        }
    }

    static long windowProc(long l, long l2, long l3, long l4) {
        Object object;
        LONG lONG = new LONG(l);
        switch ((int)l2) {
            case 81: {
                object = languageMap.get(lONG);
                if (object == null) break;
                object.run();
            }
        }
        object = oldProcMap.get(lONG);
        return OS.CallWindowProc(((LONG)object).value, l, (int)l2, l3, l4);
    }
}

