/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class PreviewPrinterDevice
extends Device {
    public static final int DEFAULT_HEIGHT = 1200;
    public static final int DEFAULT_WIDTH = 900;
    private Point dpi;
    private Widget owner;
    private PrinterData printerData;
    private Rectangle rcBounds;
    private Rectangle rcClient;
    private final Font systemFont;

    public PreviewPrinterDevice(Widget widget, PrinterData printerData) {
        super(printerData);
        Object object;
        this.owner = widget;
        this.printerData = printerData;
        this.systemFont = this.getDisplay().getSystemFont();
        Printer printer = new Printer(printerData);
        try {
            object = this.getDPI();
            Point point = printer.getDPI();
            float f = (float)((Point)object).x / (float)point.x;
            float f2 = (float)((Point)object).y / (float)point.y;
            Rectangle rectangle = printer.getBounds();
            rectangle = new Rectangle(Math.round((float)rectangle.x * f), Math.round((float)rectangle.y * f2), Math.round((float)rectangle.width * f), Math.round((float)rectangle.height * f2));
            rectangle = printer.getClientArea();
            this.rcClient = new Rectangle(Math.round((float)rectangle.x * f), Math.round((float)rectangle.y * f2), Math.round((float)rectangle.width * f), Math.round((float)rectangle.height * f2));
        }
        finally {
            printer.dispose();
        }
        if (this.owner.isDisposed()) {
            this.owner = null;
        } else {
            object = new Listener(){

                @Override
                public void handleEvent(Event event) {
                    Widget widget = event.widget;
                    try {
                        PreviewPrinterDevice.this.handleDispose(event);
                    }
                    finally {
                        if (!widget.isDisposed()) {
                            widget.removeListener(12, this);
                        }
                    }
                }
            };
            this.owner.addListener(12, (Listener)object);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.rcBounds != null) {
            return new Rectangle(this.rcBounds.x, this.rcBounds.y, this.rcBounds.width, this.rcBounds.height);
        }
        return this.getOrientation() == 2 ? new Rectangle(0, 0, 1200, 900) : new Rectangle(0, 0, 900, 1200);
    }

    @Override
    public Rectangle getClientArea() {
        if (this.rcClient != null) {
            new Rectangle(this.rcClient.x, this.rcClient.y, this.rcClient.width, this.rcClient.height);
        }
        return this.getBounds();
    }

    private Display getDisplay() {
        return this.owner == null || this.owner.isDisposed() ? Display.getCurrent() : this.owner.getDisplay();
    }

    @Override
    public Point getDPI() {
        if (this.dpi == null) {
            this.dpi = this.getDisplay().getDPI();
        }
        return this.dpi;
    }

    public int getOrientation() {
        return this.printerData.orientation;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    @Override
    public Font getSystemFont() {
        return this.systemFont == null ? Display.getCurrent().getSystemFont() : this.systemFont;
    }

    protected void handleDispose(Event event) {
        if (this.owner == event.widget) {
            this.owner = null;
        }
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        this.getDisplay().internal_dispose_GC(l, gCData);
    }

    @Override
    public long internal_new_GC(GCData gCData) {
        return this.getDisplay().internal_new_GC(gCData);
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }
}

