/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.GdiplusStartupInput;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    public long hPalette = 0L;
    int[] colorRefCount;
    Font systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    TEXTMETRIC metrics;
    int[] pixels;
    long[] scripts;
    long[] gdipToken;
    long fontCollection;
    String[] loadedFonts;
    boolean disposed;
    boolean enableAutoScaling = true;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void addFont(String string) {
        if (this.loadedFonts == null) {
            this.loadedFonts = new String[4];
        }
        int n = this.loadedFonts.length;
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this.loadedFonts[n2])) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.loadedFonts[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            String[] stringArray = new String[n + 4];
            System.arraycopy(this.loadedFonts, 0, stringArray, 0, n);
            this.loadedFonts = stringArray;
        }
        this.loadedFonts[n2] = string;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    void checkGDIP() {
        if (this.gdipToken != null) {
            return;
        }
        int n = 0;
        if (!OS.IsWinCE) {
            n = OS.SetErrorMode(1);
        }
        try {
            try {
                long[] lArray = new long[1];
                GdiplusStartupInput gdiplusStartupInput = new GdiplusStartupInput();
                gdiplusStartupInput.GdiplusVersion = 1;
                if (Gdip.GdiplusStartup(lArray, gdiplusStartupInput, 0L) == 0) {
                    this.gdipToken = lArray;
                    if (this.loadedFonts != null) {
                        this.fontCollection = Gdip.PrivateFontCollection_new();
                        if (this.fontCollection == 0L) {
                            SWT.error(2);
                        }
                        int n2 = 0;
                        while (n2 < this.loadedFonts.length) {
                            String string = this.loadedFonts[n2];
                            if (string == null) break;
                            int n3 = string.length();
                            char[] cArray = new char[n3 + 1];
                            string.getChars(0, n3, cArray, 0);
                            Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, cArray);
                            ++n2;
                        }
                        this.loadedFonts = null;
                    }
                }
            }
            catch (Throwable throwable) {
                SWT.error(16, throwable, " [GDI+ is required]");
                if (!OS.IsWinCE) {
                    OS.SetErrorMode(n);
                }
            }
        }
        finally {
            if (!OS.IsWinCE) {
                OS.SetErrorMode(n);
            }
        }
    }

    protected void create(DeviceData deviceData) {
    }

    int computePixels(float f) {
        long l = this.internal_new_GC(null);
        int n = -((int)(0.5f + f * (float)OS.GetDeviceCaps(l, 90) / 72.0f));
        this.internal_dispose_GC(l, null);
        return n;
    }

    float computePoints(LOGFONT lOGFONT, long l) {
        long l2 = this.internal_new_GC(null);
        int n = OS.GetDeviceCaps(l2, 90);
        int n2 = 0;
        if (lOGFONT.lfHeight > 0) {
            long l3 = OS.SelectObject(l2, l);
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(l2, tEXTMETRIC);
            OS.SelectObject(l2, l3);
            n2 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
        } else {
            n2 = -lOGFONT.lfHeight;
        }
        this.internal_dispose_GC(l2, null);
        return (float)n2 * 72.0f / (float)n;
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == object) {
                    this.objects[n] = null;
                    this.errors[n] = null;
                    return;
                }
                ++n;
            }
        }
    }

    long EnumFontFamProc(long l, long l2, long l3, long l4) {
        boolean bl;
        boolean bl2 = ((int)l3 & 1) == 0;
        boolean bl3 = bl = l4 == 1L;
        if (bl2 == bl) {
            Object object;
            if (this.nFonts == this.logFonts.length) {
                object = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, object, 0, this.nFonts);
                this.logFonts = object;
                int[] nArray = new int[((LOGFONT[])object).length];
                System.arraycopy(this.pixels, 0, nArray, 0, this.nFonts);
                this.pixels = nArray;
            }
            if ((object = this.logFonts[this.nFonts]) == null) {
                object = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            }
            OS.MoveMemory((LOGFONT)object, l, LOGFONT.sizeof);
            this.logFonts[this.nFonts] = object;
            if (object.lfHeight > 0) {
                OS.MoveMemory(this.metrics, l2, TEXTMETRIC.sizeof);
                this.pixels[this.nFonts] = object.lfHeight - this.metrics.tmInternalLeading;
            } else {
                this.pixels[this.nFonts] = -object.lfHeight;
            }
            ++this.nFonts;
        }
        return 1L;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    private Rectangle getBoundsInPixels() {
        long l = this.internal_new_GC(null);
        int n = OS.GetDeviceCaps(l, 8);
        int n2 = OS.GetDeviceCaps(l, 10);
        this.internal_dispose_GC(l, null);
        return new Rectangle(0, 0, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n = 0;
                int n2 = this.objects.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.objects[n3] != null) {
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                deviceData.objects = new Object[n];
                deviceData.errors = new Error[n];
                int n4 = 0;
                while (n4 < n2) {
                    if (this.objects[n4] != null) {
                        deviceData.objects[n3] = this.objects[n4];
                        deviceData.errors[n3] = this.errors[n4];
                        ++n3;
                    }
                    ++n4;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        long l = this.internal_new_GC(null);
        int n = OS.GetDeviceCaps(l, 12);
        int n2 = OS.GetDeviceCaps(l, 14);
        this.internal_dispose_GC(l, null);
        return n * n2;
    }

    public Point getDPI() {
        this.checkDevice();
        long l = this.internal_new_GC(null);
        int n = OS.GetDeviceCaps(l, 88);
        int n2 = OS.GetDeviceCaps(l, 90);
        this.internal_dispose_GC(l, null);
        return DPIUtil.autoScaleDown(new Point(n, n2));
    }

    int _getDPIx() {
        long l = this.internal_new_GC(null);
        int n = OS.GetDeviceCaps(l, 88);
        this.internal_dispose_GC(l, null);
        return n;
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        long l = callback.getAddress();
        if (l == 0L) {
            SWT.error(3);
        }
        this.metrics = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        this.pixels = new int[this.nFonts];
        this.logFonts = new LOGFONT[this.nFonts];
        int n = 0;
        while (n < this.logFonts.length) {
            this.logFonts[n] = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            ++n;
        }
        this.nFonts = 0;
        n = 0;
        long l2 = this.internal_new_GC(null);
        if (string == null) {
            OS.EnumFontFamilies(l2, null, l, bl ? 1 : 0);
            n = this.nFonts;
            int n2 = 0;
            while (n2 < n) {
                LOGFONT lOGFONT = this.logFonts[n2];
                if (OS.IsUnicode) {
                    OS.EnumFontFamiliesW(l2, ((LOGFONTW)lOGFONT).lfFaceName, l, bl ? 1 : 0);
                } else {
                    OS.EnumFontFamiliesA(l2, ((LOGFONTA)lOGFONT).lfFaceName, l, bl ? 1 : 0);
                }
                ++n2;
            }
        } else {
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.EnumFontFamilies(l2, tCHAR, l, bl ? 1 : 0);
        }
        int n3 = OS.GetDeviceCaps(l2, 90);
        this.internal_dispose_GC(l2, null);
        int n4 = 0;
        FontData[] fontDataArray = new FontData[this.nFonts - n];
        int n5 = n;
        while (n5 < this.nFonts) {
            FontData fontData = FontData.win32_new(this.logFonts[n5], (float)this.pixels[n5] * 72.0f / (float)n3);
            int n6 = 0;
            while (n6 < n4) {
                if (fontData.equals(fontDataArray[n6])) break;
                ++n6;
            }
            if (n6 == n4) {
                fontDataArray[n4++] = fontData;
            }
            ++n5;
        }
        if (n4 != fontDataArray.length) {
            FontData[] fontDataArray2 = new FontData[n4];
            System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n4);
            fontDataArray = fontDataArray2;
        }
        callback.dispose();
        this.logFonts = null;
        this.pixels = null;
        this.metrics = null;
        return fontDataArray;
    }

    String getLastError() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(n) + "]";
    }

    String getLastErrorText() {
        int n = OS.GetLastError();
        if (n == 0) {
            return "";
        }
        int n2 = 4864;
        long[] lArray = new long[1];
        int n3 = OS.FormatMessage(n2, 0L, n, 1024, lArray, 0, 0L);
        if (n3 == 0) {
            return " [GetLastError=0x" + Integer.toHexString(n) + "]";
        }
        TCHAR tCHAR = new TCHAR(0, n3);
        OS.MoveMemory(tCHAR, lArray[0], n3 * TCHAR.sizeof);
        if (lArray[0] != 0L) {
            OS.LocalFree(lArray[0]);
        }
        return tCHAR.toString(0, n3);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        int n2 = 0;
        int n3 = 255;
        switch (n) {
            case 37: {
                n3 = 0;
            }
            case 1: {
                n2 = 0xFFFFFF;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 255;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
            case 5: {
                n2 = 65280;
                break;
            }
            case 6: {
                n2 = 32768;
                break;
            }
            case 7: {
                n2 = 65535;
                break;
            }
            case 8: {
                n2 = 32896;
                break;
            }
            case 9: {
                n2 = 0xFF0000;
                break;
            }
            case 10: {
                n2 = 0x800000;
                break;
            }
            case 11: {
                n2 = 0xFF00FF;
                break;
            }
            case 12: {
                n2 = 0x800080;
                break;
            }
            case 13: {
                n2 = 0xFFFF00;
                break;
            }
            case 14: {
                n2 = 0x808000;
                break;
            }
            case 15: {
                n2 = 0xC0C0C0;
                break;
            }
            case 16: {
                n2 = 0x808080;
            }
        }
        return Color.win32_new(this, n2, n3);
    }

    public Font getSystemFont() {
        this.checkDevice();
        long l = OS.GetStockObject(13);
        return Font.win32_new(this, l);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug && !OS.IsWinCE) {
            OS.GdiSetBatchLimit(1);
        }
        this.systemFont = this.getSystemFont();
        if (!OS.IsWinCE) {
            long[] lArray = new long[1];
            int[] nArray = new int[1];
            OS.ScriptGetProperties(lArray, nArray);
            this.scripts = new long[nArray[0]];
            OS.MoveMemory(this.scripts, lArray[0], this.scripts.length * OS.PTR_SIZEOF);
        }
        long l = this.internal_new_GC(null);
        int n = OS.GetDeviceCaps(l, 38);
        int n2 = OS.GetDeviceCaps(l, 12);
        int n3 = OS.GetDeviceCaps(l, 14);
        if ((n & 0x100) == 0 || (n2 *= n3) != 8) {
            this.internal_dispose_GC(l, null);
            return;
        }
        int n4 = OS.GetDeviceCaps(l, 106);
        int n5 = OS.GetDeviceCaps(l, 104);
        if (OS.IsWinCE && n4 == 0 && n5 >= 20) {
            n4 = 20;
        }
        this.colorRefCount = new int[n5];
        byte[] byArray = new byte[4 + 4 * n5];
        byArray[0] = 0;
        byArray[1] = 3;
        byArray[2] = 0;
        byArray[3] = 1;
        byte[] byArray2 = new byte[4 * n5];
        OS.GetSystemPaletteEntries(l, 0, n5, byArray2);
        System.arraycopy(byArray2, 0, byArray, 4, 4 * n5);
        int n6 = 0;
        while (n6 < n4 / 2) {
            this.colorRefCount[n6] = 1;
            this.colorRefCount[n5 - 1 - n6] = 1;
            ++n6;
        }
        this.internal_dispose_GC(l, null);
        this.hPalette = OS.CreatePalette(byArray);
    }

    @Override
    public abstract long internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(long var1, GCData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        if (OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            boolean bl;
            TCHAR tCHAR = new TCHAR(0, string, true);
            boolean bl2 = bl = OS.AddFontResourceEx(tCHAR, 16, 0L) != 0L;
            if (bl) {
                if (this.gdipToken != null) {
                    if (this.fontCollection == 0L) {
                        this.fontCollection = Gdip.PrivateFontCollection_new();
                        if (this.fontCollection == 0L) {
                            SWT.error(2);
                        }
                    }
                    int n = string.length();
                    char[] cArray = new char[n + 1];
                    string.getChars(0, n, cArray, 0);
                    Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, cArray);
                } else {
                    this.addFont(string);
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == null) {
                    this.objects[n] = object;
                    this.errors[n] = new Error();
                    return;
                }
                ++n;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                while (n12 < this.objects.length) {
                    Object object2 = this.objects[n12];
                    if (object2 != null) {
                        ++n;
                        if (object2 instanceof Color) {
                            ++n2;
                        }
                        if (object2 instanceof Cursor) {
                            ++n3;
                        }
                        if (object2 instanceof Font) {
                            ++n4;
                        }
                        if (object2 instanceof GC) {
                            ++n5;
                        }
                        if (object2 instanceof Image) {
                            ++n6;
                        }
                        if (object2 instanceof Path) {
                            ++n7;
                        }
                        if (object2 instanceof Pattern) {
                            ++n8;
                        }
                        if (object2 instanceof Region) {
                            ++n9;
                        }
                        if (object2 instanceof TextLayout) {
                            ++n10;
                        }
                        if (object2 instanceof Transform) {
                            ++n11;
                        }
                    }
                    ++n12;
                }
                if (n != 0) {
                    String string = "Summary: ";
                    if (n2 != 0) {
                        string = String.valueOf(string) + n2 + " Color(s), ";
                    }
                    if (n3 != 0) {
                        string = String.valueOf(string) + n3 + " Cursor(s), ";
                    }
                    if (n4 != 0) {
                        string = String.valueOf(string) + n4 + " Font(s), ";
                    }
                    if (n5 != 0) {
                        string = String.valueOf(string) + n5 + " GC(s), ";
                    }
                    if (n6 != 0) {
                        string = String.valueOf(string) + n6 + " Image(s), ";
                    }
                    if (n7 != 0) {
                        string = String.valueOf(string) + n7 + " Path(s), ";
                    }
                    if (n8 != 0) {
                        string = String.valueOf(string) + n8 + " Pattern(s), ";
                    }
                    if (n9 != 0) {
                        string = String.valueOf(string) + n9 + " Region(s), ";
                    }
                    if (n10 != 0) {
                        string = String.valueOf(string) + n10 + " TextLayout(s), ";
                    }
                    if (n11 != 0) {
                        string = String.valueOf(string) + n11 + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.err.println(string);
                    }
                    int n13 = 0;
                    while (n13 < this.errors.length) {
                        if (this.errors[n13] != null) {
                            this.errors[n13].printStackTrace(System.err);
                        }
                        ++n13;
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.gdipToken != null) {
            if (this.fontCollection != 0L) {
                Gdip.PrivateFontCollection_delete(this.fontCollection);
            }
            this.fontCollection = 0L;
            Gdip.GdiplusShutdown(this.gdipToken[0]);
        }
        this.gdipToken = null;
        this.scripts = null;
        if (this.hPalette != 0L) {
            OS.DeleteObject(this.hPalette);
        }
        this.hPalette = 0L;
        this.colorRefCount = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
    }

    boolean getEnableAutoScaling() {
        return this.enableAutoScaling;
    }

    void setEnableAutoScaling(boolean bl) {
        this.enableAutoScaling = bl;
    }

    protected int getDeviceZoom() {
        return DPIUtil.mapDPIToZoom(this._getDPIx());
    }
}

