/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String CFSTR_INETURLW = "UniformResourceLocatorW";
    static final int CFSTR_INETURLIDW = URLTransfer.registerType("UniformResourceLocatorW");
    static final String CFSTR_INETURL = "UniformResourceLocator";
    static final int CFSTR_INETURLID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        if (transferData.type == CFSTR_INETURLIDW) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            int n2 = cArray.length * 2;
            long l = OS.GlobalAlloc(64, n2);
            OS.MoveMemory(l, cArray, n2);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = l;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        } else if (transferData.type == CFSTR_INETURLID) {
            int n = string.length();
            char[] cArray = new char[n + 1];
            string.getChars(0, n, cArray, 0);
            int n3 = OS.GetACP();
            int n4 = OS.WideCharToMultiByte(n3, 0, cArray, -1, null, 0, null, null);
            if (n4 == 0) {
                transferData.stgmedium = new STGMEDIUM();
                transferData.result = -2147221402;
                return;
            }
            long l = OS.GlobalAlloc(64, n4);
            OS.WideCharToMultiByte(n3, 0, cArray, -1, l, n4, null, null);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = l;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object nativeToJava(TransferData var1_1) {
        block22: {
            if (!this.isSupportedType(var1_1) || var1_1.pIDataObject == 0L) {
                return null;
            }
            var2_2 = new IDataObject(var1_1.pIDataObject);
            var2_2.AddRef();
            var3_3 = new STGMEDIUM();
            var4_4 = var1_1.formatetc;
            var3_3.tymed = 1;
            var1_1.result = this.getData(var2_2, var4_4, var3_3);
            var2_2.Release();
            if (var1_1.result != 0) {
                return null;
            }
            var5_5 = var3_3.unionField;
            if (var1_1.type == URLTransfer.CFSTR_INETURLIDW) {
                var7_6 = OS.GlobalSize(var5_5) / 2 * 2;
                if (var7_6 == 0) {
                    return null;
                }
                var8_8 = new char[var7_6 / 2];
                var9_9 = OS.GlobalLock(var5_5);
                if (var9_9 == 0L) {
                    return null;
                }
                try {
                    OS.MoveMemory(var8_8, var9_9, var7_6);
                    var11_11 = var8_8.length;
                    var12_13 = 0;
                    while (var12_13 < var8_8.length) {
                        if (var8_8[var12_13] == '\u0000') {
                            var11_11 = var12_13;
                            break;
                        }
                        ++var12_13;
                    }
                    var14_15 = new String(var8_8, 0, var11_11);
                    return var14_15;
                }
                finally {
                    OS.GlobalUnlock(var5_5);
                }
            }
            if (var1_1.type != URLTransfer.CFSTR_INETURLID) break block22;
            var7_7 = OS.GlobalLock(var5_5);
            if (var7_7 != 0L) ** GOTO lbl-1000
            return null;
lbl-1000:
            // 1 sources

            {
                var9_10 = OS.GetACP();
                var10_18 = OS.MultiByteToWideChar(var9_10, 1, var7_7, -1, null, 0);
                if (var10_18 != 0) ** break block23
                OS.GlobalUnlock(var5_5);
            }
            return null;
            {
                var11_12 = new char[var10_18 - 1];
                OS.MultiByteToWideChar(var9_10, 1, var7_7, -1, var11_12, var11_12.length);
                var13_17 = new String(var11_12);
                OS.GlobalUnlock(var5_5);
            }
            return var13_17;
            {
                catch (Throwable var12_14) {
                    OS.GlobalUnlock(var5_5);
                    throw var12_14;
                }
            }
            finally {
                OS.GlobalFree(var5_5);
            }
        }
        return null;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLIDW, CFSTR_INETURLID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CFSTR_INETURLW, CFSTR_INETURL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

