/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String CF_UNICODETEXT = "CF_UNICODETEXT";
    private static final String CF_TEXT = "CF_TEXT";
    private static final int CF_UNICODETEXTID = 13;
    private static final int CF_TEXTID = 1;

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        switch (transferData.type) {
            case 13: {
                int n = string.length();
                char[] cArray = new char[n + 1];
                string.getChars(0, n, cArray, 0);
                int n2 = cArray.length * 2;
                long l = OS.GlobalAlloc(64, n2);
                OS.MoveMemory(l, cArray, n2);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = l;
                transferData.stgmedium.pUnkForRelease = 0L;
                transferData.result = 0;
                break;
            }
            case 1: {
                int n = string.length();
                char[] cArray = new char[n + 1];
                string.getChars(0, n, cArray, 0);
                int n3 = OS.GetACP();
                int n4 = OS.WideCharToMultiByte(n3, 0, cArray, -1, null, 0, null, null);
                if (n4 == 0) {
                    transferData.stgmedium = new STGMEDIUM();
                    transferData.result = -2147221402;
                    return;
                }
                long l = OS.GlobalAlloc(64, n4);
                OS.WideCharToMultiByte(n3, 0, cArray, -1, l, n4, null, null);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = l;
                transferData.stgmedium.pUnkForRelease = 0L;
                transferData.result = 0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) return null;
        if (transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        FORMATETC fORMATETC = transferData.formatetc;
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        long l = sTGMEDIUM.unionField;
        try {
            switch (transferData.type) {
                case 13: {
                    int n = OS.GlobalSize(l) / 2 * 2;
                    if (n == 0) {
                        return null;
                    }
                    char[] cArray = new char[n / 2];
                    long l2 = OS.GlobalLock(l);
                    if (l2 == 0L) {
                        return null;
                    }
                    try {
                        OS.MoveMemory(cArray, l2, n);
                        int n2 = cArray.length;
                        int n3 = 0;
                        while (n3 < cArray.length) {
                            if (cArray[n3] == '\u0000') {
                                n2 = n3;
                                break;
                            }
                            ++n3;
                        }
                        String string = new String(cArray, 0, n2);
                        return string;
                    }
                    finally {
                        OS.GlobalUnlock(l);
                    }
                }
                case 1: {
                    long l3 = OS.GlobalLock(l);
                    if (l3 == 0L) {
                        return null;
                    }
                    try {
                        int n = OS.GetACP();
                        int n4 = OS.MultiByteToWideChar(n, 1, l3, -1, null, 0);
                        if (n4 == 0) {
                            return null;
                        }
                        char[] cArray = new char[n4 - 1];
                        OS.MultiByteToWideChar(n, 1, l3, -1, cArray, cArray.length);
                        String string = new String(cArray);
                        return string;
                    }
                    finally {
                        OS.GlobalUnlock(l);
                    }
                }
            }
            return null;
        }
        finally {
            OS.GlobalFree(l);
        }
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{13, 1};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CF_UNICODETEXT, CF_TEXT};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

