/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    @Override
    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    @Override
    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            SHDRAGIMAGE sHDRAGIMAGE = new SHDRAGIMAGE();
            int n = OS.RegisterWindowMessage(new TCHAR(0, "ShellGetDragImage", true));
            if (OS.SendMessage(this.control.handle, n, 0L, sHDRAGIMAGE) != 0L) {
                dragSourceEvent.offsetX = (this.control.getStyle() & 0x8000000) != 0 ? sHDRAGIMAGE.sizeDragImage.cx - sHDRAGIMAGE.ptOffset.x : sHDRAGIMAGE.ptOffset.x;
                dragSourceEvent.offsetY = sHDRAGIMAGE.ptOffset.y;
                long l = sHDRAGIMAGE.hbmpDragImage;
                if (l != 0L) {
                    Object object;
                    BITMAP bITMAP = new BITMAP();
                    OS.GetObject(l, BITMAP.sizeof, bITMAP);
                    int n2 = bITMAP.bmWidth;
                    int n3 = bITMAP.bmHeight;
                    long l2 = OS.GetDC(0L);
                    long l3 = OS.CreateCompatibleDC(l2);
                    long l4 = OS.SelectObject(l3, l);
                    long l5 = OS.CreateCompatibleDC(l2);
                    BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
                    bITMAPINFOHEADER.biWidth = n2;
                    bITMAPINFOHEADER.biHeight = -n3;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)32;
                    bITMAPINFOHEADER.biCompression = 0;
                    byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
                    long[] lArray = new long[1];
                    long l6 = OS.CreateDIBSection(0L, byArray, 0, lArray, 0L, 0);
                    if (l6 == 0L) {
                        SWT.error(2);
                    }
                    long l7 = OS.SelectObject(l5, l6);
                    BITMAP bITMAP2 = new BITMAP();
                    OS.GetObject(l6, BITMAP.sizeof, bITMAP2);
                    int n4 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
                    OS.BitBlt(l5, 0, 0, n2, n3, l3, 0, 0, 0xCC0020);
                    byte[] byArray2 = new byte[n4];
                    OS.MoveMemory(byArray2, bITMAP2.bmBits, n4);
                    PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    ImageData imageData = new ImageData(n2, n3, bITMAP.bmBitsPixel, paletteData, bITMAP.bmWidthBytes, byArray2);
                    if (sHDRAGIMAGE.crColorKey == -1) {
                        object = new byte[n2 * n3];
                        int n5 = bITMAP2.bmWidthBytes - n2 * 4;
                        int n6 = 0;
                        int n7 = 3;
                        int n8 = 0;
                        while (n8 < n3) {
                            int n9 = 0;
                            while (n9 < n2) {
                                object[n6++] = byArray2[n7];
                                n7 += 4;
                                ++n9;
                            }
                            n7 += n5;
                            ++n8;
                        }
                        imageData.alphaData = object;
                    } else {
                        imageData.transparentPixel = sHDRAGIMAGE.crColorKey << 8;
                    }
                    object = this.control.getDisplay();
                    this.dragSourceImage = new Image((Device)object, new DPIUtil.AutoScaleImageDataProvider((Device)object, imageData, DPIUtil.getDeviceZoom()));
                    OS.SelectObject(l5, l7);
                    OS.DeleteDC(l5);
                    OS.DeleteObject(l6);
                    OS.SelectObject(l3, l4);
                    OS.DeleteDC(l3);
                    OS.ReleaseDC(0L, l2);
                    OS.DeleteObject(l);
                    return this.dragSourceImage;
                }
            }
            return null;
        }
        Table table = (Table)this.control;
        if (table.isListening(40) || table.isListening(42)) {
            return null;
        }
        TableItem[] tableItemArray = table.getSelection();
        if (tableItemArray.length == 0) {
            return null;
        }
        long l = OS.SendMessage(table.handle, 4098, 1L, 0L);
        if (l != 0L) {
            int n = Math.min(tableItemArray.length, 10);
            Rectangle rectangle = DPIUtil.autoScaleUp(tableItemArray[0].getBounds(0));
            int n10 = 1;
            while (n10 < n) {
                rectangle = rectangle.union(DPIUtil.autoScaleUp(tableItemArray[n10].getBounds(0)));
                ++n10;
            }
            long l8 = OS.GetDC(0L);
            long l9 = OS.CreateCompatibleDC(l8);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && (table.getStyle() & 0x4000000) != 0) {
                OS.SetLayout(l9, 9);
            }
            long l10 = OS.CreateCompatibleBitmap(l8, rectangle.width, rectangle.height);
            long l11 = OS.SelectObject(l9, l10);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            long l12 = OS.GetStockObject(0);
            OS.FillRect(l9, rECT, l12);
            int n11 = 0;
            while (n11 < n) {
                TableItem tableItem = tableItemArray[n11];
                Rectangle rectangle2 = DPIUtil.autoScaleUp(tableItem.getBounds(0));
                POINT pOINT = new POINT();
                long l13 = OS.SendMessage(table.handle, 4129, (long)table.indexOf(tableItem), pOINT);
                OS.ImageList_Draw(l13, 0, l9, rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, 4);
                OS.ImageList_Destroy(l13);
                ++n11;
            }
            OS.SelectObject(l9, l11);
            OS.DeleteDC(l9);
            OS.ReleaseDC(0L, l8);
            Display display = table.getDisplay();
            this.dragSourceImage = Image.win32_new(display, 0, l10);
            return this.dragSourceImage;
        }
        return null;
    }
}

