/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String CF_RTF = "Rich Text Format";
    private static final int CF_RTFID = RTFTransfer.registerType("Rich Text Format");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        int n = string.length();
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = OS.GetACP();
        int n3 = OS.WideCharToMultiByte(n2, 0, cArray, -1, null, 0, null, null);
        if (n3 == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        long l = OS.GlobalAlloc(64, n3);
        OS.WideCharToMultiByte(n2, 0, cArray, -1, l, n3, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = l;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        FORMATETC fORMATETC = transferData.formatetc;
        sTGMEDIUM.tymed = 1;
        transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        long l = sTGMEDIUM.unionField;
        try {
            int n;
            int n2;
            long l2;
            block12: {
                l2 = OS.GlobalLock(l);
                if (l2 == 0L) {
                    return null;
                }
                try {
                    n2 = OS.GetACP();
                    n = OS.MultiByteToWideChar(n2, 1, l2, -1, null, 0);
                    if (n != 0) break block12;
                }
                catch (Throwable throwable) {
                    OS.GlobalUnlock(l);
                    throw throwable;
                }
                OS.GlobalUnlock(l);
                return null;
            }
            char[] cArray = new char[n - 1];
            OS.MultiByteToWideChar(n2, 1, l2, -1, cArray, cArray.length);
            String string = new String(cArray);
            OS.GlobalUnlock(l);
            return string;
        }
        finally {
            OS.GlobalFree(l);
        }
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{CF_RTFID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CF_RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

