/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PopupList {
    Shell shell;
    List list;
    int minimumWidth;

    public PopupList(Shell shell) {
        this(shell, 0);
    }

    public PopupList(Shell shell, int n) {
        int n2 = 516;
        if ((n & 0x100) != 0) {
            n2 |= 0x100;
        }
        this.shell = new Shell(shell, PopupList.checkStyle(n));
        this.list = new List(this.shell, n2);
        this.shell.addListener(27, new Listener(){

            @Override
            public void handleEvent(Event event) {
                PopupList.this.shell.setVisible(false);
            }
        });
        this.shell.addControlListener(new ControlListener(){

            @Override
            public void controlMoved(ControlEvent controlEvent) {
            }

            @Override
            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = PopupList.this.shell.getClientArea();
                PopupList.this.list.setSize(rectangle.width, rectangle.height);
            }
        });
        this.list.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseDown(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                PopupList.this.shell.setVisible(false);
            }
        });
        this.list.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    PopupList.this.shell.setVisible(false);
                }
            }
        });
    }

    private static int checkStyle(int n) {
        int n2 = 0x6000000;
        return n & n2;
    }

    public Font getFont() {
        return this.list.getFont();
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public String open(Rectangle rectangle) {
        Point point = this.list.computeSize(rectangle.width, -1, false);
        Rectangle rectangle2 = this.shell.getDisplay().getBounds();
        int n = rectangle2.height - (rectangle.y + rectangle.height) - 30;
        int n2 = rectangle.y - 30;
        int n3 = 0;
        if (n2 > n && point.y > n) {
            point.y = point.y > n2 ? n2 : (point.y += 2);
            n3 = rectangle.y - point.y;
        } else {
            point.y = point.y > n ? n : (point.y += 2);
            n3 = rectangle.y + rectangle.height;
        }
        point.x = rectangle.width;
        if (point.x < this.minimumWidth) {
            point.x = this.minimumWidth;
        }
        int n4 = rectangle.x + rectangle.width - point.x;
        this.shell.setBounds(n4, n3, point.x, point.y);
        this.shell.open();
        this.list.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        String string = null;
        if (!this.shell.isDisposed()) {
            String[] stringArray = this.list.getSelection();
            this.shell.dispose();
            if (stringArray.length != 0) {
                string = stringArray[0];
            }
        }
        return string;
    }

    public void select(String string) {
        String[] stringArray = this.list.getItems();
        if (string != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(string)) {
                    int n2 = this.list.indexOf(stringArray[n]);
                    this.list.select(n2);
                    break;
                }
                ++n;
            }
        }
    }

    public void setFont(Font font) {
        this.list.setFont(font);
    }

    public void setItems(String[] stringArray) {
        this.list.setItems(stringArray);
    }

    public void setMinimumWidth(int n) {
        if (n < 0) {
            SWT.error(5);
        }
        this.minimumWidth = n;
    }
}

