/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.TypedListener;

class DefaultContent
implements StyledTextContent {
    private static final String LineDelimiter = System.getProperty("line.separator");
    List<StyledTextListener> textListeners = new ArrayList<StyledTextListener>();
    char[] textStore = new char[0];
    int gapStart = -1;
    int gapEnd = -1;
    int gapLine = -1;
    int highWatermark = 300;
    int lowWatermark = 50;
    int[][] lines = new int[50][2];
    int lineCount = 0;
    int expandExp = 1;
    int replaceExpandExp = 1;

    DefaultContent() {
        this.setText("");
    }

    void addLineIndex(int n, int n2) {
        Object object;
        int n3 = this.lines.length;
        if (this.lineCount == n3) {
            object = new int[n3 + Compatibility.pow2(this.expandExp)][2];
            System.arraycopy(this.lines, 0, object, 0, n3);
            this.lines = object;
            ++this.expandExp;
        }
        object = new int[]{n, n2};
        this.lines[this.lineCount] = (int[])object;
        ++this.lineCount;
    }

    int[][] addLineIndex(int n, int n2, int[][] nArray, int n3) {
        int n4 = nArray.length;
        int[][] nArray2 = nArray;
        if (n3 == n4) {
            nArray2 = new int[n4 + Compatibility.pow2(this.replaceExpandExp)][2];
            ++this.replaceExpandExp;
            System.arraycopy(nArray, 0, nArray2, 0, n4);
        }
        int[] nArray3 = new int[]{n, n2};
        nArray2[n3] = nArray3;
        return nArray2;
    }

    @Override
    public void addTextChangeListener(TextChangeListener textChangeListener) {
        if (textChangeListener == null) {
            this.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(textChangeListener);
        this.textListeners.add(styledTextListener);
    }

    void adjustGap(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n == this.gapStart ? this.lowWatermark <= (n5 = this.gapEnd - this.gapStart - n2) && n5 <= this.highWatermark : n + n2 == this.gapStart && n2 < 0 && this.lowWatermark <= (n4 = this.gapEnd - this.gapStart - n2) && n4 <= this.highWatermark) {
            return;
        }
        this.moveAndResizeGap(n, n2, n3);
    }

    void indexLines() {
        int n = 0;
        this.lineCount = 0;
        int n2 = this.textStore.length;
        int n3 = n;
        while (n3 < n2) {
            char c = this.textStore[n3];
            if (c == '\r') {
                if (n3 + 1 < n2 && (c = this.textStore[n3 + 1]) == '\n') {
                    ++n3;
                }
                this.addLineIndex(n, n3 - n + 1);
                n = n3 + 1;
            } else if (c == '\n') {
                this.addLineIndex(n, n3 - n + 1);
                n = n3 + 1;
            }
            ++n3;
        }
        this.addLineIndex(n, n3 - n);
    }

    boolean isDelimiter(char c) {
        if (c == '\r') {
            return true;
        }
        return c == '\n';
    }

    protected boolean isValidReplace(int n, int n2, String string) {
        if (n2 == 0) {
            char c;
            if (n == 0) {
                return true;
            }
            if (n == this.getCharCount()) {
                return true;
            }
            char c2 = this.getTextRange(n - 1, 1).charAt(0);
            if (c2 == '\r' && (c = this.getTextRange(n, 1).charAt(0)) == '\n') {
                return false;
            }
        } else {
            char c;
            char c3;
            char c4 = this.getTextRange(n, 1).charAt(0);
            if (c4 == '\n' && n != 0 && (c3 = this.getTextRange(n - 1, 1).charAt(0)) == '\r') {
                return false;
            }
            c3 = this.getTextRange(n + n2 - 1, 1).charAt(0);
            if (c3 == '\r' && n + n2 != this.getCharCount() && (c = this.getTextRange(n + n2, 1).charAt(0)) == '\n') {
                return false;
            }
        }
        return true;
    }

    int[][] indexLines(int n, int n2, int n3) {
        int[][] nArray = new int[n3][2];
        int n4 = 0;
        int n5 = 0;
        this.replaceExpandExp = 1;
        int n6 = n4;
        while (n6 < n2) {
            int n7 = n6 + n;
            if (n7 < this.gapStart || n7 >= this.gapEnd) {
                char c = this.textStore[n7];
                if (c == '\r') {
                    if (n7 + 1 < this.textStore.length && (c = this.textStore[n7 + 1]) == '\n') {
                        ++n6;
                    }
                    nArray = this.addLineIndex(n4, n6 - n4 + 1, nArray, n5);
                    ++n5;
                    n4 = n6 + 1;
                } else if (c == '\n') {
                    nArray = this.addLineIndex(n4, n6 - n4 + 1, nArray, n5);
                    ++n5;
                    n4 = n6 + 1;
                }
            }
            ++n6;
        }
        int[][] nArray2 = new int[n5 + 1][2];
        System.arraycopy(nArray, 0, nArray2, 0, n5);
        int[] nArray3 = new int[]{n4, n6 - n4};
        nArray2[n5] = nArray3;
        return nArray2;
    }

    void insert(int n, String string) {
        int n2;
        int[][] nArray;
        if (string.length() == 0) {
            return;
        }
        int n3 = this.getLineAtOffset(n);
        int n4 = string.length();
        boolean bl = n == this.getCharCount();
        this.adjustGap(n, n4, n3);
        int n5 = this.getOffsetAtLine(n3);
        int n6 = this.getPhysicalLine(n3).length();
        if (n4 > 0) {
            this.gapStart += n4;
            int n7 = 0;
            while (n7 < string.length()) {
                this.textStore[n + n7] = string.charAt(n7);
                ++n7;
            }
        }
        if ((nArray = this.indexLines(n5, n6, 10))[n2 = nArray.length - 1][1] == 0) {
            n2 = bl ? ++n2 : --n2;
        }
        this.expandLinesBy(n2);
        int n8 = this.lineCount - 1;
        while (n8 > n3) {
            this.lines[n8 + n2] = this.lines[n8];
            --n8;
        }
        n8 = 0;
        while (n8 < n2) {
            int[] nArray2 = nArray[n8];
            nArray2[0] = nArray2[0] + n5;
            this.lines[n3 + n8] = nArray[n8];
            ++n8;
        }
        if (n2 < nArray.length) {
            int[] nArray3 = nArray[n2];
            nArray3[0] = nArray3[0] + n5;
            this.lines[n3 + n2] = nArray[n2];
        }
        this.lineCount += n2;
        this.gapLine = this.getLineAtPhysicalOffset(this.gapStart);
    }

    void moveAndResizeGap(int n, int n2, int n3) {
        int n4;
        int n5;
        char[] cArray = null;
        int n6 = this.gapEnd - this.gapStart;
        int n7 = n2 > 0 ? this.highWatermark + n2 : this.lowWatermark - n2;
        if (this.gapExists()) {
            this.lines[this.gapLine][1] = this.lines[this.gapLine][1] - n6;
            n5 = this.gapLine + 1;
            while (n5 < this.lineCount) {
                this.lines[n5][0] = this.lines[n5][0] - n6;
                ++n5;
            }
        }
        if (n7 < 0) {
            if (n6 > 0) {
                cArray = new char[this.textStore.length - n6];
                System.arraycopy(this.textStore, 0, cArray, 0, this.gapStart);
                System.arraycopy(this.textStore, this.gapEnd, cArray, this.gapStart, cArray.length - this.gapStart);
                this.textStore = cArray;
            }
            this.gapStart = this.gapEnd = n;
            return;
        }
        cArray = new char[this.textStore.length + (n7 - n6)];
        n5 = n;
        int n8 = n5 + n7;
        if (n6 == 0) {
            System.arraycopy(this.textStore, 0, cArray, 0, n5);
            System.arraycopy(this.textStore, n5, cArray, n8, cArray.length - n8);
        } else if (n5 < this.gapStart) {
            n4 = this.gapStart - n5;
            System.arraycopy(this.textStore, 0, cArray, 0, n5);
            System.arraycopy(this.textStore, n5, cArray, n8, n4);
            System.arraycopy(this.textStore, this.gapEnd, cArray, n8 + n4, this.textStore.length - this.gapEnd);
        } else {
            n4 = n5 - this.gapStart;
            System.arraycopy(this.textStore, 0, cArray, 0, this.gapStart);
            System.arraycopy(this.textStore, this.gapEnd, cArray, this.gapStart, n4);
            System.arraycopy(this.textStore, this.gapEnd + n4, cArray, n8, cArray.length - n8);
        }
        this.textStore = cArray;
        this.gapStart = n5;
        this.gapEnd = n8;
        if (this.gapExists()) {
            this.gapLine = n3;
            n4 = this.gapEnd - this.gapStart;
            this.lines[this.gapLine][1] = this.lines[this.gapLine][1] + n4;
            int n9 = this.gapLine + 1;
            while (n9 < this.lineCount) {
                this.lines[n9][0] = this.lines[n9][0] + n4;
                ++n9;
            }
        }
    }

    int lineCount(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        if (n5 >= this.gapStart) {
            n5 += this.gapEnd - this.gapStart;
        }
        while (n4 < n2) {
            if (n5 < this.gapStart || n5 >= this.gapEnd) {
                char c = this.textStore[n5];
                if (c == '\r') {
                    if (n5 + 1 < this.textStore.length && (c = this.textStore[n5 + 1]) == '\n') {
                        ++n5;
                        ++n4;
                    }
                    ++n3;
                } else if (c == '\n') {
                    ++n3;
                }
                ++n4;
            }
            ++n5;
        }
        return n3;
    }

    int lineCount(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '\r') {
                if (n3 + 1 < n2 && string.charAt(n3 + 1) == '\n') {
                    ++n3;
                }
                ++n;
            } else if (c == '\n') {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    @Override
    public int getCharCount() {
        int n = this.gapEnd - this.gapStart;
        return this.textStore.length - n;
    }

    @Override
    public String getLine(int n) {
        if (n >= this.lineCount || n < 0) {
            this.error(5);
        }
        int n2 = this.lines[n][0];
        int n3 = this.lines[n][1];
        int n4 = n2 + n3 - 1;
        if (!this.gapExists() || n4 < this.gapStart || n2 >= this.gapEnd) {
            while (n3 - 1 >= 0 && this.isDelimiter(this.textStore[n2 + n3 - 1])) {
                --n3;
            }
            return new String(this.textStore, n2, n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = this.gapEnd - this.gapStart;
        stringBuffer.append(this.textStore, n2, this.gapStart - n2);
        stringBuffer.append(this.textStore, this.gapEnd, n3 - n5 - (this.gapStart - n2));
        n3 = stringBuffer.length();
        while (n3 - 1 >= 0 && this.isDelimiter(stringBuffer.charAt(n3 - 1))) {
            --n3;
        }
        return stringBuffer.toString().substring(0, n3);
    }

    @Override
    public String getLineDelimiter() {
        return LineDelimiter;
    }

    String getFullLine(int n) {
        int n2 = this.lines[n][0];
        int n3 = this.lines[n][1];
        int n4 = n2 + n3 - 1;
        if (!this.gapExists() || n4 < this.gapStart || n2 >= this.gapEnd) {
            return new String(this.textStore, n2, n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = this.gapEnd - this.gapStart;
        stringBuffer.append(this.textStore, n2, this.gapStart - n2);
        stringBuffer.append(this.textStore, this.gapEnd, n3 - n5 - (this.gapStart - n2));
        return stringBuffer.toString();
    }

    String getPhysicalLine(int n) {
        int n2 = this.lines[n][0];
        int n3 = this.lines[n][1];
        return this.getPhysicalText(n2, n3);
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public int getLineAtOffset(int n) {
        int n2;
        if (n > this.getCharCount() || n < 0) {
            this.error(5);
        }
        int n3 = n < this.gapStart ? n : n + (this.gapEnd - this.gapStart);
        if (this.lineCount > 0 && n3 == this.lines[n2 = this.lineCount - 1][0] + this.lines[n2][1]) {
            return n2;
        }
        n2 = this.lineCount;
        int n4 = -1;
        int n5 = this.lineCount;
        while (n2 - n4 > 1) {
            n5 = (n2 + n4) / 2;
            int n6 = this.lines[n5][0];
            int n7 = n6 + this.lines[n5][1] - 1;
            if (n3 <= n6) {
                n2 = n5;
                continue;
            }
            if (n3 <= n7) {
                n2 = n5;
                break;
            }
            n4 = n5;
        }
        return n2;
    }

    int getLineAtPhysicalOffset(int n) {
        int n2 = this.lineCount;
        int n3 = -1;
        int n4 = this.lineCount;
        while (n2 - n3 > 1) {
            n4 = (n2 + n3) / 2;
            int n5 = this.lines[n4][0];
            int n6 = n5 + this.lines[n4][1] - 1;
            if (n <= n5) {
                n2 = n4;
                continue;
            }
            if (n <= n6) {
                n2 = n4;
                break;
            }
            n3 = n4;
        }
        return n2;
    }

    @Override
    public int getOffsetAtLine(int n) {
        int n2;
        if (n == 0) {
            return 0;
        }
        if (n >= this.lineCount || n < 0) {
            this.error(5);
        }
        if ((n2 = this.lines[n][0]) > this.gapEnd) {
            return n2 - (this.gapEnd - this.gapStart);
        }
        return n2;
    }

    void expandLinesBy(int n) {
        int n2 = this.lines.length;
        if (n2 - this.lineCount >= n) {
            return;
        }
        int[][] nArray = new int[n2 + Math.max(10, n)][2];
        System.arraycopy(this.lines, 0, nArray, 0, n2);
        this.lines = nArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean gapExists() {
        return this.gapStart != this.gapEnd;
    }

    String getPhysicalText(int n, int n2) {
        return new String(this.textStore, n, n2);
    }

    @Override
    public String getTextRange(int n, int n2) {
        if (this.textStore == null) {
            return "";
        }
        if (n2 == 0) {
            return "";
        }
        int n3 = n + n2;
        if (!this.gapExists() || n3 < this.gapStart) {
            return new String(this.textStore, n, n2);
        }
        if (this.gapStart < n) {
            int n4 = this.gapEnd - this.gapStart;
            return new String(this.textStore, n + n4, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.textStore, n, this.gapStart - n);
        stringBuffer.append(this.textStore, this.gapEnd, n3 - this.gapStart);
        return stringBuffer.toString();
    }

    @Override
    public void removeTextChangeListener(TextChangeListener textChangeListener) {
        if (textChangeListener == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.textListeners.size()) {
            TypedListener typedListener = this.textListeners.get(n);
            if (typedListener.getEventListener() == textChangeListener) {
                this.textListeners.remove(n);
                break;
            }
            ++n;
        }
    }

    @Override
    public void replaceTextRange(int n, int n2, String string) {
        if (!this.isValidReplace(n, n2, string)) {
            SWT.error(5);
        }
        StyledTextEvent styledTextEvent = new StyledTextEvent(this);
        styledTextEvent.type = 3003;
        styledTextEvent.start = n;
        styledTextEvent.replaceLineCount = this.lineCount(n, n2);
        styledTextEvent.text = string;
        styledTextEvent.newLineCount = this.lineCount(string);
        styledTextEvent.replaceCharCount = n2;
        styledTextEvent.newCharCount = string.length();
        this.sendTextEvent(styledTextEvent);
        this.delete(n, n2, styledTextEvent.replaceLineCount + 1);
        this.insert(n, string);
        styledTextEvent = new StyledTextEvent(this);
        styledTextEvent.type = 3006;
        this.sendTextEvent(styledTextEvent);
    }

    void sendTextEvent(StyledTextEvent styledTextEvent) {
        int n = 0;
        while (n < this.textListeners.size()) {
            this.textListeners.get(n).handleEvent(styledTextEvent);
            ++n;
        }
    }

    @Override
    public void setText(String string) {
        this.textStore = string.toCharArray();
        this.gapStart = -1;
        this.gapEnd = -1;
        this.expandExp = 1;
        this.indexLines();
        StyledTextEvent styledTextEvent = new StyledTextEvent(this);
        styledTextEvent.type = 3004;
        styledTextEvent.text = "";
        this.sendTextEvent(styledTextEvent);
    }

    void delete(int n, int n2, int n3) {
        int n4;
        if (n2 == 0) {
            return;
        }
        int n5 = this.getLineAtOffset(n);
        int n6 = this.getOffsetAtLine(n5);
        int n7 = this.getLineAtOffset(n + n2);
        String string = "";
        boolean bl = false;
        if (n + n2 < this.getCharCount() && (string = this.getTextRange(n + n2 - 1, 2)).charAt(0) == '\r' && string.charAt(1) == '\n') {
            bl = true;
        }
        this.adjustGap(n + n2, -n2, n5);
        int[][] nArray = this.indexLines(n, n2 + (this.gapEnd - this.gapStart), n3);
        if (n + n2 == this.gapStart) {
            this.gapStart -= n2;
        } else {
            this.gapEnd += n2;
        }
        int n8 = n;
        boolean bl2 = false;
        while (n8 < this.textStore.length && !bl2) {
            if ((n8 < this.gapStart || n8 >= this.gapEnd) && this.isDelimiter((char)(n4 = this.textStore[n8]))) {
                if (n8 + 1 < this.textStore.length && n4 == 13 && this.textStore[n8 + 1] == '\n') {
                    ++n8;
                }
                bl2 = true;
            }
            ++n8;
        }
        this.lines[n5][1] = n - n6 + (n8 - n);
        n4 = nArray.length - 1;
        if (bl) {
            --n4;
        }
        int n9 = n7 + 1;
        while (n9 < this.lineCount) {
            this.lines[n9 - n4] = this.lines[n9];
            ++n9;
        }
        this.lineCount -= n4;
        this.gapLine = this.getLineAtPhysicalOffset(this.gapStart);
    }
}

