/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebDownloadDelegate;
import org.eclipse.swt.browser.WebFrameLoadDelegate;
import org.eclipse.swt.browser.WebPolicyDelegate;
import org.eclipse.swt.browser.WebResourceLoadDelegate;
import org.eclipse.swt.browser.WebUIDelegate;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.webkit.IWebCookieManager;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebDocumentRepresentation;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebIBActions;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebPreferences;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.IWebViewPrivate;
import org.eclipse.swt.internal.webkit.JSClassDefinition;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    IWebView webView;
    long webViewWindowHandle;
    long webViewData;
    int refCount = 0;
    int lastKeyCode;
    int lastCharCode;
    WebDownloadDelegate webDownloadDelegate;
    WebFrameLoadDelegate webFrameLoadDelegate;
    WebPolicyDelegate webPolicyDelegate;
    WebResourceLoadDelegate webResourceLoadDelegate;
    WebUIDelegate webUIDelegate;
    boolean ignoreDispose;
    boolean loadingText = false;
    boolean traverseNext = true;
    boolean traverseOut = false;
    boolean untrustedText;
    String lastNavigateURL;
    BrowserFunction eventFunction;
    static int prefsIdentifier;
    static long ExternalClass;
    static boolean LibraryLoaded;
    static String LibraryLoadError;
    static Callback JSObjectHasPropertyProc;
    static Callback JSObjectGetPropertyProc;
    static Callback JSObjectCallAsFunctionProc;
    static final int MAX_PROGRESS = 100;
    static final String ABOUT_BLANK = "about:blank";
    static final String CHARSET_UTF8 = "UTF-8";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String EMPTY_STRING = "";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String HEADER_SETCOOKIE = "Set-Cookie";
    static final String POST = "POST";
    static final String PROPERTY_LENGTH = "length";
    static final String PROTOCOL_HTTPS = "https://";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String USER_AGENT = "user-agent";
    static final String URI_FILEROOT = "file:///";
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";

    static {
        LibraryLoaded = false;
        try {
            Library.loadLibrary("swt-webkit");
            LibraryLoaded = true;
        }
        catch (Throwable throwable) {}
        if (!LibraryLoaded) {
            String string = WebKit.readInstallDir("SOFTWARE\\Apple Computer, Inc.\\Safari");
            if (string != null && !new File(string = String.valueOf(string) + "\\Apple Application Support").exists()) {
                string = null;
            }
            if (string == null) {
                string = WebKit.readInstallDir("SOFTWARE\\Apple Inc.\\Apple Application Support");
            }
            if (string != null) {
                TCHAR tCHAR = new TCHAR(0, string, true);
                boolean bl = OS.SetDllDirectory(tCHAR);
                if (bl) {
                    try {
                        Library.loadLibrary("swt-webkit");
                        LibraryLoaded = true;
                    }
                    catch (Throwable throwable) {
                        LibraryLoadError = "Failed to load the swt-webkit library";
                        if (Device.DEBUG) {
                            System.out.println("Failed to load swt-webkit library. Apple Application Support directory path: " + string);
                        }
                    }
                } else {
                    LibraryLoadError = "Failed to add the Apple Application Support package to the library lookup path.  ";
                    LibraryLoadError = String.valueOf(LibraryLoadError) + "To use a SWT.WEBKIT-style Browser prepend " + string + " to your Windows 'Path' environment variable and restart.";
                }
            } else {
                LibraryLoadError = "Safari must be installed to use a SWT.WEBKIT-style Browser";
            }
        }
        if (LibraryLoaded) {
            JSObjectHasPropertyProc = new Callback(WebKit.class, "JSObjectHasPropertyProc", 3);
            if (JSObjectHasPropertyProc.getAddress() == 0L) {
                SWT.error(3);
            }
            if ((JSObjectGetPropertyProc = new Callback(WebKit.class, "JSObjectGetPropertyProc", 4)).getAddress() == 0L) {
                SWT.error(3);
            }
            if ((JSObjectCallAsFunctionProc = new Callback(WebKit.class, "JSObjectCallAsFunctionProc", 6)).getAddress() == 0L) {
                SWT.error(3);
            }
            NativeClearSessions = new Runnable(){

                @Override
                public void run() {
                    long[] lArray = new long[1];
                    int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebCookieManager, 0L, WebKit_win32.IID_IWebCookieManager, lArray);
                    if (n != 0 || lArray[0] == 0L) {
                        return;
                    }
                    IWebCookieManager iWebCookieManager = new IWebCookieManager(lArray[0]);
                    long[] lArray2 = new long[1];
                    n = iWebCookieManager.cookieStorage(lArray2);
                    iWebCookieManager.Release();
                    if (n != 0 || lArray2[0] == 0L) {
                        return;
                    }
                    long l = WebKit_win32.CFHTTPCookieStorageCopyCookies(lArray2[0]);
                    if (l != 0L) {
                        int n2 = WebKit_win32.CFArrayGetCount(l);
                        int n3 = 0;
                        while (n3 < n2) {
                            long l2 = WebKit_win32.CFArrayGetValueAtIndex(l, n3);
                            long l3 = WebKit_win32.CFHTTPCookieGetFlags(l2);
                            if ((l3 & 2L) != 0L) {
                                WebKit_win32.CFHTTPCookieStorageDeleteCookie(lArray2[0], l2);
                            }
                            ++n3;
                        }
                        WebKit_win32.CFRelease(l);
                    }
                }
            };
            NativeGetCookie = new Runnable(){

                @Override
                public void run() {
                    long[] lArray = new long[1];
                    int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebCookieManager, 0L, WebKit_win32.IID_IWebCookieManager, lArray);
                    if (n != 0 || lArray[0] == 0L) {
                        return;
                    }
                    IWebCookieManager iWebCookieManager = new IWebCookieManager(lArray[0]);
                    long[] lArray2 = new long[1];
                    n = iWebCookieManager.cookieStorage(lArray2);
                    iWebCookieManager.Release();
                    if (n != 0 || lArray2[0] == 0L) {
                        return;
                    }
                    char[] cArray = CookieUrl.toCharArray();
                    long l = WebKit_win32.CFStringCreateWithCharacters(0L, cArray, cArray.length);
                    if (l != 0L) {
                        long l2 = WebKit_win32.CFURLCreateWithString(0L, l, 0L);
                        if (l2 != 0L) {
                            boolean bl = CookieUrl.startsWith(WebKit.PROTOCOL_HTTPS);
                            long l3 = WebKit_win32.CFHTTPCookieStorageCopyCookiesForURL(lArray2[0], l2, bl);
                            if (l3 != 0L) {
                                int n2 = WebKit_win32.CFArrayGetCount(l3);
                                int n3 = 0;
                                while (n3 < n2) {
                                    String string;
                                    long l4;
                                    long l5 = WebKit_win32.CFArrayGetValueAtIndex(l3, n3);
                                    if (l5 != 0L && (l4 = WebKit_win32.CFHTTPCookieGetName(l5)) != 0L && CookieName.equals(string = WebKit.stringFromCFString(l4))) {
                                        long l6 = WebKit_win32.CFHTTPCookieGetValue(l5);
                                        if (l6 == 0L) break;
                                        CookieValue = WebKit.stringFromCFString(l6);
                                        break;
                                    }
                                    ++n3;
                                }
                                WebKit_win32.CFRelease(l3);
                            }
                            WebKit_win32.CFRelease(l2);
                        }
                        WebKit_win32.CFRelease(l);
                    }
                }
            };
            NativeSetCookie = new Runnable(){

                @Override
                public void run() {
                    long[] lArray = new long[1];
                    int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebCookieManager, 0L, WebKit_win32.IID_IWebCookieManager, lArray);
                    if (n != 0 || lArray[0] == 0L) {
                        return;
                    }
                    IWebCookieManager iWebCookieManager = new IWebCookieManager(lArray[0]);
                    long[] lArray2 = new long[1];
                    n = iWebCookieManager.cookieStorage(lArray2);
                    iWebCookieManager.Release();
                    if (n != 0 || lArray2[0] == 0L) {
                        return;
                    }
                    char[] cArray = CookieUrl.toCharArray();
                    long l = WebKit_win32.CFStringCreateWithCharacters(0L, cArray, cArray.length);
                    if (l != 0L) {
                        long l2 = WebKit_win32.CFURLCreateWithString(0L, l, 0L);
                        if (l2 != 0L) {
                            cArray = CookieValue.toCharArray();
                            long l3 = WebKit_win32.CFStringCreateWithCharacters(0L, cArray, cArray.length);
                            if (l3 != 0L) {
                                cArray = WebKit.HEADER_SETCOOKIE.toCharArray();
                                long l4 = WebKit_win32.CFStringCreateWithCharacters(0L, cArray, cArray.length);
                                if (l4 != 0L) {
                                    long l5 = WebKit_win32.CFDictionaryCreate(0L, new long[]{l4}, new long[]{l3}, 1, WebKit_win32.kCFCopyStringDictionaryKeyCallBacks(), WebKit_win32.kCFTypeDictionaryValueCallBacks());
                                    if (l5 != 0L) {
                                        long l6 = WebKit_win32.CFHTTPCookieCreateWithResponseHeaderFields(0L, l5, l2);
                                        if (l6 != 0L) {
                                            long l7 = WebKit_win32.CFArrayGetValueAtIndex(l6, 0);
                                            if (l7 != 0L) {
                                                WebKit_win32.CFHTTPCookieStorageSetCookie(lArray2[0], l7);
                                                CookieResult = true;
                                            }
                                            WebKit_win32.CFRelease(l6);
                                        }
                                        WebKit_win32.CFRelease(l5);
                                    }
                                    WebKit_win32.CFRelease(l4);
                                }
                                WebKit_win32.CFRelease(l3);
                            }
                            WebKit_win32.CFRelease(l2);
                        }
                        WebKit_win32.CFRelease(l);
                    }
                }
            };
            if (NativePendingCookies != null) {
                WebKit.SetPendingCookies(NativePendingCookies);
            }
            NativePendingCookies = null;
        }
    }

    WebKit() {
    }

    static long createBSTR(String string) {
        char[] cArray = (String.valueOf(string) + '\u0000').toCharArray();
        return COM.SysAllocString(cArray);
    }

    static String error(int n) {
        throw new SWTError("WebKit error " + n);
    }

    static String extractBSTR(long l) {
        int n = COM.SysStringByteLen(l);
        if (n == 0) {
            return EMPTY_STRING;
        }
        char[] cArray = new char[(n + 1) / 2];
        COM.MoveMemory(cArray, l, n);
        return new String(cArray);
    }

    static Browser findBrowser(long l) {
        Widget widget;
        if (l == 0L) {
            return null;
        }
        IWebView iWebView = new IWebView(l);
        long[] lArray = new long[1];
        int n = iWebView.hostWindow(lArray);
        if (n == 0 && lArray[0] != 0L && (widget = Display.getCurrent().findWidget(lArray[0])) != null && widget instanceof Browser) {
            return (Browser)widget;
        }
        return null;
    }

    static long JSObjectCallAsFunctionProc(long l, long l2, long l3, long l4, long l5, long l6) {
        WebKit_win32.JSGlobalContextRetain(l);
        if (WebKit_win32.JSValueIsObjectOfClass(l, l3, ExternalClass) == 0) {
            return WebKit_win32.JSValueMakeUndefined(l);
        }
        long l7 = WebKit_win32.JSObjectGetPrivate(l3);
        long[] lArray = new long[1];
        C.memmove(lArray, l7, (long)C.PTR_SIZEOF);
        Browser browser = WebKit.findBrowser(lArray[0]);
        if (browser == null) {
            return WebKit_win32.JSValueMakeUndefined(l);
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.callJava(l, l2, l3, l4, l5, l6);
    }

    static long JSObjectGetPropertyProc(long l, long l2, long l3, long l4) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = "callJava\u0000".getBytes();
        }
        long l5 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        long l6 = WebKit_win32.JSObjectCallAsFunctionProc_CALLBACK(JSObjectCallAsFunctionProc.getAddress());
        long l7 = WebKit_win32.JSObjectMakeFunctionWithCallback(l, l5, l6);
        WebKit_win32.JSStringRelease(l5);
        return l7;
    }

    static long JSObjectHasPropertyProc(long l, long l2, long l3) {
        byte[] byArray = null;
        try {
            byArray = "callJava\u0000".getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = "callJava\u0000".getBytes();
        }
        return WebKit_win32.JSStringIsEqualToUTF8CString(l3, byArray);
    }

    static String readInstallDir(String string) {
        TCHAR tCHAR = new TCHAR(0, string, true);
        long[] lArray = new long[1];
        if (OS.RegOpenKeyEx(-2147483646L, tCHAR, 0, 131097, lArray) == 0) {
            TCHAR tCHAR2;
            TCHAR tCHAR3 = new TCHAR(0, "InstallDir", true);
            int[] nArray = new int[1];
            int n = OS.RegQueryValueEx(lArray[0], tCHAR3, 0L, null, null, nArray);
            if (n == 0 && (n = OS.RegQueryValueEx(lArray[0], tCHAR3, 0L, null, tCHAR2 = new TCHAR(0, nArray[0] / TCHAR.sizeof), nArray)) == 0) {
                OS.RegCloseKey(lArray[0]);
                return tCHAR2.toString(0, tCHAR2.strlen());
            }
            OS.RegCloseKey(lArray[0]);
        }
        return null;
    }

    static String stringFromCFString(long l) {
        if (l == 0L) {
            return null;
        }
        int n = WebKit_win32.CFStringGetLength(l);
        long l2 = WebKit_win32.CFStringGetCharactersPtr(l);
        char[] cArray = new char[n];
        if (l2 != 0L) {
            OS.MoveMemory(cArray, l2, n);
        } else {
            int n2 = 0;
            while (n2 < n) {
                cArray[n2] = WebKit_win32.CFStringGetCharacterAtIndex(l, n2);
                ++n2;
            }
        }
        return new String(cArray);
    }

    static String stringFromJSString(long l) {
        if (l == 0L) {
            return null;
        }
        int n = WebKit_win32.JSStringGetLength(l);
        byte[] byArray = new byte[n + 1];
        WebKit_win32.JSStringGetUTF8CString(l, byArray, n + 1);
        return new String(byArray);
    }

    @Override
    public boolean back() {
        int[] nArray = new int[1];
        this.webView.goBack(nArray);
        return nArray[0] != 0;
    }

    long callJava(long l, long l2, long l3, long l4, long l5, long l6) {
        Object object = null;
        if (l4 == 3L) {
            long[] lArray = new long[1];
            C.memmove(lArray, l5, (long)C.PTR_SIZEOF);
            int n = WebKit_win32.JSValueGetType(l, lArray[0]);
            if (n == 3) {
                int n2 = ((Double)this.convertToJava(l, lArray[0])).intValue();
                lArray[0] = 0L;
                if (n2 > 0) {
                    Integer n3 = new Integer(n2);
                    C.memmove(lArray, l5 + (long)C.PTR_SIZEOF, (long)C.PTR_SIZEOF);
                    n = WebKit_win32.JSValueGetType(l, lArray[0]);
                    if (n == 4) {
                        String string = (String)this.convertToJava(l, lArray[0]);
                        BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n3);
                        if (browserFunction != null && string.equals(browserFunction.token)) {
                            try {
                                C.memmove(lArray, l5 + (long)(2 * C.PTR_SIZEOF), (long)C.PTR_SIZEOF);
                                Object object2 = this.convertToJava(l, lArray[0]);
                                if (object2 instanceof Object[]) {
                                    Object[] objectArray = (Object[])object2;
                                    try {
                                        object = browserFunction.function(objectArray);
                                    }
                                    catch (Exception exception) {
                                        object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                                    }
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (browserFunction.isEvaluate) {
                                    browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                                }
                                object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                            }
                        }
                    }
                }
            }
        }
        return this.convertToJS(l, object);
    }

    @Override
    public boolean close() {
        return this.shouldClose();
    }

    Object convertToJava(long l, long l2) {
        int n = WebKit_win32.JSValueGetType(l, l2);
        switch (n) {
            case 2: {
                int n2 = (int)WebKit_win32.JSValueToNumber(l, l2, null);
                return new Boolean(n2 != 0);
            }
            case 3: {
                double d = WebKit_win32.JSValueToNumber(l, l2, null);
                return new Double(d);
            }
            case 4: {
                long l3 = WebKit_win32.JSValueToStringCopy(l, l2, null);
                if (l3 == 0L) {
                    return EMPTY_STRING;
                }
                long l4 = WebKit_win32.JSStringGetMaximumUTF8CStringSize(l3);
                byte[] byArray = new byte[(int)l4];
                l4 = WebKit_win32.JSStringGetUTF8CString(l3, byArray, l4);
                WebKit_win32.JSStringRelease(l3);
                try {
                    return new String(byArray, 0, (int)l4 - 1, CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(byArray);
                }
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] byArray = null;
                try {
                    byArray = "length\u0000".getBytes(CHARSET_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = "length\u0000".getBytes();
                }
                long l5 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
                long l6 = WebKit_win32.JSObjectGetProperty(l, l2, l5, null);
                WebKit_win32.JSStringRelease(l5);
                n = WebKit_win32.JSValueGetType(l, l6);
                if (n != 3) break;
                int n3 = (int)WebKit_win32.JSValueToNumber(l, l6, null);
                Object[] objectArray = new Object[n3];
                int n4 = 0;
                while (n4 < n3) {
                    long l7 = WebKit_win32.JSObjectGetPropertyAtIndex(l, l2, n4, null);
                    if (l7 != 0L) {
                        objectArray[n4] = this.convertToJava(l, l7);
                    }
                    ++n4;
                }
                return objectArray;
            }
        }
        SWT.error(5);
        return null;
    }

    long convertToJS(long l, Object object) {
        if (object == null) {
            return WebKit_win32.JSValueMakeNull(l);
        }
        if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = (String.valueOf((String)object) + '\u0000').getBytes(CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = (String.valueOf((String)object) + '\u0000').getBytes();
            }
            long l2 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
            long l3 = WebKit_win32.JSValueMakeString(l, l2);
            WebKit_win32.JSStringRelease(l2);
            return l3;
        }
        if (object instanceof Boolean) {
            return WebKit_win32.JSValueMakeBoolean(l, (Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Number) {
            return WebKit_win32.JSValueMakeNumber(l, ((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            long[] lArray = new long[n];
            int n2 = 0;
            while (n2 < n) {
                long l4;
                Object object2 = objectArray[n2];
                lArray[n2] = l4 = this.convertToJS(l, object2);
                ++n2;
            }
            return WebKit_win32.JSObjectMakeArray(l, n, lArray, null);
        }
        SWT.error(51);
        return 0L;
    }

    @Override
    public void create(Composite composite, int n) {
        int n2;
        Object object;
        if (!LibraryLoaded) {
            this.browser.dispose();
            SWT.error(2, null, LibraryLoadError == null ? null : " [" + LibraryLoadError + ']');
        }
        if (ExternalClass == 0L) {
            long l;
            object = new JSClassDefinition();
            byte[] byArray = "External\u0000".getBytes();
            object.className = C.malloc(byArray.length);
            OS.memmove(object.className, byArray, (long)byArray.length);
            object.hasProperty = l = WebKit_win32.JSObjectHasPropertyProc_CALLBACK(JSObjectHasPropertyProc.getAddress());
            object.getProperty = l = WebKit_win32.JSObjectGetPropertyProc_CALLBACK(JSObjectGetPropertyProc.getAddress());
            long l2 = C.malloc(JSClassDefinition.sizeof);
            WebKit_win32.memmove(l2, (JSClassDefinition)object, (long)JSClassDefinition.sizeof);
            ExternalClass = WebKit_win32.JSClassCreate(l2);
            WebKit_win32.JSClassRetain(ExternalClass);
        }
        if ((n2 = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebView, 0L, WebKit_win32.IID_IWebView, object = new long[1])) != 0 || object[0] == 0L) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webView = new IWebView(object[0]);
        this.webViewData = C.malloc(C.PTR_SIZEOF);
        C.memmove(this.webViewData, new long[]{this.webView.getAddress()}, (long)C.PTR_SIZEOF);
        n2 = this.webView.setHostWindow(this.browser.handle);
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        if ((n2 = this.webView.initWithFrame(new RECT(), 0L, 0L)) != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        object[0] = 0L;
        n2 = this.webView.QueryInterface(WebKit_win32.IID_IWebViewPrivate, (long[])object);
        if (n2 != 0 || object[0] == 0L) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        IWebViewPrivate iWebViewPrivate = new IWebViewPrivate(object[0]);
        object[0] = 0L;
        n2 = iWebViewPrivate.viewWindow((long[])object);
        if (n2 != 0 || object[0] == 0L) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        iWebViewPrivate.Release();
        this.webViewWindowHandle = object[0];
        this.webFrameLoadDelegate = new WebFrameLoadDelegate(this.browser);
        n2 = this.webView.setFrameLoadDelegate(this.webFrameLoadDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webUIDelegate = new WebUIDelegate(this.browser);
        n2 = this.webView.setUIDelegate(this.webUIDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webResourceLoadDelegate = new WebResourceLoadDelegate(this.browser);
        n2 = this.webView.setResourceLoadDelegate(this.webResourceLoadDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webDownloadDelegate = new WebDownloadDelegate(this.browser);
        n2 = this.webView.setDownloadDelegate(this.webDownloadDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.webPolicyDelegate = new WebPolicyDelegate(this.browser);
        n2 = this.webView.setPolicyDelegate(this.webPolicyDelegate.getAddress());
        if (n2 != 0) {
            this.browser.dispose();
            WebKit.error(n2);
        }
        this.initializeWebViewPreferences();
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        WebKit.this.onDispose();
                        break;
                    }
                    case 15: {
                        OS.SetFocus(WebKit.this.webViewWindowHandle);
                        break;
                    }
                    case 11: {
                        Rectangle rectangle = DPIUtil.autoScaleUp(WebKit.this.browser.getClientArea());
                        OS.SetWindowPos(WebKit.this.webViewWindowHandle, 0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 32);
                        break;
                    }
                    case 31: {
                        if (WebKit.this.traverseOut) {
                            event.doit = true;
                            WebKit.this.traverseOut = false;
                            break;
                        }
                        event.doit = false;
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(11, listener);
        this.browser.addListener(31, listener);
        this.eventFunction = new BrowserFunction(this.browser, "HandleWebKitEvent"){

            @Override
            public Object function(Object[] objectArray) {
                return WebKit.this.handleEvent(objectArray) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    @Override
    public boolean execute(String string) {
        long[] lArray = new long[1];
        int n = this.webView.mainFrame(lArray);
        if (n != 0 || lArray[0] == 0L) {
            return false;
        }
        IWebFrame iWebFrame = new IWebFrame(lArray[0]);
        long l = iWebFrame.globalContext();
        iWebFrame.Release();
        if (l == 0L) {
            return false;
        }
        byte[] byArray = null;
        try {
            byArray = (String.valueOf(string) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (String.valueOf(string) + '\u0000').getBytes();
        }
        long l2 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        if (l2 == 0L) {
            return false;
        }
        try {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes(CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes();
        }
        long l3 = WebKit_win32.JSStringCreateWithUTF8CString(byArray);
        if (l3 == 0L) {
            WebKit_win32.JSStringRelease(l2);
            return false;
        }
        long l4 = WebKit_win32.JSEvaluateScript(l, l2, 0L, l3, 0, null);
        WebKit_win32.JSStringRelease(l3);
        WebKit_win32.JSStringRelease(l2);
        return l4 != 0L;
    }

    @Override
    public boolean forward() {
        int[] nArray = new int[1];
        this.webView.goForward(nArray);
        return nArray[0] != 0;
    }

    @Override
    public String getBrowserType() {
        return "webkit";
    }

    @Override
    public String getText() {
        long[] lArray = new long[1];
        int n = this.webView.mainFrame(lArray);
        if (n != 0 || lArray[0] == 0L) {
            return EMPTY_STRING;
        }
        IWebFrame iWebFrame = new IWebFrame(lArray[0]);
        lArray[0] = 0L;
        n = iWebFrame.dataSource(lArray);
        iWebFrame.Release();
        if (n != 0 || lArray[0] == 0L) {
            return EMPTY_STRING;
        }
        IWebDataSource iWebDataSource = new IWebDataSource(lArray[0]);
        lArray[0] = 0L;
        n = iWebDataSource.representation(lArray);
        iWebDataSource.Release();
        if (n != 0 || lArray[0] == 0L) {
            return EMPTY_STRING;
        }
        IWebDocumentRepresentation iWebDocumentRepresentation = new IWebDocumentRepresentation(lArray[0]);
        lArray[0] = 0L;
        n = iWebDocumentRepresentation.documentSource(lArray);
        iWebDocumentRepresentation.Release();
        if (n != 0 || lArray[0] == 0L) {
            return EMPTY_STRING;
        }
        String string = WebKit.extractBSTR(lArray[0]);
        COM.SysFreeString(lArray[0]);
        return string;
    }

    @Override
    public String getUrl() {
        return this.webFrameLoadDelegate.getUrl();
    }

    boolean handleEvent(Object[] objectArray) {
        int n;
        String string = (String)objectArray[0];
        if (string.equals(DOMEVENT_KEYDOWN)) {
            int n2;
            this.lastKeyCode = n2 = this.translateKey(((Double)objectArray[1]).intValue());
            switch (n2) {
                case 9: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event event = new Event();
                    event.widget = this.browser;
                    event.type = string.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    event.keyCode = n2;
                    switch (n2) {
                        case 8: {
                            event.character = (char)8;
                            break;
                        }
                        case 127: {
                            event.character = (char)127;
                            break;
                        }
                        case 27: {
                            event.character = (char)27;
                            break;
                        }
                        case 9: {
                            event.character = (char)9;
                        }
                    }
                    this.lastCharCode = event.character;
                    event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
                    event.stateMask &= ~n2;
                    if (this.sendKeyEvent(event) && !this.browser.isDisposed()) break;
                    return false;
                }
            }
            return true;
        }
        if (string.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = ((Double)objectArray[2]).intValue();
            if (((Boolean)objectArray[4]).booleanValue() && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 1;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            return this.sendKeyEvent(event) && !this.browser.isDisposed();
        }
        if (string.equals(DOMEVENT_KEYUP)) {
            int n3 = this.translateKey(((Double)objectArray[1]).intValue());
            if (n3 == 0) {
                return true;
            }
            if (n3 != this.lastKeyCode) {
                this.lastKeyCode = n3;
                this.lastCharCode = 0;
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 2;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = ((Boolean)objectArray[3] != false ? 65536 : 0) | ((Boolean)objectArray[4] != false ? 262144 : 0) | ((Boolean)objectArray[5] != false ? 131072 : 0) | ((Boolean)objectArray[6] != false ? 0x400000 : 0);
            switch (this.lastKeyCode) {
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: {
                    event.stateMask |= this.lastKeyCode;
                }
            }
            this.browser.notifyListeners(event.type, event);
            this.lastCharCode = 0;
            this.lastKeyCode = 0;
            return event.doit && !this.browser.isDisposed();
        }
        if ((string.equals(DOMEVENT_MOUSEOVER) || string.equals(DOMEVENT_MOUSEOUT)) && ((Boolean)objectArray[9]).booleanValue()) {
            return true;
        }
        Point point = new Point(((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue());
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = n = ((Boolean)objectArray[5] != false ? 65536 : 0) | ((Boolean)objectArray[6] != false ? 262144 : 0) | ((Boolean)objectArray[7] != false ? 131072 : 0);
        if (string.equals(DOMEVENT_MOUSEDOWN)) {
            event.type = 3;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (((Double)objectArray[3]).intValue() == 2) {
                event = new Event();
                event.type = 8;
                event.widget = this.browser;
                event.x = point.x;
                event.y = point.y;
                event.stateMask = n;
                event.count = ((Double)objectArray[3]).intValue();
                event.button = ((Double)objectArray[4]).intValue();
                this.browser.notifyListeners(event.type, event);
            }
            return true;
        }
        if (string.equals(DOMEVENT_MOUSEUP)) {
            event.type = 4;
            event.count = ((Double)objectArray[3]).intValue();
            event.button = ((Double)objectArray[4]).intValue();
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        } else if (string.equals(DOMEVENT_MOUSEMOVE)) {
            event.type = 5;
        } else if (string.equals(DOMEVENT_MOUSEWHEEL)) {
            event.type = 37;
            event.count = ((Double)objectArray[3]).intValue();
        } else if (string.equals(DOMEVENT_MOUSEOVER)) {
            event.type = 6;
        } else if (string.equals(DOMEVENT_MOUSEOUT)) {
            event.type = 7;
            if (event.x < 0) {
                event.x = -1;
            }
            if (event.y < 0) {
                event.y = -1;
            }
        } else if (string.equals(DOMEVENT_DRAGSTART)) {
            event.type = 29;
            event.button = ((Double)objectArray[4]).intValue() + 1;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        }
        this.browser.notifyListeners(event.type, event);
        return true;
    }

    @Override
    public boolean isBackEnabled() {
        long[] lArray = new long[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, lArray);
        if (n != 0 || lArray[0] == 0L) {
            return false;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(lArray[0]);
        int[] nArray = new int[1];
        iWebIBActions.canGoBack(this.webView.getAddress(), nArray);
        iWebIBActions.Release();
        return nArray[0] != 0;
    }

    @Override
    public boolean isFocusControl() {
        long l = OS.GetFocus();
        return l != 0L && l == this.webViewWindowHandle;
    }

    @Override
    public boolean isForwardEnabled() {
        long[] lArray = new long[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, lArray);
        if (n != 0 || lArray[0] == 0L) {
            return false;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(lArray[0]);
        int[] nArray = new int[1];
        iWebIBActions.canGoForward(this.webView.getAddress(), nArray);
        iWebIBActions.Release();
        return nArray[0] != 0;
    }

    void onDispose() {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.webUIDelegate.prompt = false;
            this.shouldClose();
            this.webUIDelegate.prompt = true;
        }
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            ((BrowserFunction)iterator.next()).dispose(false);
        }
        this.functions = null;
        this.eventFunction.dispose();
        this.eventFunction = null;
        C.free(this.webViewData);
        this.webView.setPreferences(0L);
        this.webView.setHostWindow(0L);
        this.webView.setFrameLoadDelegate(0L);
        this.webView.setResourceLoadDelegate(0L);
        this.webView.setUIDelegate(0L);
        this.webView.setPolicyDelegate(0L);
        this.webView.setDownloadDelegate(0L);
        this.webView.Release();
        this.webView = null;
        this.webDownloadDelegate = null;
        this.webFrameLoadDelegate = null;
        this.webPolicyDelegate = null;
        this.webResourceLoadDelegate = null;
        this.webUIDelegate = null;
        this.lastNavigateURL = null;
    }

    @Override
    public void refresh() {
        this.webFrameLoadDelegate.html = null;
        long[] lArray = new long[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, lArray);
        if (n != 0 || lArray[0] == 0L) {
            return;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(lArray[0]);
        iWebIBActions.reload(this.webView.getAddress());
        iWebIBActions.Release();
    }

    @Override
    boolean sendKeyEvent(Event event) {
        boolean bl = true;
        switch (event.keyCode) {
            case 9: 
            case 13: 
            case 27: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: {
                break;
            }
            default: {
                if (!this.translateMnemonics() || event.character == '\u0000' || (event.stateMask & 0x50000) != 65536) break;
                int n = 128;
                boolean bl2 = event.doit;
                event.doit = true;
                bl = !this.browser.traverse(n, event);
                event.doit = bl2;
            }
        }
        if (bl) {
            this.browser.notifyListeners(event.type, event);
            bl = event.doit;
        }
        return bl;
    }

    @Override
    public boolean setText(String string, boolean bl) {
        boolean bl2 = this.webFrameLoadDelegate.html != null;
        this.webFrameLoadDelegate.html = string;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        long[] lArray = new long[1];
        int n = this.webView.mainFrame(lArray);
        if (n != 0 || lArray[0] == 0L) {
            return false;
        }
        IWebFrame iWebFrame = new IWebFrame(lArray[0]);
        lArray[0] = 0L;
        n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebMutableURLRequest, 0L, WebKit_win32.IID_IWebMutableURLRequest, lArray);
        if (n != 0 || lArray[0] == 0L) {
            iWebFrame.Release();
            return false;
        }
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(lArray[0]);
        long l = WebKit.createBSTR(ABOUT_BLANK);
        n = iWebMutableURLRequest.setURL(l);
        COM.SysFreeString(l);
        if (n == 0) {
            n = iWebFrame.loadRequest(iWebMutableURLRequest.getAddress());
        }
        iWebFrame.Release();
        iWebMutableURLRequest.Release();
        return n == 0;
    }

    @Override
    public boolean setUrl(String object, String string, String[] stringArray) {
        Object object2;
        if (((String)object).length() == 0) {
            return false;
        }
        try {
            new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            object2 = null;
            object2 = new File((String)object).isAbsolute() ? (Object)(PROTOCOL_FILE + (String)object) : (Object)(PROTOCOL_HTTP + (String)object);
            try {
                new URL((String)object2);
                object = object2;
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        this.webFrameLoadDelegate.html = null;
        this.lastNavigateURL = object;
        object2 = new long[1];
        int n = this.webView.mainFrame((long[])object2);
        if (n != 0 || object2[0] == 0L) {
            return false;
        }
        IWebFrame iWebFrame = new IWebFrame(object2[0]);
        object2[0] = 0L;
        n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebMutableURLRequest, 0L, WebKit_win32.IID_IWebMutableURLRequest, (long[])object2);
        if (n != 0 || object2[0] == 0L) {
            iWebFrame.Release();
            return false;
        }
        IWebMutableURLRequest iWebMutableURLRequest = new IWebMutableURLRequest(object2[0]);
        n = 0;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3;
                String string2 = stringArray[n2];
                if (string2 != null && (n3 = string2.indexOf(58)) != -1) {
                    String string3 = string2.substring(0, n3).trim();
                    String string4 = string2.substring(n3 + 1).trim();
                    if (string3.length() > 0 && string4.length() > 0) {
                        long l = WebKit.createBSTR(string4);
                        if (string3.equalsIgnoreCase(USER_AGENT)) {
                            n = this.webView.setCustomUserAgent(l);
                        } else {
                            long l2 = WebKit.createBSTR(string3);
                            n = iWebMutableURLRequest.setValue(l, l2);
                            COM.SysFreeString(l2);
                        }
                        COM.SysFreeString(l);
                    }
                }
                ++n2;
            }
        }
        if (n == 0) {
            long l = WebKit.createBSTR((String)object);
            n = iWebMutableURLRequest.setURL(l);
            COM.SysFreeString(l);
            if (n == 0) {
                n = iWebFrame.loadRequest(iWebMutableURLRequest.getAddress());
            }
            this.webView.setCustomUserAgent(0L);
        }
        iWebFrame.Release();
        iWebMutableURLRequest.Release();
        return n == 0;
    }

    boolean shouldClose() {
        if (!this.jsEnabled) {
            return true;
        }
        long[] lArray = new long[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebViewPrivate, lArray);
        if (n != 0 || lArray[0] == 0L) {
            return false;
        }
        IWebViewPrivate iWebViewPrivate = new IWebViewPrivate(lArray[0]);
        int[] nArray = new int[1];
        iWebViewPrivate.shouldClose(nArray);
        iWebViewPrivate.Release();
        return nArray[0] != 0;
    }

    @Override
    public void stop() {
        this.webFrameLoadDelegate.html = null;
        long[] lArray = new long[1];
        int n = this.webView.QueryInterface(WebKit_win32.IID_IWebIBActions, lArray);
        if (n != 0 || lArray[0] == 0L) {
            return;
        }
        IWebIBActions iWebIBActions = new IWebIBActions(lArray[0]);
        iWebIBActions.stopLoading(this.webView.getAddress());
        iWebIBActions.Release();
    }

    void initializeWebViewPreferences() {
        IWebPreferences iWebPreferences;
        long[] lArray = new long[1];
        int n = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebPreferences, 0L, WebKit_win32.IID_IWebPreferences, lArray);
        if (n == 0 && lArray[0] != 0L) {
            iWebPreferences = new IWebPreferences(lArray[0]);
            lArray[0] = 0L;
            n = iWebPreferences.initWithIdentifier(WebKit.createBSTR(String.valueOf(prefsIdentifier++)), lArray);
            iWebPreferences.Release();
            if (n == 0 && lArray[0] != 0L) {
                iWebPreferences = new IWebPreferences(lArray[0]);
                this.webView.setPreferences(iWebPreferences.getAddress());
                iWebPreferences.Release();
            }
        }
        lArray[0] = 0L;
        n = this.webView.preferences(lArray);
        if (n == 0 && lArray[0] != 0L) {
            iWebPreferences = new IWebPreferences(lArray[0]);
            iWebPreferences.setJavaScriptEnabled(1);
            iWebPreferences.setJavaScriptCanOpenWindowsAutomatically(1);
            iWebPreferences.setJavaEnabled(0);
            iWebPreferences.setTabsToLinks(1);
            iWebPreferences.setFontSmoothing(4);
            iWebPreferences.Release();
        }
    }
}

