/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.interfaces.IReplaceable;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.StructPlugin;
import com.deltawalker.structure.internal.SyncOp;
import com.deltawalker.structure.internal.ui.ConfirmReplaceDialog;
import com.deltawalker.structure.internal.ui.SyncModel;
import com.deltawalker.structure.internal.ui.dialogs.ProgressDialog;
import com.deltawalker.structure.ui.FolderAlerts;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.ChooseSyncMenuAction;
import com.deltawalker.ui.actions.CopyMenuAction;
import com.deltawalker.ui.actions.DropdownMenuAction;
import com.deltawalker.ui.actions.IActionAccessor;
import com.deltawalker.ui.actions.ResourceAction;
import com.deltopia.util.IDisposable;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class SyncAction
extends ResourceAction
implements IDisposable {
    private IActionAccessor actAccessor;
    private IDiffDoc dDoc;
    private final IDiffDocListener onDiffDoc = new IDiffDocListener(){

        public void comparing() {
            SyncAction.this.setEnabled(false);
        }

        public void done() {
            if (SyncAction.this.getCheckedAction() != null) {
                SyncAction.this.update(true, SyncAction.this.toolTipText);
            }
        }

        public void threeWayChanged(boolean bl) {
            String string = NLS.bind((String)StructMsg.SyncAction_compositeTooltip, (Object)StructMsg.SyncAction_twoWayOnly);
            SyncAction.this.update(!bl, bl ? string : "");
        }
    };
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if ("INPUT".equals(string)) {
                SyncAction.this.setInput(SyncAction.this.sdView.getInput());
            }
        }
    };
    private StructDiffView sdView;
    private SyncModel syncModel;
    private String toolTipText;

    public SyncAction(ResourceBundle resourceBundle, StructDiffView structDiffView, IActionAccessor iActionAccessor) {
        super(StructPlugin.getPluginId(), resourceBundle, "SyncAction.", 1);
        this.sdView = structDiffView;
        structDiffView.addPropertyListener(this.onProp);
        this.setInput(structDiffView.getInput());
        this.actAccessor = iActionAccessor;
        this.setId("com.deltawalker.structure.sync");
        this.toolTipText = this.getToolTipText();
        this.update(false, NLS.bind((String)StructMsg.SyncAction_compositeTooltip, (Object)StructMsg.SyncAction_chooseFirst));
    }

    public void dispose() {
        this.sdView.removePropertyListener(this.onProp);
        this.sdView = null;
    }

    private IAction getCheckedAction() {
        DropdownMenuAction dropdownMenuAction = (DropdownMenuAction)this.actAccessor.getAction("com.deltawalker.structure.chooseSync");
        return dropdownMenuAction.getCheckedAction();
    }

    public void runWithEvent(final Event event) {
        IAction iAction = this.getCheckedAction();
        if (iAction == null) {
            return;
        }
        if (this.syncModel == null) {
            this.syncModel = new SyncModel(this.sdView.deltaModel());
        }
        SyncModel.SyncModelEventAdapter syncModelEventAdapter = new SyncModel.SyncModelEventAdapter(this.syncModel){

            @Override
            public void done() {
                SyncAction.this.syncModel = null;
            }

            @Override
            public Control getControl() {
                return SyncAction.this.sdView.getControl();
            }
        };
        this.syncModel.addListener(syncModelEventAdapter);
        final ChooseSyncMenuAction chooseSyncMenuAction = (ChooseSyncMenuAction)iAction;
        final SyncOp syncOp = chooseSyncMenuAction.syncOp();
        final SyncModel.SyncNodes syncNodes = chooseSyncMenuAction.syncNodes(true);
        final Role role = chooseSyncMenuAction.source();
        final Role role2 = chooseSyncMenuAction.destination();
        FolderAlerts.SyncOpInfo syncOpInfo = chooseSyncMenuAction.syncOpInfo2();
        final long l = chooseSyncMenuAction.syncOpInfo1().totalSize() + (syncOpInfo != null ? syncOpInfo.totalSize() : 0L);
        ConfirmReplaceDialog.Choice[] choiceArray = new ConfirmReplaceDialog.Choice[]{ConfirmReplaceDialog.Choice.DONT_REPLACE};
        this.syncModel.confirmNodes(chooseSyncMenuAction.syncOp(), syncNodes, role, role2, choiceArray, new IReplaceable(){

            public boolean shouldConfirm() {
                return CopyMenuAction.shouldConfirmReplace((Event)event);
            }
        });
        this.syncModel.removeListener(syncModelEventAdapter);
        if (choiceArray[0] == ConfirmReplaceDialog.Choice.CANCEL) {
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog(this.sdView.getControl().getShell()){

            @Override
            public void done() {
                SyncAction.this.setEnabled(true);
                chooseSyncMenuAction.setEnabled(true);
                super.done();
                SyncAction.this.syncModel = null;
            }

            @Override
            public String getErrorLabel() {
                return SyncOp.COPY.errorLabel();
            }

            @Override
            protected void run() {
                SyncAction.this.syncModel.sync(syncOp, role, role2, syncNodes, l);
            }

            @Override
            public void synchronizing() {
                SyncAction.this.setEnabled(false);
                chooseSyncMenuAction.setEnabled(false);
            }
        };
        String string = NLS.bind((String)syncOp.progressText(), (Object)(role2 != null ? role2.getDisplayName(this.dDoc.isThreeWay()) : StructMsg.SyncAction_both));
        progressDialog.setTitle(string);
        this.syncModel.addListener(progressDialog);
        progressDialog.open();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setToolTipText(this.toolTipText);
        }
    }

    private void setInput(IDiffDoc iDiffDoc) {
        if (this.dDoc != iDiffDoc) {
            if (this.dDoc != null) {
                this.dDoc.removeDiffDocListener(this.onDiffDoc);
            }
            this.dDoc = iDiffDoc;
            if (this.dDoc != null) {
                this.dDoc.addDiffDocListener(this.onDiffDoc);
            }
        }
    }

    private void update(boolean bl, String string) {
        this.setEnabled(bl);
        this.setToolTipText(string);
    }
}

