/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.interfaces.INodeFilter;
import com.deltawalker.interfaces.IPrefSerializer;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.internal.NodeFilter;
import com.deltawalker.structure.internal.ui.NodeFilters;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.StructAction;
import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;

public class ShowAction
extends StructAction
implements IPrefSerializer {
    private final INodeFilter.Criterion criterion;
    private final INodeFilter filter;

    public ShowAction(StructDiffView structDiffView, ResourceBundle resourceBundle, INodeFilter.Criterion criterion) {
        super(structDiffView, resourceBundle, "Show" + criterion + "Action.", 2);
        this.criterion = criterion;
        this.setId(criterion.actionId());
        this.filter = new NodeFilter(criterion);
        this.fromPrefs();
        this.update();
    }

    private String constructPrefName() {
        return String.valueOf(this.structView().getName()) + ".Show" + this.criterion + "Action";
    }

    private NodeFilters nodeFilters() {
        StructDiffModel structDiffModel = (StructDiffModel)this.structView().deltaModel();
        return structDiffModel != null ? structDiffModel.nodeFilters() : null;
    }

    public void fromPrefs() {
        String string;
        NodeFilters nodeFilters = this.nodeFilters();
        if (nodeFilters == null) {
            return;
        }
        IPreferenceStore iPreferenceStore = this.structView().preferences();
        if (iPreferenceStore.getBoolean(string = this.constructPrefName())) {
            nodeFilters.addFilter(this.filter);
        } else {
            nodeFilters.removeFilter(this.filter);
        }
    }

    public void run() {
        NodeFilters nodeFilters = this.nodeFilters();
        if (nodeFilters.contains(this.filter)) {
            nodeFilters.removeFilter(this.filter);
        } else {
            nodeFilters.addFilter(this.filter);
        }
        this.toPrefs();
    }

    @Override
    public void update() {
        NodeFilters nodeFilters = this.nodeFilters();
        if (nodeFilters != null) {
            this.setChecked(!this.nodeFilters().contains(this.filter));
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void toPrefs() {
        NodeFilters nodeFilters = this.nodeFilters();
        if (nodeFilters == null) {
            return;
        }
        IPreferenceStore iPreferenceStore = this.structView().preferences();
        String string = this.constructPrefName();
        iPreferenceStore.setValue(string, nodeFilters.contains(this.filter));
    }
}

