/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.Addon;
import com.deltawalker.IStructElement;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.internal.ui.dialogs.SetDateModifiedDialog;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltopia.io.VfsUtil;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetDateModifiedAction
extends StructAction {
    Logger LOG = LoggerFactory.getLogger(SetDateModifiedAction.class);

    public SetDateModifiedAction(StructDiffView structDiffView, ResourceBundle resourceBundle) {
        super(structDiffView, resourceBundle, null, 1, EnumSet.allOf(Addon.Edition.class));
        this.setId("com.deltawalker.structure.setDateModified");
    }

    public void run() {
        StructDiffView structDiffView = this.structView();
        final Role role = structDiffView.getFocusRole();
        Shell shell = structDiffView.getControl().getShell();
        final SetDateModifiedDialog setDateModifiedDialog = new SetDateModifiedDialog(shell, structDiffView);
        if (setDateModifiedDialog.open() == 0) {
            final List<IDiffNode> list = this.selectedNodes();
            final HashSet hashSet = new HashSet(list.size());
            BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (IDiffNode iDiffNode : list) {
                        if (!SetDateModifiedAction.this.setDateModified(iDiffNode, role, setDateModifiedDialog)) continue;
                        hashSet.add(iDiffNode);
                    }
                }
            });
            structDiffView.deltaModel().recompare(hashSet, true);
        }
    }

    private boolean setDateModified(IDiffNode iDiffNode, Role role, SetDateModifiedDialog setDateModifiedDialog) {
        IResource iResource = (IResource)iDiffNode.getElement(role);
        boolean bl = false;
        boolean bl2 = setDateModifiedDialog.useCopyDate();
        try {
            if (bl2) {
                Role role2 = setDateModifiedDialog.sourceRole();
                assert (role2 != role);
                IStructElement iStructElement = iDiffNode.getElement(role2);
                if (iStructElement instanceof IResource) {
                    long l = ((IResource)iStructElement).getLastModifiedTime();
                    iResource.setLastModifiedTime(l);
                    bl = true;
                }
            } else {
                long l = setDateModifiedDialog.selectedDate();
                iResource.setLastModifiedTime(l);
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.LOG.error("setDateModified() failed: ", (Throwable)iOException);
        }
        if (bl) {
            iDiffNode.update((IStructElement)iResource, true);
        }
        return bl;
    }

    @Override
    public void update() {
        StructDiffView structDiffView = this.structView();
        List list = structDiffView.deltaModel().getSelected();
        Role role = structDiffView.getFocusRole();
        boolean bl = false;
        if (role != null) {
            for (IDiffNode iDiffNode : list) {
                String string;
                IResource iResource = (IResource)iDiffNode.getElement(role);
                if (iResource == null || VfsUtil.getScheme((String)(string = iResource.getUri())).equals("ftp")) continue;
                bl = true;
            }
        }
        if (bl) {
            bl = !((IDoc)structDiffView.getInputs().get(role)).isSnapshot();
        }
        this.setEnabled(bl);
    }
}

