/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.IStructElement;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltawalker.ui.UriChooser;
import com.deltawalker.ui.UriChooserBoss;
import com.deltopia.io.FileType;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public class SetAsRootFolderAction
extends StructAction {
    public SetAsRootFolderAction(StructDiffView structDiffView, ResourceBundle resourceBundle) {
        super(structDiffView, resourceBundle);
        this.setId("com.deltawalker.structure.setAsRootFolder");
    }

    public boolean canAddToContextMenu() {
        IStructDiffModel iStructDiffModel = this.structView().deltaModel();
        List list = iStructDiffModel.getSelected();
        if (list.size() == 1) {
            IDiffNode iDiffNode = (IDiffNode)list.get(0);
            Set set = this.structView().roles();
            for (Role role : set) {
                IResource iResource;
                IStructElement iStructElement = iDiffNode.getElement(role);
                if (!(iStructElement instanceof IResource) || (iResource = (IResource)iStructElement).getType() != FileType.FOLDER) continue;
                return true;
            }
        }
        return false;
    }

    private IDiffNode getSelectedFolderNode() {
        IStructDiffModel iStructDiffModel = this.structView().deltaModel();
        List list = iStructDiffModel.getSelected();
        if (list.size() == 1) {
            IResource iResource;
            IStructElement iStructElement;
            IDiffNode iDiffNode = (IDiffNode)list.get(0);
            Role role = this.structView().getFocusRole();
            if (role != null && (iStructElement = iDiffNode.getElement(role)) instanceof IResource && FileType.FOLDER.equals((Object)(iResource = (IResource)iStructElement).getType())) {
                return iDiffNode;
            }
        }
        return null;
    }

    public void run() {
        IDiffNode iDiffNode = this.getSelectedFolderNode();
        if (iDiffNode != null) {
            StructDiffView structDiffView = this.structView();
            UriChooserBoss uriChooserBoss = structDiffView.uriChooserBoss();
            Role role = structDiffView.getFocusRole();
            IResource iResource = (IResource)iDiffNode.getElement(role);
            UriChooser uriChooser = uriChooserBoss.uriChooser(role);
            UriInfo uriInfo = uriChooser.uriInfo().cloneUpdateUri(iResource.getUri(), false);
            uriChooser.updateUriInfo(uriInfo, false, false, false);
        }
    }

    @Override
    public void update() {
        this.setEnabled(this.getSelectedFolderNode() != null);
    }
}

