/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.resources.FileResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.ShowInAction;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltopia.io.FileUtil;
import com.deltopia.util.OS;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;

public class OpenWithAction
extends StructAction {
    private String defaultText = this.getText();

    public OpenWithAction(StructDiffView structDiffView, ResourceBundle resourceBundle) {
        super(structDiffView, resourceBundle);
        this.setId("openWith");
    }

    public void run() {
        Role[] roleArray = new Role[1];
        IDiffNode iDiffNode = ShowInAction.getSingleValidNode(this.structView(), roleArray);
        IResource iResource = (IResource)iDiffNode.getElement(roleArray[0]);
        Program.launch((String)iResource.getUri());
    }

    @Override
    public void update() {
        Role[] roleArray = new Role[1];
        IDiffNode iDiffNode = ShowInAction.getSingleValidNode(this.structView(), roleArray);
        if (iDiffNode == null) {
            this.setEnabled(false);
            return;
        }
        IResource iResource = (IResource)iDiffNode.getElement(roleArray[0]);
        FileUtil.ProgramInfo programInfo = FileUtil.getImageFromExtension((String)iResource.getExtension(), (Point)FileResource.getImageSize());
        if (programInfo != null) {
            this.setText(NLS.bind((String)StructMsg.OpenWithAction_subText, (Object)programInfo.name));
            if (!OS.COCOA && programInfo.image != null && !programInfo.image.isDisposed()) {
                this.setImageDescriptor(ImageDescriptor.createFromImage((Image)programInfo.image));
            } else {
                this.setImageDescriptor("");
            }
        } else {
            this.setText(this.defaultText);
            this.setImageDescriptor("");
        }
        this.setEnabled(true);
    }
}

