/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.App;
import com.deltawalker.IStructElement;
import com.deltawalker.PrefKey;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.interfaces.IViewBoss;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.ui.StructAlerts;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltopia.io.FileType;
import com.deltopia.io.VfsUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class OpenSelectedAction
extends StructAction {
    private final Listener onSelection = new Listener(){

        public void handleEvent(Event event) {
            if (!$assertionsDisabled && event.type != 14) {
                throw new AssertionError();
            }
            OpenSelectedAction.this.run();
        }
    };

    public static List<Map<Role, UriInfo>> getSelectedUriInfoTriads(StructDiffView structDiffView, boolean bl) {
        IStructDiffModel iStructDiffModel = structDiffView.deltaModel();
        List list = iStructDiffModel.getSelected();
        ArrayList<Map<Role, UriInfo>> arrayList = new ArrayList<Map<Role, UriInfo>>(list.size());
        IDiffDoc iDiffDoc = structDiffView.getInput();
        Map map = iDiffDoc.triad(0);
        Set set = structDiffView.roles();
        for (IDiffNode iDiffNode : list) {
            EnumMap<Role, UriInfo> enumMap = new EnumMap<Role, UriInfo>(Role.class);
            int n = 0;
            for (Role role : set) {
                IResource iResource;
                IStructElement iStructElement = iDiffNode.getElement(role);
                String string = "";
                FileType fileType = FileType.UNKNOWN;
                if (iStructElement instanceof IResource) {
                    iResource = (IResource)iStructElement;
                    fileType = iResource.getType();
                    if (fileType == FileType.FILE) {
                        fileType = VfsUtil.isArchiveExtension((String)iResource.getExtension()) ? FileType.FOLDER : FileType.FILE;
                    }
                    string = iResource.getUri();
                }
                iResource = ((IDoc)map.get(role)).uriInfo();
                enumMap.put(role, new UriInfo(string, fileType, iResource.properties()));
                ++n;
            }
            if (n == 0) continue;
            arrayList.add(enumMap);
            if (bl) break;
        }
        return arrayList;
    }

    public OpenSelectedAction(StructDiffView structDiffView, ResourceBundle resourceBundle) {
        super(structDiffView, resourceBundle);
        this.setId("com.deltawalker.openSelected");
        this.installListeners(true);
    }

    @Override
    public void dispose() {
        this.installListeners(false);
        super.dispose();
    }

    private StructAlerts getAlerts() {
        return this.structView().controller().alerts();
    }

    private void installListeners(boolean bl) {
        StructDiffView structDiffView = this.structView();
        for (Role role : structDiffView.roles()) {
            Canvas canvas = structDiffView.treeView(role).tree();
            if (bl) {
                canvas.addListener(14, this.onSelection);
                continue;
            }
            canvas.removeListener(14, this.onSelection);
        }
    }

    public void run() {
        int n;
        StructDiffView structDiffView = this.structView();
        List<Map<Role, UriInfo>> list = OpenSelectedAction.getSelectedUriInfoTriads(structDiffView, false);
        if (list.isEmpty()) {
            return;
        }
        IDiffDoc iDiffDoc = structDiffView.getInput();
        IPreferenceStore iPreferenceStore = iDiffDoc.preferences();
        int n2 = n = iPreferenceStore.getBoolean(PrefKey.D_MAX_FILE_WND_COUNT_ON.toString()) ? iPreferenceStore.getInt(PrefKey.D_MAX_FILE_WND_COUNT.toString()) : 0;
        if (n <= 0 || list.size() <= n) {
            this.structView().getAlerts().showOpenFileLimit(false, 0);
        }
        int n3 = 0;
        IViewBoss iViewBoss = App.instance().viewBoss();
        for (Map<Role, UriInfo> map : list) {
            if (n > 0 && n3 >= n) {
                this.getAlerts().showOpenFileLimit(true, n3);
                break;
            }
            iViewBoss.createDocView(map, iPreferenceStore, iDiffDoc.getFiltersId(), iDiffDoc.isThreeWay(), null, true, true);
            ++n3;
        }
    }
}

