/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.FilterTable;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.StructPlugin;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.DropdownMenuAction;
import com.deltopia.util.IDisposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class FolderFiltersAction
extends DropdownMenuAction
implements IDisposable {
    private IDiffDoc dDoc;
    private DiffView dView;
    private FilterTable filterTable;
    private final IDiffDocListener onDiffDoc = new IDiffDocListener(){

        public void comparing() {
            FolderFiltersAction.this.comparisonInProgressChange();
        }

        public void done() {
            FolderFiltersAction.this.comparisonInProgressChange();
        }

        public void threeWayChanged(boolean bl) {
        }
    };
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if ("INPUT".equals(string)) {
                FolderFiltersAction.this.setDiffDoc(FolderFiltersAction.this.dView.getInput());
            }
        }
    };

    public FolderFiltersAction(IWorkbenchWindow iWorkbenchWindow, ResourceBundle resourceBundle) {
        super(StructPlugin.getPluginId(), resourceBundle, "FolderFiltersAction.", iWorkbenchWindow, true);
        this.setId("com.deltawalker.structure.folderFilters");
    }

    private void comparisonInProgressChange() {
        if (this.filterTable != null && !this.filterTable.isDisposed()) {
            Display display = this.filterTable.getDisplay();
            if (!Thread.currentThread().equals(display.getThread())) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FolderFiltersAction.this.comparisonInProgressChange();
                    }
                });
            } else {
                this.filterTable.setEnabled(this.dDoc == null || !this.dDoc.isWorking());
            }
        }
    }

    protected Control createControl(Composite composite) {
        this.filterTable = new FilterTable(composite, 16, this.dDoc.filters()){

            protected void checkStateChanged(IFilter iFilter, int n, boolean bl) {
                this.deepEnableContentChanged(false);
                try {
                    super.checkStateChanged(iFilter, n, bl);
                }
                finally {
                    this.deepEnableContentChanged(true);
                }
            }

            private void deepEnableContentChanged(boolean bl) {
                IStructDiffModel iStructDiffModel;
                if (FolderFiltersAction.this.dView != null && (iStructDiffModel = (IStructDiffModel)FolderFiltersAction.this.dView.deltaModel()) != null) {
                    iStructDiffModel.getRoot().deepEnableUpdate(bl);
                }
            }

            protected String getColumnText(Object object, int n) {
                FolderFilter folderFilter = (FolderFilter)object;
                switch (n) {
                    case 1: {
                        return folderFilter.target().toString();
                    }
                    case 0: {
                        return folderFilter.getDisplayExpression();
                    }
                    case 2: {
                        return folderFilter.action().toString();
                    }
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return "";
            }

            protected Object[] getFilterElements(List<IFilter> list) {
                ArrayList<IFilter> arrayList = new ArrayList<IFilter>(list.size());
                for (IFilter iFilter : list) {
                    if (!(iFilter instanceof IFolderFilter)) continue;
                    arrayList.add(iFilter);
                }
                return arrayList.toArray();
            }

            protected void setupTable(Table table) {
                TableColumn tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(StructMsg.FolderFiltersPrefPage_filter);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(60));
                tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(StructMsg.FolderFiltersPrefPage_target);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(20));
                tableColumn = new TableColumn(table, 16384);
                tableColumn.setText(StructMsg.FolderFiltersPrefPage_action);
                this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(15));
            }
        };
        FilterTable.increaseFontSize((Control)this.filterTable.table());
        this.filterTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (FolderFiltersAction.this.filterTable == disposeEvent.widget) {
                    FolderFiltersAction.this.filterTable = null;
                }
            }
        });
        return this.filterTable;
    }

    protected int defaultWidth() {
        return 450;
    }

    public void dispose() {
        try {
            this.setViewer(null);
        }
        finally {
            super.dispose();
        }
    }

    protected List<IAction> getMenuActions() {
        return Collections.emptyList();
    }

    public void runWithEvent(Event event) {
        if (this.canRunWithEvent(event)) {
            PrefUtil.openPrefDialogOn(null, (String)"com.deltawalker.structure.FolderFiltersPrefPage", null);
        }
    }

    private void setDiffDoc(IDiffDoc iDiffDoc) {
        if (this.dDoc != iDiffDoc) {
            if (this.dDoc != null) {
                this.dDoc.removeDiffDocListener(this.onDiffDoc);
            }
            this.dDoc = iDiffDoc;
            if (this.dDoc != null) {
                this.dDoc.addDiffDocListener(this.onDiffDoc);
            }
            this.comparisonInProgressChange();
        }
    }

    private void setViewer(DiffView diffView) {
        if (this.dView != diffView) {
            if (this.dView != null) {
                this.dView.removePropertyListener(this.onProp);
            }
            this.dView = diffView;
            if (this.dView != null) {
                this.dView.addPropertyListener(this.onProp);
            }
            this.setDiffDoc(diffView != null ? diffView.getInput() : null);
        }
    }

    protected void workbenchPartChanged(IWorkbenchPart iWorkbenchPart, IWorkbenchPart iWorkbenchPart2) {
        this.setViewer(this.deltaView(iWorkbenchPart));
        this.updateState();
    }
}

