/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.DiffDocListener;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.Expand;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltopia.util.ArrayListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ExpandAction
extends StructAction {
    private final Expand expand;
    private final DiffDocListener onDiffDoc;

    public ExpandAction(StructDiffView structDiffView, ResourceBundle resourceBundle, Expand expand) {
        super(structDiffView, resourceBundle, "Expand" + (Object)((Object)expand) + "Action.");
        this.setId(expand.actionId());
        this.expand = expand;
        this.onDiffDoc = new DiffDocListener(this.structView()){

            protected void comparing() {
                ExpandAction.this.update();
            }

            protected void diffDocChanged(IDiffDoc iDiffDoc, IDiffDoc iDiffDoc2) {
                ExpandAction.this.update();
            }

            protected void done() {
                ExpandAction.this.update();
            }
        };
    }

    @Override
    public void dispose() {
        try {
            this.onDiffDoc.dispose();
        }
        finally {
            super.dispose();
        }
    }

    private void expandChildren(IDiffNode iDiffNode, boolean bl) {
        ArrayList<IDiffNode> arrayList = new ArrayList<IDiffNode>();
        arrayList.add(iDiffNode);
        int n = arrayList.size();
        while (n > 0) {
            Object[] objectArray;
            Object e;
            IDiffNode iDiffNode2;
            if ((iDiffNode2 = (IDiffNode)(e = arrayList.remove(--n))).isSame() || (objectArray = iDiffNode2.getChildren(true)).length <= 0) continue;
            iDiffNode2.setExpanded(bl);
            ArrayListUtil.addAll(arrayList, (Object[])objectArray, (boolean)true);
            n += objectArray.length;
        }
    }

    public void run() {
        IStructDiffModel iStructDiffModel = this.deltaModel();
        IDiffNode iDiffNode = this.getTopNode(!this.expand.isContextual());
        try {
            iStructDiffModel.enableUpdate(false);
            if ((this.expand == Expand.ALL || this.expand == Expand.COLLAPSE_ALL) && iStructDiffModel != null && iDiffNode.equals(iStructDiffModel.getRoot())) {
                StructDiffModel.setExpanded(iDiffNode, this.expand.isExpand());
            } else {
                if (this.expand.isExpand()) {
                    StructDiffModel.setExpanded(iDiffNode, false);
                }
                this.expandChildren(iDiffNode, this.expand.isExpand());
            }
        }
        finally {
            iStructDiffModel.enableUpdate(true);
        }
    }

    @Override
    public void update() {
        if (this.expand.isContextual()) {
            List list = this.deltaModel().getSelected();
            if (list.isEmpty()) {
                this.setEnabled(false);
            } else {
                boolean bl = false;
                IDiffNode iDiffNode = (IDiffNode)list.get(0);
                if (iDiffNode.isStructure() && iDiffNode.hasChildren()) {
                    bl = true;
                }
                this.setEnabled(bl);
            }
        } else {
            this.setEnabled(true);
        }
    }
}

