/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.DiffModel;
import com.deltawalker.IStruct;
import com.deltawalker.IStructElement;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.DiffNode;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.PathFilter;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltawalker.ui.actions.DropdownMenuAction;
import com.deltopia.StringUtil;
import com.deltopia.jface.util.StatusLineUtil;
import com.deltopia.regex.RegexUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeAction
extends StructAction {
    protected static final Logger LOG = LoggerFactory.getLogger(ExcludeAction.class);
    private final ResourceBundle bundle;
    private final String defaultText;

    private static String getPrefix(String string) {
        if ("com.deltawalker.structure.excludeByExtension".equals(string)) {
            return "ExcludeByExtensionAction.";
        }
        if ("com.deltawalker.structure.excludeByName".equals(string)) {
            return "ExcludeByNameAction.";
        }
        if ("com.deltawalker.structure.excludeByPath".equals(string)) {
            return "ExcludeByPathAction.";
        }
        return null;
    }

    public ExcludeAction(StructDiffView structDiffView, ResourceBundle resourceBundle, String string) {
        super(structDiffView, resourceBundle, ExcludeAction.getPrefix(string));
        this.bundle = resourceBundle;
        this.setId(string);
        this.defaultText = this.getText();
    }

    private List<PathFilter> createRulesFromSelection() {
        Role role;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        List<IDiffNode> list = this.selectedNodes();
        block0: for (IDiffNode iDiffNode : list) {
            Role[] roleArray = Role.values();
            int n = roleArray.length;
            int n2 = 0;
            while (n2 < n) {
                role = roleArray[n2];
                IStructElement iStructElement = iDiffNode.getElement(role);
                if (!DiffModel.isNullElement((Object)iStructElement) && iStructElement instanceof IResource) {
                    String string = this.constructExpression((IResource)iStructElement, false);
                    if (string == null) continue block0;
                    (iStructElement instanceof IStruct ? hashSet : hashSet2).add(string);
                    continue block0;
                }
                ++n2;
            }
        }
        int n = hashSet.size();
        int n3 = hashSet2.size();
        role = new ArrayList(n + n3);
        if (!hashSet.isEmpty()) {
            String string = StringUtil.join((Object[])hashSet.toArray(new String[hashSet.size()]), (String)RegexUtil.SUB_EXPRESSION_SEPARATOR);
            role.add(new PathFilter(FolderFilter.Action.EXCLUDE, FolderFilter.Target.FOLDERS, string, false, false, true));
        }
        if (!hashSet2.isEmpty()) {
            String string = StringUtil.join((Object[])hashSet2.toArray(new String[hashSet2.size()]), (String)RegexUtil.SUB_EXPRESSION_SEPARATOR);
            role.add(new PathFilter(FolderFilter.Action.EXCLUDE, FolderFilter.Target.FILES, string, false, false, true));
        }
        return role;
    }

    private String constructExpression(IResource iResource, boolean bl) {
        String string = this.getId();
        String string2 = null;
        if ("com.deltawalker.structure.excludeByExtension".equals(string)) {
            if (!iResource.isDirectory() && (string2 = iResource.getExtension()) != null && string2.length() > 0) {
                string2 = bl ? ".*\\." + Pattern.quote(string2) : "*." + string2;
            }
        } else if ("com.deltawalker.structure.excludeByName".equals(string)) {
            string2 = bl ? "(.*" + RegexUtil.REGEX_SEPARATOR + "|)" + Pattern.quote(iResource.getName()) + "(" + RegexUtil.REGEX_SEPARATOR + ".*|)" : iResource.getName();
        } else if ("com.deltawalker.structure.excludeByPath".equals(string)) {
            string2 = bl ? "(.*" + RegexUtil.REGEX_SEPARATOR + "|)" + Pattern.quote(iResource.rootlessPath()) + "(" + RegexUtil.REGEX_SEPARATOR + ".*|)" : iResource.rootlessPath();
        }
        return string2;
    }

    public void run() {
        List<PathFilter> list = this.createRulesFromSelection();
        if (list.isEmpty()) {
            return;
        }
        IStructDiffModel iStructDiffModel = this.deltaModel();
        DiffNode diffNode = (DiffNode)iStructDiffModel.getRoot();
        diffNode.deepEnableUpdate(false);
        try {
            iStructDiffModel.filters().addAll(list);
        }
        finally {
            diffNode.deepEnableUpdate(true);
        }
        String string = list.size() == 1 ? NLS.bind((String)StructMsg.ExcludeAction_filterAdded, (Object)DropdownMenuAction.stripMnemonic((String)this.getText())) : StructMsg.ExcludeAction_filtersAdded;
        StatusLineUtil.setTimedMessage((IStatusLineManager)this.structView().getStatusLineManager(), (String)string);
    }

    @Override
    public void update() {
        boolean bl = false;
        String string = null;
        List<IDiffNode> list = this.selectedNodes();
        String string2 = this.getId();
        String string3 = ExcludeAction.getPrefix(string2);
        for (IDiffNode iDiffNode : list) {
            Object object;
            IResource iResource = null;
            Role[] roleArray = Role.values();
            int n = roleArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = roleArray[n2];
                IStructElement iStructElement = iDiffNode.getElement(object);
                if (!DiffModel.isNullElement((Object)iStructElement) && iStructElement instanceof IResource) {
                    iResource = (IResource)iStructElement;
                    break;
                }
                ++n2;
            }
            if (iResource == null) continue;
            if (string != null) {
                string = null;
                break;
            }
            if ("com.deltawalker.structure.excludeByPath".equals(string2)) {
                string = String.valueOf('\"') + iResource.rootlessPath() + '\"';
                bl = true;
                continue;
            }
            object = null;
            if ("com.deltawalker.structure.excludeByExtension".equals(string2)) {
                if (!iResource.isDirectory()) {
                    object = iResource.getExtension();
                }
            } else if ("com.deltawalker.structure.excludeByName".equals(string2)) {
                object = iResource.getName();
            }
            if (object == null) continue;
            bl = true;
            string = NLS.bind((String)this.bundle.getString(String.valueOf(string3) + "labelOne"), (Object)object);
        }
        if (string == null) {
            string = this.defaultText;
        }
        this.setEnabled(bl);
        this.setText(string);
    }
}

