/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.Addon;
import com.deltawalker.IStructElement;
import com.deltawalker.Relation;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IEditableStruct;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.SyncOp;
import com.deltawalker.structure.internal.ui.SyncModel;
import com.deltawalker.structure.internal.ui.dialogs.ProgressDialog;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.ElementWorkbenchAdapter;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltawalker.ui.actions.ActionId;
import com.deltopia.StringUtil;
import com.deltopia.jface.util.SelectionDialogUtil;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSelectedAction
extends StructAction {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteSelectedAction.class);
    private ResourceBundle bundle;
    private String prefix;

    public static boolean canEnable(IStructDiffModel iStructDiffModel) {
        List list = iStructDiffModel.getSelected();
        boolean bl = iStructDiffModel.isThreeWay();
        for (IDiffNode iDiffNode : list) {
            IDiffNode iDiffNode2 = iDiffNode.getParent();
            if (iDiffNode2 == null) continue;
            Set set = Relation.roles((boolean)bl);
            for (Role role : set) {
                IStructElement iStructElement = iDiffNode2.getElement(role);
                try {
                    if (!(iStructElement instanceof IEditableStruct) || iStructElement instanceof IResource && !((IResource)iStructElement).canEverWrite()) continue;
                    return true;
                }
                catch (IOException iOException) {
                    LOG.error(null, (Throwable)iOException);
                }
            }
        }
        return false;
    }

    public DeleteSelectedAction(StructDiffView structDiffView, ResourceBundle resourceBundle) {
        super(structDiffView, resourceBundle, "DeleteSelectedAction.", 1, EnumSet.allOf(Addon.Edition.class));
        this.setId(ActionId.DELETE_SELECTED);
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    private Object[] confirmDelete(Shell shell, AdaptableList adaptableList) {
        if (adaptableList.size() <= 0) {
            return Const.EMPTY_OBJECT_ARRAY;
        }
        SelectionDialog selectionDialog = SelectionDialogUtil.createSelectionDialog((Shell)shell, (Object)adaptableList, (ITreeContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new LabelProvider(), (String)this.getConfirmationMessage(), (String)StructMsg.DeleteSelectedAction_delete, (String)StructMsg.DeleteSelectedAction_dontDelete, (boolean)false);
        selectionDialog.setInitialSelections(new Object[]{adaptableList.getChildren()[0]});
        selectionDialog.setTitle(this.getConfirmationTitle(adaptableList.size() == 1));
        selectionDialog.open();
        return selectionDialog.getResult();
    }

    private void delete(Shell shell, Set<ElementWorkbenchAdapter> set) {
        if (set.isEmpty()) {
            return;
        }
        final SyncModel syncModel = new SyncModel(this.deltaModel());
        final SyncModel.SyncNodes syncNodes = syncModel.new SyncModel.SyncNodes();
        syncNodes.elements = set;
        ProgressDialog progressDialog = new ProgressDialog(shell){

            @Override
            public void done() {
                DeleteSelectedAction.this.setEnabled(true);
                super.done();
            }

            @Override
            public String getErrorLabel() {
                return SyncOp.DELETE.errorLabel();
            }

            @Override
            protected void run() {
                try {
                    syncModel.sync(SyncOp.DELETE, null, null, syncNodes, syncNodes.elements.size());
                }
                catch (Throwable throwable) {
                    LOG.error("Error deleting resource: ", throwable);
                }
            }

            @Override
            public void synchronizing() {
                DeleteSelectedAction.this.setEnabled(false);
            }
        };
        progressDialog.setTitle(StructMsg.DeleteSelectedAction_title);
        syncModel.addListener(progressDialog);
        int n = progressDialog.open();
        if (OS.WIN && n == 0) {
            this.structView().redrawContentAreas();
        }
    }

    private void deleteElements(List<List<IStructElement>> list, Set<Role> set, List<IDiffNode> list2) {
        int n;
        Object object;
        Object object2;
        Role role2;
        final boolean bl = this.structView().isThreeWay();
        AdaptableList adaptableList = new AdaptableList();
        int n2 = 0;
        for (final Role role2 : set) {
            object2 = new AdaptableList(){

                public String toString() {
                    return role2.getDisplayName(bl);
                }
            };
            object = list.get(n2++);
            n = 0;
            while (n < object.size()) {
                IStructElement iStructElement = object.get(n);
                if (iStructElement != null && iStructElement.getParent() instanceof IEditableStruct) {
                    object2.add((IAdaptable)new ElementWorkbenchAdapter(iStructElement, list2.get(n), object2));
                }
                ++n;
            }
            if (object2.size() <= 0) continue;
            adaptableList.add((IAdaptable)object2);
        }
        role2 = this.structView().getControl().getShell();
        Object[] objectArray = this.confirmDelete((Shell)role2, adaptableList);
        if (objectArray != null) {
            object2 = new LinkedHashSet();
            Object[] objectArray2 = objectArray;
            int n3 = objectArray.length;
            n = 0;
            while (n < n3) {
                object = objectArray2[n];
                if (object instanceof ElementWorkbenchAdapter) {
                    object2.add((ElementWorkbenchAdapter)object);
                }
                ++n;
            }
            this.delete((Shell)role2, (Set<ElementWorkbenchAdapter>)object2);
        }
    }

    protected void doInitialize(ResourceBundle resourceBundle, String string, String string2) {
        super.doInitialize(resourceBundle, string, string2);
        this.bundle = resourceBundle;
        this.prefix = string;
    }

    protected String getConfirmationMessage() {
        String string = String.valueOf(this.prefix) + "confirm.";
        String string2 = OS.resourceSuffix();
        String string3 = DeleteSelectedAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(string) + string2), null);
        if (string3 == null && !StringUtil.isEmpty((String)string2)) {
            string3 = DeleteSelectedAction.getString((ResourceBundle)this.bundle, (String)string, null);
        }
        return string3;
    }

    protected String getConfirmationTitle(boolean bl) {
        return DeleteSelectedAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(this.prefix) + "confirm" + (bl ? "Multi" : "Single")), null);
    }

    protected String getErrorMessage(Object object) {
        String string = object instanceof IStructElement ? "Element" : "Cause";
        return DeleteSelectedAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(this.prefix) + "errMsgWith" + string), null);
    }

    protected String getErrorTitle() {
        return DeleteSelectedAction.getString((ResourceBundle)this.bundle, (String)(String.valueOf(this.prefix) + "errTitle"), (String)"");
    }

    private Set<Role> getRolesInDeletionOrder() {
        StructDiffView structDiffView = this.structView();
        Role role = structDiffView.getFocusRole();
        boolean bl = structDiffView.isThreeWay();
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>();
        if (role != null) {
            linkedHashSet.add(role);
            linkedHashSet.addAll(Relation.others((Role)role, (boolean)bl));
        } else {
            linkedHashSet = Relation.roles((boolean)bl);
        }
        return linkedHashSet;
    }

    public void run() {
        IStructDiffModel iStructDiffModel = this.deltaModel();
        List list = iStructDiffModel.getSelected();
        Set<Role> set = this.getRolesInDeletionOrder();
        LinkedList<List<IStructElement>> linkedList = new LinkedList<List<IStructElement>>();
        for (Role role : set) {
            linkedList.add(iStructDiffModel.getSelectedElements(role));
        }
        this.deleteElements(linkedList, set, list);
    }

    @Override
    public void update() {
        boolean bl = DeleteSelectedAction.canEnable(this.deltaModel());
        if (bl) {
            Role role = this.structView().getFocusRole();
            bl = !((IDoc)this.structView().getInputs().get(role)).isSnapshot();
        }
        this.setEnabled(bl);
    }
}

