/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.Addon;
import com.deltawalker.IStructElement;
import com.deltawalker.LineEndingUtil;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.CopyAction;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;

public class CopySelectedPathsAction
extends StructAction {
    public CopySelectedPathsAction(StructDiffView structDiffView, ResourceBundle resourceBundle) {
        super(structDiffView, resourceBundle, null, 1, EnumSet.allOf(Addon.Edition.class));
        this.setId("com.deltawalker.structure.copySelectedPaths");
    }

    public void run() {
        StructDiffView structDiffView = this.structView();
        Role role = structDiffView.getFocusRole();
        if (role == null) {
            return;
        }
        String string = LineEndingUtil.fromPreferences();
        List<IDiffNode> list = this.selectedNodes();
        StringBuffer stringBuffer = new StringBuffer();
        for (IDiffNode iDiffNode : list) {
            IStructElement iStructElement = iDiffNode.getElement(role);
            if (!(iStructElement instanceof IResource)) continue;
            stringBuffer.append(((IResource)iStructElement).getUri());
            stringBuffer.append(string);
        }
        UIUtil.copyTextToClipboard((String)stringBuffer.toString());
    }

    @Override
    public void update() {
        IStructDiffModel iStructDiffModel = this.structView().deltaModel();
        boolean bl = iStructDiffModel.getSelected().size() > 1;
        this.setText(bl ? StructMsg.CopySelectedPathsAction_textPlural : StructMsg.CopySelectedPathsAction_textSingular);
        this.setEnabled(CopyAction.shouldEnable((IStructDiffModel)iStructDiffModel, (boolean)false, (Role)this.structView().getFocusRole(), null));
    }
}

