/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.Addon;
import com.deltawalker.Relation;
import com.deltawalker.interfaces.IReplaceable;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.CopyAction;
import com.deltawalker.ui.actions.CopyMenuAction;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;

public class CopySelectedAction
extends StructAction {
    private Role dst;
    private final boolean move;
    private Role src;

    private static String constructActionId(boolean bl, int n) {
        String string = bl ? (n == 0 ? "com.deltawalker.structure.moveSelected0" : "com.deltawalker.structure.moveSelected1") : (n == 0 ? "com.deltawalker.structure.copySelected0" : "com.deltawalker.structure.copySelected1");
        return string;
    }

    public static String constructActionLabel(Role role, Role role2, boolean bl, boolean bl2) {
        return NLS.bind((String)(bl ? StructMsg.MoveSelectedAction_label : StructMsg.CopySelectedAction_label), (Object)role.getDisplayName(bl2), (Object)role2.getDisplayName(bl2));
    }

    private static String constructActionName(boolean bl, int n) {
        String string = String.valueOf(bl ? "Move" : "Copy") + "Selected" + n + "Action.";
        return string;
    }

    private String constructImageKey(Role role, Role role2, boolean bl, boolean bl2) {
        String string = bl ? "Move" : "Copy";
        String string2 = String.valueOf(string) + "Selected0Action.icon";
        String string3 = String.valueOf(string) + "Selected0Action.disabledIcon";
        String string4 = String.valueOf(string) + "Selected1Action.icon";
        String string5 = String.valueOf(string) + "Selected1Action.disabledIcon";
        boolean bl3 = this.structView().isThreeWay();
        if (role == Role.REF) {
            if (bl3 && role2 == Role.ONE) {
                return bl2 ? string4 : string5;
            }
            return bl2 ? string2 : string3;
        }
        if (role == Role.ONE) {
            if (bl3) {
                return bl2 ? string2 : string3;
            }
            return bl2 ? string4 : string5;
        }
        return bl2 ? string4 : string5;
    }

    public static Set<Role> getPossibleDestinations(Role role, DiffView diffView) {
        if (role == null) {
            throw new NullPointerException("src");
        }
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>();
        Set set = Relation.roles((boolean)diffView.isThreeWay());
        for (Role role2 : set) {
            if (role2 == role) continue;
            linkedHashSet.add(role2);
        }
        return linkedHashSet;
    }

    public static boolean isValidResource(Object object) {
        return object instanceof IResource;
    }

    public CopySelectedAction(StructDiffView structDiffView, ResourceBundle resourceBundle, int n, boolean bl) {
        super(structDiffView, resourceBundle, CopySelectedAction.constructActionName(bl, n), 1, EnumSet.allOf(Addon.Edition.class));
        this.move = bl;
        this.setId(CopySelectedAction.constructActionId(bl, n));
    }

    private String constructImageKey(boolean bl) {
        return this.constructImageKey(this.src, this.dst, this.move, bl);
    }

    public void runWithEvent(final Event event) {
        this.structView().deltaModel().copy(this.src, this.dst, this.move, new IReplaceable(){

            public boolean shouldConfirm() {
                return CopyMenuAction.shouldConfirmReplace((Event)event);
            }
        });
    }

    public void setRoles(Role role, Role role2) {
        this.src = role;
        this.dst = role2;
        boolean bl = this.structView().isThreeWay();
        String string = CopySelectedAction.constructActionLabel(role, role2, this.move, bl);
        String string2 = this.getTextSuffix();
        string = this.isLicensed() ? string : String.valueOf(string) + string2;
        this.setText(string);
        this.setToolTipText(string);
        ResourceBundle resourceBundle = StructMsg.constructedKeyBundle();
        String string3 = CopySelectedAction.getString((ResourceBundle)resourceBundle, (String)this.constructImageKey(true), null);
        this.setImageDescriptor(string3);
        string3 = CopySelectedAction.getString((ResourceBundle)resourceBundle, (String)this.constructImageKey(false), null);
        this.setDisabledImageDescriptor(string3);
    }

    @Override
    public void update() {
        boolean bl;
        boolean bl2 = bl = this.src != null && this.dst != null && CopyAction.shouldEnable((IStructDiffModel)this.structView().deltaModel(), (boolean)this.move, (Role)this.src, (Role)this.dst);
        if (bl) {
            bl = !this.structView().getInput().hasSnapshot();
        }
        this.setEnabled(bl);
    }
}

