/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.App;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.StructDiffController;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.OpenSelectedAction;
import com.deltawalker.structure.ui.actions.StructAction;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.jface.util.StatusLineUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CompareWithAction
extends StructAction {
    private static final int TIMEOUT = 5000;
    private Menu oldMenu;
    private final KeyListener onKey = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.character == '\u001b') {
                CompareWithAction.this.cancelCompareWith(true);
            }
        }
    };
    private final MouseListener onMouse = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                CompareWithAction.this.compareWith();
            }
        }
    };
    private Map<Role, UriInfo> uriInfos = null;

    public CompareWithAction(StructDiffView structDiffView, ResourceBundle resourceBundle) {
        super(structDiffView, resourceBundle);
        this.setId("com.deltawalker.structure.compareTo");
    }

    private void cancelCompareWith(boolean bl) {
        Object object2;
        StructDiffView structDiffView = this.structView();
        for (Object object2 : structDiffView.roles()) {
            structDiffView.treeView((Role)object2).tree().setCursor(structDiffView.getCursor(0));
            structDiffView.treeView((Role)object2).controller().clearSelectionMode();
        }
        this.uriInfos = null;
        this.installListeners(false);
        object2 = structDiffView.controller();
        ((StructDiffController)((Object)object2)).setCanShowTreeContextMenu(true);
        ((StructDiffController)((Object)object2)).installContextMenu();
        if (bl) {
            StatusLineUtil.setTimedMessage((IStatusLineManager)structDiffView.getStatusLineManager(), (String)StructMsg.CompareWithAction_canceled, (int)5000);
        }
        if (this.oldMenu != null) {
            Canvas canvas = structDiffView.treeView(structDiffView.getFocusRole()).tree();
            canvas.setMenu(this.oldMenu);
        }
    }

    private void compareWith() {
        if (this.uriInfos == null) {
            return;
        }
        final StructDiffView structDiffView = this.structView();
        Role role = structDiffView.getFocusRole();
        if (role == null) {
            return;
        }
        Map<Role, UriInfo> map = this.getSelectedUriInfos();
        UriInfo uriInfo = map.get(role);
        if (uriInfo == null || uriInfo.isEmpty() || this.getCachedType() != uriInfo.fileType()) {
            return;
        }
        if (this.uriInfos.containsKey(role)) {
            Set set = Relation.others((Role)role, (boolean)false);
            Role role2 = (Role)set.iterator().next();
            this.uriInfos.put(role2, uriInfo);
        } else {
            this.uriInfos.put(role, uriInfo);
        }
        UriInfoUtil.makeUriInfosSafe(this.uriInfos, (FileType)FileType.FILE);
        StatusLineUtil.setTimedMessage((IStatusLineManager)structDiffView.getStatusLineManager(), (String)StructMsg.CompareWithAction_opening, (int)5000);
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    IDiffDoc iDiffDoc = structDiffView.getInput();
                    App.instance().viewBoss().createDocView(CompareWithAction.this.uriInfos, iDiffDoc.preferences(), iDiffDoc.getFiltersId(), false, null, true, true);
                }
                finally {
                    CompareWithAction.this.cancelCompareWith(false);
                }
            }
        });
    }

    private String getCachedName() {
        Set set = Relation.roles((boolean)false);
        for (Role role : set) {
            UriInfo uriInfo = this.uriInfos.get(role);
            if (uriInfo == null) continue;
            return FileUtil.getFileName((String)uriInfo.uri());
        }
        return "";
    }

    private FileType getCachedType() {
        Set set = Relation.roles((boolean)this.structView().isThreeWay());
        for (Role role : set) {
            UriInfo uriInfo = this.uriInfos.get(role);
            if (uriInfo == null) continue;
            return uriInfo.fileType();
        }
        return FileType.UNKNOWN;
    }

    private Map<Role, UriInfo> getSelectedUriInfos() {
        return OpenSelectedAction.getSelectedUriInfoTriads(this.structView(), true).get(0);
    }

    private FileType getTargetType(Map<Role, UriInfo> map, Role role) {
        UriInfo uriInfo;
        if (role != null && (uriInfo = map.get(role)) != null && !uriInfo.isEmpty()) {
            return uriInfo.fileType();
        }
        return FileType.UNKNOWN;
    }

    private void installListeners(boolean bl) {
        StructDiffView structDiffView = this.structView();
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            Canvas canvas = structDiffView.treeView(role).tree();
            if (bl) {
                canvas.addMouseListener(this.onMouse);
                canvas.addKeyListener(this.onKey);
            } else {
                canvas.removeMouseListener(this.onMouse);
                canvas.removeKeyListener(this.onKey);
            }
            ++n2;
        }
    }

    private boolean isTargetUriValid(Map<Role, UriInfo> map, Role role) {
        UriInfo uriInfo;
        boolean bl = false;
        if (role != null && (uriInfo = map.get(role)) != null && !uriInfo.isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private void replaceContextMenu() {
        final StructDiffView structDiffView = this.structView();
        TreeView treeView = structDiffView.treeView(structDiffView.getFocusRole());
        Canvas canvas = treeView.tree();
        Menu menu = new Menu((Control)canvas);
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CompareWithAction.this.compareWith();
            }
        });
        new MenuItem(menu, 2);
        final MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CompareWithAction.this.cancelCompareWith(true);
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                Role role;
                Map map = CompareWithAction.this.getSelectedUriInfos();
                boolean bl = CompareWithAction.this.isTargetUriValid(map, role = structDiffView.getFocusRole()) && CompareWithAction.this.getCachedType() == CompareWithAction.this.getTargetType(map, role);
                String string = CompareWithAction.this.getCachedName();
                menuItem.setText(NLS.bind((String)StructMsg.CompareWithAction_compareWith, (Object)string));
                menuItem.setEnabled(bl);
                menuItem2.setText(StructMsg.CompareWithAction_cancel);
            }
        });
        this.oldMenu = canvas.getMenu();
        canvas.setMenu(menu);
    }

    public void run() {
        this.setTreeCursor(21);
        Map<Role, UriInfo> map = this.getSelectedUriInfos();
        this.uriInfos = new EnumMap<Role, UriInfo>(Role.class);
        StructDiffView structDiffView = this.structView();
        Role role = structDiffView.getFocusRole();
        this.uriInfos.put(role, map.get(role));
        String string = NLS.bind((String)StructMsg.CompareWithAction_select, (Object)this.getCachedName(), (Object)role.getDisplayName(structDiffView.isThreeWay()));
        StatusLineUtil.setMessage((IStatusLineManager)structDiffView.getStatusLineManager(), (String)string);
        this.installListeners(true);
        structDiffView.controller().setCanShowTreeContextMenu(false);
    }

    private void setTreeCursor(int n) {
        StructDiffView structDiffView = this.structView();
        Role[] roleArray = Role.values();
        int n2 = roleArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Role role = roleArray[n3];
            structDiffView.treeView(role).tree().setCursor(structDiffView.getCursor(n));
            ++n3;
        }
    }

    @Override
    public void update() {
        List<Map<Role, UriInfo>> list;
        StructDiffView structDiffView = this.structView();
        IStructDiffModel iStructDiffModel = this.deltaModel();
        boolean bl = false;
        if (!iStructDiffModel.isEmpty() && (list = OpenSelectedAction.getSelectedUriInfoTriads(structDiffView, false)).size() == 1) {
            bl = this.isTargetUriValid(list.get(0), structDiffView.getFocusRole());
        }
        this.setEnabled(bl);
    }
}

