/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui.actions;

import com.deltawalker.script.Role;
import com.deltawalker.structure.Sync2WayOp;
import com.deltawalker.structure.internal.StructPlugin;
import com.deltawalker.structure.internal.SyncOp;
import com.deltawalker.structure.internal.ui.SyncModel;
import com.deltawalker.structure.ui.FolderAlerts;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.actions.ResourceAction;
import com.deltopia.jface.util.StatusLineUtil;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.texteditor.IUpdate;

public class ChooseSyncMenuAction
extends ResourceAction
implements IUpdate {
    private Role dst;
    private SyncOp op;
    private FolderAlerts.SyncOpInfo opInfo1;
    private FolderAlerts.SyncOpInfo opInfo2;
    private StructDiffView sdView;
    private Role src;
    private SyncOp subOp1;
    private SyncOp subOp2;
    private SyncModel syncModel;
    private SyncModel.SyncNodes syncNodes;
    private int totalWork;

    private static String getPrefix(String string) {
        String string2 = "";
        if (string.equals("com.deltawalker.updateRef")) {
            string2 = Sync2WayOp.UPDATE_REF.actionPrefix();
        } else if (string.equals("com.deltawalker.updateOne")) {
            string2 = Sync2WayOp.UPDATE_ONE.actionPrefix();
        } else if (string.equals("com.deltawalker.updateBoth")) {
            string2 = Sync2WayOp.UPDATE_BOTH.actionPrefix();
        } else if (string.equals("com.deltawalker.mirrorToRef")) {
            string2 = Sync2WayOp.MIRROR_TO_REF.actionPrefix();
        } else if (string.equals("com.deltawalker.mirrorToOne")) {
            string2 = Sync2WayOp.MIRROR_TO_ONE.actionPrefix();
        } else assert (false);
        return string2;
    }

    public ChooseSyncMenuAction(ResourceBundle resourceBundle, StructDiffView structDiffView, String string) {
        super(StructPlugin.getPluginId(), resourceBundle, ChooseSyncMenuAction.getPrefix(string), 8);
        this.setId(string);
        this.sdView = structDiffView;
    }

    public Role destination() {
        return this.dst;
    }

    public Role source() {
        return this.src;
    }

    public FolderAlerts.SyncOpInfo syncOpInfo1() {
        return this.opInfo1;
    }

    public FolderAlerts.SyncOpInfo syncOpInfo2() {
        return this.opInfo2;
    }

    public SyncModel.SyncNodes syncNodes(boolean bl) {
        return bl ? this.syncNodes.clone() : this.syncNodes;
    }

    public SyncOp syncOp() {
        return this.op;
    }

    public int totalWork() {
        return this.totalWork;
    }

    private void initilizeSyncInfo() {
        this.opInfo1 = null;
        this.opInfo2 = null;
        FolderAlerts folderAlerts = (FolderAlerts)this.sdView.getAlerts();
        switch (this.op) {
            case UPDATE: {
                boolean bl = this.src == null && this.dst == null;
                int n = this.syncNodes.newerIn1.size() + this.syncNodes.added.size();
                Role role = bl ? Role.ONE : this.src;
                long l = this.syncModel.totalSize(this.syncNodes.newerIn1, role);
                FolderAlerts folderAlerts2 = folderAlerts;
                ((Object)((Object)folderAlerts2)).getClass();
                this.opInfo1 = folderAlerts2.new FolderAlerts.SyncOpInfo(this.op, this.subOp1, bl ? Role.REF : this.dst, n, l += this.syncModel.totalSize(this.syncNodes.added, role));
                if (!bl) break;
                n = this.syncNodes.newerIn0.size() + this.syncNodes.deleted.size();
                role = Role.REF;
                l = this.syncModel.totalSize(this.syncNodes.newerIn0, role);
                FolderAlerts folderAlerts3 = folderAlerts;
                ((Object)((Object)folderAlerts3)).getClass();
                this.opInfo2 = folderAlerts3.new FolderAlerts.SyncOpInfo(this.op, this.subOp2, bl ? Role.ONE : this.src, n, l += this.syncModel.totalSize(this.syncNodes.deleted, role));
                break;
            }
            case MIRROR: {
                int n = this.syncNodes.newerIn0.size() + this.syncNodes.newerIn1.size() + this.syncNodes.added.size();
                long l = this.syncModel.totalSize(this.syncNodes.newerIn0, this.src) + this.syncModel.totalSize(this.syncNodes.newerIn1, this.src);
                FolderAlerts folderAlerts4 = folderAlerts;
                ((Object)((Object)folderAlerts4)).getClass();
                this.opInfo1 = folderAlerts4.new FolderAlerts.SyncOpInfo(this.op, this.subOp1, this.dst, n, l += this.syncModel.totalSize(this.syncNodes.added, this.src));
                if (this.syncNodes.toDelete.size() <= 0) break;
                n = this.syncNodes.toDelete.size();
                l = this.syncModel.totalSize(this.syncNodes.toDelete, this.dst);
                FolderAlerts folderAlerts5 = folderAlerts;
                ((Object)((Object)folderAlerts5)).getClass();
                this.opInfo2 = folderAlerts5.new FolderAlerts.SyncOpInfo(this.op, this.subOp2, this.dst, n, l);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void run() {
        if (!this.isChecked()) {
            return;
        }
        String string = this.getId();
        if (string.equals("com.deltawalker.updateRef")) {
            this.op = SyncOp.UPDATE;
            this.subOp1 = SyncOp.COPY;
            this.src = Role.ONE;
            this.dst = Role.REF;
        } else if (string.equals("com.deltawalker.updateOne")) {
            this.op = SyncOp.UPDATE;
            this.subOp1 = SyncOp.COPY;
            this.src = Role.REF;
            this.dst = Role.ONE;
        } else if (string.equals("com.deltawalker.updateBoth")) {
            this.op = SyncOp.UPDATE;
            this.subOp1 = SyncOp.COPY;
            this.subOp2 = SyncOp.COPY;
            this.src = null;
            this.dst = null;
        } else if (string.equals("com.deltawalker.mirrorToRef")) {
            this.op = SyncOp.MIRROR;
            this.subOp1 = SyncOp.COPY;
            this.subOp2 = SyncOp.DELETE;
            this.src = Role.ONE;
            this.dst = Role.REF;
        } else if (string.equals("com.deltawalker.mirrorToOne")) {
            this.op = SyncOp.MIRROR;
            this.subOp1 = SyncOp.COPY;
            this.subOp2 = SyncOp.DELETE;
            this.src = Role.REF;
            this.dst = Role.ONE;
        } else assert (false) : "Invalid Update/Mirror action ID.";
        this.syncModel = new SyncModel(this.sdView.deltaModel());
        this.syncNodes = this.syncModel.new SyncModel.SyncNodes();
        this.totalWork = this.syncModel.collectNodes(this.op, this.src, this.dst, this.syncNodes);
        this.showSyncAlert();
        StatusLineUtil.setTimedMessage((IStatusLineManager)this.sdView.getStatusLineManager(), (String)this.getDescription());
        this.syncModel = null;
    }

    private void showSyncAlert() {
        this.initilizeSyncInfo();
        FolderAlerts folderAlerts = (FolderAlerts)this.sdView.getAlerts();
        folderAlerts.showSyncInfo(true, this.opInfo1, this.opInfo2);
    }

    public void update() {
        boolean bl;
        boolean bl2 = bl = !this.sdView.isThreeWay();
        if (bl) {
            bl = !this.sdView.getInput().hasSnapshot();
        }
        this.setEnabled(bl);
    }
}

