/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.Delta;
import com.deltawalker.IStruct;
import com.deltawalker.IStructElement;
import com.deltawalker.NullStructElement;
import com.deltawalker.Relation;
import com.deltawalker.StructException;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFolderFilter;
import com.deltawalker.interfaces.IPrefSerializer;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.structure.IStructDoc;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.StructBirdsEye;
import com.deltawalker.structure.internal.ui.StructDiffModelListener;
import com.deltawalker.structure.internal.ui.StructPrintOp;
import com.deltawalker.structure.internal.ui.StructViewLayout;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.StructAlerts;
import com.deltawalker.structure.ui.StructContentArea;
import com.deltawalker.structure.ui.StructDiffController;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.DiffModelListener;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.DiffViewLayout;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.IDeltaNotifier;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.IPrintable;
import com.deltawalker.ui.printing.IPrinter;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.jface.util.StatusLineUtil;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public abstract class StructDiffView
extends DiffView
implements IPrintable {
    protected Map<Role, ColumnBoss> colBosses = new EnumMap<Role, ColumnBoss>(Role.class);
    private final IDeltaListener onDelta = new IDeltaListener(){

        public void deltasChanged() {
            StructDiffView.this.fireDeltasChanged();
        }

        public void selectionChanged(boolean bl) {
            StructDiffView.this.fireDeltaSelectionChanged(bl);
        }
    };
    private IStructDiffModel sdModel;

    protected StructDiffView(Composite composite, int n) {
        super(composite, 0, n);
    }

    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        for (Role role : Relation.roles((boolean)true)) {
            this.treeView(role).addFocusListener(focusListener);
        }
    }

    public StructBirdsEye birdsEye() {
        return (StructBirdsEye)super.birdsEye();
    }

    public abstract ColumnBoss columnBoss(Role var1);

    public int commonScrollableWidth() {
        return this.isThreeWay() ? 46 : 26;
    }

    public int commonScrollBarVerticalOffset() {
        return this.isCommonScrollBarVisible() ? (OS.OSX ? 16 : 20) : 0;
    }

    public StructContentArea contentArea(Role role) {
        return (StructContentArea)super.contentArea(role);
    }

    public StructDiffController controller() {
        return (StructDiffController)super.controller();
    }

    protected void createBirdsEye(Composite composite) {
        this.birdsEye = new StructBirdsEye(composite, this);
    }

    protected StructContentArea createContentArea(Composite composite, Role role) {
        return new StructContentArea(composite, 0, this, role);
    }

    protected void createControl() {
        super.createControl();
        this.controller().filterBoss().initialize(this);
    }

    protected DiffModelListener createDeltaModelListener() {
        return new StructDiffModelListener(this);
    }

    protected DiffViewLayout createLayout() {
        return new StructViewLayout(this);
    }

    public IStructDiffModel deltaModel() {
        if (this.sdModel == null) {
            this.sdModel = (IStructDiffModel)super.deltaModel();
        }
        return this.sdModel;
    }

    public void dispose() {
        IDeltaNotifier iDeltaNotifier = (IDeltaNotifier)this.deltaModel();
        iDeltaNotifier.removeDeltaListener(this.onDelta);
        this.disposeColumnBosses();
        this.sdModel = null;
        super.dispose();
    }

    private void disposeColumnBosses() {
        for (ColumnBoss columnBoss : this.colBosses.values()) {
            columnBoss.dispose();
        }
        this.colBosses.clear();
    }

    protected void doVerticalScroll(int n, int n2, int n3, Control control) {
        if (!this.isSyncedVScrolling()) {
            // empty if block
        }
        super.doVerticalScroll(n, n2, n3, control);
    }

    private void doVerticalScroll(Scrollable scrollable, int n, double d) {
        ScrollBar scrollBar = scrollable.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        double d2 = (double)(scrollBar.getMaximum() - scrollBar.getThumb()) * d * (double)n;
        int n2 = ((StructDiffModel)this.deltaModel()).descendantCount(null, true);
        scrollBar.setMaximum(n2);
        int n3 = scrollBar.getMaximum() - scrollBar.getMinimum();
        if (n3 > 0) {
            int n4 = (int)Math.round((double)n2 / (double)n3 * (d2 - (double)scrollBar.getMinimum()));
            scrollBar.setSelection(n4);
            scrollBar.notifyListeners(13, null);
        }
    }

    public TreeView effectiveTreeView(Role role) {
        return this.treeView(this.getOrientation() == 512 ? Role.REF : role);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    public StructAlerts getAlerts() {
        return this.controller().alerts();
    }

    public int getSashWidth() {
        return 50;
    }

    public Color getColor(Role role, IDiffNode iDiffNode, DeltaPart deltaPart) {
        RGB rGB = DeltaColor.getColor((com.deltawalker.script.Delta)iDiffNode, (DeltaPart)deltaPart, (Role)role, (boolean)false);
        return this.deltaColor().colorFromRgb(rGB);
    }

    protected byte[] getContents(Role role, boolean bl) {
        return null;
    }

    public abstract String getDoneMessage();

    public Role getFocusRole() {
        for (Role role : this.roles()) {
            Role role2;
            ColumnBoss columnBoss;
            StructContentArea structContentArea = this.contentArea(role);
            if (structContentArea.isFocusControl() && (columnBoss = ColumnBoss.get((Control)structContentArea.treeView())) != null && (role2 = columnBoss.getFocusRole()) != null) {
                return role2;
            }
            if (this.uriBoss == null || !this.uriBoss.uriChooser(role).isFocusControl()) continue;
            return role;
        }
        return Relation.firstRole((boolean)this.isThreeWay());
    }

    public TreeView getFocusViewer() {
        Role role = this.getFocusRole();
        return role != null ? this.treeView(role) : null;
    }

    public Image getImage(Role role, Object object) {
        return this.treeView(role).getRowInfoProvider().getImage(object);
    }

    protected ScrollBar getReferenceScrollBar() {
        ScrollBar scrollBar = null;
        int n = 0;
        boolean bl = this.isOrientation(512);
        for (Role role : this.roles()) {
            ScrollBar scrollBar2;
            Role role2 = bl ? Role.REF : role;
            Scrollable scrollable = this.scrollable(role2);
            if (scrollable != null && (scrollBar2 = scrollable.getVerticalBar()) != null) {
                int n2 = scrollBar2.getMaximum() - scrollBar2.getMinimum();
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < n2 && n2 - scrollBar2.getThumb() > 0) {
                    n = n2;
                    scrollBar = scrollBar2;
                }
            }
            if (bl) break;
        }
        return scrollBar;
    }

    public boolean hasDeltas(Set<Delta> set) {
        return this.deltaModel().gotoDelta(Goto.NEXT, true, set);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.scrollable(Role.REF).addListener(37, new Listener(){

            public void handleEvent(Event event) {
                StructDiffView.this.onMouseWheel(event);
            }
        });
    }

    protected void inputChanged(Object object, Object object2) {
        boolean bl;
        this.sdModel = null;
        super.inputChanged(object, object2);
        if (object != null && object2 != null && (bl = ((IDiffDoc)object).isThreeWay()) != ((IDiffDoc)object2).isThreeWay()) {
            this.updateControlLayout();
        }
        if (object != null) {
            ((IDeltaNotifier)this.deltaModel()).addDeltaListener(this.onDelta);
        }
        if (object2 != null) {
            IDiffModel iDiffModel = ((IDiffDoc)object).diffModel(0);
            ((IDeltaNotifier)iDiffModel).removeDeltaListener(this.onDelta);
        }
    }

    public boolean isCommonScrollBarVisible() {
        return this.getOrientation() == 512;
    }

    public boolean isStructView() {
        return true;
    }

    protected boolean nextDelta(Goto goto_, boolean bl, Set<Delta> set) {
        return this.deltaModel().gotoDelta(goto_, bl, set);
    }

    protected void onMouseWheel(Event event) {
        super.onMouseWheel(event);
        if (!event.doit || !this.isCommonScrollBarVisible()) {
            return;
        }
        for (Role role : this.roles()) {
            if (event.widget != this.scrollable(role)) continue;
            int n = this.sbCommon.getSelection() - event.count;
            this.sbCommon.setSelection(n);
            this.sbCommon.notifyListeners(13, null);
            break;
        }
    }

    public void print(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        this.print((HeaderFooterPrintOp)new StructPrintOp(this, iPrinter, iProgressMonitor));
    }

    protected void redrawMargins() {
    }

    public void redrawTrees(Control control) {
        for (Role role : this.roles()) {
            TreeView treeView = this.treeView(role);
            if (treeView == control) continue;
            treeView.redraw();
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
        for (Role role : Relation.roles((boolean)true)) {
            this.treeView(role).removeFocusListener(focusListener);
        }
    }

    public void reportSelection() {
        List list = this.deltaModel().getSelected();
        IStatusLineManager iStatusLineManager = this.getStatusLineManager();
        if (list.size() > 1) {
            StatusLineUtil.setTimedMessage((IStatusLineManager)iStatusLineManager, (String)NLS.bind((String)StructMsg.StructView_selectionCount, (Object)Integer.toString(list.size())));
        } else {
            iStatusLineManager.setMessage("");
        }
    }

    public void resizeColumns() {
        for (Role role : this.roles()) {
            ColumnBoss columnBoss = ColumnBoss.get((Control)this.treeView(role));
            if (columnBoss == null) continue;
            columnBoss.resizeColumns();
        }
    }

    public void syncCommonScrollBar(ScrollBar scrollBar) {
        if (!this.isSyncedVScrolling()) {
            return;
        }
        if (this.inScrolling) {
            return;
        }
        double d = 0.0;
        int n = scrollBar.getMaximum() - scrollBar.getThumb();
        if (n > 0) {
            d = (float)scrollBar.getSelection() / (float)n;
        }
        ScrollBar scrollBar2 = this.commonScrollBar();
        int n2 = (int)Math.round((double)(scrollBar2.getMaximum() - scrollBar2.getThumb()) * d);
        this.doVerticalScroll(n2, n2, n2, null);
        scrollBar2.setSelection(n2);
    }

    public void syncViewport(Composite composite) {
        if (!this.isSyncedVScrolling()) {
            return;
        }
        if (this.inScrolling) {
            return;
        }
        ScrollBar scrollBar = composite.getVerticalBar();
        double d = 0.0;
        int n = scrollBar.getMaximum() - scrollBar.getThumb();
        if (n > 0) {
            d = (float)scrollBar.getSelection() / (float)n;
        }
        ScrollBar scrollBar2 = this.commonScrollBar();
        int n2 = (int)Math.round((double)(scrollBar2.getMaximum() - scrollBar2.getThumb()) * d);
        this.doVerticalScroll(n2, n2, n2, null);
        scrollBar2.setSelection(n2);
        scrollBar2.notifyListeners(13, null);
    }

    public TreeView treeView(Role role) {
        return this.contentArea(role).treeView();
    }

    public void updateCommonScrollBar() {
    }

    protected void updateContent() {
        Object object;
        Object object22;
        Object object3;
        Object object42;
        for (Object object42 : this.roles()) {
            this.treeView((Role)object42).disconnect();
        }
        super.updateContent();
        object42 = new LinkedList();
        List list = this.getInput().filters().getAllAsList();
        ArrayList<IFolderFilter> arrayList = new ArrayList<IFolderFilter>();
        Object object5 = list.iterator();
        while (object5.hasNext()) {
            object3 = (IFilter)object5.next();
            if (!object3.isEnabled() || !(object3 instanceof IFolderFilter)) continue;
            arrayList.add((IFolderFilter)object3);
        }
        object3 = new EnumMap(Role.class);
        object5 = this.getInputs();
        Set set = this.roles();
        for (Object object22 : set) {
            object = (IDoc)object5.get(object22);
            TreeView treeView = this.treeView((Role)object22);
            if (treeView == null) continue;
            IStructElement iStructElement = ((IStructDoc)object).rootElement();
            Throwable throwable = object.uriInfo().error();
            if (throwable instanceof StructException) {
                object42.add(object);
            }
            if (iStructElement instanceof IStruct) {
                ((IStruct)iStructElement).setFilters(arrayList);
            }
            if (iStructElement == null) {
                iStructElement = new NullStructElement();
            }
            object3.put(object22, iStructElement);
        }
        ((StructDiffModel)this.deltaModel()).setRootElements((Map<Role, IStructElement>)object3);
        for (Object object22 : this.roles()) {
            this.treeView((Role)object22).connect((IMvcModel)this.deltaModel(), null);
        }
        object22 = this.controller().actions();
        object = object22.iterator();
        while (object.hasNext()) {
            IAction iAction = (IAction)object.next();
            if (!(iAction instanceof IPrefSerializer)) continue;
            ((IPrefSerializer)iAction).fromPrefs();
        }
        this.getAlerts().showStructError((List<IDoc>)object42);
    }

    public void updateControlLayout() {
        super.updateControlLayout();
        Set set = Relation.roles((boolean)this.isThreeWay());
        this.disposeColumnBosses();
        for (Role role : set) {
            ColumnBoss columnBoss = this.columnBoss(role);
            TreeView treeView = this.treeView(role);
            columnBoss.configure(treeView, role, this.isThreeWay(), this.getOrientation());
        }
        this.resizeColumns();
    }
}

