/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.Delta;
import com.deltawalker.DeltaUtil;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.structure.StructDiffModel;
import com.deltawalker.ui.DiffSummary;
import com.deltawalker.ui.DiffSummaryItem;
import com.deltawalker.ui.IDiffSummaryItem;
import com.deltawalker.ui.UIMsg;
import java.util.Set;

public abstract class StructDiffSummary
extends DiffSummary {
    public StructDiffSummary(StructDiffModel structDiffModel) {
        super(structDiffModel.isThreeWay());
        this.setDescription(UIMsg.CompareSummary_description);
        this.createItems(structDiffModel);
    }

    protected void createDeltaSubItems(String string, IStructDiffModel iStructDiffModel, IDeltaItemFilter iDeltaItemFilter) {
        DiffSummaryItem diffSummaryItem = new DiffSummaryItem();
        diffSummaryItem.setName(string);
        Set set = DeltaUtil.deltas();
        for (Delta delta : set) {
            Set set2 = iStructDiffModel.getDeltasOfOverallKind(delta);
            diffSummaryItem.setValue(DeltaUtil.displayName((Delta)delta), (Object)this.getCount(set2, iDeltaItemFilter));
        }
        this.addItem((IDiffSummaryItem)diffSummaryItem);
    }

    protected abstract void createItems(StructDiffModel var1);

    private int getCount(Set<IDiffNode> set, IDeltaItemFilter iDeltaItemFilter) {
        int n = 0;
        for (IDiffNode iDiffNode : set) {
            if (!iDeltaItemFilter.matches(iDiffNode)) continue;
            ++n;
        }
        return n;
    }

    protected static interface IDeltaItemFilter {
        public boolean matches(IDiffNode var1);
    }
}

