/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.Msg;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.INodeFilter;
import com.deltawalker.script.Role;
import com.deltawalker.structure.FolderActionId;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.TreeFilterBoss;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.StructAlerts;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.Expand;
import com.deltawalker.structure.ui.actions.ExpandAction;
import com.deltawalker.structure.ui.actions.ExpandNodesAction;
import com.deltawalker.structure.ui.actions.Select;
import com.deltawalker.structure.ui.actions.SelectAction;
import com.deltawalker.structure.ui.actions.SelectNodesAction;
import com.deltawalker.structure.ui.actions.ShowAction;
import com.deltawalker.structure.ui.actions.ShowNodesAction;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.GotoConflictAction;
import com.deltawalker.ui.actions.GotoDiffAction;
import com.deltawalker.ui.actions.MergeNonConflictsAction;
import com.deltawalker.ui.actions.SearchContributionItem;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.ui.treeview.ITreeEventListener;
import com.deltopia.ui.treeview.TreeEventAdapter;
import com.deltopia.util.OS;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class StructDiffController
extends DiffController {
    private boolean canShowTreeMenu = true;
    private Menu ctxMenu;
    protected TreeFilterBoss filterBoss;
    protected TreeEventAdapter onTree = new TreeEventAdapter(){

        public void showContextMenu(Control control, Point point) {
            StructDiffController.this.showContextMenu(control);
        }
    };

    protected void addExcludeActionsSwt(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.getAction("com.deltawalker.structure.folderFilters").getText());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        this.addMenuItem(menu2, "com.deltawalker.structure.excludeByPath", true);
        this.addMenuItem(menu2, "com.deltawalker.structure.excludeByName", true);
        this.addMenuItem(menu2, "com.deltawalker.structure.excludeByExtension", true);
    }

    protected void addExpandActions(IContributionManager iContributionManager, boolean bl) {
        if (bl) {
            iContributionManager.add(this.getAction("com.deltawalker.structure.expandDiffsInSel"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.expandAllInSel"));
        } else {
            iContributionManager.add(this.getAction("com.deltawalker.structure.expandDiffs"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.expandAll"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.collapseAll"));
        }
        iContributionManager.add((IContributionItem)new Separator());
    }

    protected void addExpandActionsSwt(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.getAction("expandNodes").getText());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        this.addMenuItem(menu2, "com.deltawalker.structure.expandDiffsInSel");
        this.addMenuItem(menu2, "com.deltawalker.structure.expandAllInSel");
        this.addMenuItem(menu2, "");
        this.addMenuItem(menu2, "com.deltawalker.structure.collapseAllInSel");
    }

    protected void addSelectActions(IContributionManager iContributionManager, boolean bl) {
        if (bl) {
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectChangedInSel"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectAddedInSel"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectDeletedInSel"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectDiffsInSel"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.invertSelectionInSel"));
        } else {
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectChanged"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectAdded"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectDeleted"));
            iContributionManager.add(this.getAction("com.deltawalker.structure.selectDiffs"));
            iContributionManager.add(this.getAction(FolderActionId.SELECT_ALL));
            iContributionManager.add(this.getAction("com.deltawalker.structure.invertSelection"));
        }
        iContributionManager.add((IContributionItem)new Separator());
    }

    protected void addSelectActionsSwt(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.getAction("selectNodes").getText());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        this.addMenuItem(menu2, "com.deltawalker.structure.selectChangedInSel");
        this.addMenuItem(menu2, "com.deltawalker.structure.selectAddedInSel");
        this.addMenuItem(menu2, "com.deltawalker.structure.selectDeletedInSel");
        this.addMenuItem(menu2, "com.deltawalker.structure.selectDiffsInSel");
    }

    protected void addShowActions(IContributionManager iContributionManager) {
        iContributionManager.add(this.getAction("showSame"));
        iContributionManager.add(this.getAction("showAdded"));
        iContributionManager.add(this.getAction("showDeleted"));
        iContributionManager.add(this.getAction("showNewer"));
        iContributionManager.add(this.getAction("showOlder"));
        iContributionManager.add((IContributionItem)new Separator());
    }

    protected void addShowActionsSwt(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.getAction("showNodes").getText());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        this.addMenuItem(menu2, "showSame");
        this.addMenuItem(menu2, "showAdded");
        this.addMenuItem(menu2, "showDeleted");
        this.addMenuItem(menu2, "showNewer");
        this.addMenuItem(menu2, "showOlder");
    }

    public StructAlerts alerts() {
        if (this.alerts == null) {
            this.alerts = new StructAlerts(this);
        }
        return (StructAlerts)this.alerts;
    }

    public void connectSearchField(boolean bl, boolean bl2) {
        Object object;
        String[] stringArray;
        final IToolBarManager iToolBarManager = UIUtil.getSearchToolBarManager((IWorkbenchWindow)this.view().getSite().getWorkbenchWindow());
        if (bl) {
            PlatformUI.getWorkbench().getDisplay().timerExec(10, new Runnable(){

                @Override
                public void run() {
                    if (StructDiffController.this.filterBoss != null && iToolBarManager != null) {
                        IContributionItem iContributionItem = iToolBarManager.find("searchContributionItem");
                        Text text = ((SearchContributionItem)iContributionItem).getTextControl();
                        StructDiffController.this.filterBoss.connectSearchControl(iToolBarManager, text, true);
                    }
                }
            });
        } else if (iToolBarManager != null) {
            stringArray = iToolBarManager.find("searchContributionItem");
            object = ((SearchContributionItem)stringArray).getTextControl();
            this.filterBoss.connectSearchControl(iToolBarManager, (Text)object, false);
        }
        String[] stringArray2 = stringArray = new String[]{"expandNodes", "selectNodes", "showNodes"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            IAction iAction = this.getAction((String)object);
            if (iAction != null) {
                IActionBars iActionBars = this.getActionBars();
                if (bl) {
                    iActionBars.setGlobalActionHandler((String)object, iAction);
                } else if (iActionBars.getGlobalActionHandler((String)object) == iAction) {
                    iActionBars.setGlobalActionHandler((String)object, null);
                }
            }
            ++n2;
        }
        object = this.model();
        if (object.isWorking()) {
            this.getActionBars().getStatusLineManager().setMessage(this.view().deltaModelListener().taskDescription());
        }
    }

    protected void disconnectIndividualGlobalActions(IActionBars iActionBars) {
        super.disconnectIndividualGlobalActions(iActionBars);
        iActionBars.setGlobalActionHandler(FolderActionId.SELECT_ALL, null);
    }

    public void dispose() {
        super.dispose();
        if (this.filterBoss != null) {
            this.filterBoss.dispose();
            this.filterBoss = null;
        }
        for (Role role : this.view().roles()) {
            TreeView treeView = this.view().treeView(role);
            if (treeView.isDisposed()) continue;
            treeView.removeTreeEventListener((ITreeEventListener)this.onTree);
        }
    }

    protected void fillHeaderContextMenu(IContributionManager iContributionManager) {
    }

    protected void fillMenuBar(IMenuManager iMenuManager) {
        try {
            this.fillHeaderContextMenu((IContributionManager)iMenuManager);
            iMenuManager.add((IContributionItem)new Separator());
        }
        finally {
            super.fillMenuBar(iMenuManager);
        }
    }

    public TreeFilterBoss filterBoss() {
        if (this.filterBoss == null) {
            this.filterBoss = new TreeFilterBoss(this.getSearchToolTipText());
        }
        return this.filterBoss;
    }

    public String getColumnToolTip(IDiffNode iDiffNode, Role role, int n) {
        return null;
    }

    protected abstract String getSearchToolTipText();

    public void installContextMenu() {
        MenuManager menuManager = new MenuManager("#TreeMenu");
        MenuManager menuManager2 = new MenuManager("#HeaderMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager2.setRemoveAllWhenShown(true);
        StructDiffView structDiffView = this.view();
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                if (StructDiffController.this.canShowTreeMenu) {
                    StructDiffController.this.fillContextMenu(iMenuManager);
                }
            }
        });
        menuManager2.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                StructDiffController.this.fillHeaderContextMenu((IContributionManager)iMenuManager);
            }
        });
        for (Role role : structDiffView.roles()) {
            Canvas canvas;
            TreeView treeView = structDiffView.treeView(role);
            if (this.onTree != null) {
                treeView.addTreeEventListener((ITreeEventListener)this.onTree);
            } else {
                canvas = treeView.tree();
                canvas.setMenu(menuManager.createContextMenu((Control)canvas));
            }
            canvas = treeView.header();
            canvas.setMenu(menuManager2.createContextMenu((Control)canvas));
        }
    }

    protected void makeActions() {
        StructDiffView structDiffView = this.view();
        super.makeActions();
        ResourceBundle resourceBundle = StructMsg.constructedKeyBundle();
        IWorkbenchWindow iWorkbenchWindow = this.window();
        this.addAction((IAction)new ExpandNodesAction(resourceBundle, iWorkbenchWindow));
        this.addAction((IAction)new ExpandAction(structDiffView, resourceBundle, Expand.ALL));
        this.addAction((IAction)new ExpandAction(structDiffView, resourceBundle, Expand.ALL_IN_SEL));
        this.addAction((IAction)new ExpandAction(structDiffView, resourceBundle, Expand.DIFFS));
        this.addAction((IAction)new ExpandAction(structDiffView, resourceBundle, Expand.DIFFS_IN_SEL));
        this.addAction((IAction)new ExpandAction(structDiffView, resourceBundle, Expand.COLLAPSE_ALL));
        this.addAction((IAction)new ExpandAction(structDiffView, resourceBundle, Expand.COLLAPSE_ALL_IN_SEL));
        this.addAction((IAction)new SelectNodesAction(resourceBundle, iWorkbenchWindow));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.ADDED));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.ADDED_IN_SEL));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.ALL));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.DELETED));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.DELETED_IN_SEL));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.CHANGED));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.CHANGED_IN_SEL));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.DIFFS));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.DIFFS_IN_SEL));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.INVERTED));
        this.addAction((IAction)new SelectAction(structDiffView, resourceBundle, Select.INVERTED_IN_SEL));
        this.addAction((IAction)new ShowNodesAction(resourceBundle, iWorkbenchWindow));
        this.addAction((IAction)new ShowAction(structDiffView, resourceBundle, INodeFilter.Criterion.SAME));
        this.addAction((IAction)new ShowAction(structDiffView, resourceBundle, INodeFilter.Criterion.ADDED));
        this.addAction((IAction)new ShowAction(structDiffView, resourceBundle, INodeFilter.Criterion.DELETED));
        this.addAction((IAction)new ShowAction(structDiffView, resourceBundle, INodeFilter.Criterion.NEWER));
        this.addAction((IAction)new ShowAction(structDiffView, resourceBundle, INodeFilter.Criterion.OLDER));
        this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.NEXT, (DiffView)structDiffView, false));
        this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.PREVIOUS, (DiffView)structDiffView, false));
        this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.NEXT, (DiffView)structDiffView, false));
        this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.PREVIOUS, (DiffView)structDiffView, false));
        ResourceBundle resourceBundle2 = Msg.constructedKeyBundle();
        this.addAction((IAction)new MergeNonConflictsAction(resourceBundle2, (DiffView)structDiffView, false));
        if (OS.COCOA) {
            this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.NEXT, (DiffView)structDiffView, true));
            this.addAction((IAction)new GotoDiffAction(resourceBundle, Goto.PREVIOUS, (DiffView)structDiffView, true));
            this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.NEXT, (DiffView)structDiffView, true));
            this.addAction((IAction)new GotoConflictAction(resourceBundle, Goto.PREVIOUS, (DiffView)structDiffView, true));
            this.addAction((IAction)new MergeNonConflictsAction(resourceBundle2, (DiffView)structDiffView, true));
        }
        this.initializeGotoDiffButtons();
    }

    public void setCanShowTreeContextMenu(boolean bl) {
        this.canShowTreeMenu = bl;
    }

    public void showContextMenu(Control control) {
        final Shell shell = control.getShell();
        if (this.ctxMenu != null) {
            this.ctxMenu.dispose();
            this.ctxMenu = null;
        }
        this.ctxMenu = new Menu((Decorations)shell, 8);
        this.fillContextMenuSwt(control, this.ctxMenu);
        this.ctxMenu.setLocation(shell.getDisplay().getCursorLocation());
        this.ctxMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent menuEvent) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (StructDiffController.this.ctxMenu != null && !StructDiffController.this.ctxMenu.isDisposed()) {
                            StructDiffController.this.ctxMenu.dispose();
                            StructDiffController.this.ctxMenu = null;
                        }
                    }
                });
            }
        });
        this.ctxMenu.setVisible(true);
    }

    public StructDiffView view() {
        return (StructDiffView)super.view();
    }
}

