/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.script.Role;
import com.deltawalker.structure.internal.StructContextId;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.DiffViewLabelProvider;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.ContentArea;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.UriChooser;
import com.deltopia.util.OS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;

public class StructContentArea
extends ContentArea {
    private ControlListener onResize = new ControlAdapter(){

        public void controlResized(ControlEvent controlEvent) {
            if (StructContentArea.this.skipEvent[0]) {
                return;
            }
            StructContentArea.this.skipEvent[0] = true;
            UIUtil.display().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Canvas canvas = StructContentArea.this.treeView.tree();
                    if (canvas.isDisposed()) {
                        return;
                    }
                    this.onResize(canvas.getClientArea());
                    (this).StructContentArea.this.skipEvent[0] = false;
                }
            });
        }

        private void onResize(Rectangle rectangle) {
            ColumnBoss columnBoss;
            if (((StructContentArea)StructContentArea.this).rcTreeOld.width != rectangle.width && (columnBoss = ColumnBoss.get((Control)StructContentArea.this.treeView)) != null) {
                columnBoss.resizeColumns();
            }
            StructContentArea.this.rcTreeOld = rectangle;
        }
    };
    private SelectionListener onSelect = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            StructContentArea.this.structView().syncViewport((Composite)StructContentArea.this.treeView.tree());
        }
    };
    private Rectangle rcTreeOld = new Rectangle(0, 0, 0, 0);
    final boolean[] skipEvent = new boolean[1];
    private TreeView treeView;

    public StructContentArea(Composite composite, int n, DiffView diffView, Role role) {
        super(composite, n, diffView, role);
        this.populate();
        this.postPopulate();
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.treeView().tree().addTraverseListener(traverseListener);
    }

    protected DropTargetListener configureDropTargetListener(final DropTargetListener dropTargetListener, Role role, Control control, DropTarget dropTarget) {
        return new DropTargetListener(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                DropTargetListener dropTargetListener2 = this.getListener(dropTargetEvent);
                if (dropTargetListener2 != null) {
                    dropTargetListener2.dragEnter(dropTargetEvent);
                }
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
                DropTargetListener dropTargetListener2 = this.getListener(dropTargetEvent);
                if (dropTargetListener2 != null) {
                    dropTargetListener2.dragLeave(dropTargetEvent);
                }
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                DropTargetListener dropTargetListener2 = this.getListener(dropTargetEvent);
                if (dropTargetListener2 != null) {
                    dropTargetListener2.dragOperationChanged(dropTargetEvent);
                }
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                DropTargetListener dropTargetListener2 = this.getListener(dropTargetEvent);
                if (dropTargetListener2 != null) {
                    dropTargetListener2.dragOver(dropTargetEvent);
                }
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                DropTargetListener dropTargetListener2 = this.getListener(dropTargetEvent);
                if (dropTargetListener2 != null) {
                    dropTargetListener2.drop(dropTargetEvent);
                }
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
                DropTargetListener dropTargetListener2 = this.getListener(dropTargetEvent);
                if (dropTargetListener2 != null) {
                    dropTargetListener2.dropAccept(dropTargetEvent);
                }
            }

            private DropTargetListener getListener(DropTargetEvent dropTargetEvent) {
                UriChooser uriChooser;
                Role role;
                ColumnBoss columnBoss = ColumnBoss.get((Control)StructContentArea.this.treeView);
                if (columnBoss != null && (role = columnBoss.getRole(StructContentArea.this.treeView.tree().toControl(dropTargetEvent.x, dropTargetEvent.y))) != null && (uriChooser = StructContentArea.this.deltaView().uriChooserBoss().uriChooser(role)) != null) {
                    return uriChooser.dropTargetListener();
                }
                return dropTargetListener;
            }
        };
    }

    protected DropTarget createDropTarget(Role role, Control control) {
        DropTargetEffect dropTargetEffect;
        DropTarget dropTarget = super.createDropTarget(role, control);
        if (OS.OSX && control instanceof Tree && (dropTargetEffect = dropTarget.getDropTargetEffect()) instanceof TreeDropTargetEffect) {
            dropTarget.setDropTargetEffect(null);
        }
        return dropTarget;
    }

    public void dispose() {
        this.treeView.tree().removeControlListener(this.onResize);
        this.treeView.dispose();
        super.dispose();
    }

    protected String getHelpContextId() {
        return StructContextId.FOLDER_COMPARISON_WINDOW;
    }

    public boolean isFocusControl() {
        return this.treeView != null && this.treeView.isFocusControl();
    }

    private void populate() {
        StructDiffView structDiffView = this.structView();
        this.treeView = new TreeView(structDiffView, (Composite)this, 0);
        this.treeView.setRowInfoProvider(new DiffViewLabelProvider(structDiffView, this.treeView, this.role));
        this.treeView.tree().addControlListener(this.onResize);
    }

    public void redraw() {
        this.treeView.redraw();
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.treeView().tree().removeTraverseListener(traverseListener);
    }

    public Scrollable scrollable() {
        return this.treeView.tree();
    }

    public boolean setFocus() {
        boolean bl = false;
        if (this.treeView != null && !(bl = this.treeView.isFocusControl())) {
            bl = this.treeView.setFocus();
        }
        return bl;
    }

    protected StructDiffView structView() {
        return (StructDiffView)super.deltaView();
    }

    public TreeView treeView() {
        return this.treeView;
    }
}

