/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.interfaces.IDoc;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.ui.Alert;
import com.deltawalker.ui.Alerts;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.IAlertService;
import com.deltawalker.ui.UIUtil;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class StructAlerts
extends Alerts {
    private static final int OPEN_FILE_LIMIT_KEY = 0;
    private final String[] limitMsgKeys = new String[2];
    private String structErrKey;

    public StructAlerts(DiffController diffController) {
        super(diffController);
    }

    private void showLimitMessage(final int n, final String string, boolean bl, final int n2) {
        final IAlertService iAlertService = this.service();
        IAlert iAlert = iAlertService.getAlert(this.limitMsgKeys[n]);
        if (iAlert != null) {
            if (bl) {
                iAlert.setText(NLS.bind((String)string, (Object)new Integer(n2)));
                UIUtil.display().beep();
            } else {
                iAlertService.removeAlert(iAlert.getKey());
            }
        } else if (bl) {
            final Display display = UIUtil.display();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    display.beep();
                    ((StructAlerts)StructAlerts.this).limitMsgKeys[n] = iAlertService.addAlert((IAlert)new Alert(null, NLS.bind((String)string, (Object)new Integer(n2)), 2, 64));
                }
            });
        }
    }

    public void showOpenFileLimit(boolean bl, int n) {
        this.showLimitMessage(0, StructMsg.StructController_wndCountLimitMessage, bl, n);
    }

    public void showStructError(List<IDoc> list) {
        IDoc iDoc2;
        IAlertService iAlertService = this.service();
        if (list.isEmpty()) {
            iAlertService.removeAlert(this.structErrKey);
            return;
        }
        String string = StructMsg.StructController_errStructViewCreate;
        for (IDoc iDoc2 : list) {
            string = String.valueOf(string) + "\n- " + iDoc2.getName();
            Throwable throwable = iDoc2.uriInfo().error();
            if (throwable == null || throwable.getLocalizedMessage().isEmpty()) continue;
            string = String.valueOf(string) + ": " + throwable.getLocalizedMessage();
        }
        iDoc2 = iAlertService.getAlert(this.structErrKey);
        if (iDoc2 != null) {
            iDoc2.setText(string);
        } else {
            iDoc2 = new Alert(null, string, 1, 64);
            this.structErrKey = iAlertService.addAlert((IAlert)iDoc2);
        }
    }
}

