/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.DiffModel;
import com.deltawalker.DocType;
import com.deltawalker.IStructElement;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.FolderSummaryStatusLineGroup;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.FolderAlerts;
import com.deltawalker.structure.ui.StructDiffController;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.structure.ui.actions.ChooseSyncAction;
import com.deltawalker.structure.ui.actions.ChooseSyncMenuAction;
import com.deltawalker.structure.ui.actions.CompareWithAction;
import com.deltawalker.structure.ui.actions.CopySelectedAction;
import com.deltawalker.structure.ui.actions.CopySelectedPathsAction;
import com.deltawalker.structure.ui.actions.DeleteSelectedAction;
import com.deltawalker.structure.ui.actions.ExcludeAction;
import com.deltawalker.structure.ui.actions.FolderFiltersAction;
import com.deltawalker.structure.ui.actions.OpenFolderAction;
import com.deltawalker.structure.ui.actions.OpenLocalFolderAction;
import com.deltawalker.structure.ui.actions.OpenRemoteFolderAction;
import com.deltawalker.structure.ui.actions.OpenSelectedAction;
import com.deltawalker.structure.ui.actions.OpenWithAction;
import com.deltawalker.structure.ui.actions.OpenWithOtherAction;
import com.deltawalker.structure.ui.actions.RecompareSelectedAction;
import com.deltawalker.structure.ui.actions.RenameAction;
import com.deltawalker.structure.ui.actions.SetAsRootFolderAction;
import com.deltawalker.structure.ui.actions.SetDateModifiedAction;
import com.deltawalker.structure.ui.actions.ShowInAction;
import com.deltawalker.structure.ui.actions.SyncAction;
import com.deltawalker.structure.ui.actions.ToggleTreeColumnAction;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.SummaryStatusLineGroup;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.actions.ActionId;
import com.deltawalker.ui.actions.CreateReportJsonAction;
import com.deltawalker.ui.actions.IActionAccessor;
import com.deltopia.eclipse.util.SizeFormatter;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.io.IO;
import com.deltopia.util.OS;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.texteditor.IUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderDiffController
extends StructDiffController {
    protected static final Logger LOG = LoggerFactory.getLogger(FolderDiffController.class);

    protected void addExcludeActions(IContributionManager iContributionManager) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"com.deltawalker.structure.excludeByName", "com.deltawalker.structure.excludeByExtension"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            IAction iAction = this.getAction(string);
            ((IUpdate)iAction).update();
            if (iAction.isEnabled()) {
                iContributionManager.add(iAction);
            }
            ++n2;
        }
        iContributionManager.add((IContributionItem)new Separator());
    }

    @Override
    public FolderAlerts alerts() {
        if (this.alerts == null) {
            this.alerts = new FolderAlerts(this);
        }
        return (FolderAlerts)this.alerts;
    }

    protected boolean canShowIOErrorMessage(UriInfo[] uriInfoArray) {
        int n = uriInfoArray.length;
        if (n <= 0 || this.getSubInput(Role.ONE).docType() == DocType.PREVIEW) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!uriInfoArray[n2].hasHintUri()) {
                return true;
            }
            ++n2;
        }
        return this.view().isThreeWay() ? n < 3 : n < 2;
    }

    protected SummaryStatusLineGroup createSummaryPanels() {
        return new FolderSummaryStatusLineGroup(this.window().getShell(), this.getActionBars());
    }

    @Override
    protected void disconnectIndividualGlobalActions(IActionBars iActionBars) {
        super.disconnectIndividualGlobalActions(iActionBars);
        iActionBars.setGlobalActionHandler(ActionId.DELETE_SELECTED, null);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        IAction iAction;
        boolean bl;
        StructDiffView structDiffView = this.view();
        boolean bl2 = bl = !structDiffView.deltaModel().isEmpty();
        if (bl) {
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add(this.getAction("com.deltawalker.openSelected"));
            iMenuManager.add(this.getAction("recompareSelected"));
            this.addMenu(iMenuManager, "com.deltawalker.structure.compareTo");
            iMenuManager.add((IContributionItem)new Separator());
            this.addMenu(iMenuManager, "showIn");
            iAction = new MenuManager(StructMsg.OpenWithAction_text, null);
            this.addMenu((IMenuManager)iAction, "openWith");
            this.addMenu((IMenuManager)iAction, "openWithOther");
            iMenuManager.add((IContributionItem)iAction);
            iMenuManager.add((IContributionItem)new Separator());
        }
        this.addExcludeActions((IContributionManager)iMenuManager);
        if (bl) {
            this.addSelectActions((IContributionManager)iMenuManager, true);
            iMenuManager.add((IContributionItem)new Separator());
            this.addExpandActions((IContributionManager)iMenuManager, true);
        }
        if (bl) {
            this.fillCopyActions(iMenuManager);
            iAction = this.getAction("com.deltawalker.structure.setAsRootFolder");
            ((IUpdate)iAction).update();
            if (((SetAsRootFolderAction)iAction).canAddToContextMenu()) {
                iMenuManager.add(iAction);
            }
            this.addMenu(iMenuManager, "com.deltawalker.structure.copySelectedPaths");
            this.addMenu(iMenuManager, "com.deltawalker.structure.setDateModified");
            this.addMenu(iMenuManager, ActionId.DELETE_SELECTED);
            this.addMenu(iMenuManager, "com.deltawalker.structure.rename");
        }
    }

    protected void fillContextMenuSwt(Control control, Menu menu) {
        boolean bl;
        StructDiffView structDiffView = this.view();
        boolean bl2 = bl = !structDiffView.deltaModel().isEmpty();
        if (bl) {
            CopySelectedAction copySelectedAction;
            String string;
            Role role;
            Object object;
            MenuItem menuItem;
            this.addMenuItem(menu, "com.deltawalker.openSelected");
            this.addMenuItem(menu, "recompareSelected");
            this.addMenuItem(menu, "com.deltawalker.structure.compareTo");
            this.addMenuItem(menu, null);
            this.addMenuItem(menu, "showIn");
            if (OS.WIN) {
                menuItem = this.getSelectedPaths();
                if (!menuItem.isEmpty()) {
                    object = new MenuItem(menu, 64);
                    object.setText("Explorer");
                    try {
                        Menu menu2 = IO.fileSystem().attachContextMenu((Control)control.getShell(), menu, (Set)menuItem);
                        object.setMenu(menu2);
                    }
                    catch (Throwable throwable) {
                        LOG.warn("Couldn't show Explorer context menu.", throwable);
                    }
                }
            } else {
                menuItem = new MenuItem(menu, 64);
                menuItem.setText(StructMsg.OpenWithAction_text);
                object = new Menu(menuItem);
                menuItem.setMenu((Menu)object);
                this.addMenuItem((Menu)object, "openWith");
                this.addMenuItem((Menu)object, "openWithOther");
            }
            this.addMenuItem(menu, null);
            this.addExcludeActionsSwt(menu);
            this.addMenuItem(menu, null);
            this.addSelectActionsSwt(menu);
            this.addMenuItem(menu, null);
            this.addExpandActionsSwt(menu);
            this.addMenuItem(menu, null);
            menuItem = structDiffView.getFocusRole();
            object = CopySelectedAction.getPossibleDestinations((Role)menuItem, structDiffView);
            boolean bl3 = true;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                role = (Role)iterator.next();
                string = bl3 ? "com.deltawalker.structure.copySelected0" : "com.deltawalker.structure.copySelected1";
                bl3 = false;
                copySelectedAction = (CopySelectedAction)((Object)this.actions.get(string));
                copySelectedAction.setRoles((Role)menuItem, role);
                this.addMenuItem(menu, string);
            }
            bl3 = true;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                role = (Role)iterator.next();
                string = bl3 ? "com.deltawalker.structure.moveSelected0" : "com.deltawalker.structure.moveSelected1";
                bl3 = false;
                copySelectedAction = (CopySelectedAction)((Object)this.actions.get(string));
                copySelectedAction.setRoles((Role)menuItem, role);
                this.addMenuItem(menu, string);
            }
            this.addMenuItem(menu, null);
            if (this.view().isThreeWay()) {
                this.addMenuItem(menu, "mergeNonConflicts");
                this.addMenuItem(menu, null);
            }
            if (((SetAsRootFolderAction)(role = this.getAction("com.deltawalker.structure.setAsRootFolder"))).canAddToContextMenu()) {
                this.addMenuItem(menu, role.getId());
            }
            this.addMenuItem(menu, "com.deltawalker.structure.copySelectedPaths");
            this.addMenuItem(menu, "com.deltawalker.structure.setDateModified");
            this.addMenuItem(menu, ActionId.DELETE_SELECTED);
            this.addMenuItem(menu, "com.deltawalker.structure.rename");
        }
        this.addMenuItem(menu, null);
        this.addMenuItem(menu, "createReportHtml");
        this.addMenuItem(menu, "compareSummary");
    }

    private void fillCopyActions(IMenuManager iMenuManager) {
        CopySelectedAction copySelectedAction;
        String string;
        StructDiffView structDiffView = this.view();
        Role role = structDiffView.getFocusRole();
        Set<Role> set = CopySelectedAction.getPossibleDestinations(role, structDiffView);
        boolean bl = true;
        for (Role role2 : set) {
            string = bl ? "com.deltawalker.structure.copySelected0" : "com.deltawalker.structure.copySelected1";
            bl = false;
            copySelectedAction = (CopySelectedAction)((Object)this.actions.get(string));
            copySelectedAction.setRoles(role, role2);
            copySelectedAction.update();
            iMenuManager.add((IAction)copySelectedAction);
        }
        bl = true;
        for (Role role2 : set) {
            string = bl ? "com.deltawalker.structure.moveSelected0" : "com.deltawalker.structure.moveSelected1";
            bl = false;
            copySelectedAction = (CopySelectedAction)((Object)this.actions.get(string));
            copySelectedAction.setRoles(role, role2);
            copySelectedAction.update();
            iMenuManager.add((IAction)copySelectedAction);
        }
        iMenuManager.add((IContributionItem)new Separator());
    }

    @Override
    protected void fillHeaderContextMenu(IContributionManager iContributionManager) {
        iContributionManager.add((IContributionItem)new Separator());
        iContributionManager.add(this.getAction("toggleGroup"));
        iContributionManager.add(this.getAction("toggleOwner"));
        iContributionManager.add(this.getAction("toggleAttributes"));
        iContributionManager.add(this.getAction("toggleDateOpened"));
        iContributionManager.add(this.getAction("toggleDateCreated"));
        iContributionManager.add(this.getAction("toggleDateModified"));
        iContributionManager.add(this.getAction("toggleSize"));
    }

    @Override
    protected void fillMenuBar(IMenuManager iMenuManager) {
        iMenuManager.add(this.getAction("com.deltawalker.openSelected"));
        iMenuManager.add(this.getAction("recompareSelected"));
        iMenuManager.add(this.getAction("com.deltawalker.structure.compareTo"));
        iMenuManager.add((IContributionItem)new Separator());
        MenuManager menuManager = new MenuManager("Header", null);
        super.fillMenuBar((IMenuManager)menuManager);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)new Separator());
        menuManager = new MenuManager(this.getAction("showNodes").getText(), null);
        this.addShowActions((IContributionManager)menuManager);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)new Separator());
        menuManager = new MenuManager(this.getAction("selectNodes").getText(), null);
        this.addSelectActions((IContributionManager)menuManager, false);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)new Separator());
        menuManager = new MenuManager(this.getAction("expandNodes").getText(), null);
        this.addExpandActions((IContributionManager)menuManager, false);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add(this.getAction(ActionId.DELETE_SELECTED));
        iMenuManager.add(this.getAction("com.deltawalker.structure.rename"));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add(this.getAction("createReportHtml"));
        iMenuManager.add(this.getAction("compareSummary"));
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
        ActionContributionItem actionContributionItem = new ActionContributionItem(this.getAction("expandNodes"));
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        iToolBarManager.add((IContributionItem)actionContributionItem);
        actionContributionItem = new ActionContributionItem(this.getAction("showNodes"));
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        iToolBarManager.add((IContributionItem)actionContributionItem);
        actionContributionItem = new ActionContributionItem(this.getAction("selectNodes"));
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        iToolBarManager.add((IContributionItem)actionContributionItem);
        actionContributionItem = new ActionContributionItem(this.getAction("com.deltawalker.structure.folderFilters"));
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        iToolBarManager.add((IContributionItem)actionContributionItem);
        actionContributionItem = new ActionContributionItem(this.getAction("com.deltawalker.structure.chooseSync"));
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        iToolBarManager.add((IContributionItem)actionContributionItem);
        actionContributionItem = new ActionContributionItem(this.getAction("com.deltawalker.structure.sync"));
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        iToolBarManager.add((IContributionItem)actionContributionItem);
        super.fillToolBar(iToolBarManager);
    }

    @Override
    public String getColumnToolTip(IDiffNode iDiffNode, Role role, int n) {
        IStructElement iStructElement = iDiffNode.getElement(role);
        if (!DiffModel.isNullElement((Object)iStructElement)) {
            IResource iResource = (IResource)iStructElement;
            String string = null;
            if (iResource.file().isReadable()) {
                if (n == ColumnType.EXPAND.toInt()) {
                    string = iResource.getDisplayUri();
                } else {
                    if (n == ColumnType.DATE_CREATED.toInt()) {
                        return TimeFormatter.formatLong((long)iResource.createdTime());
                    }
                    if (n == ColumnType.DATE_OPENED.toInt()) {
                        return TimeFormatter.formatLong((long)iResource.lastOpenedTime());
                    }
                    if (n == ColumnType.DATE_MODIFIED.toInt()) {
                        return TimeFormatter.formatLong((long)iResource.getLastModifiedTime());
                    }
                    if (n == ColumnType.SIZE.toInt()) {
                        return SizeFormatter.formatLong((long)iResource.getSize());
                    }
                }
            } else {
                string = String.valueOf(iResource.getUri()) + StructMsg.FolderDiffController_noAccess;
            }
            long l = iResource.resourceForkSize();
            if (l > 0L) {
                string = String.valueOf(string) + StructMsg.FolderDiffController_resForkSize + SizeFormatter.format((long)l, (int)2);
            }
            return string;
        }
        return super.getColumnToolTip(iDiffNode, role, n);
    }

    protected String getIntroMessageText() {
        return StructMsg.FolderView_introMsg;
    }

    protected String getResourceTypeDisplayName() {
        return StructMsg.FolderDiffController_folder;
    }

    @Override
    protected String getSearchToolTipText() {
        return StructMsg.FolderDiffController_search;
    }

    public Set<File> getSelectedPaths() {
        StructDiffView structDiffView = this.view();
        IStructDiffModel iStructDiffModel = structDiffView.deltaModel();
        List list = iStructDiffModel.getSelected();
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        Role role = structDiffView.getFocusRole();
        assert (role != null);
        if (role == null) {
            role = Role.ONE;
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (IDiffNode iDiffNode : list) {
            IStructElement iStructElement = iDiffNode.getElement(role);
            if (!(iStructElement instanceof IResource)) continue;
            File file = new File(((IResource)iStructElement).getPath());
            hashSet.add(file);
        }
        return hashSet;
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        ResourceBundle resourceBundle = StructMsg.constructedKeyBundle();
        StructDiffView structDiffView = this.view();
        this.addAction((IAction)new ChooseSyncMenuAction(resourceBundle, structDiffView, "com.deltawalker.updateRef"));
        this.addAction((IAction)new ChooseSyncMenuAction(resourceBundle, structDiffView, "com.deltawalker.updateOne"));
        this.addAction((IAction)new ChooseSyncMenuAction(resourceBundle, structDiffView, "com.deltawalker.updateBoth"));
        this.addAction((IAction)new ChooseSyncMenuAction(resourceBundle, structDiffView, "com.deltawalker.mirrorToRef"));
        this.addAction((IAction)new ChooseSyncMenuAction(resourceBundle, structDiffView, "com.deltawalker.mirrorToOne"));
        this.addAction((IAction)new ChooseSyncAction(structDiffView.getSite().getWorkbenchWindow(), resourceBundle, structDiffView, (IActionAccessor)this));
        this.addAction((IAction)new SyncAction(resourceBundle, structDiffView, (IActionAccessor)this));
        this.addAction((IAction)new RecompareSelectedAction(structDiffView, resourceBundle));
        this.addAction((IAction)new CompareWithAction(structDiffView, resourceBundle));
        this.addAction((IAction)new OpenSelectedAction(structDiffView, resourceBundle));
        ResourceBundle resourceBundle2 = UIMsg.constructedKeyBundle();
        this.addAction((IAction)new ShowInAction(structDiffView, resourceBundle2));
        this.addAction((IAction)new OpenWithAction(structDiffView, resourceBundle2));
        this.addAction((IAction)new OpenWithOtherAction(structDiffView, resourceBundle2));
        this.addAction((IAction)new ToggleTreeColumnAction(structDiffView, resourceBundle, ColumnType.SIZE));
        this.addAction((IAction)new ToggleTreeColumnAction(structDiffView, resourceBundle, ColumnType.ATTRIBUTES));
        this.addAction((IAction)new ToggleTreeColumnAction(structDiffView, resourceBundle, ColumnType.DATE_MODIFIED));
        this.addAction((IAction)new ToggleTreeColumnAction(structDiffView, resourceBundle, ColumnType.DATE_CREATED));
        this.addAction((IAction)new ToggleTreeColumnAction(structDiffView, resourceBundle, ColumnType.DATE_OPENED));
        this.addAction((IAction)new ToggleTreeColumnAction(structDiffView, resourceBundle, ColumnType.OWNER));
        this.addAction((IAction)new ToggleTreeColumnAction(structDiffView, resourceBundle, ColumnType.GROUP));
        this.addAction((IAction)new CopySelectedAction(structDiffView, resourceBundle, 0, false));
        this.addAction((IAction)new CopySelectedAction(structDiffView, resourceBundle, 1, false));
        this.addAction((IAction)new CopySelectedAction(structDiffView, resourceBundle, 0, true));
        this.addAction((IAction)new CopySelectedAction(structDiffView, resourceBundle, 1, true));
        this.addAction((IAction)new CopySelectedPathsAction(structDiffView, resourceBundle));
        this.addAction((IAction)new SetDateModifiedAction(structDiffView, resourceBundle));
        this.addAction((IAction)new DeleteSelectedAction(structDiffView, resourceBundle));
        this.addAction((IAction)new RenameAction(structDiffView, resourceBundle));
        this.addAction((IAction)new ExcludeAction(structDiffView, resourceBundle, "com.deltawalker.structure.excludeByExtension"));
        this.addAction((IAction)new ExcludeAction(structDiffView, resourceBundle, "com.deltawalker.structure.excludeByName"));
        this.addAction((IAction)new ExcludeAction(structDiffView, resourceBundle, "com.deltawalker.structure.excludeByPath"));
        this.addAction((IAction)new FolderFiltersAction(structDiffView.getSite().getWorkbenchWindow(), resourceBundle));
        this.addAction((IAction)new SetAsRootFolderAction(structDiffView, resourceBundle));
        this.addAction((IAction)new CreateReportJsonAction(resourceBundle, (DiffView)structDiffView));
    }

    protected void makeOpenSaveActions() {
        StructDiffView structDiffView = this.view();
        this.addAction((IAction)new OpenFolderAction(structDiffView));
        this.addAction((IAction)new OpenLocalFolderAction(structDiffView));
        this.addAction((IAction)new OpenRemoteFolderAction(structDiffView));
    }
}

