/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.SyncOp;
import com.deltawalker.structure.ui.StructAlerts;
import com.deltawalker.ui.Alert;
import com.deltawalker.ui.DiffController;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.IAlertService;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.SizeFormatter;
import org.eclipse.osgi.util.NLS;

public class FolderAlerts
extends StructAlerts {
    private static final String COLLECT_INFO_EX = "COLLECT_INFO_EX";
    private static final String NO_INC_FILTER = "NO_INC_FILTER";
    private String syncInfoKey;

    public FolderAlerts(DiffController diffController) {
        super(diffController);
    }

    protected String getIntroText() {
        return StructMsg.FolderView_introMsg;
    }

    private String getPluralSuffix(boolean bl) {
        return bl ? StructMsg.FolderAlerts_pluralSuffix : "";
    }

    private String getPrepositionInTo(boolean bl) {
        return bl ? StructMsg.FolderAlerts_prepositionIn : StructMsg.FolderAlerts_prepositionTo;
    }

    private String getPrepositionToFrom(boolean bl) {
        return bl ? StructMsg.FolderAlerts_prepositionTo : StructMsg.FolderAlerts_prepositionFrom;
    }

    public void showCollectFileInfoEx(boolean bl) {
        IAlertService iAlertService = this.service();
        IAlert iAlert = iAlertService.getAlert(COLLECT_INFO_EX);
        if (iAlert != null) {
            if (bl) {
                iAlert.setText(StructMsg.FolderAlerts_collectInfoEx);
            } else {
                iAlertService.removeAlert(iAlert.getKey());
            }
        } else if (bl) {
            iAlertService.addAlert((IAlert)new Alert(NO_INC_FILTER, StructMsg.FolderAlerts_collectInfoEx, 2, 64));
        }
        if (bl) {
            UIUtil.display().beep();
        }
    }

    public void showNoInclusionFilters(boolean bl) {
        IAlertService iAlertService = this.service();
        IAlert iAlert = iAlertService.getAlert(NO_INC_FILTER);
        if (iAlert != null) {
            if (bl) {
                iAlert.setText(StructMsg.FolderAlerts_noIncFilters);
            } else {
                iAlertService.removeAlert(iAlert.getKey());
            }
        } else if (bl) {
            iAlertService.addAlert((IAlert)new Alert(NO_INC_FILTER, StructMsg.FolderAlerts_noIncFilters, 2, 64));
        }
        if (bl) {
            UIUtil.display().beep();
        }
    }

    public void showSyncInfo(boolean bl, SyncOpInfo syncOpInfo, SyncOpInfo syncOpInfo2) {
        if (bl) {
            String string;
            if (syncOpInfo.itemCount == 0 && syncOpInfo2 == null) {
                string = NLS.bind((String)StructMsg.FolderAlerts_nothingToSync, (Object[])new Object[]{syncOpInfo.op.getName().toLowerCase(), this.getPrepositionInTo(syncOpInfo.op == SyncOp.UPDATE), syncOpInfo.dst.getDisplayName(false)});
            } else {
                string = syncOpInfo.itemCount == 0 ? "" : NLS.bind((String)StructMsg.FolderAlerts_syncOp, (Object[])new Object[]{syncOpInfo.subOp, syncOpInfo.itemCount, this.getPluralSuffix(syncOpInfo.itemCount > 1), SizeFormatter.format((long)syncOpInfo.size, (int)2), this.getPrepositionToFrom(syncOpInfo.subOp == SyncOp.COPY), syncOpInfo.dst.getDisplayName(false)});
                if (syncOpInfo2 != null && syncOpInfo2.itemCount > 0) {
                    string = String.valueOf(string) + NLS.bind((String)StructMsg.FolderAlerts_syncOp, (Object[])new Object[]{syncOpInfo2.subOp, syncOpInfo2.itemCount, this.getPluralSuffix(syncOpInfo2.itemCount > 1), SizeFormatter.format((long)syncOpInfo2.size, (int)2), this.getPrepositionToFrom(syncOpInfo2.subOp == SyncOp.COPY), syncOpInfo2.dst.getDisplayName(false)});
                }
                string = StringUtil.isEmpty((String)string) ? StructMsg.FolderAlerts_inSync : String.valueOf(string) + StructMsg.FolderAlerts_clickSync;
            }
            IAlert iAlert = this.service().getAlert(this.syncInfoKey);
            if (iAlert != null) {
                iAlert.setText(string);
            } else {
                iAlert = new Alert(null, string, 2, 64);
                this.syncInfoKey = this.service().addAlert(iAlert);
            }
        } else {
            this.service().removeAlert(this.syncInfoKey);
        }
    }

    public class SyncOpInfo {
        private Role dst;
        private int itemCount;
        private SyncOp op;
        private long size;
        private SyncOp subOp;

        public SyncOpInfo(SyncOp syncOp, SyncOp syncOp2, Role role, int n, long l) {
            this.op = syncOp;
            this.subOp = syncOp2;
            this.dst = role;
            this.itemCount = n;
            this.size = l;
        }

        public boolean gotSyncWork() {
            return this.itemCount > 0;
        }

        public long totalSize() {
            return this.size;
        }
    }
}

