/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.DeltaNodeDetail;
import com.deltawalker.DiffMethodUtil;
import com.deltawalker.IStructElement;
import com.deltawalker.IStructPropertyProvider;
import com.deltawalker.Relation;
import com.deltawalker.StructProperty;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.Role;
import com.deltawalker.structure.StructMsg;
import com.deltawalker.structure.internal.ui.IRowInfoProvider;
import com.deltawalker.structure.internal.ui.StructViewLabelDecorator;
import com.deltawalker.structure.internal.ui.TreeFilterBoss;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.StructDiffController;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltopia.ObjectUtil;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import com.deltopia.util.IDisposable;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffViewLabelProvider
implements ILabelProvider,
ITableColorProvider,
ITableLabelProvider,
ITableFontProvider,
IRowInfoProvider,
IDisposable {
    private static final Logger LOG = LoggerFactory.getLogger(DiffViewLabelProvider.class);
    private ILabelDecorator decorator;
    private Color fgGray;
    protected final Role role;
    private StructDiffView sdView;

    public static String getText(Role role, IDiffNode iDiffNode) {
        IStructElement iStructElement = iDiffNode.getElement(role);
        if (iStructElement != null) {
            IFileSystem iFileSystem;
            IResource iResource;
            String string = iStructElement.getName();
            if (!string.isEmpty() && iStructElement instanceof IResource && (iResource = (IResource)iStructElement).isSymbolicLink() && (iFileSystem = IO.fileSystem()).isReadSymbolicLinkSupported()) {
                try {
                    String string2 = iFileSystem.readSymbolicLink(iResource.getPath());
                    string = NLS.bind((String)"{0} [ -> {1} ]", (Object)string, (Object)string2);
                }
                catch (Throwable throwable) {
                    LOG.warn("Couldn't read symlink content", throwable);
                }
            }
            return string;
        }
        return "";
    }

    public DiffViewLabelProvider(StructDiffView structDiffView, TreeView treeView, Role role) {
        this.sdView = structDiffView;
        this.role = role;
        structDiffView.columnBoss(role).configure(treeView, role, structDiffView.isThreeWay(), structDiffView.getOrientation());
        this.setDecorator(new StructViewLabelDecorator(structDiffView));
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        throw new UnsupportedOperationException("DiffViewLabelProvider#addListener");
    }

    public void dispose() {
        if (this.fgGray != null) {
            this.fgGray.dispose();
            this.fgGray = null;
        }
        this.sdView = null;
        ILabelDecorator iLabelDecorator = this.getDecorator();
        if (iLabelDecorator != null) {
            iLabelDecorator.dispose();
        }
    }

    @Override
    public Color getBackground(Object object, int n) {
        return this.sdView.getColor(this.role, (IDiffNode)object, DeltaPart.BG);
    }

    @Override
    public Image getColumnImage(Object object, int n) {
        ColumnBoss columnBoss = this.sdView.columnBoss(this.role);
        if (columnBoss.getColumnType(n) == ColumnType.EXPAND) {
            return this.getImage(columnBoss.getColumnRole(n), object);
        }
        return null;
    }

    @Override
    public String getColumnText(Object object, int n) {
        ColumnBoss columnBoss = this.sdView.columnBoss(this.role);
        if (n == 0 || columnBoss.getColumnType(n) == ColumnType.EXPAND) {
            Role role = columnBoss.getColumnRole(n);
            return this.getText(role, object);
        }
        if (columnBoss.getColumnType(n) == ColumnType.DIFFS) {
            Relation relation = this.relationFromColumnIndex(n);
            return Differencer.getDeltaDetailAsString((IDiffNode)((IDiffNode)object), (Relation)relation);
        }
        IDiffNode iDiffNode = (IDiffNode)object;
        Role role = n == 0 ? this.role : columnBoss.getColumnRole(n);
        IStructElement iStructElement = iDiffNode.getElement(role);
        if (iStructElement != null) {
            List list;
            if (n != 0) {
                list = columnBoss.getColumnIndexRange(role);
                assert (((Point)list).y > 0);
                n -= ((Point)list).x;
            }
            list = iStructElement.getProperties();
            return Differencer.getPropertyValueAsString((IStructPropertyProvider)iStructElement, (StructProperty)((StructProperty)list.get(n)));
        }
        return "";
    }

    @Override
    public String getColumnToolTipText(Object object, int n) {
        ColumnBoss columnBoss = this.sdView.columnBoss(this.role);
        if (n != 0 && columnBoss.getColumnType(n) == ColumnType.DIFFS) {
            IDiffNode iDiffNode = (IDiffNode)object;
            DeltaNodeDetail deltaNodeDetail = iDiffNode.detail(this.relationFromColumnIndex(n));
            if (deltaNodeDetail != null && deltaNodeDetail.total > 0) {
                Set set = deltaNodeDetail.method;
                if (set.contains(Comparison.Method.BYTE_BY_BYTE)) {
                    return StructMsg.Smlp_byteByByteToolTip;
                }
                if (set.contains(Comparison.Method.AS_TEXT)) {
                    Object[] objectArray = new Object[]{deltaNodeDetail.total, deltaNodeDetail.deleted, deltaNodeDetail.added, deltaNodeDetail.different};
                    return NLS.bind((String)StructMsg.Smlp_charByCharToolTip, (Object[])objectArray);
                }
                return DiffMethodUtil.formatForToolTip((Set)set, (Object)deltaNodeDetail.timeDelta);
            }
        } else {
            Role role = columnBoss.getColumnRole(n);
            if (n != 0) {
                Point point = columnBoss.getColumnIndexRange(role);
                assert (point.y > 0);
                n -= point.x;
            }
            return this.sdView.controller().getColumnToolTip((IDiffNode)object, role, n);
        }
        return null;
    }

    private StructDiffController getController() {
        return this.sdView.controller();
    }

    public ILabelDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    public Font getFont(Object object, int n) {
        TreeFilterBoss treeFilterBoss = this.getController().filterBoss();
        Font font = treeFilterBoss.getBoldFont(object, treeFilterBoss.getPatternFilter(this.role), this.role);
        if (font != null) {
            return font;
        }
        if (this.sdView.columnBoss(this.role).getColumnType(n) == ColumnType.DIFFS) {
            return treeFilterBoss.getBoldFont();
        }
        return treeFilterBoss.getFont();
    }

    @Override
    public Color getForeground(Object object, int n) {
        IDiffNode iDiffNode;
        ColumnBoss columnBoss = this.sdView.columnBoss(this.role);
        ColumnType columnType = columnBoss.getColumnType(n);
        if (columnType == ColumnType.DATE_MODIFIED || columnType != ColumnType.SIZE || columnType != ColumnType.DATE_CREATED || columnType != ColumnType.DATE_OPENED) {
            iDiffNode = (IDiffNode)object;
            Role role = columnBoss.getColumnRole(n);
            IStructElement iStructElement = iDiffNode.getElement(role);
            Set set = Relation.others((Role)role, (boolean)this.sdView.isThreeWay());
            if (iStructElement instanceof IResource) {
                IResource iResource = (IResource)iStructElement;
                for (Role role2 : set) {
                    IStructElement iStructElement2 = iDiffNode.getElement(role2);
                    if (!(iStructElement2 instanceof IResource)) continue;
                    IResource iResource2 = (IResource)iStructElement2;
                    switch (columnType) {
                        case DATE_MODIFIED: {
                            if (iResource.getLastModifiedTime() > iResource2.getLastModifiedTime()) break;
                            iResource = iResource2;
                            break;
                        }
                        case SIZE: {
                            if (iResource.getSize() > iResource2.getSize()) break;
                            iResource = iResource2;
                            break;
                        }
                        case DATE_CREATED: {
                            if (iResource.createdTime() > iResource2.createdTime()) break;
                            iResource = iResource2;
                            break;
                        }
                        case DATE_OPENED: {
                            if (iResource.lastOpenedTime() > iResource2.lastOpenedTime()) break;
                            iResource = iResource2;
                            break;
                        }
                        case ATTRIBUTES: {
                            if (iResource.attributes() != iResource2.attributes()) break;
                            iResource = iResource2;
                            break;
                        }
                        case OWNER: {
                            if (!ObjectUtil.areEqual((Object)iResource.getOwner(), (Object)iResource2.getOwner())) break;
                            iResource = iResource2;
                            break;
                        }
                        case GROUP: {
                            if (!ObjectUtil.areEqual((Object)iResource.getGroup(), (Object)iResource2.getGroup())) break;
                            iResource = iResource2;
                            break;
                        }
                    }
                }
                if (iResource != iStructElement) {
                    return this.getGrayForeground();
                }
            }
        }
        if ((iDiffNode = (IDiffNode)object).isSame()) {
            return this.getGrayForeground();
        }
        return null;
    }

    private Color getGrayForeground() {
        if (this.fgGray == null) {
            Canvas canvas = this.sdView.treeView(Role.REF).tree();
            this.fgGray = this.sdView.deltaColor().colorFromRgb(DeltaColor.interpolate((RGB)canvas.getForeground().getRGB(), (RGB)canvas.getBackground().getRGB(), (double)0.65));
        }
        return this.fgGray;
    }

    @Override
    public Image getImage(Object object) {
        return this.getImage(this.role, object);
    }

    private Image getImage(Role role, Object object) {
        Image image;
        ILabelDecorator iLabelDecorator;
        assert (object != null);
        IDiffNode iDiffNode = (IDiffNode)object;
        Image image2 = iDiffNode.image(role);
        if (image2 != null && iDiffNode.isSame() && (iLabelDecorator = this.getDecorator()) != null && (image = iLabelDecorator.decorateImage(image2, null)) != null) {
            return image;
        }
        return image2;
    }

    public final Role getRole() {
        return this.role;
    }

    @Override
    public String getText(Object object) {
        return this.getText(this.role, object);
    }

    private String getText(Role role, Object object) {
        return DiffViewLabelProvider.getText(role, (IDiffNode)object);
    }

    protected Object getValue(Role role, IDiffNode iDiffNode, StructProperty structProperty) {
        return null;
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    private Relation relationFromColumnIndex(int n) {
        ColumnBoss columnBoss = this.sdView.columnBoss(this.role);
        Role role = n == 0 ? this.role : columnBoss.getColumnRole(n);
        Relation relation = Relation.fromRole((Role)role, (boolean)this.sdView.isThreeWay());
        if (LOG.isDebugEnabled()) {
            LOG.debug("colIx=" + n + "   role=" + role + "   relation=" + relation);
        }
        return relation;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        throw new UnsupportedOperationException("DiffViewLabelProvider#removeListener");
    }

    public void setDecorator(ILabelDecorator iLabelDecorator) {
        this.decorator = iLabelDecorator;
    }
}

