/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.StructProperty;
import com.deltawalker.script.SortBy;
import com.deltawalker.structure.StructMsg;
import java.util.HashMap;
import java.util.Map;

public enum ColumnType {
    ATTRIBUTES(StructProperty.ATTRIBUTES, PrefKey.D_SHOW_ATTRIBUTES_COLUMN, null, SortBy.ATTRIBUTES, "drwxrwxrwx@", 3),
    DATE_CREATED(StructProperty.DATE_CREATED, PrefKey.D_SHOW_DATE_CREATED_COLUMN, null, null, "00/00/00 00:00:00", 5),
    DATE_MODIFIED(StructProperty.DATE_MODIFIED, PrefKey.D_SHOW_DATE_MODIFIED_COLUMN, null, SortBy.MODIFIED_TIME, "00/00/00 00:00:00", 6),
    DATE_OPENED(StructProperty.DATE_OPENED, PrefKey.D_SHOW_DATE_OPENED_COLUMN, null, null, "00/00/00 00:00:00", 4),
    DIFFS(null, null, StructMsg.ColumnType_diffs, null, "P/D/S", 7),
    EXPAND(StructProperty.NAME, null, null, SortBy.NAME, "0123456789", 0),
    GROUP(StructProperty.GROUP, PrefKey.D_SHOW_GROUP_COLUMN, null, SortBy.GROUP, "abcdefgh", 1),
    OWNER(StructProperty.OWNER, PrefKey.D_SHOW_OWNER_COLUMN, null, SortBy.OWNER, "abcdefghij", 2),
    SIZE(StructProperty.SIZE, PrefKey.D_SHOW_SIZE_COLUMN, null, SortBy.SIZE, "999.99 MB", 7),
    VALUE(StructProperty.VALUE, null, null, null, "", 1);

    private static final Map<PrefKey, ColumnType> prefKey2Enum;
    private static final Map<StructProperty, ColumnType> prop2Enum;
    private static final Map<SortBy, ColumnType> sortBy2Enum;
    private static final Map<String, ColumnType> title2Enum;
    private final String extent;
    private final int intVal;
    private final PrefKey prefKey;
    private final SortBy sortBy;
    private final StructProperty structProp;
    private final String title;

    static {
        prefKey2Enum = new HashMap<PrefKey, ColumnType>();
        prop2Enum = new HashMap<StructProperty, ColumnType>();
        sortBy2Enum = new HashMap<SortBy, ColumnType>();
        title2Enum = new HashMap<String, ColumnType>();
        ColumnType[] columnTypeArray = ColumnType.values();
        int n = columnTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnType columnType = columnTypeArray[n2];
            title2Enum.put(columnType.title, columnType);
            prefKey2Enum.put(columnType.prefKey, columnType);
            prop2Enum.put(columnType.structProp, columnType);
            sortBy2Enum.put(columnType.sortBy, columnType);
            ++n2;
        }
    }

    public static ColumnType fromPrefKey(PrefKey prefKey) {
        return prefKey2Enum.get(prefKey);
    }

    public static ColumnType fromSortBy(SortBy sortBy) {
        return sortBy2Enum.get(sortBy);
    }

    public static ColumnType fromStructProperty(StructProperty structProperty) {
        return prop2Enum.get(structProperty);
    }

    public static ColumnType fromTitle(StructProperty structProperty) {
        return title2Enum.get(structProperty.toString());
    }

    private ColumnType(StructProperty structProperty, PrefKey prefKey, String string2, SortBy sortBy, String string3, int n2) {
        this.prefKey = prefKey;
        this.structProp = structProperty;
        this.title = structProperty != null ? structProperty.displayName() : string2;
        this.sortBy = sortBy;
        this.extent = string3;
        this.intVal = n2;
    }

    public boolean isExtendedAttribute() {
        return this == GROUP || this == OWNER || this == DATE_CREATED || this == DATE_OPENED;
    }

    public boolean isVisible() {
        if (this.structProp != null) {
            return this.structProp.isVisible();
        }
        return true;
    }

    public void setVisible(boolean bl) {
        if (this.structProp != null) {
            this.structProp.setVisible(bl);
        }
    }

    public StructProperty structProperty() {
        return this.structProp;
    }

    public String textForExtent() {
        return this.extent;
    }

    public String title() {
        return this.title;
    }

    public int toInt() {
        return this.intVal;
    }
}

