/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.ui;

import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.StructProperty;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.script.Role;
import com.deltawalker.structure.internal.ui.treeview.TreeView;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.FolderAlerts;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltopia.util.OS;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class ColumnBoss {
    private static final String COLUMN_BOSS = "columnBoss";
    private List<StructProperty> colProps;
    private String expandTitle;
    private Role focusRole;
    private final Listener onMouse = new Listener(){

        public void handleEvent(Event event) {
            if (!$assertionsDisabled && event.type != 3 && event.type != 4) {
                throw new AssertionError();
            }
            TreeColumnEx treeColumnEx = (TreeColumnEx)ColumnBoss.this.treeView.hitTestColumn(event.x);
            ColumnBoss.this.setFocusRole(treeColumnEx != null ? treeColumnEx.role : null);
        }
    };
    private Set<Role> roles = EnumSet.noneOf(Role.class);
    private StructDiffView sdView;
    private boolean showDiffsCol = true;
    protected TreeView treeView;

    public static ColumnBoss get(Control control) {
        return (ColumnBoss)control.getData(COLUMN_BOSS);
    }

    public ColumnBoss(StructDiffView structDiffView, List<StructProperty> list) {
        this.sdView = structDiffView;
        this.colProps = list;
    }

    public boolean configure(TreeView treeView, Role role, boolean bl, int n) {
        boolean bl2 = false;
        this.configureRoles(role, n);
        this.updateFocusRole();
        this.createColumns();
        this.setTreeView(treeView);
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureRoles(Role role, int n) {
        boolean bl = this.sdView.isThreeWay();
        if (role == Role.TWO) {
            if (!bl || (n & 0x100) != 256) return;
            this.roles = EnumSet.of(Role.TWO);
            return;
        }
        if (role == Role.REF) {
            switch (n) {
                case 256: {
                    this.roles = EnumSet.of(Role.REF);
                    return;
                }
                case 512: {
                    if (bl) {
                        this.roles = Relation.roles((boolean)true);
                        return;
                    }
                }
                case 768: {
                    this.roles = Relation.roles((boolean)false);
                    return;
                }
                default: {
                    assert (false);
                    return;
                }
            }
        }
        if (role != Role.ONE || (n & 0x200) == 512) return;
        this.roles = EnumSet.of(Role.ONE);
    }

    private TreeColumnEx createColumn(int n, int n2, Role role, ColumnType columnType) {
        final TreeColumnEx treeColumnEx = new TreeColumnEx(this.treeView.header(), n, n2, role, columnType);
        treeColumnEx.setResizable(true);
        String string = columnType.title();
        if (!string.isEmpty()) {
            treeColumnEx.setText(string);
            treeColumnEx.setVisible(columnType.isVisible());
        }
        treeColumnEx.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColumnBoss.this.sortByColumn(treeColumnEx);
            }
        });
        treeColumnEx.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ColumnBoss.this.treeView.redraw();
            }
        });
        return treeColumnEx;
    }

    private void createColumns() {
        if (!this.isInitialized()) {
            return;
        }
        TreeColumn[] treeColumnArray = this.treeView.getColumns();
        int n = this.roles.size();
        boolean[] blArray = new boolean[n];
        Role[] roleArray = this.roles.toArray(new Role[n]);
        int n2 = treeColumnArray.length - 1;
        while (n2 >= 0) {
            TreeColumnEx treeColumnEx = (TreeColumnEx)treeColumnArray[n2];
            boolean bl = true;
            int n3 = 0;
            while (n3 < n) {
                if (treeColumnEx.role == roleArray[n3]) {
                    bl = false;
                    blArray[n3] = true;
                    break;
                }
                ++n3;
            }
            if (bl) {
                treeColumnEx.dispose();
            }
            --n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                int n4;
                if (n2 == 0) {
                    n4 = this.treeView.getColumnCount();
                } else {
                    Point point = this.getColumnIndexRange(roleArray[n2 - 1]);
                    n4 = point.x + point.y;
                }
                this.createInitialColumns(roleArray[n2], n4);
            }
            ++n2;
        }
    }

    public int createColumns(Role role, List<StructProperty> list, boolean bl) {
        Point point = this.getColumnIndexRange(role);
        int n = point.y;
        if (role != Role.ONE && n > 1 && this.getColumnType(point.x + n - 1) == ColumnType.DIFFS) {
            --n;
        }
        int n2 = 0;
        int n3 = list.size();
        if (n3 > n) {
            int n4 = n;
            while (n4 < n3) {
                StructProperty structProperty = list.get(n4);
                ColumnType columnType = ColumnType.fromTitle(structProperty);
                TreeColumnEx treeColumnEx = this.createColumn(16384, point.x + n4, role, columnType);
                treeColumnEx.setData(structProperty);
                treeColumnEx.setText(columnType.title());
                ++n2;
                ++n4;
            }
        }
        if (bl && n2 > 0) {
            this.resizeColumns();
        }
        return n2;
    }

    private void createInitialColumns(Role role, int n) {
        Role role2;
        TreeColumnEx treeColumnEx = this.createColumn(16384, n++, role, ColumnType.EXPAND);
        int n2 = 0;
        if (!this.colProps.isEmpty()) {
            n2 = this.createColumns(role, this.colProps, false);
        }
        if (role != (role2 = Relation.lastRole((boolean)this.sdView.isThreeWay())) && this.getShowDiffsColumn()) {
            this.createColumn(0x1000000, n + n2, role, ColumnType.DIFFS);
        }
        treeColumnEx.setText(this.getExpandColumnTitle(n));
        this.initializeColumnWidths(role);
    }

    public void dispose() {
        this.disposeColumns();
        this.setTreeView(null);
    }

    public void disposeColumns() {
        if (this.treeView == null) {
            return;
        }
        TreeColumn[] treeColumnArray = this.treeView.getColumns();
        int n = treeColumnArray.length - 1;
        while (n >= 0) {
            TreeColumn treeColumn = treeColumnArray[n];
            treeColumn.dispose();
            --n;
        }
    }

    private Role firstRole() {
        Iterator<Role> iterator = this.roles.iterator();
        return iterator.hasNext() ? this.roles.iterator().next() : null;
    }

    public TreeColumnEx getColumn(Role role, ColumnType columnType) {
        List<TreeColumnEx> list = this.getColumns(role);
        for (TreeColumn treeColumn : list) {
            if (((TreeColumnEx)treeColumn).type() != columnType) continue;
            return (TreeColumnEx)treeColumn;
        }
        return null;
    }

    public Point getColumnIndexRange(Role role) {
        TreeColumn[] treeColumnArray = this.treeView.getColumns();
        Point point = new Point(-1, 0);
        int n = 0;
        while (n < treeColumnArray.length) {
            TreeColumnEx treeColumnEx = (TreeColumnEx)treeColumnArray[n];
            if (treeColumnEx.role == role) {
                if (point.x == -1) {
                    point.x = n;
                }
                ++point.y;
            }
            ++n;
        }
        if (point.x == -1) {
            point.x = 0;
        }
        return point;
    }

    public Role getColumnRole(int n) {
        return this.treeView.getColumn((int)n).role;
    }

    private List<TreeColumnEx> getColumns(Role role) {
        TreeColumn[] treeColumnArray = this.treeView.getColumns();
        LinkedList<TreeColumnEx> linkedList = new LinkedList<TreeColumnEx>();
        TreeColumn[] treeColumnArray2 = treeColumnArray;
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray2[n2];
            TreeColumnEx treeColumnEx = (TreeColumnEx)treeColumn;
            if (treeColumnEx.role == role) {
                linkedList.add(treeColumnEx);
            }
            ++n2;
        }
        return linkedList;
    }

    public ColumnType getColumnType(int n) {
        assert (n < this.treeView.getColumnCount());
        return this.treeView.getColumn((int)n).type;
    }

    public String getExpandColumnTitle(int n) {
        return this.expandTitle;
    }

    public Role getFocusRole() {
        return this.focusRole;
    }

    private int getHiddenColumnCount() {
        List<TreeColumnEx> list = this.getColumns(this.firstRole());
        int n = 0;
        for (TreeColumnEx treeColumnEx : list) {
            if (treeColumnEx.visible) continue;
            ++n;
        }
        return n;
    }

    public Role getRole(Point point) {
        TreeColumn[] treeColumnArray = this.treeView.getColumns();
        int n = 0;
        Role role = null;
        TreeColumn[] treeColumnArray2 = treeColumnArray;
        int n2 = treeColumnArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TreeColumn treeColumn = treeColumnArray2[n3];
            int n4 = n + treeColumn.getWidth();
            if (n <= point.x && point.x < n4) {
                role = ((TreeColumnEx)treeColumn).role;
                break;
            }
            n = n4;
            ++n3;
        }
        return role;
    }

    public boolean getShowDiffsColumn() {
        return this.showDiffsCol;
    }

    protected abstract void initializeColumnWidths(Role var1);

    public void inputChanged(Object object, Object object2) {
        IDiffDoc iDiffDoc;
        IPreferenceStore iPreferenceStore;
        int n;
        if (object instanceof IDiffDoc && this.treeView != null && (n = (iPreferenceStore = (iDiffDoc = (IDiffDoc)object).preferences()).getInt(PrefKey.D_SORT_COLUMN.toString())) < this.treeView.getColumnCount()) {
            int n2 = iPreferenceStore.getBoolean(PrefKey.D_SORT_UP.toString()) ? 128 : 1024;
            this.treeView.header().setSortColumn((TreeColumn)this.treeView.getColumn(n));
            this.treeView.header().setSortDirection(n2);
            this.sortDiffModel(this.treeView.getColumn(n), n2);
        }
    }

    private boolean isInitialized() {
        return this.treeView != null && !this.treeView.isDisposed() && !this.roles.isEmpty();
    }

    public void resizeColumns() {
        if (this.isInitialized()) {
            int n = this.roles.size();
            boolean bl = n == 3;
            int n2 = bl ? 2 : 1;
            TreeColumnEx treeColumnEx = this.getColumn(Role.REF, ColumnType.DIFFS);
            int n3 = treeColumnEx != null ? treeColumnEx.getDefaultWidth() : 0;
            int n4 = (this.treeView.getClientArea().width - n3 * n2) / n - (OS.COCOA ? this.getHiddenColumnCount() : 0);
            for (Role role : this.roles) {
                List<TreeColumnEx> list = this.getColumns(role);
                if (list.isEmpty()) continue;
                int n5 = 0;
                if (role == Role.REF) {
                    n5 = n3;
                } else if (bl && role == Role.ONE) {
                    n5 = n3;
                }
                this.resizeColumns(list, n4 + n5);
            }
        }
    }

    public abstract void resizeColumns(List<TreeColumnEx> var1, int var2);

    public boolean setColumnVisibility(PropertyChangeEvent propertyChangeEvent, boolean bl) {
        boolean bl2 = false;
        if (this.isInitialized()) {
            String string = propertyChangeEvent.getProperty();
            for (Role role : this.sdView.roles()) {
                ColumnType columnType;
                TreeColumnEx treeColumnEx = this.getColumn(role, columnType = ColumnType.fromPrefKey(PrefKey.fromString((String)string)));
                if (treeColumnEx != null) {
                    boolean bl3;
                    if (columnType.isVisible() && columnType.isExtendedAttribute() && !(bl3 = this.sdView.getInput().preferences().getBoolean(PrefKey.D_COLLECT_INFO_EX.toString()))) {
                        ((FolderAlerts)this.sdView.controller().alerts()).showCollectFileInfoEx(true);
                    }
                    treeColumnEx.setVisible(columnType.isVisible());
                }
                bl2 = true;
            }
        }
        if (bl2) {
            this.resizeColumns();
        }
        return bl2;
    }

    public void setExpandColumnTitle(String string) {
        this.expandTitle = string;
    }

    private void setFocusRole(Role role) {
        if (this.focusRole != role) {
            this.focusRole = role;
        }
        if (this.treeView != null && !this.treeView.isDisposed()) {
            this.treeView.setFocus();
        }
    }

    public void setShowDiffsColumn(boolean bl) {
        this.showDiffsCol = bl;
    }

    private void setTreeView(TreeView treeView) {
        if (this.treeView != treeView) {
            if (this.treeView != null && !this.treeView.isDisposed()) {
                assert (this == this.treeView.getData(COLUMN_BOSS));
                this.treeView.setData(COLUMN_BOSS, null);
                this.treeView.tree().removeListener(3, this.onMouse);
                this.treeView.tree().removeListener(4, this.onMouse);
            }
            this.treeView = treeView;
            if (this.treeView != null && !this.treeView.isDisposed()) {
                treeView.setData(COLUMN_BOSS, this);
                treeView.tree().addListener(3, this.onMouse);
                treeView.tree().addListener(4, this.onMouse);
            }
            this.createColumns();
        }
    }

    protected void sortByColumn(TreeColumnEx treeColumnEx) {
    }

    protected void sortDiffModel(TreeColumnEx treeColumnEx, int n) {
    }

    public StructDiffView structView() {
        return this.sdView;
    }

    public TreeView treeView() {
        return this.treeView;
    }

    private void updateFocusRole() {
        if (this.roles.isEmpty()) {
            return;
        }
        if (this.roles != null) {
            for (Role role : this.roles) {
                assert (role != null);
            }
        }
        boolean bl = true;
        for (Role role : this.roles) {
            if (role != this.focusRole) continue;
            bl = false;
        }
        if (bl) {
            this.setFocusRole(this.firstRole());
        }
    }

    public final class TreeColumnEx
    extends TreeColumn {
        private int defaultWidth;
        public final Role role;
        private int sortDir;
        public final ColumnType type;
        private boolean visible;

        public TreeColumnEx(Tree tree, int n, int n2, Role role, ColumnType columnType) {
            super(tree, n, n2);
            this.sortDir = 128;
            this.visible = true;
            this.role = role;
            this.type = columnType;
        }

        protected void checkSubclass() {
        }

        public int getDefaultWidth() {
            return this.defaultWidth;
        }

        public int getSortDirection() {
            return this.sortDir;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setDefaultWidth(int n) {
            this.defaultWidth = n;
        }

        public void setSortDirection(int n) {
            this.sortDir = n;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
            if (!bl) {
                this.setWidth(0);
            }
            this.setResizable(bl);
        }

        public void setWidth(int n) {
            super.setWidth(n);
            if (OS.OSX && OS.isVersionEqualOrNewerThan((double)10.7)) {
                Tree tree = ColumnBoss.this.treeView.header();
                Rectangle rectangle = ColumnBoss.this.treeView.header().getBounds();
                ++rectangle.width;
                tree.setBounds(rectangle);
            }
        }

        public String toString() {
            return this.role + " " + super.toString();
        }

        public ColumnType type() {
            return this.type;
        }
    }
}

