/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.treeview;

import com.deltawalker.ImageCache;
import com.deltawalker.PrefKey;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.structure.internal.StructImageConst;
import com.deltawalker.structure.internal.StructPlugin;
import com.deltawalker.structure.internal.ui.IRowInfoProvider;
import com.deltawalker.structure.internal.ui.treeview.TreeController;
import com.deltawalker.structure.ui.ColumnBoss;
import com.deltawalker.structure.ui.ColumnType;
import com.deltawalker.structure.ui.StructDiffView;
import com.deltopia.interfaces.IMvcController;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.ui.treeview.ITreeEventListener;
import com.deltopia.util.Const;
import com.deltopia.util.IDisposable;
import com.deltopia.util.Listeners;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeView
extends Composite
implements IMvcView {
    public static final Point arrowImgSize;
    public static final int DEPTH_OFFSET;
    private static final int EXPAND_GAP = 3;
    private static Font font;
    private static final Image imgCollapse;
    private static final Image imgCollapseSel;
    private static final Image imgExpand;
    private static final Image imgExpandSel;
    private static int rowHeight;
    final Color bg;
    private final Color bgSelected;
    private final Color bgSelFocus;
    final Color fg;
    private final Color fgSelected;
    private final Color fgSelFocus;
    private Tree header;
    private Listeners listeners = new Listeners();
    private IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("com.deltawalker.ui.editorFont")) {
                TreeView.this.updateFont();
            }
        }
    };
    private IRowInfoProvider rowInfo;
    private final ScrollBar sbCommon;
    private IStructDiffModel sdModel;
    private StructDiffView sdView;
    private Canvas tree;
    private TreeController treeCtlr;
    private final List<IDiffNode> visibles = new ArrayList<IDiffNode>();

    static {
        DEPTH_OFFSET = OS.OSX ? 14 : 12;
        imgExpand = ImageCache.getImage((String)StructPlugin.getPluginId(), (String)StructImageConst.ARROW_EXPAND);
        imgExpandSel = ImageCache.getImage((String)StructPlugin.getPluginId(), (String)StructImageConst.ARROW_EXPAND_SEL);
        imgCollapse = ImageCache.getImage((String)StructPlugin.getPluginId(), (String)StructImageConst.ARROW_COLLAPSE);
        imgCollapseSel = ImageCache.getImage((String)StructPlugin.getPluginId(), (String)StructImageConst.ARROW_COLLAPSE_SEL);
        if (imgCollapse != null && imgExpand != null) {
            Rectangle rectangle = imgCollapse.getBounds();
            arrowImgSize = new Point(rectangle.width, rectangle.height);
            rectangle = imgExpand.getBounds();
            if (TreeView.arrowImgSize.x < rectangle.width) {
                TreeView.arrowImgSize.x = rectangle.width;
            }
            if (TreeView.arrowImgSize.y < rectangle.height) {
                TreeView.arrowImgSize.y = rectangle.height;
            }
        } else {
            arrowImgSize = null;
        }
    }

    public static int depthOffset(IDiffNode iDiffNode) {
        return iDiffNode.depth() * DEPTH_OFFSET;
    }

    public TreeView(StructDiffView structDiffView, Composite composite, int n) {
        super(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.sdView = structDiffView;
        this.sbCommon = structDiffView.commonScrollBar();
        this.createHeader();
        this.createTree();
        this.updateFont();
        rowHeight = this.header.getItemHeight() + (OS.OSX ? 4 : 1);
        this.installListeners();
        Display display = this.header.getDisplay();
        this.fg = display.getSystemColor(24);
        this.bg = display.getSystemColor(25);
        boolean bl = OS.OSX;
        this.bgSelected = display.getSystemColor(bl ? 34 : 26);
        this.bgSelFocus = display.getSystemColor(bl ? 31 : 26);
        this.fgSelected = display.getSystemColor(bl ? 30 : 27);
        this.fgSelFocus = display.getSystemColor(bl ? 1 : 27);
        this.createToolTip();
        JFaceResources.getFontRegistry().addListener(this.onProp);
    }

    public void addFilter(ViewerFilter viewerFilter) {
    }

    public void addTreeEventListener(ITreeEventListener iTreeEventListener) {
        this.listeners.addListenerObject((Object)iTreeEventListener);
    }

    public int columnIndex(TreeColumn treeColumn) {
        TreeColumn[] treeColumnArray = this.header.getColumns();
        int n = 0;
        while (n < treeColumnArray.length) {
            if (treeColumn == treeColumnArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void connect(IMvcModel iMvcModel, IMvcController iMvcController) {
        this.treeCtlr = iMvcController != null ? (TreeController)iMvcController : new TreeController(this.sdView.commonScrollBar());
        this.sdModel = this.sdView.deltaModel();
        this.treeCtlr.connect(iMvcModel, this);
        this.sdModel.getChildren(this.sdModel.getRoot(), false);
    }

    public Control control() {
        return this;
    }

    public TreeController controller() {
        return this.treeCtlr;
    }

    private void createHeader() {
        this.header = new Tree((Composite)this, 16);
        font = this.header.getFont();
        this.header.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, false);
        int n = 0;
        if (OS.OSX) {
            n = 1;
        }
        if (OS.GTK) {
            new TreeColumn(this.header, 0);
        }
        gridData.heightHint = this.header.getHeaderHeight() + n;
        if (OS.GTK) {
            this.header.getColumn(0).dispose();
        }
        this.header.setLayoutData((Object)gridData);
    }

    private void createToolTip() {
        DefaultToolTip defaultToolTip = new DefaultToolTip((Control)this.tree){

            protected String getText(Event event) {
                String string = TreeView.this.getToolTipText(event);
                return string == null ? super.getText(event) : string;
            }

            protected boolean shouldCreateToolTip(Event event) {
                if (!super.shouldCreateToolTip(event)) {
                    return false;
                }
                return this.getText(event) != null;
            }
        };
        defaultToolTip.setPopupDelay(0);
        defaultToolTip.setShift(new Point(0, 16));
    }

    private void createTree() {
        this.tree = new Canvas((Composite)this, 538181632);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void disconnect() {
        if (this.treeCtlr != null) {
            this.treeCtlr.disconnect();
        }
        this.sdModel = null;
        this.treeCtlr = null;
        this.visibles.clear();
    }

    public void dispose() {
        this.disconnect();
    }

    void fireMouseDown(ITreeEventListener.MouseButton mouseButton, Point point) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof ITreeEventListener) {
                ((ITreeEventListener)object).mouseDown(mouseButton, point);
            }
            ++n2;
        }
    }

    void fireShowContextMenu(Point point) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof ITreeEventListener) {
                ((ITreeEventListener)object).showContextMenu((Control)this.tree, point);
            }
            ++n2;
        }
    }

    public void fullUpdate() {
        this.sdView.birdsEye().refresh();
        this.controller().updateScrollBar();
    }

    public ColumnBoss.TreeColumnEx getColumn(int n) {
        return (ColumnBoss.TreeColumnEx)this.header.getColumn(n);
    }

    public int getColumnCount() {
        return this.header.getColumnCount();
    }

    public TreeColumn[] getColumns() {
        return this.header.getColumns();
    }

    public Font getFont() {
        return font;
    }

    public int getItemHeight() {
        return rowHeight;
    }

    private Rectangle getRowBounds(IDiffNode iDiffNode) {
        Point point = this.visibleRange();
        List list = this.sdModel.getViewable();
        Rectangle rectangle = this.tree.getClientArea();
        int n = point.x;
        while (n <= point.y) {
            if (iDiffNode == list.get(n)) {
                rectangle.y = (n - point.x) * rowHeight;
                rectangle.height = rowHeight;
                return rectangle;
            }
            ++n;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public IRowInfoProvider getRowInfoProvider() {
        return this.rowInfo;
    }

    public TreeColumn getSortColumn() {
        return this.header.getSortColumn();
    }

    public int getSortDirection() {
        return this.header.getSortDirection();
    }

    private String getToolTipText(Event event) {
        IDiffNode iDiffNode;
        TreeColumn treeColumn;
        if (this.rowInfo != null && (treeColumn = this.hitTestColumn(event.x)) != null && (iDiffNode = this.hitTestNode(event.y)) != null) {
            TreeColumn[] treeColumnArray;
            int n = 0;
            TreeColumn[] treeColumnArray2 = treeColumnArray = this.getColumns();
            int n2 = treeColumnArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TreeColumn treeColumn2 = treeColumnArray2[n3];
                if (treeColumn2 == treeColumn) {
                    return this.rowInfo.getColumnToolTipText(iDiffNode, n);
                }
                ++n;
                ++n3;
            }
        }
        return null;
    }

    public ScrollBar getVerticalBar() {
        return this.sbCommon;
    }

    public int getVisibleNodeIndex(IDiffNode iDiffNode) {
        Point point = this.visibleRange();
        List list = this.sdModel.getViewable();
        int n = point.x;
        while (n <= point.y) {
            if (list.get(n) == iDiffNode) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Tree header() {
        return this.header;
    }

    public Rectangle headerBounds() {
        return this.header.getBounds();
    }

    public TreeColumn hitTestColumn(int n) {
        TreeColumn[] treeColumnArray;
        Rectangle rectangle = this.tree.getClientArea();
        rectangle.height += this.header.getHeaderHeight();
        if (!rectangle.contains(n, 0)) {
            return null;
        }
        int n2 = 0;
        TreeColumn[] treeColumnArray2 = treeColumnArray = this.header.getColumns();
        int n3 = treeColumnArray.length;
        int n4 = 0;
        while (n4 < n3) {
            TreeColumn treeColumn = treeColumnArray2[n4];
            int n5 = treeColumn.getWidth();
            if (n2 <= n && n < n2 + n5) {
                return treeColumn;
            }
            n2 += treeColumn.getWidth();
            ++n4;
        }
        return null;
    }

    public IDiffNode hitTestNode(int n) {
        Rectangle rectangle = this.tree.getClientArea();
        if (!rectangle.contains(0, n) || this.sdModel == null) {
            return null;
        }
        int n2 = n / rowHeight;
        Point point = this.visibleRange();
        if (n2 <= point.y - point.x) {
            return (IDiffNode)this.sdModel.getViewable().get(point.x + n2);
        }
        return null;
    }

    private void installListeners() {
        this.tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TreeView.this.onPaint(paintEvent);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TreeView.this.sdView = null;
                JFaceResources.getFontRegistry().removeListener(TreeView.this.onProp);
                ((IDisposable)TreeView.this.rowInfo).dispose();
                TreeView.this.rowInfo = null;
            }
        });
    }

    public boolean isFocusControl() {
        return this.tree.isFocusControl();
    }

    public boolean isNodeVisible(IDiffNode iDiffNode, boolean bl) {
        List list = this.sdModel.getViewable();
        Point point = this.visibleRange();
        int n = bl ? point.y + 1 : point.y;
        int n2 = point.x;
        while (n2 < n) {
            if (list.get(n2) == iDiffNode) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int maxVisibleRowCount(boolean bl) {
        int n = this.tree.getClientArea().height;
        if (bl) {
            return (int)Math.ceil((double)n / (double)rowHeight);
        }
        return n / rowHeight;
    }

    public IStructDiffModel model() {
        return this.sdModel;
    }

    private void onPaint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = gC.getClipping();
        int n = this.tree.getClientArea().width;
        gC.setBackground(this.bg);
        gC.fillRectangle(rectangle);
        if (this.sdModel == null) {
            return;
        }
        gC.setForeground(this.fg);
        Point point = this.visibleRange();
        List list = this.sdModel.getViewable();
        if (list.isEmpty()) {
            return;
        }
        int n2 = list.size();
        int n3 = Math.min(point.x, n2);
        int n4 = Math.min(point.y, n2) + 1;
        ArrayList arrayList = new ArrayList(list.subList(n3, n4));
        int n5 = 0;
        for (IDiffNode iDiffNode : arrayList) {
            if (iDiffNode.isDisposed()) continue;
            int n6 = n5 * rowHeight;
            if (rectangle.intersects(0, n6, n, rowHeight)) {
                this.paintRow(gC, iDiffNode, n6, n);
            }
            ++n5;
        }
    }

    private void paintCell(GC gC, IDiffNode iDiffNode, int n, ColumnType columnType, Rectangle rectangle) {
        Rectangle rectangle2;
        Color color;
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        gC.setFont(this.rowInfo.getFont(iDiffNode, n));
        gC.setClipping(rectangle);
        if (!iDiffNode.isSelected() && (color = this.rowInfo.getForeground(iDiffNode, n)) != null && !color.isDisposed()) {
            gC.setForeground(color);
        }
        color = this.rowInfo.getColumnImage(iDiffNode, n);
        String string = this.rowInfo.getColumnText(iDiffNode, n);
        Point point = gC.stringExtent(string);
        int n2 = rectangle.x;
        if (columnType == ColumnType.EXPAND && arrowImgSize != null) {
            if (iDiffNode.getChildren(false).length > 0) {
                rectangle2 = iDiffNode.isSelected() ? (iDiffNode.isExpanded() ? imgCollapseSel : imgExpandSel) : (iDiffNode.isExpanded() ? imgCollapse : imgExpand);
                gC.drawImage((Image)rectangle2, n2, rectangle.y + (rectangle.height - TreeView.arrowImgSize.y) / 2);
            }
            n2 += TreeView.arrowImgSize.x + 3;
        }
        if (color != null && !color.isDisposed()) {
            rectangle2 = color.getBounds();
            gC.drawImage((Image)color, n2, rectangle.y + (rectangle.height - color.getBounds().height) / 2);
            n2 += rectangle2.width + 6;
        }
        if (columnType == ColumnType.DIFFS) {
            n2 += Math.max(0, (rectangle.width - point.x) / 2);
        }
        gC.drawString(string, n2, rectangle.y + (rectangle.height - point.y) / 2, false);
        gC.setClipping(null);
    }

    private void paintRow(GC gC, IDiffNode iDiffNode, int n, int n2) {
        Color color;
        if (this.rowInfo == null) {
            return;
        }
        Color color2 = gC.getBackground();
        Color color3 = gC.getForeground();
        int n3 = rowHeight - 1;
        if (iDiffNode.isSelected()) {
            boolean bl = true;
            gC.setBackground(bl ? this.bgSelFocus : this.bgSelected);
            gC.fillRoundRectangle(0, n, n2, n3, Const.ARC.x, Const.ARC.y);
            gC.setForeground(bl ? this.fgSelFocus : this.fgSelected);
        } else if (!iDiffNode.isSame() && (color = this.rowInfo.getBackground(iDiffNode, 0)) != null) {
            gC.setBackground(color);
            gC.fillRoundRectangle(0, n, n2, n3, Const.ARC.x, Const.ARC.y);
        }
        TreeColumn[] treeColumnArray = this.header.getColumns();
        int n4 = 0;
        int n5 = 0;
        TreeColumn[] treeColumnArray2 = treeColumnArray;
        int n6 = treeColumnArray.length;
        int n7 = 0;
        while (n7 < n6) {
            TreeColumn treeColumn = treeColumnArray2[n7];
            Color color4 = gC.getForeground();
            int n8 = treeColumn.getWidth();
            ColumnType columnType = ((ColumnBoss.TreeColumnEx)treeColumn).type();
            int n9 = 0;
            if (columnType == ColumnType.EXPAND) {
                n9 = TreeView.depthOffset(iDiffNode);
            }
            Rectangle rectangle = new Rectangle(n4 + n9, n, n8, rowHeight);
            this.paintCell(gC, iDiffNode, n5, columnType, rectangle);
            n4 += n8;
            ++n5;
            gC.setForeground(color4);
            ++n7;
        }
        if (color2 != null) {
            gC.setBackground(color2);
        }
        if (color3 != null) {
            gC.setForeground(color3);
        }
    }

    public void redraw() {
        if (this.tree != null && !this.tree.isDisposed()) {
            this.tree.redraw();
        }
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.tree.redraw(n, n2, n3, n4, bl);
    }

    public void redrawNow() {
        this.redraw();
        this.update();
    }

    public void redrawNow(IDiffNode iDiffNode) {
        Rectangle rectangle = this.isNodeVisible(iDiffNode, false) ? this.getRowBounds(iDiffNode) : this.tree.getClientArea();
        this.tree.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        this.tree.update();
    }

    public void removeTreeEventListener(ITreeEventListener iTreeEventListener) {
        this.listeners.removeListenerObject((Object)iTreeEventListener);
    }

    public boolean setFocus() {
        boolean bl = this.tree.setFocus();
        this.notifyListeners(bl ? 15 : 16, null);
        return bl;
    }

    public void setRowInfoProvider(IRowInfoProvider iRowInfoProvider) {
        this.rowInfo = iRowInfoProvider;
    }

    public void setSortColumn(TreeColumn treeColumn) {
        IPreferenceStore iPreferenceStore = this.sdView.preferences();
        int n = this.header.indexOf(treeColumn);
        iPreferenceStore.putValue(PrefKey.D_SORT_COLUMN.toString(), String.valueOf(n));
        this.header.setSortColumn(treeColumn);
    }

    public void setSortDirection(int n) {
        assert (n == 128 || n == 1024);
        IPreferenceStore iPreferenceStore = this.sdView.preferences();
        iPreferenceStore.putValue(PrefKey.D_SORT_UP.toString(), String.valueOf(n == 128));
        this.header.setSortDirection(n);
    }

    public StructDiffView structView() {
        return this.sdView;
    }

    public TreeItem testFindItem(Object object) {
        return null;
    }

    public Canvas tree() {
        return this.tree;
    }

    public void update() {
        if (this.tree != null && !this.tree.isDisposed()) {
            this.tree.update();
        }
    }

    private void updateFont() {
        Device device;
        FontData[] fontDataArray;
        FontData[] fontDataArray2 = JFaceResources.getFont((String)"com.deltawalker.ui.editorFont").getFontData();
        FontData[] fontDataArray3 = fontDataArray = font.getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            device = fontDataArray3[n2];
            device.setHeight(fontDataArray2[0].getHeight());
            ++n2;
        }
        device = font.getDevice();
        font = new Font(device, fontDataArray);
        this.header.setFont(font);
        rowHeight = this.header.getItemHeight();
        this.redrawNow();
    }

    public void updateSelection(IDiffNode iDiffNode) {
        Rectangle rectangle;
        if (this.isNodeVisible(iDiffNode, false)) {
            rectangle = this.getRowBounds(iDiffNode);
        } else {
            int n = this.sdModel.getViewable().indexOf(iDiffNode);
            int n2 = 1;
            Point point = this.visibleRange();
            int n3 = n > point.x ? n - this.sbCommon.getThumb() + n2 : n;
            this.sbCommon.setSelection(n3);
            rectangle = this.tree.getClientArea();
        }
        this.tree.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        this.tree.update();
    }

    public void updateSelection(List<IDiffNode> list) {
        Rectangle rectangle;
        if (list.isEmpty()) {
            return;
        }
        if (list.size() < this.visibleNodes().size()) {
            rectangle = this.getRowBounds(list.get(0));
            for (IDiffNode iDiffNode : list) {
                rectangle = rectangle.union(this.getRowBounds(iDiffNode));
            }
        } else {
            rectangle = this.tree.getClientArea();
        }
        this.tree.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        this.tree.update();
    }

    public List<IDiffNode> visibleNodes() {
        this.visibles.clear();
        List list = this.sdModel.getViewable();
        Point point = this.visibleRange();
        int n = point.x;
        while (n <= point.y) {
            this.visibles.add((IDiffNode)list.get(n));
            ++n;
        }
        return this.visibles;
    }

    public Point visibleRange() {
        Point point = new Point(0, 0);
        List list = this.sdModel.getViewable();
        point.x = this.sbCommon.getSelection();
        point.y = Math.min(list.size() - 1, point.x + this.maxVisibleRowCount(false));
        return point;
    }
}

