/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.structure.internal.ui.treeview;

import com.deltawalker.structure.internal.ui.ControlEdit;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeEdit
extends ControlEdit {
    private static final int IMAGE_WIDTH = 16;
    static int ROW_HEIGHT;
    static final int TIMEOUT = 1500;
    Point cell = new Point(0, 0);
    Tree header;
    Runnable layoutRunnable;
    ControlListener onColumn;
    Listener onExpand;
    Canvas tree;

    public TreeEdit(Tree tree, Canvas canvas) {
        super((Composite)canvas);
        this.tree = canvas;
        this.header = tree;
        ROW_HEIGHT = tree.getItemHeight();
        this.onColumn = new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                TreeEdit.this.layout();
            }

            public void controlResized(ControlEvent controlEvent) {
                TreeEdit.this.layout();
            }
        };
        this.layoutRunnable = new Runnable(){

            @Override
            public void run() {
                TreeEdit.this.layout();
            }
        };
        this.onExpand = new Listener(){
            Control edit;
            final Runnable runnable;
            {
                this.edit = TreeEdit.this.getEditor();
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (edit == null || edit.isDisposed()) {
                            return;
                        }
                        if ((this).TreeEdit.this.tree.isDisposed()) {
                            return;
                        }
                        TreeEdit.this.layout();
                        edit.setVisible(true);
                    }
                };
            }

            public void handleEvent(Event event) {
                if (event.type == 17) {
                    if (this.edit == null || this.edit.isDisposed()) {
                        return;
                    }
                    this.edit.setVisible(false);
                    event.display.asyncExec(this.runnable);
                } else if (event.type == 18) {
                    if (this.edit == null || this.edit.isDisposed()) {
                        return;
                    }
                    this.edit.setVisible(false);
                    event.display.asyncExec(this.runnable);
                }
            }
        };
        canvas.addListener(17, this.onExpand);
        canvas.addListener(18, this.onExpand);
        this.grabVertical = true;
    }

    @Override
    public Rectangle computeBounds() {
        if (this.cell.x == -1 || this.cell.y == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.getCellBounds();
        rectangle.x += 16;
        rectangle.width -= 16;
        Rectangle rectangle2 = this.tree.getClientArea();
        if (rectangle.x < rectangle2.x + rectangle2.width && rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
        }
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, this.minimumWidth, this.minimumHeight);
        if (this.grabHorizontal) {
            if (this.header.getColumnCount() == 0) {
                rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
            }
            rectangle3.width = Math.max(rectangle.width, this.minimumWidth);
        }
        if (this.grabVertical) {
            rectangle3.height = Math.max(rectangle.height, this.minimumHeight);
        }
        if (this.horizontalAlignment == 131072) {
            rectangle3.x += rectangle.width - rectangle3.width;
        } else if (this.horizontalAlignment != 16384) {
            rectangle3.x += (rectangle.width - rectangle3.width) / 2;
        }
        rectangle3.x = Math.max(rectangle.x, rectangle3.x);
        if (this.verticalAlignment == 1024) {
            rectangle3.y += rectangle.height - rectangle3.height;
        } else if (this.verticalAlignment != 128) {
            rectangle3.y += (rectangle.height - rectangle3.height) / 2;
        }
        return rectangle3;
    }

    @Override
    public void dispose() {
        if (this.tree != null && !this.tree.isDisposed()) {
            if (this.cell.x > -1 && this.cell.x < this.header.getColumnCount()) {
                TreeColumn treeColumn = this.header.getColumn(this.cell.x);
                treeColumn.removeControlListener(this.onColumn);
            }
            if (this.onExpand != null) {
                this.tree.removeListener(17, this.onExpand);
                this.tree.removeListener(18, this.onExpand);
            }
        }
        this.onColumn = null;
        this.onExpand = null;
        this.tree = null;
        this.cell.x = 0;
        this.cell.y = 0;
        this.layoutRunnable = null;
        super.dispose();
    }

    public Point getCell() {
        return this.cell;
    }

    protected Rectangle getCellBounds() {
        TreeColumn[] treeColumnArray = this.header.getColumns();
        int n = treeColumnArray[this.cell.x].getWidth();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cell.x) {
            n2 += treeColumnArray[n3].getWidth();
            ++n3;
        }
        return new Rectangle(n2, this.cell.y * ROW_HEIGHT, n, ROW_HEIGHT);
    }

    @Override
    public void layout() {
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        if (this.cell.x == -1 || this.cell.y == -1) {
            return;
        }
        int n = this.header.getColumnCount();
        if (n == 0 && this.cell.x != 0) {
            return;
        }
        if (n > 0 && (this.cell.x < 0 || this.cell.x >= n)) {
            return;
        }
        super.layout();
    }

    void resize() {
        this.layout();
        if (this.tree != null && !this.tree.isDisposed()) {
            Display display = this.tree.getDisplay();
            display.timerExec(-1, this.layoutRunnable);
            display.timerExec(1500, this.layoutRunnable);
        }
    }

    public void setCell(Point point) {
        this.cell = point;
        this.setColumn(point.x);
        this.resize();
    }

    public void setColumn(int n) {
        TreeColumn treeColumn;
        int n2 = this.header.getColumnCount();
        if (n2 == 0) {
            this.cell.x = n == 0 ? 0 : -1;
            this.resize();
            return;
        }
        if (this.cell.x > -1 && this.cell.x < n2) {
            treeColumn = this.header.getColumn(this.cell.x);
            treeColumn.removeControlListener(this.onColumn);
            this.cell.x = -1;
        }
        if (n < 0 || n >= this.header.getColumnCount()) {
            return;
        }
        this.cell.x = n;
        treeColumn = this.header.getColumn(this.cell.x);
        treeColumn.addControlListener(this.onColumn);
        this.resize();
    }

    @Override
    public void setEditor(Control control) {
        super.setEditor(control);
        this.resize();
    }

    public void setEditor(Control control, Point point) {
        this.setCell(point);
        this.setEditor(control);
    }
}

